/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import java.math.BigDecimal;
import java.util.Random;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PBoolean
extends PDataType<Boolean> {
    public static final PBoolean INSTANCE = new PBoolean();

    private PBoolean() {
        super("BOOLEAN", 16, Boolean.class, null, 21);
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            throw PBoolean.newIllegalDataException(this + " may not be null");
        }
        return (Boolean)object != false ? TRUE_BYTES : FALSE_BYTES;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PBoolean.newIllegalDataException(this + " may not be null");
        }
        bytes[offset] = (Boolean)object != false ? (byte)1 : 0;
        return BOOLEAN_LENGTH;
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        if (object == null) {
            throw PBoolean.newIllegalDataException(this + " may not be null");
        }
        return (Boolean)object ^ sortOrder == SortOrder.ASC ? FALSE_BYTES : TRUE_BYTES;
    }

    @Override
    public Boolean toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        Preconditions.checkNotNull((Object)((Object)sortOrder));
        if (length == 0) {
            return null;
        }
        if (actualType == this) {
            if (length > 1) {
                throw PBoolean.newIllegalDataException("BOOLEAN may only be a single byte");
            }
            return bytes[offset] == 0 ^ sortOrder == SortOrder.DESC ? Boolean.FALSE : Boolean.TRUE;
        }
        if (actualType == PDecimal.INSTANCE) {
            return sortOrder == SortOrder.DESC ? SortOrder.invert(bytes[offset]) != -128 : bytes[offset] != -128;
        }
        PBoolean.throwConstraintViolationException(actualType, this);
        return null;
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return super.isCoercibleTo(targetType) || targetType.equals(PBinary.INSTANCE);
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return super.isCastableTo(targetType) || targetType.equals(PDecimal.INSTANCE);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return BOOLEAN_LENGTH;
    }

    @Override
    public int estimateByteSize(Object o) {
        return BOOLEAN_LENGTH;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return Booleans.compare((boolean)((Boolean)lhs), (boolean)((Boolean)rhs));
    }

    @Override
    public Object toObject(String value) {
        return Boolean.parseBoolean(value);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (actualType == this || object == null) {
            return object;
        }
        if (actualType == PVarbinary.INSTANCE || actualType == PBinary.INSTANCE) {
            byte[] bytes = (byte[])object;
            return this.toObject(bytes, 0, bytes.length);
        }
        if (actualType == PDecimal.INSTANCE) {
            return ((BigDecimal)object).equals(BigDecimal.ZERO) ? Boolean.FALSE : Boolean.TRUE;
        }
        return PBoolean.throwConstraintViolationException(actualType, this);
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return ((Random)RANDOM.get()).nextBoolean();
    }

    @Override
    public PDataType.PhoenixArrayFactory getArrayFactory() {
        return new PDataType.PhoenixArrayFactory(){

            @Override
            public PhoenixArray newArray(PDataType type, Object[] elements) {
                return new PhoenixArray.PrimitiveBooleanPhoenixArray(type, elements);
            }
        };
    }
}

