/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Lists;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexStatementRewriter;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.visitor.RowKeyExpressionVisitor;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;

public class IndexUtil {
    public static final String INDEX_COLUMN_NAME_SEP = ":";
    public static final byte[] INDEX_COLUMN_NAME_SEP_BYTES = Bytes.toBytes((String)":");

    private IndexUtil() {
    }

    public static PDataType getIndexColumnDataType(PColumn dataColumn) throws SQLException {
        PDataType type = IndexUtil.getIndexColumnDataType(dataColumn.isNullable(), dataColumn.getDataType());
        if (type == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_INDEX_COLUMN_ON_TYPE).setColumnName(dataColumn.getName().getString()).setMessage("Type=" + dataColumn.getDataType()).build().buildException();
        }
        return type;
    }

    public static PDataType getIndexColumnDataType(boolean isNullable, PDataType dataType) {
        if (dataType == null || !isNullable || !dataType.isFixedWidth()) {
            return dataType;
        }
        if (dataType.isCastableTo(PDecimal.INSTANCE)) {
            return PDecimal.INSTANCE;
        }
        if (dataType.isCoercibleTo(PVarchar.INSTANCE)) {
            return PVarchar.INSTANCE;
        }
        if (PBinary.INSTANCE.equals(dataType)) {
            return PVarbinary.INSTANCE;
        }
        throw new IllegalArgumentException("Unsupported non nullable type " + dataType);
    }

    public static String getDataColumnName(String name) {
        return name.substring(name.indexOf(INDEX_COLUMN_NAME_SEP) + 1);
    }

    public static String getDataColumnFamilyName(String name) {
        return name.substring(0, name.indexOf(INDEX_COLUMN_NAME_SEP));
    }

    public static String getActualColumnFamilyName(String name) {
        if (name.startsWith("L#")) {
            return name.substring("L#".length());
        }
        return name;
    }

    public static String getCaseSensitiveDataColumnFullName(String name) {
        int index = name.indexOf(INDEX_COLUMN_NAME_SEP);
        return SchemaUtil.getCaseSensitiveColumnDisplayName(IndexUtil.getDataColumnFamilyName(name), name.substring(index + 1));
    }

    public static String getIndexColumnName(String dataColumnFamilyName, String dataColumnName) {
        return (dataColumnFamilyName == null ? "" : dataColumnFamilyName) + INDEX_COLUMN_NAME_SEP + dataColumnName;
    }

    public static byte[] getIndexColumnName(byte[] dataColumnFamilyName, byte[] dataColumnName) {
        return ByteUtil.concat(dataColumnFamilyName == null ? ByteUtil.EMPTY_BYTE_ARRAY : dataColumnFamilyName, INDEX_COLUMN_NAME_SEP_BYTES, dataColumnName);
    }

    public static String getIndexColumnName(PColumn dataColumn) {
        String dataColumnFamilyName = SchemaUtil.isPKColumn(dataColumn) ? null : dataColumn.getFamilyName().getString();
        return IndexUtil.getIndexColumnName(dataColumnFamilyName, dataColumn.getName().getString());
    }

    public static String getLocalIndexColumnFamily(String dataColumnFamilyName) {
        return dataColumnFamilyName == null ? null : "L#" + dataColumnFamilyName;
    }

    public static byte[] getLocalIndexColumnFamily(byte[] dataColumnFamilyBytes) {
        String dataCF = Bytes.toString((byte[])dataColumnFamilyBytes);
        return IndexUtil.getLocalIndexColumnFamily(dataCF).getBytes();
    }

    public static PColumn getDataColumn(PTable dataTable, String indexColumnName) {
        PColumnFamily family;
        int pos = indexColumnName.indexOf(INDEX_COLUMN_NAME_SEP);
        if (pos < 0) {
            throw new IllegalArgumentException("Could not find expected ':' separator in index column name of \"" + indexColumnName + "\"");
        }
        if (pos == 0) {
            try {
                return dataTable.getPKColumn(indexColumnName.substring(1));
            }
            catch (ColumnNotFoundException e) {
                throw new IllegalArgumentException("Could not find PK column \"" + indexColumnName.substring(pos + 1) + "\" in index column name of \"" + indexColumnName + "\"", e);
            }
        }
        try {
            family = dataTable.getColumnFamily(IndexUtil.getDataColumnFamilyName(indexColumnName));
        }
        catch (ColumnFamilyNotFoundException e) {
            throw new IllegalArgumentException("Could not find column family \"" + indexColumnName.substring(0, pos) + "\" in index column name of \"" + indexColumnName + "\"", e);
        }
        try {
            return family.getPColumnForColumnName(indexColumnName.substring(pos + 1));
        }
        catch (ColumnNotFoundException e) {
            throw new IllegalArgumentException("Could not find column \"" + indexColumnName.substring(pos + 1) + "\" in index column name of \"" + indexColumnName + "\"", e);
        }
    }

    public static List<PColumn> getDataColumns(String dataTableName, List<PColumn> indexColumns, PhoenixConnection conn) throws SQLException {
        PTable dataTable = PhoenixRuntime.getTable(conn, dataTableName);
        ArrayList<PColumn> dataColumns = new ArrayList<PColumn>(indexColumns.size());
        for (PColumn indexColumn : indexColumns) {
            dataColumns.add(IndexUtil.getDataColumn(dataTable, indexColumn.getName().getString()));
        }
        return dataColumns;
    }

    private static boolean isEmptyKeyValue(PTable table, ColumnReference ref) {
        byte[] emptyKeyValueCF = SchemaUtil.getEmptyColumnFamily(table);
        byte[] emptyKeyValueQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(table).getFirst();
        return Bytes.compareTo((byte[])emptyKeyValueCF, (int)0, (int)emptyKeyValueCF.length, (byte[])ref.getFamilyWritable().get(), (int)ref.getFamilyWritable().getOffset(), (int)ref.getFamilyWritable().getLength()) == 0 && Bytes.compareTo((byte[])emptyKeyValueQualifier, (int)0, (int)emptyKeyValueQualifier.length, (byte[])ref.getQualifierWritable().get(), (int)ref.getQualifierWritable().getOffset(), (int)ref.getQualifierWritable().getLength()) == 0;
    }

    public static List<Delete> generateDeleteIndexData(PTable table, PTable index, List<Delete> dataMutations, ImmutableBytesWritable ptr, KeyValueBuilder kvBuilder, PhoenixConnection connection) throws SQLException {
        try {
            IndexMaintainer maintainer = index.getIndexMaintainer(table, connection);
            ArrayList indexMutations = Lists.newArrayListWithExpectedSize((int)dataMutations.size());
            for (Mutation mutation : dataMutations) {
                long ts = MetaDataUtil.getClientTimeStamp(mutation);
                ptr.set(mutation.getRow());
                byte[] regionStartKey = null;
                byte[] regionEndkey = null;
                if (maintainer.isLocalIndex()) {
                    HRegionLocation tableRegionLocation = connection.getQueryServices().getTableRegionLocation(table.getPhysicalName().getBytes(), mutation.getRow());
                    regionStartKey = tableRegionLocation.getRegionInfo().getStartKey();
                    regionEndkey = tableRegionLocation.getRegionInfo().getEndKey();
                }
                Delete delete = maintainer.buildDeleteMutation(kvBuilder, null, ptr, Collections.emptyList(), ts, regionStartKey, regionEndkey);
                delete.setAttribute("tephra.tx.rollback", mutation.getAttribute("tephra.tx.rollback"));
                indexMutations.add(delete);
            }
            return indexMutations;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public static List<Mutation> generateIndexData(final PTable table, PTable index, Map<ImmutableBytesPtr, MutationState.RowMutationState> valuesMap, List<Mutation> dataMutations, final KeyValueBuilder kvBuilder, PhoenixConnection connection) throws SQLException {
        try {
            ImmutableBytesPtr ptr = new ImmutableBytesPtr();
            IndexMaintainer maintainer = index.getIndexMaintainer(table, connection);
            ArrayList indexMutations = Lists.newArrayListWithExpectedSize((int)dataMutations.size());
            for (final Mutation dataMutation : dataMutations) {
                long ts = MetaDataUtil.getClientTimeStamp(dataMutation);
                ptr.set(dataMutation.getRow());
                if (!(dataMutation instanceof Put)) continue;
                ValueGetter valueGetter = new ValueGetter(){

                    @Override
                    public byte[] getRowKey() {
                        return dataMutation.getRow();
                    }

                    @Override
                    public ImmutableBytesWritable getLatestValue(ColumnReference ref) {
                        if (IndexUtil.isEmptyKeyValue(table, ref)) {
                            return null;
                        }
                        byte[] family = ref.getFamily();
                        byte[] qualifier = ref.getQualifier();
                        NavigableMap familyMap = dataMutation.getFamilyCellMap();
                        List kvs = (List)familyMap.get(family);
                        if (kvs == null) {
                            return null;
                        }
                        for (Cell kv : kvs) {
                            if (Bytes.compareTo((byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])family, (int)0, (int)family.length) != 0 || Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])qualifier, (int)0, (int)qualifier.length) != 0) continue;
                            ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                            kvBuilder.getValueAsPtr(kv, ptr);
                            return ptr;
                        }
                        return null;
                    }
                };
                byte[] regionStartKey = null;
                byte[] regionEndkey = null;
                if (maintainer.isLocalIndex()) {
                    HRegionLocation tableRegionLocation = connection.getQueryServices().getTableRegionLocation(table.getPhysicalName().getBytes(), dataMutation.getRow());
                    regionStartKey = tableRegionLocation.getRegionInfo().getStartKey();
                    regionEndkey = tableRegionLocation.getRegionInfo().getEndKey();
                }
                indexMutations.add(maintainer.buildUpdateMutation(kvBuilder, valueGetter, ptr, ts, regionStartKey, regionEndkey));
            }
            return indexMutations;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public static boolean isDataPKColumn(PColumn column) {
        return column.getName().getString().startsWith(INDEX_COLUMN_NAME_SEP);
    }

    public static boolean isIndexColumn(String name) {
        return name.contains(INDEX_COLUMN_NAME_SEP);
    }

    public static boolean getViewConstantValue(PColumn column, ImmutableBytesWritable ptr) {
        byte[] value = column.getViewConstant();
        if (value != null) {
            ptr.set(value, 0, value.length - 1);
            return true;
        }
        return false;
    }

    public static void setRowKeyExpressionOffset(Expression rootExpression, final int offset) {
        rootExpression.accept(new RowKeyExpressionVisitor(){

            @Override
            public Void visit(RowKeyColumnExpression node) {
                node.setOffset(offset);
                return null;
            }
        });
    }

    public static ColumnReference[] deserializeDataTableColumnsToJoin(Scan scan) {
        byte[] columnsBytes = scan.getAttribute("_DataTableColumnsToJoin");
        if (columnsBytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(columnsBytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            int numColumns = WritableUtils.readVInt((DataInput)input);
            ColumnReference[] dataColumns = new ColumnReference[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                dataColumns[i] = new ColumnReference(Bytes.readByteArray((DataInput)input), Bytes.readByteArray((DataInput)input));
            }
            ColumnReference[] columnReferenceArray = dataColumns;
            return columnReferenceArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[][] deserializeViewConstantsFromScan(Scan scan) {
        byte[] bytes = scan.getAttribute("_ViewConstants");
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            int numConstants = WritableUtils.readVInt((DataInput)input);
            byte[][] viewConstants = new byte[numConstants][];
            for (int i = 0; i < numConstants; ++i) {
                viewConstants[i] = Bytes.readByteArray((DataInput)input);
            }
            byte[][] byArrayArray = viewConstants;
            return byArrayArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static KeyValueSchema deserializeLocalIndexJoinSchemaFromScan(Scan scan) {
        byte[] schemaBytes = scan.getAttribute("_LocalIndexJoinSchema");
        if (schemaBytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(schemaBytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            KeyValueSchema schema = new KeyValueSchema();
            schema.readFields(input);
            KeyValueSchema keyValueSchema = schema;
            return keyValueSchema;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static TupleProjector getTupleProjector(Scan scan, ColumnReference[] dataColumns) {
        if (dataColumns != null && dataColumns.length != 0) {
            KeyValueSchema keyValueSchema = IndexUtil.deserializeLocalIndexJoinSchemaFromScan(scan);
            boolean storeColsInSingleCell = scan.getAttribute("_ColumnsStoredInSingleCell") != null;
            PTable.QualifierEncodingScheme encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme(scan);
            Expression[] colExpressions = storeColsInSingleCell ? new SingleCellColumnExpression[dataColumns.length] : new KeyValueColumnExpression[dataColumns.length];
            for (int i = 0; i < dataColumns.length; ++i) {
                byte[] family = dataColumns[i].getFamily();
                byte[] qualifier = dataColumns[i].getQualifier();
                ValueSchema.Field field = keyValueSchema.getField(i);
                KeyValueColumnExpression dataColumnExpr = storeColsInSingleCell ? new SingleCellColumnExpression(field, family, qualifier, encodingScheme) : new KeyValueColumnExpression(field, family, qualifier);
                colExpressions[i] = dataColumnExpr;
            }
            return new TupleProjector(keyValueSchema, colExpressions);
        }
        return null;
    }

    public static String rewriteViewStatement(PhoenixConnection conn, PTable index, PTable table, String viewStatement) throws SQLException {
        if (viewStatement == null) {
            return null;
        }
        SelectStatement select = new SQLParser(viewStatement).parseQuery();
        ColumnResolver resolver = FromCompiler.getResolver(new TableRef(table));
        SelectStatement translatedSelect = IndexStatementRewriter.translate(select, resolver);
        ParseNode whereNode = translatedSelect.getWhere();
        PhoenixStatement statement = new PhoenixStatement(conn);
        TableRef indexTableRef = new TableRef(index){

            @Override
            public String getColumnDisplayName(ColumnRef ref, boolean schemaNameCaseSensitive, boolean colNameCaseSensitive) {
                return '\"' + ref.getColumn().getName().getString() + '\"';
            }
        };
        ColumnResolver indexResolver = FromCompiler.getResolver(indexTableRef);
        StatementContext context = new StatementContext(statement, indexResolver);
        WhereCompiler.compile(context, whereNode);
        StringBuilder buf = new StringBuilder();
        whereNode.toSQL(indexResolver, buf);
        return QueryUtil.getViewStatement(index.getSchemaName().getString(), index.getTableName().getString(), buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wrapResultUsingOffset(RegionCoprocessorEnvironment environment, List<Cell> result, final int offset, ColumnReference[] dataColumns, TupleProjector tupleProjector, Region dataRegion, IndexMaintainer indexMaintainer, byte[][] viewConstants, ImmutableBytesWritable ptr) throws IOException {
        if (tupleProjector != null) {
            Cell firstCell = result.get(0);
            byte[] indexRowKey = firstCell.getRowArray();
            ptr.set(indexRowKey, firstCell.getRowOffset() + offset, firstCell.getRowLength() - offset);
            byte[] dataRowKey = indexMaintainer.buildDataRowKey(ptr, viewConstants);
            Get get = new Get(dataRowKey);
            PTable.ImmutableStorageScheme storageScheme = indexMaintainer.getIndexStorageScheme();
            for (int i = 0; i < dataColumns.length; ++i) {
                if (storageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
                    get.addFamily(dataColumns[i].getFamily());
                    continue;
                }
                get.addColumn(dataColumns[i].getFamily(), dataColumns[i].getQualifier());
            }
            Result joinResult = null;
            if (dataRegion != null) {
                joinResult = dataRegion.get(get);
            } else {
                TableName dataTable = TableName.valueOf((String)MetaDataUtil.getLocalIndexUserTableName(environment.getRegion().getTableDesc().getNameAsString()));
                try (HTableInterface table = null;){
                    table = environment.getTable(dataTable);
                    joinResult = table.get(get);
                }
            }
            ResultTuple joinTuple = new ResultTuple(joinResult);
            byte[] value = tupleProjector.getSchema().toBytes(joinTuple, tupleProjector.getExpressions(), tupleProjector.getValueBitSet(), ptr);
            KeyValue keyValue = KeyValueUtil.newKeyValue(firstCell.getRowArray(), firstCell.getRowOffset(), firstCell.getRowLength(), QueryConstants.VALUE_COLUMN_FAMILY, QueryConstants.VALUE_COLUMN_QUALIFIER, firstCell.getTimestamp(), value, 0, value.length);
            result.add((Cell)keyValue);
        }
        ListIterator<Cell> itr = result.listIterator();
        while (itr.hasNext()) {
            final Cell cell = itr.next();
            Cell newCell = new Cell(){

                public byte[] getRowArray() {
                    return cell.getRowArray();
                }

                public int getRowOffset() {
                    return cell.getRowOffset() + offset;
                }

                public short getRowLength() {
                    return (short)(cell.getRowLength() - offset);
                }

                public byte[] getFamilyArray() {
                    return cell.getFamilyArray();
                }

                public int getFamilyOffset() {
                    return cell.getFamilyOffset();
                }

                public byte getFamilyLength() {
                    return cell.getFamilyLength();
                }

                public byte[] getQualifierArray() {
                    return cell.getQualifierArray();
                }

                public int getQualifierOffset() {
                    return cell.getQualifierOffset();
                }

                public int getQualifierLength() {
                    return cell.getQualifierLength();
                }

                public long getTimestamp() {
                    return cell.getTimestamp();
                }

                public byte getTypeByte() {
                    return cell.getTypeByte();
                }

                public long getMvccVersion() {
                    return cell.getMvccVersion();
                }

                public long getSequenceId() {
                    return cell.getSequenceId();
                }

                public byte[] getValueArray() {
                    return cell.getValueArray();
                }

                public int getValueOffset() {
                    return cell.getValueOffset();
                }

                public int getValueLength() {
                    return cell.getValueLength();
                }

                public byte[] getTagsArray() {
                    return cell.getTagsArray();
                }

                public int getTagsOffset() {
                    return cell.getTagsOffset();
                }

                public int getTagsLength() {
                    return cell.getTagsLength();
                }

                public byte[] getValue() {
                    return cell.getValue();
                }

                public byte[] getFamily() {
                    return cell.getFamily();
                }

                public byte[] getQualifier() {
                    return cell.getQualifier();
                }

                public byte[] getRow() {
                    return cell.getRow();
                }
            };
            itr.set(newCell);
        }
    }

    public static String getIndexColumnExpressionStr(PColumn col) {
        return col.getExpressionStr() == null ? IndexUtil.getCaseSensitiveDataColumnFullName(col.getName().getString()) : col.getExpressionStr();
    }

    public static byte[][] getViewConstants(PTable dataTable) {
        if (dataTable.getType() != PTableType.VIEW) {
            return null;
        }
        int dataPosOffset = (dataTable.getBucketNum() != null ? 1 : 0) + (dataTable.isMultiTenant() ? 1 : 0);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ArrayList<byte[]> viewConstants = new ArrayList<byte[]>();
        List<PColumn> dataPkColumns = dataTable.getPKColumns();
        for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
            PColumn dataPKColumn = dataPkColumns.get(i);
            if (dataPKColumn.getViewConstant() == null) continue;
            if (IndexUtil.getViewConstantValue(dataPKColumn, ptr)) {
                viewConstants.add(ByteUtil.copyKeyBytesIfNecessary(ptr));
                continue;
            }
            throw new IllegalStateException();
        }
        return viewConstants.isEmpty() ? (byte[][])null : (byte[][])viewConstants.toArray((T[])new byte[viewConstants.size()][]);
    }

    public static void writeLocalUpdates(Region region, List<Mutation> mutations, boolean skipWAL) throws IOException {
        if (skipWAL) {
            for (Mutation m : mutations) {
                m.setDurability(Durability.SKIP_WAL);
            }
        }
        region.batchMutate(mutations.toArray(new Mutation[mutations.size()]), 0L, 0L);
    }

    public static MetaDataProtocol.MetaDataMutationResult setIndexDisableTimeStamp(String indexTableName, long minTimeStamp, HTableInterface metaTable, PIndexState newState) throws ServiceException, Throwable {
        byte[] indexTableKey = SchemaUtil.getTableKeyFromFullName(indexTableName);
        Put put = new Put(indexTableKey);
        put.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES, newState.getSerializedBytes());
        put.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES, PLong.INSTANCE.toBytes(minTimeStamp));
        put.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.ASYNC_REBUILD_TIMESTAMP_BYTES, PLong.INSTANCE.toBytes(0));
        final List<Put> tableMetadata = Collections.singletonList(put);
        Map results = metaTable.coprocessorService(MetaDataProtos.MetaDataService.class, indexTableKey, indexTableKey, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.UpdateIndexStateRequest.Builder builder = MetaDataProtos.UpdateIndexStateRequest.newBuilder();
                for (Mutation m : tableMetadata) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                instance.updateIndexState((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        if (results.isEmpty()) {
            throw new IOException("Didn't get expected result size");
        }
        MetaDataProtos.MetaDataResponse tmpResponse = (MetaDataProtos.MetaDataResponse)results.values().iterator().next();
        return MetaDataProtocol.MetaDataMutationResult.constructFromProto(tmpResponse);
    }

    public static boolean matchingSplitKeys(byte[][] splitKeys1, byte[][] splitKeys2) throws IOException {
        if (splitKeys1 != null && splitKeys2 != null && splitKeys1.length == splitKeys2.length) {
            for (int i = 0; i < splitKeys1.length; ++i) {
                if (Bytes.compareTo((byte[])splitKeys1[i], (byte[])splitKeys2[i]) == 0) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean isLocalIndexStore(Store store) {
        return store.getFamily().getNameAsString().startsWith("L#");
    }

    public static PTable getPDataTable(Connection conn, HTableDescriptor tableDesc) throws SQLException {
        String dataTableName = Bytes.toString((byte[])tableDesc.getValue(MetaDataUtil.DATA_TABLE_NAME_PROP_BYTES));
        String physicalTableName = tableDesc.getTableName().getNameAsString();
        PTable pDataTable = null;
        if (dataTableName == null) {
            if (physicalTableName.contains(INDEX_COLUMN_NAME_SEP)) {
                try {
                    pDataTable = PhoenixRuntime.getTable(conn, physicalTableName.replace(INDEX_COLUMN_NAME_SEP, "."));
                }
                catch (TableNotFoundException e) {
                    pDataTable = PhoenixRuntime.getTable(conn, physicalTableName);
                }
            } else {
                pDataTable = PhoenixRuntime.getTable(conn, physicalTableName);
            }
        } else {
            pDataTable = PhoenixRuntime.getTable(conn, dataTableName);
        }
        return pDataTable;
    }

    public static boolean isLocalIndexFamily(String family) {
        return family.indexOf("L#") != -1;
    }
}

