/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;

public class ServerUtil {
    private static final int COPROCESSOR_SCAN_WORKS = VersionUtil.encodeVersion("0.98.6");
    private static final String FORMAT = "ERROR %d (%s): %s";
    private static final Pattern PATTERN = Pattern.compile("ERROR (\\d+) \\((\\w+)\\): (.*)");
    private static final Pattern PATTERN_FOR_TS = Pattern.compile(",serverTimestamp=(\\d+),");
    private static final String FORMAT_FOR_TIMESTAMP = ",serverTimestamp=%d,";
    private static final Map<Class<? extends Exception>, SQLExceptionCode> errorcodeMap = new HashMap<Class<? extends Exception>, SQLExceptionCode>();

    public static void throwIOException(String msg, Throwable t) throws IOException {
        throw ServerUtil.createIOException(msg, t);
    }

    public static IOException createIOException(String msg, Throwable t) {
        Throwable cause;
        if (t instanceof SQLException && (cause = t.getCause()) instanceof IOException) {
            t = cause;
        }
        if (t instanceof DoNotRetryIOException) {
            return (DoNotRetryIOException)t;
        }
        if (t instanceof IOException) {
            cause = t.getCause();
            if (cause instanceof RetriesExhaustedWithDetailsException || cause instanceof DoNotRetryIOException) {
                return new DoNotRetryIOException(t.getMessage(), cause);
            }
            if (cause == null || cause instanceof IOException) {
                return (IOException)t;
            }
            return new DoNotRetryIOException(t.getMessage(), cause);
        }
        if (t instanceof SQLException) {
            return new DoNotRetryIOException(ServerUtil.constructSQLErrorMessage((SQLException)t, msg), t);
        }
        SQLExceptionCode code = errorcodeMap.get(t.getClass());
        if (code == null) {
            return new DoNotRetryIOException(msg + ": " + t.getMessage(), t);
        }
        return new DoNotRetryIOException(ServerUtil.constructSQLErrorMessage(code, t, msg), t);
    }

    private static String constructSQLErrorMessage(SQLExceptionCode code, Throwable e, String message) {
        return ServerUtil.constructSQLErrorMessage(code.getErrorCode(), code.getSQLState(), code.getMessage() + " " + e.getMessage() + " " + message);
    }

    private static String constructSQLErrorMessage(SQLException e, String message) {
        return ServerUtil.constructSQLErrorMessage(e.getErrorCode(), e.getSQLState(), e.getMessage() + " " + message);
    }

    private static String constructSQLErrorMessage(int errorCode, String SQLState, String message) {
        return String.format(FORMAT, errorCode, SQLState, message);
    }

    public static SQLException parseServerException(Throwable t) {
        SQLException e = ServerUtil.parseServerExceptionOrNull(t);
        if (e != null) {
            return e;
        }
        return new PhoenixIOException(t);
    }

    public static SQLException parseServerExceptionOrNull(Throwable t) {
        while (t.getCause() != null) {
            if (t instanceof NotServingRegionException) {
                return ServerUtil.parseRemoteException(new StaleRegionBoundaryCacheException());
            }
            t = t.getCause();
        }
        return ServerUtil.parseRemoteException(t);
    }

    private static SQLException parseRemoteException(Throwable t) {
        Matcher matcher;
        String message = t.getLocalizedMessage();
        if (message != null && (matcher = PATTERN.matcher(t.getLocalizedMessage())).find()) {
            int statusCode = Integer.parseInt(matcher.group(1));
            SQLExceptionCode code = SQLExceptionCode.fromErrorCode(statusCode);
            return new SQLExceptionInfo.Builder(code).setMessage(matcher.group()).setRootCause(t).build().buildException();
        }
        return null;
    }

    private static boolean coprocessorScanWorks(RegionCoprocessorEnvironment env) {
        return VersionUtil.encodeVersion(env.getHBaseVersion()) >= COPROCESSOR_SCAN_WORKS;
    }

    private static HTableInterface getTableFromSingletonPool(RegionCoprocessorEnvironment env, byte[] tableName) throws IOException {
        HTablePool pool = new HTablePool(env.getConfiguration(), 1);
        try {
            return pool.getTable(tableName);
        }
        catch (RuntimeException t) {
            if (t.getCause() instanceof IOException) {
                throw (IOException)t.getCause();
            }
            throw t;
        }
    }

    public static HTableInterface getHTableForCoprocessorScan(RegionCoprocessorEnvironment env, HTableInterface writerTable) throws IOException {
        if (ServerUtil.coprocessorScanWorks(env)) {
            return writerTable;
        }
        return ServerUtil.getTableFromSingletonPool(env, writerTable.getTableName());
    }

    public static HTableInterface getHTableForCoprocessorScan(RegionCoprocessorEnvironment env, byte[] tableName) throws IOException {
        if (ServerUtil.coprocessorScanWorks(env)) {
            return env.getTable(TableName.valueOf((byte[])tableName));
        }
        return ServerUtil.getTableFromSingletonPool(env, tableName);
    }

    public static long parseServerTimestamp(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return ServerUtil.parseTimestampFromRemoteException(t);
    }

    private static long parseTimestampFromRemoteException(Throwable t) {
        String tsString;
        Matcher matcher;
        String message = t.getLocalizedMessage();
        if (message != null && (matcher = PATTERN_FOR_TS.matcher(t.getLocalizedMessage())).find() && (tsString = matcher.group(1)) != null) {
            return Long.parseLong(tsString);
        }
        return Long.MAX_VALUE;
    }

    public static DoNotRetryIOException wrapInDoNotRetryIOException(String msg, Throwable t, long timestamp) {
        if (msg == null) {
            msg = "";
        }
        if (t instanceof SQLException) {
            msg = ServerUtil.constructSQLErrorMessage((SQLException)t, msg);
        }
        msg = msg + String.format(FORMAT_FOR_TIMESTAMP, timestamp);
        return new DoNotRetryIOException(msg, t);
    }

    public static boolean readyToCommit(int rowCount, long mutationSize, int maxBatchSize, long maxBatchSizeBytes) {
        return maxBatchSize > 0 && rowCount > maxBatchSize || maxBatchSizeBytes > 0L && mutationSize > maxBatchSizeBytes;
    }

    static {
        errorcodeMap.put(ArithmeticException.class, SQLExceptionCode.SERVER_ARITHMETIC_ERROR);
    }
}

