/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.tephra.TransactionConflictException;
import org.apache.tephra.TransactionFailureException;
import org.apache.tephra.TxConstants;
import org.apache.tephra.hbase.TransactionAwareHTable;

public class TransactionUtil {
    private TransactionUtil() {
    }

    public static boolean isDelete(Cell cell) {
        return CellUtil.matchingValue((Cell)cell, (byte[])HConstants.EMPTY_BYTE_ARRAY);
    }

    public static long convertToNanoseconds(long serverTimeStamp) {
        return serverTimeStamp * 1000000L;
    }

    public static long convertToMilliseconds(long serverTimeStamp) {
        return serverTimeStamp / 1000000L;
    }

    public static SQLException getTransactionFailureException(TransactionFailureException e) {
        if (e instanceof TransactionConflictException) {
            return new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_CONFLICT_EXCEPTION).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
        return new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
    }

    public static TransactionAwareHTable getTransactionAwareHTable(HTableInterface htable, boolean isImmutableRows) {
        return new TransactionAwareHTable(htable, isImmutableRows ? TxConstants.ConflictDetection.NONE : TxConstants.ConflictDetection.ROW);
    }

    public static long getResolvedTimestamp(PhoenixConnection connection, boolean isTransactional, long defaultResolvedTimestamp) {
        MutationState mutationState = connection.getMutationState();
        Long scn = connection.getSCN();
        return scn != null ? scn : (isTransactional && mutationState.isTransactionStarted() ? TransactionUtil.convertToMilliseconds(mutationState.getInitialWritePointer()) : defaultResolvedTimestamp);
    }

    public static long getResolvedTime(PhoenixConnection connection, MetaDataProtocol.MetaDataMutationResult result) {
        PTable table = result.getTable();
        boolean isTransactional = table != null && table.isTransactional();
        return TransactionUtil.getResolvedTimestamp(connection, isTransactional, result.getMutationTime());
    }

    public static long getResolvedTimestamp(PhoenixConnection connection, MetaDataProtocol.MetaDataMutationResult result) {
        PTable table = result.getTable();
        MutationState mutationState = connection.getMutationState();
        boolean txInProgress = table != null && table.isTransactional() && mutationState.isTransactionStarted();
        return txInProgress ? TransactionUtil.convertToMilliseconds(mutationState.getInitialWritePointer()) : result.getMutationTime();
    }

    public static Long getTableTimestamp(PhoenixConnection connection, boolean transactional) throws SQLException {
        Long timestamp = null;
        if (!transactional) {
            return timestamp;
        }
        MutationState mutationState = connection.getMutationState();
        if (!mutationState.isTransactionStarted()) {
            mutationState.startTransaction();
        }
        timestamp = TransactionUtil.convertToMilliseconds(mutationState.getInitialWritePointer());
        return timestamp;
    }
}

