/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessor.ServerCachingProtocol;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.util.Closeables;

public class TenantCacheImpl
implements TenantCache {
    private final int maxTimeToLiveMs;
    private final MemoryManager memoryManager;
    private final Ticker ticker;
    private volatile Cache<ImmutableBytesPtr, Closeable> serverCaches;

    public TenantCacheImpl(MemoryManager memoryManager, int maxTimeToLiveMs) {
        this(memoryManager, maxTimeToLiveMs, Ticker.systemTicker());
    }

    public TenantCacheImpl(MemoryManager memoryManager, int maxTimeToLiveMs, Ticker ticker) {
        this.memoryManager = memoryManager;
        this.maxTimeToLiveMs = maxTimeToLiveMs;
        this.ticker = ticker;
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        TenantCacheImpl tenantCacheImpl = this;
        synchronized (tenantCacheImpl) {
            if (this.serverCaches != null) {
                this.serverCaches.cleanUp();
            }
        }
    }

    @Override
    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<ImmutableBytesPtr, Closeable> getServerCaches() {
        if (this.serverCaches == null) {
            TenantCacheImpl tenantCacheImpl = this;
            synchronized (tenantCacheImpl) {
                if (this.serverCaches == null) {
                    this.serverCaches = CacheBuilder.newBuilder().expireAfterAccess((long)this.maxTimeToLiveMs, TimeUnit.MILLISECONDS).ticker(this.getTicker()).removalListener((RemovalListener)new RemovalListener<ImmutableBytesPtr, Closeable>(){

                        public void onRemoval(RemovalNotification<ImmutableBytesPtr, Closeable> notification) {
                            Closeables.closeAllQuietly(Collections.singletonList(notification.getValue()));
                        }
                    }).build();
                }
            }
        }
        return this.serverCaches;
    }

    @Override
    public Closeable getServerCache(ImmutableBytesPtr cacheId) {
        this.getServerCaches().cleanUp();
        return (Closeable)this.getServerCaches().getIfPresent((Object)cacheId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Closeable addServerCache(ImmutableBytesPtr cacheId, ImmutableBytesWritable cachePtr, byte[] txState, ServerCachingProtocol.ServerCacheFactory cacheFactory, boolean useProtoForIndexMaintainer) throws SQLException {
        this.getServerCaches().cleanUp();
        MemoryManager.MemoryChunk chunk = this.getMemoryManager().allocate(cachePtr.getLength() + txState.length);
        boolean success = false;
        try {
            Closeable element = cacheFactory.newCache(cachePtr, txState, chunk, useProtoForIndexMaintainer);
            this.getServerCaches().put((Object)cacheId, (Object)element);
            success = true;
            Closeable closeable = element;
            return closeable;
        }
        finally {
            if (!success) {
                Closeables.closeAllQuietly(Collections.singletonList(chunk));
            }
        }
    }

    @Override
    public void removeServerCache(ImmutableBytesPtr cacheId) {
        this.getServerCaches().invalidate((Object)cacheId);
    }

    @Override
    public void removeAllServerCache() {
        this.getServerCaches().invalidateAll();
    }
}

