/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.visitor.StatelessTraverseAllExpressionVisitor;
import org.apache.phoenix.expression.visitor.StatelessTraverseNoExpressionVisitor;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;

public class OrderPreservingTracker {
    private final StatementContext context;
    private final TrackOrderPreservingExpressionVisitor visitor;
    private final GroupByCompiler.GroupBy groupBy;
    private final Ordering ordering;
    private final int pkPositionOffset;
    private final List<Info> orderPreservingInfos;
    private final TupleProjector projector;
    private boolean isOrderPreserving = true;
    private Boolean isReverse = null;
    private int orderPreservingColumnCount = 0;

    public OrderPreservingTracker(StatementContext context, GroupByCompiler.GroupBy groupBy, Ordering ordering, int nNodes) {
        this(context, groupBy, ordering, nNodes, null);
    }

    public OrderPreservingTracker(StatementContext context, GroupByCompiler.GroupBy groupBy, Ordering ordering, int nNodes, TupleProjector projector) {
        this.context = context;
        if (groupBy.isEmpty()) {
            PTable table = context.getResolver().getTables().get(0).getTable();
            this.isOrderPreserving = table.rowKeyOrderOptimizable();
            boolean isSalted = table.getBucketNum() != null;
            boolean isMultiTenant = context.getConnection().getTenantId() != null && table.isMultiTenant();
            boolean isSharedViewIndex = table.getViewIndexId() != null;
            this.pkPositionOffset = (isSalted ? 1 : 0) + (isMultiTenant ? 1 : 0) + (isSharedViewIndex ? 1 : 0);
        } else {
            this.isOrderPreserving = true;
            this.pkPositionOffset = 0;
        }
        this.groupBy = groupBy;
        this.visitor = new TrackOrderPreservingExpressionVisitor(projector);
        this.orderPreservingInfos = Lists.newArrayListWithExpectedSize((int)nNodes);
        this.ordering = ordering;
        this.projector = projector;
    }

    public void track(Expression node) {
        SortOrder sortOrder = node.getSortOrder();
        this.track(node, sortOrder, null);
    }

    public void track(Expression node, SortOrder sortOrder, Boolean isNullsLast) {
        if (this.isOrderPreserving) {
            Info info = node.accept(this.visitor);
            if (info == null) {
                this.isOrderPreserving = false;
            } else {
                if (node.getSortOrder() != sortOrder) {
                    if (this.isReverse == null) {
                        this.isReverse = true;
                    } else if (!this.isReverse.booleanValue()) {
                        this.isOrderPreserving = false;
                        this.isReverse = false;
                        return;
                    }
                } else if (this.isReverse == null) {
                    this.isReverse = false;
                } else if (this.isReverse.booleanValue()) {
                    this.isOrderPreserving = false;
                    this.isReverse = false;
                    return;
                }
                if (isNullsLast != null && node.isNullable() && !Boolean.valueOf(isNullsLast).equals(this.isReverse)) {
                    this.isOrderPreserving = false;
                    this.isReverse = false;
                    return;
                }
                this.orderPreservingInfos.add(info);
            }
        }
    }

    public int getOrderPreservingColumnCount() {
        return this.orderPreservingColumnCount;
    }

    public boolean isOrderPreserving() {
        if (!this.isOrderPreserving) {
            return false;
        }
        if (this.ordering == Ordering.UNORDERED) {
            Collections.sort(this.orderPreservingInfos, new Comparator<Info>(){

                @Override
                public int compare(Info o1, Info o2) {
                    int cmp = o1.pkPosition - o2.pkPosition;
                    if (cmp != 0) {
                        return cmp;
                    }
                    return o2.orderPreserving.ordinal() - o1.orderPreserving.ordinal();
                }
            });
        }
        int prevSlotSpan = 1;
        int prevPos = this.pkPositionOffset - 1;
        FunctionExpression.OrderPreserving prevOrderPreserving = FunctionExpression.OrderPreserving.YES;
        for (int i = 0; i < this.orderPreservingInfos.size() && this.isOrderPreserving; ++i) {
            Info entry = this.orderPreservingInfos.get(i);
            int pos = entry.pkPosition;
            this.isOrderPreserving &= entry.orderPreserving != FunctionExpression.OrderPreserving.NO && prevOrderPreserving == FunctionExpression.OrderPreserving.YES && (pos == prevPos || pos - prevSlotSpan == prevPos || this.hasEqualityConstraints(prevPos + prevSlotSpan, pos));
            prevPos = pos;
            prevSlotSpan = entry.slotSpan;
            prevOrderPreserving = entry.orderPreserving;
        }
        this.orderPreservingColumnCount = prevPos + prevSlotSpan;
        return this.isOrderPreserving;
    }

    private boolean hasEqualityConstraints(int startPos, int endPos) {
        ScanRanges ranges = this.context.getScanRanges();
        if (!this.groupBy.isEmpty()) {
            for (int pos = startPos; pos < endPos; ++pos) {
                IsConstantVisitor visitor = new IsConstantVisitor(this.projector, ranges);
                List<Expression> groupByExpressions = this.groupBy.getExpressions();
                if (pos >= groupByExpressions.size()) {
                    return false;
                }
                Expression groupByExpression = groupByExpressions.get(pos);
                if (groupByExpression.getDeterminism().ordinal() > Determinism.PER_STATEMENT.ordinal()) {
                    return false;
                }
                Boolean isConstant = groupByExpression.accept(visitor);
                if (Boolean.TRUE.equals(isConstant)) continue;
                return false;
            }
            return true;
        }
        for (int pos = startPos; pos < endPos; ++pos) {
            if (ranges.hasEqualityConstraint(pos)) continue;
            return false;
        }
        return true;
    }

    public boolean isReverse() {
        return Boolean.TRUE.equals(this.isReverse);
    }

    private static class TrackOrderPreservingExpressionVisitor
    extends StatelessTraverseNoExpressionVisitor<Info> {
        private final TupleProjector projector;

        public TrackOrderPreservingExpressionVisitor(TupleProjector projector) {
            this.projector = projector;
        }

        @Override
        public Info visit(RowKeyColumnExpression node) {
            return new Info(node.getPosition());
        }

        @Override
        public Info visit(ProjectedColumnExpression node) {
            if (this.projector == null) {
                return (Info)super.visit(node);
            }
            Expression expression = this.projector.getExpressions()[node.getPosition()];
            if (expression instanceof ProjectedColumnExpression) {
                return (Info)super.visit(node);
            }
            return expression.accept(this);
        }

        @Override
        public Iterator<Expression> visitEnter(ScalarFunction node) {
            return node.preservesOrder() == FunctionExpression.OrderPreserving.NO ? Iterators.emptyIterator() : Iterators.singletonIterator((Object)node.getChildren().get(node.getKeyFormationTraversalIndex()));
        }

        @Override
        public Info visitLeave(ScalarFunction node, List<Info> l) {
            if (l.isEmpty()) {
                return null;
            }
            Info info = l.get(0);
            FunctionExpression.OrderPreserving orderPreserving = FunctionExpression.OrderPreserving.values()[Math.min(node.preservesOrder().ordinal(), info.orderPreserving.ordinal())];
            if (orderPreserving == info.orderPreserving) {
                return info;
            }
            return new Info(info, orderPreserving);
        }

        @Override
        public Iterator<Expression> visitEnter(CoerceExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Info visitLeave(CoerceExpression node, List<Info> l) {
            if (l.isEmpty()) {
                return null;
            }
            return l.get(0);
        }

        @Override
        public Iterator<Expression> visitEnter(RowValueConstructorExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Info visitLeave(RowValueConstructorExpression node, List<Info> l) {
            Info firstInfo;
            if (l.size() != node.getChildren().size()) {
                return null;
            }
            Info lastInfo = firstInfo = l.get(0);
            for (int i = 1; i < l.size(); ++i) {
                if (lastInfo.orderPreserving == FunctionExpression.OrderPreserving.YES_IF_LAST) {
                    return null;
                }
                Info info = l.get(i);
                if (info.pkPosition != lastInfo.pkPosition + 1) {
                    return null;
                }
                lastInfo = info;
            }
            return new Info(firstInfo, l.size(), lastInfo.orderPreserving);
        }
    }

    private static class IsConstantVisitor
    extends StatelessTraverseAllExpressionVisitor<Boolean> {
        private final TupleProjector projector;
        private final ScanRanges scanRanges;

        public IsConstantVisitor(TupleProjector projector, ScanRanges scanRanges) {
            this.projector = projector;
            this.scanRanges = scanRanges;
        }

        @Override
        public Boolean defaultReturn(Expression node, List<Boolean> returnValues) {
            if (node.getDeterminism().ordinal() > Determinism.PER_STATEMENT.ordinal() || returnValues.size() < node.getChildren().size()) {
                return Boolean.FALSE;
            }
            for (Boolean returnValue : returnValues) {
                if (returnValue.booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(RowKeyColumnExpression node) {
            return this.scanRanges.hasEqualityConstraint(node.getPosition());
        }

        @Override
        public Boolean visit(LiteralExpression node) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(ProjectedColumnExpression node) {
            if (this.projector == null) {
                return (Boolean)super.visit(node);
            }
            Expression expression = this.projector.getExpressions()[node.getPosition()];
            if (expression instanceof ProjectedColumnExpression) {
                return (Boolean)super.visit(node);
            }
            return expression.accept(this);
        }
    }

    public static class Info {
        public final FunctionExpression.OrderPreserving orderPreserving;
        public final int pkPosition;
        public final int slotSpan;

        public Info(int pkPosition) {
            this.pkPosition = pkPosition;
            this.orderPreserving = FunctionExpression.OrderPreserving.YES;
            this.slotSpan = 1;
        }

        public Info(Info info, FunctionExpression.OrderPreserving orderPreserving) {
            this.pkPosition = info.pkPosition;
            this.slotSpan = info.slotSpan;
            this.orderPreserving = orderPreserving;
        }

        public Info(Info info, int slotSpan, FunctionExpression.OrderPreserving orderPreserving) {
            this.pkPosition = info.pkPosition;
            this.slotSpan = slotSpan;
            this.orderPreserving = orderPreserving;
        }
    }

    public static enum Ordering {
        ORDERED,
        UNORDERED;

    }
}

