/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.data;

import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;

public class LocalTable
implements LocalHBaseState {
    private RegionCoprocessorEnvironment env;

    public LocalTable(RegionCoprocessorEnvironment env) {
        this.env = env;
    }

    @Override
    public Result getCurrentRowState(Mutation m, Collection<? extends ColumnReference> columns, boolean ignoreNewerMutations) throws IOException {
        byte[] row = m.getRow();
        Scan s = IndexManagementUtil.newLocalStateScan(Collections.singletonList(columns));
        s.setStartRow(row);
        s.setStopRow(row);
        if (ignoreNewerMutations) {
            long ts = this.getOldestTimestamp(m.getFamilyCellMap().values());
            s.setTimeRange(0L, ts);
        }
        Region region = this.env.getRegion();
        RegionScanner scanner = region.getScanner(s);
        ArrayList kvs = new ArrayList(1);
        boolean more = scanner.next(kvs);
        assert (!more) : "Got more than one result when scanning a single row in the primary table!";
        Result r = Result.create(kvs);
        scanner.close();
        return r;
    }

    protected long getOldestTimestamp(Collection<List<Cell>> cellLists) {
        Ordering<List<Cell>> cellListOrdering = new Ordering<List<Cell>>(){

            public int compare(List<Cell> left, List<Cell> right) {
                return Longs.compare((long)((Cell)Iterables.getLast(left)).getTimestamp(), (long)((Cell)Iterables.getLast(right)).getTimestamp());
            }
        };
        List minList = (List)cellListOrdering.min(cellLists);
        return ((Cell)Iterables.getLast((Iterable)minList)).getTimestamp();
    }
}

