/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.IndexFailurePolicy;
import org.apache.phoenix.hbase.index.write.IndexWriterUtils;

public class InfiniteRetryFailurePolicy
implements IndexFailurePolicy {
    private static final Log LOG = LogFactory.getLog(InfiniteRetryFailurePolicy.class);
    public static long INDEX_RETRY_LOG_PAUSE = 5000L;
    private RegionCoprocessorEnvironment env;
    private HTableFactory factory;
    private long indexRetryPause;
    private Admin admin;
    private int maxRetryBeforeCheckTableExistence;

    @Override
    public void setup(Stoppable parent, RegionCoprocessorEnvironment env) {
        this.env = env;
        Configuration conf = env.getConfiguration();
        this.indexRetryPause = conf.getLong("phoenix.functions.index.update.retryPause", 500L);
        this.maxRetryBeforeCheckTableExistence = conf.getInt("phoenix.functions.index.checkTableExists.frequency", 5);
        this.factory = IndexWriterUtils.getDefaultDelegateHTableFactory((CoprocessorEnvironment)env);
        try {
            this.admin = this.factory.getConnection().getAdmin();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(String why) {
        try {
            this.admin.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Closed admin failed!");
            e.printStackTrace();
        }
        LOG.debug((Object)(this.getClass().getName() + " is stopped!"));
    }

    public boolean isStopped() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFailure(Multimap<HTableInterfaceReference, Mutation> attempted, Exception cause) throws IOException {
        Set entries = attempted.asMap().entrySet();
        long start = System.currentTimeMillis();
        block20: for (Map.Entry entry : entries) {
            List mutations = (List)entry.getValue();
            HTableInterfaceReference tableReference = (HTableInterfaceReference)entry.getKey();
            ImmutableBytesPtr tableName = tableReference.get();
            long retry = 0L;
            while (true) {
                block23: {
                    HTableInterface table = null;
                    try {
                        table = this.factory.getTable(tableName);
                        table.batch(mutations);
                        if (!LOG.isDebugEnabled()) continue block20;
                        LOG.debug((Object)("Succeeded retry " + mutations.size() + " index updates to " + tableReference.getTableName() + " after retry " + retry + " times."));
                        continue block20;
                    }
                    catch (TableNotFoundException e) {
                        LOG.info((Object)("Stop retrying index update when index table not found. tableName = " + tableReference));
                        continue block20;
                    }
                    catch (Throwable t) {
                        if (++retry % (long)this.maxRetryBeforeCheckTableExistence == 0L && this.indexTableNotExists(tableName)) {
                            LOG.info((Object)("Stop retrying index update when index table not found. tableName = " + tableReference));
                            continue block20;
                        }
                        long now = System.currentTimeMillis();
                        if (now - start <= INDEX_RETRY_LOG_PAUSE) break block23;
                        LOG.error((Object)("Retry index updates to " + tableReference + " for " + retry + " times."));
                        start = now;
                    }
                    finally {
                        if (table == null) continue block20;
                        try {
                            table.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)"Failed closing table", (Throwable)e);
                        }
                        continue block20;
                    }
                }
                try {
                    Thread.sleep(this.indexRetryPause);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean indexTableNotExists(ImmutableBytesPtr tableName) {
        boolean notExists = false;
        try {
            notExists = !this.admin.tableExists(TableName.valueOf((byte[])tableName.copyBytesIfNecessary()));
        }
        catch (Throwable t) {
            LOG.error((Object)("Failed check table existence " + tableName.toString()), t);
        }
        finally {
            if (this.admin != null) {
                try {
                    this.admin.close();
                }
                catch (Throwable t) {
                    LOG.error((Object)"Failed closing admin object", t);
                }
            }
        }
        return notExists;
    }
}

