/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.exception.MultiIndexWriteFailureException;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.IndexFailurePolicy;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.TrackingParallelWriterIndexCommitter;

public class RecoveryIndexWriter
extends IndexWriter {
    private static final Log LOG = LogFactory.getLog(RecoveryIndexWriter.class);
    private Set<HTableInterfaceReference> nonExistingTablesList = new HashSet<HTableInterfaceReference>();
    private HBaseAdmin admin;

    public RecoveryIndexWriter(IndexFailurePolicy policy, RegionCoprocessorEnvironment env, String name) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        super(new TrackingParallelWriterIndexCommitter(), policy, env, name);
        this.admin = new HBaseAdmin(env.getConfiguration());
    }

    @Override
    public void write(Collection<Pair<Mutation, byte[]>> toWrite, boolean allowLocalUpdates) throws IOException {
        try {
            this.write(this.resolveTableReferences(toWrite), allowLocalUpdates);
        }
        catch (MultiIndexWriteFailureException e) {
            for (HTableInterfaceReference table : e.getFailedTables()) {
                if (!this.admin.tableExists(table.getTableName())) {
                    LOG.warn((Object)("Failure due to non existing table: " + table.getTableName()));
                    this.nonExistingTablesList.add(table);
                    continue;
                }
                throw e;
            }
        }
    }

    @Override
    protected Multimap<HTableInterfaceReference, Mutation> resolveTableReferences(Collection<Pair<Mutation, byte[]>> indexUpdates) {
        ArrayListMultimap updates = ArrayListMultimap.create();
        HashMap<ImmutableBytesPtr, HTableInterfaceReference> tables = new HashMap<ImmutableBytesPtr, HTableInterfaceReference>(updates.size());
        for (Pair<Mutation, byte[]> entry : indexUpdates) {
            byte[] tableName = (byte[])entry.getSecond();
            ImmutableBytesPtr ptr = new ImmutableBytesPtr(tableName);
            HTableInterfaceReference table = (HTableInterfaceReference)tables.get((Object)ptr);
            if (this.nonExistingTablesList.contains(table)) {
                LOG.debug((Object)("Edits found for non existing table: " + table.getTableName() + " so skipping it!!"));
                continue;
            }
            if (table == null) {
                table = new HTableInterfaceReference(ptr);
                tables.put(ptr, table);
            }
            updates.put((Object)table, entry.getFirst());
        }
        return updates;
    }

    @Override
    public void stop(String why) {
        super.stop(why);
        if (this.admin != null) {
            try {
                this.admin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

