/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.htrace.Sampler;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.call.CallRunner;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.function.FunctionArgumentType;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.iterate.DefaultTableResultIteratorFactory;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.iterate.TableResultIteratorFactory;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.jdbc.PhoenixStatementFactory;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateConnectionQueryServices;
import org.apache.phoenix.query.MetaDataMutated;
import org.apache.phoenix.query.PropertyPolicyProvider;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixConnection
implements Connection,
MetaDataMutated,
SQLCloseable {
    private final String url;
    private String schema;
    private final ConnectionQueryServices services;
    private final Properties info;
    private final Map<PDataType<?>, Format> formatters = new HashMap();
    private final int mutateBatchSize;
    private final long mutateBatchSizeBytes;
    private final Long scn;
    private final boolean buildingIndex;
    private MutationState mutationState;
    private List<PhoenixStatement> statements = new ArrayList<PhoenixStatement>();
    private boolean isAutoFlush = false;
    private boolean isAutoCommit = false;
    private PMetaData metaData;
    private final PName tenantId;
    private final String datePattern;
    private final String timePattern;
    private final String timestampPattern;
    private int statementExecutionCounter;
    private TraceScope traceScope = null;
    private volatile boolean isClosed = false;
    private Sampler<?> sampler;
    private boolean readOnly = false;
    private Consistency consistency = Consistency.STRONG;
    private Map<String, String> customTracingAnnotations = Collections.emptyMap();
    private final boolean isRequestLevelMetricsEnabled;
    private final boolean isDescVarLengthRowKeyUpgrade;
    private ParallelIteratorFactory parallelIteratorFactory;
    private final LinkedBlockingQueue<WeakReference<TableResultIterator>> scannerQueue;
    private TableResultIteratorFactory tableResultIteratorFactory;
    private boolean isRunningUpgrade;

    private static Properties newPropsWithSCN(long scn, Properties props) {
        props = new Properties(props);
        props.setProperty("CurrentSCN", Long.toString(scn));
        return props;
    }

    public PhoenixConnection(PhoenixConnection connection, boolean isDescRowKeyOrderUpgrade, boolean isRunningUpgrade) throws SQLException {
        this(connection.getQueryServices(), connection.getURL(), connection.getClientInfo(), connection.metaData, connection.getMutationState(), isDescRowKeyOrderUpgrade, isRunningUpgrade, connection.buildingIndex);
        this.isAutoCommit = connection.isAutoCommit;
        this.isAutoFlush = connection.isAutoFlush;
        this.sampler = connection.sampler;
        this.statementExecutionCounter = connection.statementExecutionCounter;
    }

    public PhoenixConnection(PhoenixConnection connection) throws SQLException {
        this(connection, connection.isDescVarLengthRowKeyUpgrade(), connection.isRunningUpgrade());
    }

    public PhoenixConnection(PhoenixConnection connection, MutationState mutationState) throws SQLException {
        this(connection.getQueryServices(), connection.getURL(), connection.getClientInfo(), connection.getMetaDataCache(), mutationState, connection.isDescVarLengthRowKeyUpgrade(), connection.isRunningUpgrade(), connection.buildingIndex);
    }

    public PhoenixConnection(PhoenixConnection connection, long scn) throws SQLException {
        this(connection.getQueryServices(), connection, scn);
    }

    public PhoenixConnection(ConnectionQueryServices services, PhoenixConnection connection, long scn) throws SQLException {
        this(services, connection.getURL(), PhoenixConnection.newPropsWithSCN(scn, connection.getClientInfo()), connection.metaData, connection.getMutationState(), connection.isDescVarLengthRowKeyUpgrade(), connection.isRunningUpgrade(), connection.buildingIndex);
        this.isAutoCommit = connection.isAutoCommit;
        this.isAutoFlush = connection.isAutoFlush;
        this.sampler = connection.sampler;
        this.statementExecutionCounter = connection.statementExecutionCounter;
    }

    public PhoenixConnection(ConnectionQueryServices services, String url, Properties info, PMetaData metaData) throws SQLException {
        this(services, url, info, metaData, null, false, false, false);
    }

    public PhoenixConnection(PhoenixConnection connection, ConnectionQueryServices services, Properties info) throws SQLException {
        this(services, connection.url, info, connection.metaData, null, connection.isDescVarLengthRowKeyUpgrade(), connection.isRunningUpgrade(), connection.buildingIndex);
    }

    private PhoenixConnection(ConnectionQueryServices services, String url, Properties info, PMetaData metaData, MutationState mutationState, boolean isDescVarLengthRowKeyUpgrade, boolean isRunningUpgrade, boolean buildingIndex) throws SQLException {
        GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_ATTEMPTED_COUNTER.increment();
        this.url = url;
        this.isDescVarLengthRowKeyUpgrade = isDescVarLengthRowKeyUpgrade;
        PropertyPolicyProvider.getPropertyPolicy().evaluate(info);
        this.info = info == null ? new Properties() : PropertiesUtil.deepCopy(info);
        final PName tenantId = JDBCUtil.getTenantId(url, info);
        if (this.info.isEmpty() && tenantId == null) {
            this.services = services;
        } else {
            ReadOnlyProps currentProps;
            ReadOnlyProps augmentedProps;
            if (tenantId != null) {
                services = services.getChildQueryServices(tenantId.getBytesPtr());
            }
            this.services = (augmentedProps = (currentProps = services.getProps()).addAll(PhoenixConnection.filterKnownNonProperties(this.info))) == currentProps ? services : new DelegateConnectionQueryServices(services){

                @Override
                public ReadOnlyProps getProps() {
                    return augmentedProps;
                }
            };
        }
        Long scnParam = JDBCUtil.getCurrentSCN(url, this.info);
        PhoenixConnection.checkScn(scnParam);
        Long buildIndexAtParam = JDBCUtil.getBuildIndexSCN(url, this.info);
        PhoenixConnection.checkBuildIndexAt(buildIndexAtParam);
        PhoenixConnection.checkScnAndBuildIndexAtEquality(scnParam, buildIndexAtParam);
        this.scn = scnParam != null ? scnParam : buildIndexAtParam;
        this.buildingIndex = buildingIndex || buildIndexAtParam != null;
        this.isAutoFlush = this.services.getProps().getBoolean("phoenix.transactions.enabled", false) && this.services.getProps().getBoolean("phoenix.transactions.autoFlush", false);
        this.isAutoCommit = JDBCUtil.getAutoCommit(url, this.info, this.services.getProps().getBoolean("phoenix.connection.autoCommit", false));
        this.consistency = JDBCUtil.getConsistencyLevel(url, this.info, this.services.getProps().get("phoenix.connection.consistency", QueryServicesOptions.DEFAULT_CONSISTENCY_LEVEL));
        this.schema = JDBCUtil.getSchema(url, this.info, this.services.getProps().get("phoenix.connection.schema", QueryServicesOptions.DEFAULT_SCHEMA));
        this.tenantId = tenantId;
        this.mutateBatchSize = JDBCUtil.getMutateBatchSize(url, this.info, this.services.getProps());
        this.mutateBatchSizeBytes = JDBCUtil.getMutateBatchSizeBytes(url, this.info, this.services.getProps());
        this.datePattern = this.services.getProps().get("phoenix.query.dateFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        this.timePattern = this.services.getProps().get("phoenix.query.timeFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        this.timestampPattern = this.services.getProps().get("phoenix.query.timestampFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        String numberPattern = this.services.getProps().get("phoenix.query.numberFormat", "#,##0.###");
        int maxSize = this.services.getProps().getInt("phoenix.mutate.maxSize", 500000);
        int maxSizeBytes = this.services.getProps().getInt("phoenix.mutate.maxSizeBytes", 0x6400000);
        Format dateFormat = DateUtil.getDateFormatter(this.datePattern);
        Format timeFormat = DateUtil.getDateFormatter(this.timePattern);
        Format timestampFormat = DateUtil.getDateFormatter(this.timestampPattern);
        this.formatters.put(PDate.INSTANCE, dateFormat);
        this.formatters.put(PTime.INSTANCE, timeFormat);
        this.formatters.put(PTimestamp.INSTANCE, timestampFormat);
        this.formatters.put(PUnsignedDate.INSTANCE, dateFormat);
        this.formatters.put(PUnsignedTime.INSTANCE, timeFormat);
        this.formatters.put(PUnsignedTimestamp.INSTANCE, timestampFormat);
        this.formatters.put(PDecimal.INSTANCE, FunctionArgumentType.NUMERIC.getFormatter(numberPattern));
        PMetaData.Pruner pruner = new PMetaData.Pruner(){

            @Override
            public boolean prune(PTable table) {
                long maxTimestamp = PhoenixConnection.this.scn == null ? Long.MAX_VALUE : PhoenixConnection.this.scn;
                return table.getType() != PTableType.SYSTEM && (table.getTimeStamp() >= maxTimestamp || table.getTenantId() != null && !Objects.equal((Object)tenantId, (Object)table.getTenantId()));
            }

            @Override
            public boolean prune(PFunction function) {
                long maxTimestamp = PhoenixConnection.this.scn == null ? Long.MAX_VALUE : PhoenixConnection.this.scn;
                return function.getTimeStamp() >= maxTimestamp || function.getTenantId() != null && !Objects.equal((Object)tenantId, (Object)function.getTenantId());
            }
        };
        this.isRequestLevelMetricsEnabled = JDBCUtil.isCollectingRequestLevelMetricsEnabled(url, info, this.services.getProps());
        this.mutationState = mutationState == null ? this.newMutationState(maxSize, maxSizeBytes) : new MutationState(mutationState);
        this.metaData = metaData;
        this.metaData.pruneTables(pruner);
        this.metaData.pruneFunctions(pruner);
        this.services.addConnection(this);
        this.sampler = Tracing.getConfiguredSampler(this);
        this.customTracingAnnotations = this.getImmutableCustomTracingAnnotations();
        this.scannerQueue = new LinkedBlockingQueue();
        this.tableResultIteratorFactory = new DefaultTableResultIteratorFactory();
        this.isRunningUpgrade = isRunningUpgrade;
        GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.increment();
    }

    private static void checkScn(Long scnParam) throws SQLException {
        if (scnParam != null && scnParam < 0L) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_SCN).build().buildException();
        }
    }

    private static void checkBuildIndexAt(Long replayAtParam) throws SQLException {
        if (replayAtParam != null && replayAtParam < 0L) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_REPLAY_AT).build().buildException();
        }
    }

    private static void checkScnAndBuildIndexAtEquality(Long scnParam, Long replayAt) throws SQLException {
        if (scnParam != null && replayAt != null && !scnParam.equals(replayAt)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNEQUAL_SCN_AND_BUILD_INDEX_AT).build().buildException();
        }
    }

    private static Properties filterKnownNonProperties(Properties info) {
        Properties prunedProperties = info;
        for (String property : PhoenixRuntime.CONNECTION_PROPERTIES) {
            if (!info.containsKey(property)) continue;
            if (prunedProperties == info) {
                prunedProperties = PropertiesUtil.deepCopy(info);
            }
            prunedProperties.remove(property);
        }
        return prunedProperties;
    }

    private ImmutableMap<String, String> getImmutableCustomTracingAnnotations() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        result.putAll(JDBCUtil.getAnnotations(this.url, this.info));
        if (this.getSCN() != null) {
            result.put((Object)"CurrentSCN", (Object)this.getSCN().toString());
        }
        if (this.getTenantId() != null) {
            result.put((Object)"TenantId", (Object)this.getTenantId().getString());
        }
        return result.build();
    }

    public Sampler<?> getSampler() {
        return this.sampler;
    }

    public void setSampler(Sampler<?> sampler) throws SQLException {
        this.sampler = sampler;
    }

    public Map<String, String> getCustomTracingAnnotations() {
        return this.customTracingAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int executeStatements(Reader reader, List<Object> binds, PrintStream out) throws IOException, SQLException {
        bindsOffset = 0;
        nStatements = 0;
        parser = new PhoenixStatement.PhoenixStatementParser(reader);
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                stmt = null;
                try {
                    stmt = new PhoenixPreparedStatement(this, parser);
                    paramMetaData = stmt.getParameterMetaData();
                    for (i = 0; i < paramMetaData.getParameterCount(); ++i) {
                        stmt.setObject(i + 1, binds.get(bindsOffset + i));
                    }
                    start = System.currentTimeMillis();
                    isQuery = stmt.execute();
                    if (isQuery) {
                        rs = stmt.getResultSet();
                        if (!rs.next()) {
                            if (out != null) {
                                out.println("no rows selected");
                            }
                        } else {
                            columnCount = 0;
                            if (out != null) {
                                md = rs.getMetaData();
                                columnCount = md.getColumnCount();
                                for (i = 1; i <= columnCount; ++i) {
                                    displayWidth = md.getColumnDisplaySize(i);
                                    label = md.getColumnLabel(i);
                                    if (md.isSigned(i)) {
                                        out.print(displayWidth < label.length() ? label.substring(0, displayWidth) : Strings.padStart((String)label, (int)displayWidth, (char)' '));
                                        out.print(' ');
                                        continue;
                                    }
                                    out.print(displayWidth < label.length() ? label.substring(0, displayWidth) : Strings.padEnd((String)md.getColumnLabel(i), (int)displayWidth, (char)' '));
                                    out.print(' ');
                                }
                                out.println();
                                for (i = 1; i <= columnCount; ++i) {
                                    displayWidth = md.getColumnDisplaySize(i);
                                    out.print(Strings.padStart((String)"", (int)displayWidth, (char)'-'));
                                    out.print(' ');
                                }
                                out.println();
                            }
                            do {
                                if (out == null) continue;
                                md = rs.getMetaData();
                                for (i = 1; i <= columnCount; ++i) {
                                    displayWidth = md.getColumnDisplaySize(i);
                                    value = rs.getString(i);
                                    v0 = valueString = value == null ? "<null>" : value;
                                    if (md.isSigned(i)) {
                                        out.print(Strings.padStart((String)valueString, (int)displayWidth, (char)' '));
                                    } else {
                                        out.print(Strings.padEnd((String)valueString, (int)displayWidth, (char)' '));
                                    }
                                    out.print(' ');
                                }
                                out.println();
                            } while (rs.next());
                        }
                    } else if (out != null && (updateCount = stmt.getUpdateCount()) >= 0) {
                        out.println((updateCount == 0 ? "no" : Integer.valueOf(updateCount)) + (updateCount == 1 ? " row " : " rows ") + stmt.getUpdateOperation().toString());
                    }
                    bindsOffset += paramMetaData.getParameterCount();
                    elapsedDuration = (double)(System.currentTimeMillis() - start) / 1000.0;
                    out.println("Time: " + elapsedDuration + " sec(s)\n");
                    ++nStatements;
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                    continue;
                }
                break;
            }
        }
        catch (EOFException var7_8) {
            return nStatements;
        }
        ** GOTO lbl-1000
    }

    @Nullable
    public PName getTenantId() {
        return this.tenantId;
    }

    public Long getSCN() {
        return this.scn;
    }

    public boolean isBuildingIndex() {
        return this.buildingIndex;
    }

    public int getMutateBatchSize() {
        return this.mutateBatchSize;
    }

    public long getMutateBatchSizeBytes() {
        return this.mutateBatchSizeBytes;
    }

    public PMetaData getMetaDataCache() {
        return this.metaData;
    }

    public PTable getTable(PTableKey key) throws TableNotFoundException {
        return this.metaData.getTableRef(key).getTable();
    }

    public PTableRef getTableRef(PTableKey key) throws TableNotFoundException {
        return this.metaData.getTableRef(key);
    }

    protected MutationState newMutationState(int maxSize, int maxSizeBytes) {
        return new MutationState(maxSize, maxSizeBytes, this);
    }

    public MutationState getMutationState() {
        return this.mutationState;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public Format getFormatter(PDataType type) {
        return this.formatters.get(type);
    }

    public String getURL() {
        return this.url;
    }

    public ConnectionQueryServices getQueryServices() {
        return this.services;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStatements() throws SQLException {
        List<PhoenixStatement> statements = this.statements;
        this.statements = Lists.newArrayList();
        try {
            this.mutationState.rollback();
        }
        catch (SQLException sQLException) {
            try {
                SQLCloseables.closeAll(statements);
            }
            finally {
                statements.clear();
            }
        }
        finally {
            try {
                SQLCloseables.closeAll(statements);
            }
            finally {
                statements.clear();
            }
        }
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CONNECTION_CLOSED).build().buildException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            this.clearMetrics();
            try {
                if (this.traceScope != null) {
                    this.traceScope.close();
                }
                this.closeStatements();
            }
            finally {
                this.services.removeConnection(this);
            }
        }
        finally {
            this.isClosed = true;
            GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.decrement();
        }
    }

    @Override
    public void commit() throws SQLException {
        CallRunner.run(new CallRunner.CallableThrowable<Void, SQLException>(){

            @Override
            public Void call() throws SQLException {
                PhoenixConnection.this.checkOpen();
                PhoenixConnection.this.mutationState.commit();
                return null;
            }
        }, Tracing.withTracing(this, "committing mutations"));
        this.statementExecutionCounter = 0;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkOpen();
        PDataType arrayPrimitiveType = PDataType.fromSqlTypeName(typeName);
        return PArrayDataType.instantiatePhoenixArray(arrayPrimitiveType, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public List<PhoenixStatement> getStatements() {
        return this.statements;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        PhoenixStatement statement = new PhoenixStatement(this);
        this.statements.add(statement);
        return statement;
    }

    public PhoenixStatement createStatement(PhoenixStatementFactory statementFactory) throws SQLException {
        PhoenixStatement statement = statementFactory.newStatement(this);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.isAutoCommit;
    }

    public boolean getAutoFlush() {
        return this.isAutoFlush;
    }

    public void setAutoFlush(boolean autoFlush) throws SQLException {
        if (autoFlush && !this.services.getProps().getBoolean("phoenix.transactions.enabled", false)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MUST_BE_ENABLED_TO_SET_AUTO_FLUSH).build().buildException();
        }
        this.isAutoFlush = autoFlush;
    }

    public void flush() throws SQLException {
        this.mutationState.sendUncommitted();
    }

    public void setTransactionContext(PhoenixTransactionContext txContext) throws SQLException {
        if (!this.services.getProps().getBoolean("phoenix.transactions.enabled", false)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MUST_BE_ENABLED_TO_SET_TX_CONTEXT).build().buildException();
        }
        this.mutationState.rollback();
        this.mutationState = new MutationState(this.mutationState.getMaxSize(), this.mutationState.getMaxSizeBytes(), this, txContext);
        this.setAutoFlush(true);
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.tenantId == null ? "" : this.tenantId.getString();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties(this.info);
    }

    @Override
    public String getClientInfo(String name) {
        return this.info.getProperty(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return new PhoenixDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        boolean transactionsEnabled = this.getQueryServices().getProps().getBoolean("phoenix.transactions.enabled", false);
        return transactionsEnabled ? 4 : 2;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return Collections.emptyMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly || this.scn != null && !this.buildingIndex && !this.isRunningUpgrade;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        PhoenixPreparedStatement statement = new PhoenixPreparedStatement(this, sql);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
        CallRunner.run(new CallRunner.CallableThrowable<Void, SQLException>(){

            @Override
            public Void call() throws SQLException {
                PhoenixConnection.this.checkOpen();
                PhoenixConnection.this.mutationState.rollback();
                return null;
            }
        }, Tracing.withTracing(this, "rolling back"));
        this.statementExecutionCounter = 0;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean isAutoCommit) throws SQLException {
        this.checkOpen();
        this.isAutoCommit = isAutoCommit;
    }

    public void setConsistency(Consistency val) {
        this.consistency = val;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        if (!this.getCatalog().equalsIgnoreCase(catalog)) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        this.readOnly = readOnly;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        boolean transactionsEnabled = this.getQueryServices().getProps().getBoolean("phoenix.transactions.enabled", false);
        if (level == 8) {
            throw new SQLFeatureNotSupportedException();
        }
        if (!transactionsEnabled && level == 4) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MUST_BE_ENABLED_TO_SET_ISOLATION_LEVEL).build().buildException();
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage(this.getClass().getName() + " not unwrappable from " + iface.getName()).build().buildException();
        }
        return (T)this;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        this.schema = schema;
    }

    @Override
    public String getSchema() throws SQLException {
        return SchemaUtil.normalizeIdentifier(this.schema);
    }

    public PSchema getSchema(PTableKey key) throws SchemaNotFoundException {
        return this.metaData.getSchema(key);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void addTable(PTable table, long resolvedTime) throws SQLException {
        this.metaData.addTable(table, resolvedTime);
        this.getQueryServices().addTable(table, resolvedTime);
    }

    @Override
    public void updateResolvedTimestamp(PTable table, long resolvedTime) throws SQLException {
        this.metaData.updateResolvedTimestamp(table, resolvedTime);
        this.getQueryServices().updateResolvedTimestamp(table, resolvedTime);
    }

    @Override
    public void addFunction(PFunction function) throws SQLException {
        if (this.scn == null || this.scn > function.getTimeStamp()) {
            this.metaData.addFunction(function);
        }
        this.getQueryServices().addFunction(function);
    }

    @Override
    public void addSchema(PSchema schema) throws SQLException {
        this.metaData.addSchema(schema);
        this.getQueryServices().addSchema(schema);
    }

    @Override
    public void removeTable(PName tenantId, String tableName, String parentTableName, long tableTimeStamp) throws SQLException {
        this.metaData.removeTable(tenantId, tableName, parentTableName, tableTimeStamp);
        this.getQueryServices().removeTable(tenantId, tableName, parentTableName, tableTimeStamp);
    }

    @Override
    public void removeFunction(PName tenantId, String functionName, long tableTimeStamp) throws SQLException {
        this.metaData.removeFunction(tenantId, functionName, tableTimeStamp);
        this.getQueryServices().removeFunction(tenantId, functionName, tableTimeStamp);
    }

    @Override
    public void removeColumn(PName tenantId, String tableName, List<PColumn> columnsToRemove, long tableTimeStamp, long tableSeqNum, long resolvedTime) throws SQLException {
        this.metaData.removeColumn(tenantId, tableName, columnsToRemove, tableTimeStamp, tableSeqNum, resolvedTime);
        this.getQueryServices().removeColumn(tenantId, tableName, columnsToRemove, tableTimeStamp, tableSeqNum, resolvedTime);
    }

    protected boolean removeStatement(PhoenixStatement statement) throws SQLException {
        return this.statements.remove(statement);
    }

    public KeyValueBuilder getKeyValueBuilder() {
        return this.services.getKeyValueBuilder();
    }

    public int getStatementExecutionCounter() {
        return this.statementExecutionCounter;
    }

    public void incrementStatementExecutionCounter() {
        ++this.statementExecutionCounter;
    }

    public TraceScope getTraceScope() {
        return this.traceScope;
    }

    public void setTraceScope(TraceScope traceScope) {
        this.traceScope = traceScope;
    }

    public Map<String, Map<MetricType, Long>> getMutationMetrics() {
        return this.mutationState.getMutationMetricQueue().aggregate();
    }

    public Map<String, Map<MetricType, Long>> getReadMetrics() {
        return this.mutationState.getReadMetricQueue() != null ? this.mutationState.getReadMetricQueue().aggregate() : Collections.emptyMap();
    }

    public boolean isRequestLevelMetricsEnabled() {
        return this.isRequestLevelMetricsEnabled;
    }

    public void clearMetrics() {
        this.mutationState.getMutationMetricQueue().clearMetrics();
        if (this.mutationState.getReadMetricQueue() != null) {
            this.mutationState.getReadMetricQueue().clearMetrics();
        }
    }

    public boolean isDescVarLengthRowKeyUpgrade() {
        return this.isDescVarLengthRowKeyUpgrade;
    }

    public ParallelIteratorFactory getIteratorFactory() {
        return this.parallelIteratorFactory;
    }

    public void setIteratorFactory(ParallelIteratorFactory parallelIteratorFactory) {
        this.parallelIteratorFactory = parallelIteratorFactory;
    }

    public void addIteratorForLeaseRenewal(@Nonnull TableResultIterator itr) {
        if (this.services.supportsFeature(ConnectionQueryServices.Feature.RENEW_LEASE)) {
            Preconditions.checkNotNull((Object)itr);
            this.scannerQueue.add(new WeakReference<TableResultIterator>(itr));
        }
    }

    public LinkedBlockingQueue<WeakReference<TableResultIterator>> getScanners() {
        return this.scannerQueue;
    }

    @Nonnull
    @VisibleForTesting
    public TableResultIteratorFactory getTableResultIteratorFactory() {
        return this.tableResultIteratorFactory;
    }

    @VisibleForTesting
    public void setTableResultIteratorFactory(TableResultIteratorFactory factory) {
        Preconditions.checkNotNull((Object)factory);
        this.tableResultIteratorFactory = factory;
    }

    @Override
    public void removeSchema(PSchema schema, long schemaTimeStamp) {
        this.metaData.removeSchema(schema, schemaTimeStamp);
        this.getQueryServices().removeSchema(schema, schemaTimeStamp);
    }

    public boolean isRunningUpgrade() {
        return this.isRunningUpgrade;
    }

    public void setRunningUpgrade(boolean isRunningUpgrade) {
        this.isRunningUpgrade = isRunningUpgrade;
    }

    static {
        Tracing.addTraceMetricsSource();
    }
}

