/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.DirectHTableWriter;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixIndexPartialBuildMapper
extends TableMapper<ImmutableBytesWritable, IntWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixIndexPartialBuildMapper.class);
    private PhoenixConnection connection;
    private DirectHTableWriter writer;
    private int batchSize;
    private List<Mutation> mutations;
    private ImmutableBytesPtr maintainers;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration configuration = context.getConfiguration();
        this.writer = new DirectHTableWriter(configuration);
        try {
            Properties overrideProps = new Properties();
            String scn = configuration.get("phoenix.mr.currentscn.value");
            String txScnValue = configuration.get("phoenix.mr.txscn.value");
            if (txScnValue == null && scn != null) {
                overrideProps.put("BuildIndexAt", scn);
            }
            this.connection = ConnectionUtil.getOutputConnection(configuration, overrideProps).unwrap(PhoenixConnection.class);
            this.connection.setAutoCommit(false);
            ConnectionQueryServices services = this.connection.getQueryServices();
            int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
            this.batchSize = Math.min(this.connection.getMutateBatchSize(), maxSize);
            LOG.info("Mutation Batch Size = " + this.batchSize);
            this.mutations = Lists.newArrayListWithExpectedSize((int)this.batchSize);
            this.maintainers = new ImmutableBytesPtr(PhoenixConfigurationUtil.getIndexMaintainers(configuration));
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException, InterruptedException {
        context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).increment(1L);
        try {
            byte[] attribValue = ByteUtil.copyKeyBytesIfNecessary(this.maintainers);
            byte[] uuidValue = ServerCacheClient.generateId();
            Put put = null;
            Delete del = null;
            for (Cell cell : value.rawCells()) {
                if (KeyValue.Type.codeToType((byte)cell.getTypeByte()) == KeyValue.Type.Put) {
                    if (put == null) {
                        put = new Put(CellUtil.cloneRow((Cell)cell));
                        put.setAttribute("IdxUUID", uuidValue);
                        put.setAttribute("IdxProtoMD", attribValue);
                        put.setAttribute("_IGNORE_NEWER_MUTATIONS", BaseScannerRegionObserver.REPLAY_ONLY_INDEX_WRITES);
                        this.mutations.add((Mutation)put);
                    }
                    put.add(cell);
                    continue;
                }
                if (del == null) {
                    del = new Delete(CellUtil.cloneRow((Cell)cell));
                    del.setAttribute("IdxUUID", uuidValue);
                    del.setAttribute("IdxProtoMD", attribValue);
                    del.setAttribute("_IGNORE_NEWER_MUTATIONS", BaseScannerRegionObserver.REPLAY_ONLY_INDEX_WRITES);
                    this.mutations.add((Mutation)del);
                }
                del.addDeleteMarker(cell);
            }
            if (context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue() % (long)this.batchSize == 0L) {
                this.writeBatch(this.mutations, context);
                this.mutations.clear();
            }
            context.progress();
        }
        catch (SQLException e) {
            LOG.error(" Error {}  while read/write of a record ", (Object)e.getMessage());
            context.getCounter((Enum)PhoenixJobCounters.FAILED_RECORDS).increment(1L);
            throw new RuntimeException(e);
        }
    }

    private void writeBatch(List<Mutation> mutations, Mapper.Context context) throws IOException, SQLException, InterruptedException {
        this.writer.write(mutations);
        context.getCounter((Enum)PhoenixJobCounters.OUTPUT_RECORDS).increment((long)mutations.size());
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        try {
            if (!this.mutations.isEmpty()) {
                this.writeBatch(this.mutations, context);
            }
            context.write((Object)new ImmutableBytesWritable(UUID.randomUUID().toString().getBytes()), (Object)new IntWritable(0));
            super.cleanup(context);
        }
        catch (SQLException e) {
            LOG.error(" Error {}  while read/write of a record ", (Object)e.getMessage());
            context.getCounter((Enum)PhoenixJobCounters.FAILED_RECORDS).increment(1L);
            throw new RuntimeException(e);
        }
        finally {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    LOG.error("Error {} while closing connection in the PhoenixIndexMapper class ", (Object)e.getMessage());
                }
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
    }
}

