/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.mapreduce.PhoenixInputFormat;
import org.apache.phoenix.mapreduce.PhoenixOutputFormat;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;

public final class PhoenixMapReduceUtil {
    private PhoenixMapReduceUtil() {
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String tableName, String conditions, String ... fieldNames) {
        Configuration configuration = PhoenixMapReduceUtil.setInput(job, inputClass, tableName);
        if (conditions != null) {
            PhoenixConfigurationUtil.setInputTableConditions(configuration, conditions);
        }
        PhoenixConfigurationUtil.setSelectColumnNames(configuration, fieldNames);
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String tableName, String inputQuery) {
        Configuration configuration = PhoenixMapReduceUtil.setInput(job, inputClass, tableName);
        PhoenixConfigurationUtil.setInputQuery(configuration, inputQuery);
        PhoenixConfigurationUtil.setSchemaType(configuration, PhoenixConfigurationUtil.SchemaType.QUERY);
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String snapshotName, String tableName, Path restoreDir, String conditions, String ... fieldNames) throws IOException {
        Configuration configuration = PhoenixMapReduceUtil.setSnapshotInput(job, inputClass, snapshotName, tableName, restoreDir);
        if (conditions != null) {
            PhoenixConfigurationUtil.setInputTableConditions(configuration, conditions);
        }
        PhoenixConfigurationUtil.setSelectColumnNames(configuration, fieldNames);
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String snapshotName, String tableName, Path restoreDir, String inputQuery) throws IOException {
        Configuration configuration = PhoenixMapReduceUtil.setSnapshotInput(job, inputClass, snapshotName, tableName, restoreDir);
        if (inputQuery != null) {
            PhoenixConfigurationUtil.setInputQuery(configuration, inputQuery);
        }
    }

    private static Configuration setSnapshotInput(Job job, Class<? extends DBWritable> inputClass, String snapshotName, String tableName, Path restoreDir) {
        job.setInputFormatClass(PhoenixInputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setInputClass(configuration, inputClass);
        PhoenixConfigurationUtil.setSnapshotNameKey(configuration, snapshotName);
        PhoenixConfigurationUtil.setInputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setRestoreDirKey(configuration, new Path(restoreDir, UUID.randomUUID().toString()).toString());
        PhoenixConfigurationUtil.setSchemaType(configuration, PhoenixConfigurationUtil.SchemaType.QUERY);
        return configuration;
    }

    private static Configuration setInput(Job job, Class<? extends DBWritable> inputClass, String tableName) {
        job.setInputFormatClass(PhoenixInputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setInputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setInputClass(configuration, inputClass);
        return configuration;
    }

    public static void setInputCluster(Job job, String quorum) {
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setInputCluster(configuration, quorum);
    }

    public static void setOutput(Job job, String tableName, String columns) {
        job.setOutputFormatClass(PhoenixOutputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setOutputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setUpsertColumnNames(configuration, columns.split(","));
    }

    public static void setOutput(Job job, String tableName, String ... fieldNames) {
        job.setOutputFormatClass(PhoenixOutputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setOutputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setUpsertColumnNames(configuration, fieldNames);
    }

    public static void setOutputCluster(Job job, String quorum) {
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setOutputCluster(configuration, quorum);
    }
}

