// $ANTLR 3.5.2 PhoenixSQL.g 2018-07-02 11:53:19

/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.parse;

///CLOVER:OFF
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.filter.CompareFilter.CompareOp;
import java.lang.Boolean;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Stack;
import java.sql.SQLException;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PFunction.FunctionArgument;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.PTable.IndexType;
import org.apache.phoenix.schema.stats.StatisticsCollectionScope;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.parse.LikeParseNode.LikeType;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.parse.AddJarsStatement;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
@SuppressWarnings("all")
public class PhoenixSQLParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ACTIVE", "ADD", "ALL", "ALTER", 
		"AND", "ANY", "ARRAY", "AS", "ASC", "ASTERISK", "ASYNC", "AT", "BETWEEN", 
		"BIND_NAME", "BY", "CACHE", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_ESC", 
		"CLOSE", "COLON", "COLUMN", "COLUMNS", "COMMA", "COMMENT_AND_HINT_END", 
		"COMMENT_START", "CONCAT", "CONSTANT", "CONSTRAINT", "CREATE", "CURRENT", 
		"CURSOR", "CYCLE", "DBL_QUOTE_CHAR", "DECIMAL", "DECLARE", "DEFAULT", 
		"DEFAULTVALUE", "DELETE", "DESC", "DIGIT", "DISABLE", "DISTINCT", "DIVIDE", 
		"DOT", "DOUBLE", "DOUBLE_EQ", "DOUBLE_QUOTE", "DROP", "DUPLICATE", "ELSE", 
		"END", "EOL", "EQ", "EXECUTE", "EXISTS", "EXPLAIN", "Exponent", "FALSE", 
		"FETCH", "FIELDCHAR", "FIRST", "FOR", "FROM", "FULL", "FUNCTION", "GROUP", 
		"GT", "HAVING", "HINT_START", "IF", "IGNORE", "ILIKE", "IMMUTABLE", "IN", 
		"INCLUDE", "INCREMENT", "INDEX", "INNER", "INTO", "IS", "JAR", "JARS", 
		"JOIN", "KEY", "LAST", "LCURLY", "LEFT", "LETTER", "LIKE", "LIMIT", "LIST", 
		"LOCAL", "LPAREN", "LSQUARE", "LT", "MAXVALUE", "MINUS", "MINVALUE", "ML_COMMENT", 
		"ML_HINT", "NAME", "NEXT", "NOEQ1", "NOEQ2", "NOT", "NULL", "NULLS", "NUMBER", 
		"OFF", "OFFSET", "ON", "ONLY", "OPEN", "OR", "ORDER", "OTHER", "OUTER", 
		"OUTER_JOIN", "PERCENT", "PLUS", "POSINTEGER", "PRIMARY", "QUESTION", 
		"RCURLY", "REBUILD", "REPLACE", "RETURNS", "RIGHT", "ROW", "ROWS", "ROW_TIMESTAMP", 
		"RPAREN", "RSQUARE", "SAMPLING", "SCHEMA", "SELECT", "SEMICOLON", "SEQUENCE", 
		"SESSION", "SET", "SL_COMMENT", "SL_COMMENT1", "SL_COMMENT2", "SOME", 
		"SPLIT", "START", "STATISTICS", "STRING_LITERAL", "TABLE", "TABLES", "TABLESAMPLE", 
		"TEMPORARY", "THEN", "TILDE", "TRACE", "TRUE", "UNION", "UNUSABLE", "UPDATE", 
		"UPGRADE", "UPSERT", "USABLE", "USE", "USING", "VALUE", "VALUES", "VIEW", 
		"WHEN", "WHERE", "WITH", "WITHIN", "WS"
	};
	public static final int EOF=-1;
	public static final int ACTIVE=4;
	public static final int ADD=5;
	public static final int ALL=6;
	public static final int ALTER=7;
	public static final int AND=8;
	public static final int ANY=9;
	public static final int ARRAY=10;
	public static final int AS=11;
	public static final int ASC=12;
	public static final int ASTERISK=13;
	public static final int ASYNC=14;
	public static final int AT=15;
	public static final int BETWEEN=16;
	public static final int BIND_NAME=17;
	public static final int BY=18;
	public static final int CACHE=19;
	public static final int CASCADE=20;
	public static final int CASE=21;
	public static final int CAST=22;
	public static final int CHAR=23;
	public static final int CHAR_ESC=24;
	public static final int CLOSE=25;
	public static final int COLON=26;
	public static final int COLUMN=27;
	public static final int COLUMNS=28;
	public static final int COMMA=29;
	public static final int COMMENT_AND_HINT_END=30;
	public static final int COMMENT_START=31;
	public static final int CONCAT=32;
	public static final int CONSTANT=33;
	public static final int CONSTRAINT=34;
	public static final int CREATE=35;
	public static final int CURRENT=36;
	public static final int CURSOR=37;
	public static final int CYCLE=38;
	public static final int DBL_QUOTE_CHAR=39;
	public static final int DECIMAL=40;
	public static final int DECLARE=41;
	public static final int DEFAULT=42;
	public static final int DEFAULTVALUE=43;
	public static final int DELETE=44;
	public static final int DESC=45;
	public static final int DIGIT=46;
	public static final int DISABLE=47;
	public static final int DISTINCT=48;
	public static final int DIVIDE=49;
	public static final int DOT=50;
	public static final int DOUBLE=51;
	public static final int DOUBLE_EQ=52;
	public static final int DOUBLE_QUOTE=53;
	public static final int DROP=54;
	public static final int DUPLICATE=55;
	public static final int ELSE=56;
	public static final int END=57;
	public static final int EOL=58;
	public static final int EQ=59;
	public static final int EXECUTE=60;
	public static final int EXISTS=61;
	public static final int EXPLAIN=62;
	public static final int Exponent=63;
	public static final int FALSE=64;
	public static final int FETCH=65;
	public static final int FIELDCHAR=66;
	public static final int FIRST=67;
	public static final int FOR=68;
	public static final int FROM=69;
	public static final int FULL=70;
	public static final int FUNCTION=71;
	public static final int GROUP=72;
	public static final int GT=73;
	public static final int HAVING=74;
	public static final int HINT_START=75;
	public static final int IF=76;
	public static final int IGNORE=77;
	public static final int ILIKE=78;
	public static final int IMMUTABLE=79;
	public static final int IN=80;
	public static final int INCLUDE=81;
	public static final int INCREMENT=82;
	public static final int INDEX=83;
	public static final int INNER=84;
	public static final int INTO=85;
	public static final int IS=86;
	public static final int JAR=87;
	public static final int JARS=88;
	public static final int JOIN=89;
	public static final int KEY=90;
	public static final int LAST=91;
	public static final int LCURLY=92;
	public static final int LEFT=93;
	public static final int LETTER=94;
	public static final int LIKE=95;
	public static final int LIMIT=96;
	public static final int LIST=97;
	public static final int LOCAL=98;
	public static final int LPAREN=99;
	public static final int LSQUARE=100;
	public static final int LT=101;
	public static final int MAXVALUE=102;
	public static final int MINUS=103;
	public static final int MINVALUE=104;
	public static final int ML_COMMENT=105;
	public static final int ML_HINT=106;
	public static final int NAME=107;
	public static final int NEXT=108;
	public static final int NOEQ1=109;
	public static final int NOEQ2=110;
	public static final int NOT=111;
	public static final int NULL=112;
	public static final int NULLS=113;
	public static final int NUMBER=114;
	public static final int OFF=115;
	public static final int OFFSET=116;
	public static final int ON=117;
	public static final int ONLY=118;
	public static final int OPEN=119;
	public static final int OR=120;
	public static final int ORDER=121;
	public static final int OTHER=122;
	public static final int OUTER=123;
	public static final int OUTER_JOIN=124;
	public static final int PERCENT=125;
	public static final int PLUS=126;
	public static final int POSINTEGER=127;
	public static final int PRIMARY=128;
	public static final int QUESTION=129;
	public static final int RCURLY=130;
	public static final int REBUILD=131;
	public static final int REPLACE=132;
	public static final int RETURNS=133;
	public static final int RIGHT=134;
	public static final int ROW=135;
	public static final int ROWS=136;
	public static final int ROW_TIMESTAMP=137;
	public static final int RPAREN=138;
	public static final int RSQUARE=139;
	public static final int SAMPLING=140;
	public static final int SCHEMA=141;
	public static final int SELECT=142;
	public static final int SEMICOLON=143;
	public static final int SEQUENCE=144;
	public static final int SESSION=145;
	public static final int SET=146;
	public static final int SL_COMMENT=147;
	public static final int SL_COMMENT1=148;
	public static final int SL_COMMENT2=149;
	public static final int SOME=150;
	public static final int SPLIT=151;
	public static final int START=152;
	public static final int STATISTICS=153;
	public static final int STRING_LITERAL=154;
	public static final int TABLE=155;
	public static final int TABLES=156;
	public static final int TABLESAMPLE=157;
	public static final int TEMPORARY=158;
	public static final int THEN=159;
	public static final int TILDE=160;
	public static final int TRACE=161;
	public static final int TRUE=162;
	public static final int UNION=163;
	public static final int UNUSABLE=164;
	public static final int UPDATE=165;
	public static final int UPGRADE=166;
	public static final int UPSERT=167;
	public static final int USABLE=168;
	public static final int USE=169;
	public static final int USING=170;
	public static final int VALUE=171;
	public static final int VALUES=172;
	public static final int VIEW=173;
	public static final int WHEN=174;
	public static final int WHERE=175;
	public static final int WITH=176;
	public static final int WITHIN=177;
	public static final int WS=178;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public PhoenixSQLParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public PhoenixSQLParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return PhoenixSQLParser.tokenNames; }
	@Override public String getGrammarFileName() { return "PhoenixSQL.g"; }


	    
	    /**
	     * used to turn '?' binds into : binds.
	     */
	    private int anonBindNum;
	    private ParseNodeFactory factory;
	    private ParseContext.Stack contextStack = new ParseContext.Stack();
	    private Map<String, UDFParseNode> udfParseNodes = new HashMap<String, UDFParseNode>(1);

	    public void setParseNodeFactory(ParseNodeFactory factory) {
	        this.factory = factory;
	    }
	    
	    public boolean isCountFunction(String field) {
	        return CountAggregateFunction.NORMALIZED_NAME.equals(SchemaUtil.normalizeIdentifier(field));
	    }
	     
	    public int line(Token t) {
	        return t.getLine();
	    }

	    public int column(Token t) {
	        return t.getCharPositionInLine() + 1;
	    }
	    
	    private void throwRecognitionException(Token t) throws RecognitionException {
	        RecognitionException e = new RecognitionException();
	        e.token = t;
	        e.line = t.getLine();
	        e.charPositionInLine = t.getCharPositionInLine();
	        e.input = input;
	        throw e;
	    }
	    
	    public int getBindCount() {
	        return anonBindNum;
	    }
	    
	    public void resetBindCount() {
	        anonBindNum = 0;
	    }
	    
	    public String nextBind() {
	        return Integer.toString(++anonBindNum);
	    }
	    
	    public void updateBind(String namedBind){
	         int nBind = Integer.parseInt(namedBind);
	         if (nBind > anonBindNum) {
	             anonBindNum = nBind;
	         }
	    }

	    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow)
	        throws RecognitionException {
	        RecognitionException e = null;
	        // if next token is what we are looking for then "delete" this token
	        if (mismatchIsUnwantedToken(input, ttype)) {
	            e = new UnwantedTokenException(ttype, input);
	        } else if (mismatchIsMissingToken(input, follow)) {
	            Object inserted = getMissingSymbol(input, e, ttype, follow);
	            e = new MissingTokenException(ttype, input, inserted);
	        } else {
	            e = new MismatchedTokenException(ttype, input);
	        }
	        throw e;
	    }

	    public Object recoverFromMismatchedSet(IntStream input, RecognitionException e, BitSet follow)
	        throws RecognitionException
	    {
	        throw e;
	    }
	    
	    @Override
	    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
	        if (e instanceof MismatchedTokenException) {
	            MismatchedTokenException mte = (MismatchedTokenException)e;
	            String txt = mte.token.getText();
	            String p = mte.token.getType() == -1 ? "EOF" : PARAPHRASE[mte.token.getType()];
	            String expecting = (mte.expecting < PARAPHRASE.length && mte.expecting >= 0) ? PARAPHRASE[mte.expecting] : null;
	            if (expecting == null) {
	                return "unexpected token (" + line(mte.token) + "," + column(mte.token) + "): " + (txt != null ? txt : p);
	            } else {
	                return "expecting " + expecting +
	                    ", found '" + (txt != null ? txt : p) + "'";
	            }
	        } else if (e instanceof NoViableAltException) {
	            //NoViableAltException nvae = (NoViableAltException)e;
	            return "unexpected token: (" + line(e.token) + "," + column(e.token) + ")" + getTokenErrorDisplay(e.token);
	        }
	        return super.getErrorMessage(e, tokenNames);
	     }

	    public String getTokenErrorDisplay(int t) {
	        String ret = PARAPHRASE[t];
	        if (ret == null) ret = "<UNKNOWN>";
	        return ret;
	    }


	    private String[] PARAPHRASE = new String[getTokenNames().length];
	    {
	        PARAPHRASE[NAME] = "a field or entity name";
	        PARAPHRASE[NUMBER] = "a number";
	        PARAPHRASE[EQ] = "an equals sign";
	        PARAPHRASE[LT] = "a left angle bracket";
	        PARAPHRASE[GT] = "a right angle bracket";
	        PARAPHRASE[COMMA] = "a comma";
	        PARAPHRASE[LPAREN] = "a left parentheses";
	        PARAPHRASE[RPAREN] = "a right parentheses";
	        PARAPHRASE[SEMICOLON] = "a semi-colon";
	        PARAPHRASE[COLON] = "a colon";
	        PARAPHRASE[LSQUARE] = "left square bracket";
	        PARAPHRASE[RSQUARE] = "right square bracket";
	        PARAPHRASE[LCURLY] = "left curly bracket";
	        PARAPHRASE[RCURLY] = "right curly bracket";
	        PARAPHRASE[AT] = "at";
	        PARAPHRASE[MINUS] = "a subtraction";
	        PARAPHRASE[TILDE] = "a tilde";
	        PARAPHRASE[PLUS] = "an addition";
	        PARAPHRASE[ASTERISK] = "an asterisk";
	        PARAPHRASE[DIVIDE] = "a division";
	        PARAPHRASE[FIELDCHAR] = "a field character";
	        PARAPHRASE[LETTER] = "an ansi letter";
	        PARAPHRASE[POSINTEGER] = "a positive integer";
	        PARAPHRASE[DIGIT] = "a number from 0 to 9";
	    }



	// $ANTLR start "nextStatement"
	// PhoenixSQL.g:380:1: nextStatement returns [BindableStatement ret] : (s= oneStatement SEMICOLON | EOF );
	public final BindableStatement nextStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:381:5: (s= oneStatement SEMICOLON | EOF )
			int alt1=2;
			int LA1_0 = input.LA(1);
			if ( (LA1_0==ADD||LA1_0==ALTER||LA1_0==CLOSE||LA1_0==CREATE||LA1_0==DECLARE||LA1_0==DELETE||LA1_0==DROP||LA1_0==EXECUTE||LA1_0==EXPLAIN||LA1_0==FETCH||LA1_0==LIST||LA1_0==OPEN||LA1_0==SELECT||LA1_0==TRACE||LA1_0==UPDATE||LA1_0==UPSERT||LA1_0==USE) ) {
				alt1=1;
			}
			else if ( (LA1_0==EOF) ) {
				alt1=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 1, 0, input);
				throw nvae;
			}

			switch (alt1) {
				case 1 :
					// PhoenixSQL.g:381:8: s= oneStatement SEMICOLON
					{
					pushFollow(FOLLOW_oneStatement_in_nextStatement1244);
					s=oneStatement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					    		try {
					    			ret = s;
					    		} finally {
					    			udfParseNodes.clear();
					    		}
					    	}
					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_nextStatement1248); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:388:8: EOF
					{
					match(input,EOF,FOLLOW_EOF_in_nextStatement1257); if (state.failed) return ret;
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "nextStatement"



	// $ANTLR start "statement"
	// PhoenixSQL.g:392:1: statement returns [BindableStatement ret] : s= oneStatement EOF ;
	public final BindableStatement statement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		try {
			// PhoenixSQL.g:393:5: (s= oneStatement EOF )
			// PhoenixSQL.g:393:9: s= oneStatement EOF
			{
			pushFollow(FOLLOW_oneStatement_in_statement1283);
			s=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			        		try {
			    			ret = s;
			    		} finally {
			    			udfParseNodes.clear();
			    		}
			    	}
			match(input,EOF,FOLLOW_EOF_in_statement1287); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "statement"



	// $ANTLR start "query"
	// PhoenixSQL.g:403:1: query returns [SelectStatement ret] : s= select_node EOF ;
	public final SelectStatement query() throws RecognitionException {
		SelectStatement ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:404:5: (s= select_node EOF )
			// PhoenixSQL.g:404:9: s= select_node EOF
			{
			pushFollow(FOLLOW_select_node_in_query1313);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EOF,FOLLOW_EOF_in_query1315); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =s;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "query"



	// $ANTLR start "oneStatement"
	// PhoenixSQL.g:408:1: oneStatement returns [BindableStatement ret] : (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) ;
	public final BindableStatement oneStatement() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement s =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:410:5: ( (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node ) )
			// PhoenixSQL.g:410:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			{
			// PhoenixSQL.g:410:8: (s= select_node |s= upsert_node |s= delete_node |s= create_table_node |s= create_schema_node |s= create_view_node |s= create_index_node |s= cursor_open_node |s= cursor_close_node |s= cursor_fetch_node |s= declare_cursor_node |s= drop_table_node |s= drop_index_node |s= alter_index_node |s= alter_table_node |s= trace_node |s= create_function_node |s= drop_function_node |s= add_jars_node |s= list_jars_node |s= delete_jar_node |s= alter_session_node |s= create_sequence_node |s= drop_sequence_node |s= drop_schema_node |s= use_schema_node |s= update_statistics_node |s= execute_upgrade_node |s= explain_node )
			int alt2=29;
			switch ( input.LA(1) ) {
			case SELECT:
				{
				alt2=1;
				}
				break;
			case UPSERT:
				{
				alt2=2;
				}
				break;
			case DELETE:
				{
				int LA2_3 = input.LA(2);
				if ( (LA2_3==JAR) ) {
					alt2=21;
				}
				else if ( (LA2_3==FROM||LA2_3==ML_HINT) ) {
					alt2=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CREATE:
				{
				switch ( input.LA(2) ) {
				case SCHEMA:
					{
					alt2=5;
					}
					break;
				case VIEW:
					{
					alt2=6;
					}
					break;
				case SEQUENCE:
					{
					alt2=23;
					}
					break;
				case IMMUTABLE:
				case TABLE:
					{
					alt2=4;
					}
					break;
				case INDEX:
				case LOCAL:
					{
					alt2=7;
					}
					break;
				case FUNCTION:
				case OR:
				case TEMPORARY:
					{
					alt2=17;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case OPEN:
				{
				alt2=8;
				}
				break;
			case CLOSE:
				{
				alt2=9;
				}
				break;
			case FETCH:
				{
				alt2=10;
				}
				break;
			case DECLARE:
				{
				alt2=11;
				}
				break;
			case DROP:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=13;
					}
					break;
				case FUNCTION:
					{
					alt2=18;
					}
					break;
				case SEQUENCE:
					{
					alt2=24;
					}
					break;
				case SCHEMA:
					{
					alt2=25;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=12;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ALTER:
				{
				switch ( input.LA(2) ) {
				case INDEX:
					{
					alt2=14;
					}
					break;
				case SESSION:
					{
					alt2=22;
					}
					break;
				case TABLE:
				case VIEW:
					{
					alt2=15;
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case TRACE:
				{
				alt2=16;
				}
				break;
			case ADD:
				{
				alt2=19;
				}
				break;
			case LIST:
				{
				alt2=20;
				}
				break;
			case USE:
				{
				alt2=26;
				}
				break;
			case UPDATE:
				{
				alt2=27;
				}
				break;
			case EXECUTE:
				{
				alt2=28;
				}
				break;
			case EXPLAIN:
				{
				alt2=29;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// PhoenixSQL.g:410:9: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_oneStatement1347);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:411:7: s= upsert_node
					{
					pushFollow(FOLLOW_upsert_node_in_oneStatement1357);
					s=upsert_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:412:9: s= delete_node
					{
					pushFollow(FOLLOW_delete_node_in_oneStatement1369);
					s=delete_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 4 :
					// PhoenixSQL.g:413:9: s= create_table_node
					{
					pushFollow(FOLLOW_create_table_node_in_oneStatement1381);
					s=create_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 5 :
					// PhoenixSQL.g:414:9: s= create_schema_node
					{
					pushFollow(FOLLOW_create_schema_node_in_oneStatement1393);
					s=create_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 6 :
					// PhoenixSQL.g:415:9: s= create_view_node
					{
					pushFollow(FOLLOW_create_view_node_in_oneStatement1405);
					s=create_view_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 7 :
					// PhoenixSQL.g:416:9: s= create_index_node
					{
					pushFollow(FOLLOW_create_index_node_in_oneStatement1417);
					s=create_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 8 :
					// PhoenixSQL.g:417:9: s= cursor_open_node
					{
					pushFollow(FOLLOW_cursor_open_node_in_oneStatement1429);
					s=cursor_open_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 9 :
					// PhoenixSQL.g:418:9: s= cursor_close_node
					{
					pushFollow(FOLLOW_cursor_close_node_in_oneStatement1441);
					s=cursor_close_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 10 :
					// PhoenixSQL.g:419:9: s= cursor_fetch_node
					{
					pushFollow(FOLLOW_cursor_fetch_node_in_oneStatement1453);
					s=cursor_fetch_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 11 :
					// PhoenixSQL.g:420:9: s= declare_cursor_node
					{
					pushFollow(FOLLOW_declare_cursor_node_in_oneStatement1465);
					s=declare_cursor_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 12 :
					// PhoenixSQL.g:421:9: s= drop_table_node
					{
					pushFollow(FOLLOW_drop_table_node_in_oneStatement1477);
					s=drop_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 13 :
					// PhoenixSQL.g:422:9: s= drop_index_node
					{
					pushFollow(FOLLOW_drop_index_node_in_oneStatement1489);
					s=drop_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 14 :
					// PhoenixSQL.g:423:9: s= alter_index_node
					{
					pushFollow(FOLLOW_alter_index_node_in_oneStatement1501);
					s=alter_index_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 15 :
					// PhoenixSQL.g:424:9: s= alter_table_node
					{
					pushFollow(FOLLOW_alter_table_node_in_oneStatement1513);
					s=alter_table_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 16 :
					// PhoenixSQL.g:425:9: s= trace_node
					{
					pushFollow(FOLLOW_trace_node_in_oneStatement1525);
					s=trace_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 17 :
					// PhoenixSQL.g:426:9: s= create_function_node
					{
					pushFollow(FOLLOW_create_function_node_in_oneStatement1537);
					s=create_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 18 :
					// PhoenixSQL.g:427:9: s= drop_function_node
					{
					pushFollow(FOLLOW_drop_function_node_in_oneStatement1549);
					s=drop_function_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 19 :
					// PhoenixSQL.g:428:9: s= add_jars_node
					{
					pushFollow(FOLLOW_add_jars_node_in_oneStatement1561);
					s=add_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 20 :
					// PhoenixSQL.g:429:9: s= list_jars_node
					{
					pushFollow(FOLLOW_list_jars_node_in_oneStatement1573);
					s=list_jars_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 21 :
					// PhoenixSQL.g:430:9: s= delete_jar_node
					{
					pushFollow(FOLLOW_delete_jar_node_in_oneStatement1585);
					s=delete_jar_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 22 :
					// PhoenixSQL.g:431:9: s= alter_session_node
					{
					pushFollow(FOLLOW_alter_session_node_in_oneStatement1597);
					s=alter_session_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 23 :
					// PhoenixSQL.g:432:7: s= create_sequence_node
					{
					pushFollow(FOLLOW_create_sequence_node_in_oneStatement1607);
					s=create_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 24 :
					// PhoenixSQL.g:433:7: s= drop_sequence_node
					{
					pushFollow(FOLLOW_drop_sequence_node_in_oneStatement1617);
					s=drop_sequence_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 25 :
					// PhoenixSQL.g:434:7: s= drop_schema_node
					{
					pushFollow(FOLLOW_drop_schema_node_in_oneStatement1627);
					s=drop_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 26 :
					// PhoenixSQL.g:435:7: s= use_schema_node
					{
					pushFollow(FOLLOW_use_schema_node_in_oneStatement1637);
					s=use_schema_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 27 :
					// PhoenixSQL.g:436:9: s= update_statistics_node
					{
					pushFollow(FOLLOW_update_statistics_node_in_oneStatement1649);
					s=update_statistics_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 28 :
					// PhoenixSQL.g:437:9: s= execute_upgrade_node
					{
					pushFollow(FOLLOW_execute_upgrade_node_in_oneStatement1661);
					s=execute_upgrade_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;
				case 29 :
					// PhoenixSQL.g:438:9: s= explain_node
					{
					pushFollow(FOLLOW_explain_node_in_oneStatement1673);
					s=explain_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = s; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "oneStatement"



	// $ANTLR start "explain_node"
	// PhoenixSQL.g:442:1: explain_node returns [BindableStatement ret] : EXPLAIN q= oneStatement ;
	public final BindableStatement explain_node() throws RecognitionException {
		BindableStatement ret = null;


		BindableStatement q =null;

		try {
			// PhoenixSQL.g:443:5: ( EXPLAIN q= oneStatement )
			// PhoenixSQL.g:443:9: EXPLAIN q= oneStatement
			{
			match(input,EXPLAIN,FOLLOW_EXPLAIN_in_explain_node1706); if (state.failed) return ret;
			pushFollow(FOLLOW_oneStatement_in_explain_node1710);
			q=oneStatement();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret =factory.explain(q);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "explain_node"



	// $ANTLR start "create_table_node"
	// PhoenixSQL.g:447:1: create_table_node returns [CreateTableStatement ret] : CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )? ;
	public final CreateTableStatement create_table_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token im=null;
		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> s =null;

		try {
			// PhoenixSQL.g:448:5: ( CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )? )
			// PhoenixSQL.g:448:9: CREATE (im= IMMUTABLE )? TABLE ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN ) (p= fam_properties )? ( SPLIT ON s= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_table_node1736); if (state.failed) return ret;
			// PhoenixSQL.g:448:16: (im= IMMUTABLE )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==IMMUTABLE) ) {
				alt3=1;
			}
			switch (alt3) {
				case 1 :
					// PhoenixSQL.g:448:17: im= IMMUTABLE
					{
					im=(Token)match(input,IMMUTABLE,FOLLOW_IMMUTABLE_in_create_table_node1741); if (state.failed) return ret;
					}
					break;

			}

			match(input,TABLE,FOLLOW_TABLE_in_create_table_node1745); if (state.failed) return ret;
			// PhoenixSQL.g:448:38: ( IF NOT ex= EXISTS )?
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0==IF) ) {
				alt4=1;
			}
			switch (alt4) {
				case 1 :
					// PhoenixSQL.g:448:39: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_table_node1748); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_table_node1750); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_table_node1754); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_table_node1760);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:449:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )
			// PhoenixSQL.g:449:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_table_node1772); if (state.failed) return ret;
			pushFollow(FOLLOW_column_defs_in_create_table_node1776);
			c=column_defs();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:449:31: (pk= pk_constraint )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==COMMA||LA5_0==CONSTRAINT) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// PhoenixSQL.g:449:32: pk= pk_constraint
					{
					pushFollow(FOLLOW_pk_constraint_in_create_table_node1781);
					pk=pk_constraint();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,RPAREN,FOLLOW_RPAREN_in_create_table_node1785); if (state.failed) return ret;
			}

			// PhoenixSQL.g:450:9: (p= fam_properties )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==NAME) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// PhoenixSQL.g:450:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_table_node1799);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:451:9: ( SPLIT ON s= value_expression_list )?
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==SPLIT) ) {
				alt7=1;
			}
			switch (alt7) {
				case 1 :
					// PhoenixSQL.g:451:10: SPLIT ON s= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_table_node1812); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_table_node1814); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_table_node1818);
					s=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createTable(t, p, c, pk, s, PTableType.TABLE, ex!=null, null, null, getBindCount(), im!=null ? true : null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_table_node"



	// $ANTLR start "create_schema_node"
	// PhoenixSQL.g:456:1: create_schema_node returns [CreateSchemaStatement ret] : CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier ) ;
	public final CreateSchemaStatement create_schema_node() throws RecognitionException {
		CreateSchemaStatement ret = null;


		Token ex=null;
		String s =null;

		try {
			// PhoenixSQL.g:457:5: ( CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier ) )
			// PhoenixSQL.g:457:9: CREATE SCHEMA ( IF NOT ex= EXISTS )? ( DEFAULT |s= identifier )
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_schema_node1857); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_create_schema_node1859); if (state.failed) return ret;
			// PhoenixSQL.g:457:23: ( IF NOT ex= EXISTS )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==IF) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// PhoenixSQL.g:457:24: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_schema_node1862); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_schema_node1864); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_schema_node1868); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:457:43: ( DEFAULT |s= identifier )
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==DEFAULT) ) {
				alt9=1;
			}
			else if ( (LA9_0==NAME) ) {
				alt9=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 9, 0, input);
				throw nvae;
			}

			switch (alt9) {
				case 1 :
					// PhoenixSQL.g:457:44: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_create_schema_node1873); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:457:54: s= identifier
					{
					pushFollow(FOLLOW_identifier_in_create_schema_node1879);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createSchema(s, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_schema_node"



	// $ANTLR start "create_view_node"
	// PhoenixSQL.g:462:1: create_view_node returns [CreateTableStatement ret] : CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? ;
	public final CreateTableStatement create_view_node() throws RecognitionException {
		CreateTableStatement ret = null;


		Token ex=null;
		TableName t =null;
		List<ColumnDef> c =null;
		PrimaryKeyConstraint pk =null;
		TableName bt =null;
		ParseNode w =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:463:5: ( CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )? )
			// PhoenixSQL.g:463:9: CREATE VIEW ( IF NOT ex= EXISTS )? t= from_table_name ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )? ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )? (p= fam_properties )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_view_node1914); if (state.failed) return ret;
			match(input,VIEW,FOLLOW_VIEW_in_create_view_node1916); if (state.failed) return ret;
			// PhoenixSQL.g:463:21: ( IF NOT ex= EXISTS )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==IF) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// PhoenixSQL.g:463:22: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_view_node1919); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_view_node1921); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_view_node1925); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_view_node1931);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:464:9: ( LPAREN c= column_defs (pk= pk_constraint )? RPAREN )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==LPAREN) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// PhoenixSQL.g:464:10: LPAREN c= column_defs (pk= pk_constraint )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_view_node1943); if (state.failed) return ret;
					pushFollow(FOLLOW_column_defs_in_create_view_node1947);
					c=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:464:31: (pk= pk_constraint )?
					int alt11=2;
					int LA11_0 = input.LA(1);
					if ( (LA11_0==COMMA||LA11_0==CONSTRAINT) ) {
						alt11=1;
					}
					switch (alt11) {
						case 1 :
							// PhoenixSQL.g:464:32: pk= pk_constraint
							{
							pushFollow(FOLLOW_pk_constraint_in_create_view_node1952);
							pk=pk_constraint();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_create_view_node1956); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:465:9: ( AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )? )?
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( (LA14_0==AS) ) {
				alt14=1;
			}
			switch (alt14) {
				case 1 :
					// PhoenixSQL.g:465:11: AS SELECT ASTERISK FROM bt= from_table_name ( WHERE w= expression )?
					{
					match(input,AS,FOLLOW_AS_in_create_view_node1970); if (state.failed) return ret;
					match(input,SELECT,FOLLOW_SELECT_in_create_view_node1972); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_create_view_node1974); if (state.failed) return ret;
					match(input,FROM,FOLLOW_FROM_in_create_view_node1986); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_create_view_node1990);
					bt=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:467:11: ( WHERE w= expression )?
					int alt13=2;
					int LA13_0 = input.LA(1);
					if ( (LA13_0==WHERE) ) {
						alt13=1;
					}
					switch (alt13) {
						case 1 :
							// PhoenixSQL.g:467:12: WHERE w= expression
							{
							match(input,WHERE,FOLLOW_WHERE_in_create_view_node2003); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_create_view_node2007);
							w=expression();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			// PhoenixSQL.g:468:9: (p= fam_properties )?
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( (LA15_0==NAME) ) {
				alt15=1;
			}
			switch (alt15) {
				case 1 :
					// PhoenixSQL.g:468:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_view_node2025);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createTable(t, p, c, pk, null, PTableType.VIEW, ex!=null, bt==null ? t : bt, w, getBindCount(), null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_view_node"



	// $ANTLR start "create_index_node"
	// PhoenixSQL.g:473:1: create_index_node returns [CreateIndexStatement ret] : CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? ;
	public final CreateIndexStatement create_index_node() throws RecognitionException {
		CreateIndexStatement ret = null;


		Token l=null;
		Token ex=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;
		IndexKeyConstraint ik =null;
		List<ColumnName> icrefs =null;
		ListMultimap<String,Pair<String,Object>> p =null;
		List<ParseNode> v =null;

		try {
			// PhoenixSQL.g:474:5: ( CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )? )
			// PhoenixSQL.g:474:9: CREATE (l= LOCAL )? INDEX ( IF NOT ex= EXISTS )? i= index_name ON t= from_table_name ( LPAREN ik= ik_constraint RPAREN ) ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )? (async= ASYNC )? (p= fam_properties )? ( SPLIT ON v= value_expression_list )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_index_node2061); if (state.failed) return ret;
			// PhoenixSQL.g:474:17: (l= LOCAL )?
			int alt16=2;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==LOCAL) ) {
				alt16=1;
			}
			switch (alt16) {
				case 1 :
					// PhoenixSQL.g:474:17: l= LOCAL
					{
					l=(Token)match(input,LOCAL,FOLLOW_LOCAL_in_create_index_node2065); if (state.failed) return ret;
					}
					break;

			}

			match(input,INDEX,FOLLOW_INDEX_in_create_index_node2068); if (state.failed) return ret;
			// PhoenixSQL.g:474:31: ( IF NOT ex= EXISTS )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==IF) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// PhoenixSQL.g:474:32: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_index_node2071); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_index_node2073); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_index_node2077); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_create_index_node2083);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_create_index_node2085); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_create_index_node2089);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:475:9: ( LPAREN ik= ik_constraint RPAREN )
			// PhoenixSQL.g:475:10: LPAREN ik= ik_constraint RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2100); if (state.failed) return ret;
			pushFollow(FOLLOW_ik_constraint_in_create_index_node2104);
			ik=ik_constraint();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2106); if (state.failed) return ret;
			}

			// PhoenixSQL.g:476:9: ( INCLUDE ( LPAREN icrefs= column_names RPAREN ) )?
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==INCLUDE) ) {
				alt18=1;
			}
			switch (alt18) {
				case 1 :
					// PhoenixSQL.g:476:10: INCLUDE ( LPAREN icrefs= column_names RPAREN )
					{
					match(input,INCLUDE,FOLLOW_INCLUDE_in_create_index_node2118); if (state.failed) return ret;
					// PhoenixSQL.g:476:18: ( LPAREN icrefs= column_names RPAREN )
					// PhoenixSQL.g:476:19: LPAREN icrefs= column_names RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_create_index_node2121); if (state.failed) return ret;
					pushFollow(FOLLOW_column_names_in_create_index_node2125);
					icrefs=column_names();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_create_index_node2127); if (state.failed) return ret;
					}

					}
					break;

			}

			// PhoenixSQL.g:477:9: (async= ASYNC )?
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==ASYNC) ) {
				alt19=1;
			}
			switch (alt19) {
				case 1 :
					// PhoenixSQL.g:477:10: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_create_index_node2143); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:478:9: (p= fam_properties )?
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==NAME) ) {
				alt20=1;
			}
			switch (alt20) {
				case 1 :
					// PhoenixSQL.g:478:10: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_create_index_node2158);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:479:9: ( SPLIT ON v= value_expression_list )?
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==SPLIT) ) {
				alt21=1;
			}
			switch (alt21) {
				case 1 :
					// PhoenixSQL.g:479:10: SPLIT ON v= value_expression_list
					{
					match(input,SPLIT,FOLLOW_SPLIT_in_create_index_node2171); if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_create_index_node2173); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_list_in_create_index_node2177);
					v=value_expression_list();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.createIndex(i, factory.namedTable(null,t), ik, icrefs, v, p, ex!=null, l==null ? IndexType.getDefault() : IndexType.LOCAL, async != null, getBindCount(), new HashMap<String, UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_index_node"



	// $ANTLR start "create_sequence_node"
	// PhoenixSQL.g:484:1: create_sequence_node returns [CreateSequenceStatement ret] : CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? ;
	public final CreateSequenceStatement create_sequence_node() throws RecognitionException {
		CreateSequenceStatement ret = null;


		Token ex=null;
		Token cyc=null;
		TableName t =null;
		ParseNode s =null;
		ParseNode i =null;
		ParseNode min =null;
		ParseNode max =null;
		ParseNode c =null;

		try {
			// PhoenixSQL.g:485:5: ( CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )? )
			// PhoenixSQL.g:485:9: CREATE SEQUENCE ( IF NOT ex= EXISTS )? t= from_table_name ( START ( WITH )? s= value_expression )? ( INCREMENT ( BY )? i= value_expression )? ( MINVALUE min= value_expression )? ( MAXVALUE max= value_expression )? (cyc= CYCLE )? ( CACHE c= int_literal_or_bind )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_sequence_node2213); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_create_sequence_node2215); if (state.failed) return ret;
			// PhoenixSQL.g:485:26: ( IF NOT ex= EXISTS )?
			int alt22=2;
			int LA22_0 = input.LA(1);
			if ( (LA22_0==IF) ) {
				alt22=1;
			}
			switch (alt22) {
				case 1 :
					// PhoenixSQL.g:485:27: IF NOT ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_create_sequence_node2219); if (state.failed) return ret;
					match(input,NOT,FOLLOW_NOT_in_create_sequence_node2221); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_create_sequence_node2225); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_create_sequence_node2231);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:486:9: ( START ( WITH )? s= value_expression )?
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==START) ) {
				alt24=1;
			}
			switch (alt24) {
				case 1 :
					// PhoenixSQL.g:486:10: START ( WITH )? s= value_expression
					{
					match(input,START,FOLLOW_START_in_create_sequence_node2242); if (state.failed) return ret;
					// PhoenixSQL.g:486:16: ( WITH )?
					int alt23=2;
					int LA23_0 = input.LA(1);
					if ( (LA23_0==WITH) ) {
						alt23=1;
					}
					switch (alt23) {
						case 1 :
							// PhoenixSQL.g:486:16: WITH
							{
							match(input,WITH,FOLLOW_WITH_in_create_sequence_node2244); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2249);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:487:9: ( INCREMENT ( BY )? i= value_expression )?
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==INCREMENT) ) {
				alt26=1;
			}
			switch (alt26) {
				case 1 :
					// PhoenixSQL.g:487:10: INCREMENT ( BY )? i= value_expression
					{
					match(input,INCREMENT,FOLLOW_INCREMENT_in_create_sequence_node2262); if (state.failed) return ret;
					// PhoenixSQL.g:487:20: ( BY )?
					int alt25=2;
					int LA25_0 = input.LA(1);
					if ( (LA25_0==BY) ) {
						alt25=1;
					}
					switch (alt25) {
						case 1 :
							// PhoenixSQL.g:487:20: BY
							{
							match(input,BY,FOLLOW_BY_in_create_sequence_node2264); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_value_expression_in_create_sequence_node2269);
					i=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:488:9: ( MINVALUE min= value_expression )?
			int alt27=2;
			int LA27_0 = input.LA(1);
			if ( (LA27_0==MINVALUE) ) {
				alt27=1;
			}
			switch (alt27) {
				case 1 :
					// PhoenixSQL.g:488:10: MINVALUE min= value_expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_create_sequence_node2282); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2286);
					min=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:489:9: ( MAXVALUE max= value_expression )?
			int alt28=2;
			int LA28_0 = input.LA(1);
			if ( (LA28_0==MAXVALUE) ) {
				alt28=1;
			}
			switch (alt28) {
				case 1 :
					// PhoenixSQL.g:489:10: MAXVALUE max= value_expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_create_sequence_node2299); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_create_sequence_node2303);
					max=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:490:9: (cyc= CYCLE )?
			int alt29=2;
			int LA29_0 = input.LA(1);
			if ( (LA29_0==CYCLE) ) {
				alt29=1;
			}
			switch (alt29) {
				case 1 :
					// PhoenixSQL.g:490:10: cyc= CYCLE
					{
					cyc=(Token)match(input,CYCLE,FOLLOW_CYCLE_in_create_sequence_node2318); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:491:9: ( CACHE c= int_literal_or_bind )?
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==CACHE) ) {
				alt30=1;
			}
			switch (alt30) {
				case 1 :
					// PhoenixSQL.g:491:10: CACHE c= int_literal_or_bind
					{
					match(input,CACHE,FOLLOW_CACHE_in_create_sequence_node2332); if (state.failed) return ret;
					pushFollow(FOLLOW_int_literal_or_bind_in_create_sequence_node2336);
					c=int_literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.createSequence(t, s, i, c, min, max, cyc!=null, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_sequence_node"



	// $ANTLR start "int_literal_or_bind"
	// PhoenixSQL.g:495:1: int_literal_or_bind returns [ParseNode ret] : (n= int_or_long_literal |b= bind_expression );
	public final ParseNode int_literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode n =null;
		BindParseNode b =null;

		try {
			// PhoenixSQL.g:496:5: (n= int_or_long_literal |b= bind_expression )
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==NUMBER) ) {
				alt31=1;
			}
			else if ( (LA31_0==BIND_NAME||LA31_0==QUESTION) ) {
				alt31=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 31, 0, input);
				throw nvae;
			}

			switch (alt31) {
				case 1 :
					// PhoenixSQL.g:496:7: n= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_int_literal_or_bind2367);
					n=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:497:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_int_literal_or_bind2379);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = b; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_literal_or_bind"



	// $ANTLR start "drop_sequence_node"
	// PhoenixSQL.g:501:1: drop_sequence_node returns [DropSequenceStatement ret] : DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name ;
	public final DropSequenceStatement drop_sequence_node() throws RecognitionException {
		DropSequenceStatement ret = null;


		Token ex=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:502:5: ( DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name )
			// PhoenixSQL.g:502:9: DROP SEQUENCE ( IF ex= EXISTS )? t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_sequence_node2405); if (state.failed) return ret;
			match(input,SEQUENCE,FOLLOW_SEQUENCE_in_drop_sequence_node2407); if (state.failed) return ret;
			// PhoenixSQL.g:502:24: ( IF ex= EXISTS )?
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==IF) ) {
				alt32=1;
			}
			switch (alt32) {
				case 1 :
					// PhoenixSQL.g:502:25: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_sequence_node2411); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_sequence_node2415); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_sequence_node2421);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.dropSequence(t, ex!=null, getBindCount()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_sequence_node"



	// $ANTLR start "pk_constraint"
	// PhoenixSQL.g:506:1: pk_constraint returns [PrimaryKeyConstraint ret] : ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN ;
	public final PrimaryKeyConstraint pk_constraint() throws RecognitionException {
		PrimaryKeyConstraint ret = null;


		String n =null;
		List<ColumnDefInPkConstraint> cols =null;

		try {
			// PhoenixSQL.g:507:5: ( ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN )
			// PhoenixSQL.g:507:9: ( COMMA )? CONSTRAINT n= identifier PRIMARY KEY LPAREN cols= col_name_with_sort_order_rowtimestamp_list RPAREN
			{
			// PhoenixSQL.g:507:9: ( COMMA )?
			int alt33=2;
			int LA33_0 = input.LA(1);
			if ( (LA33_0==COMMA) ) {
				alt33=1;
			}
			switch (alt33) {
				case 1 :
					// PhoenixSQL.g:507:9: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_pk_constraint2450); if (state.failed) return ret;
					}
					break;

			}

			match(input,CONSTRAINT,FOLLOW_CONSTRAINT_in_pk_constraint2453); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_pk_constraint2457);
			n=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,PRIMARY,FOLLOW_PRIMARY_in_pk_constraint2459); if (state.failed) return ret;
			match(input,KEY,FOLLOW_KEY_in_pk_constraint2461); if (state.failed) return ret;
			match(input,LPAREN,FOLLOW_LPAREN_in_pk_constraint2463); if (state.failed) return ret;
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2467);
			cols=col_name_with_sort_order_rowtimestamp_list();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_pk_constraint2469); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.primaryKey(n,cols); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "pk_constraint"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp_list"
	// PhoenixSQL.g:510:1: col_name_with_sort_order_rowtimestamp_list returns [List<ColumnDefInPkConstraint> ret] : p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* ;
	public final List<ColumnDefInPkConstraint> col_name_with_sort_order_rowtimestamp_list() throws RecognitionException {
		List<ColumnDefInPkConstraint> ret = null;


		ColumnDefInPkConstraint p =null;

		ret = new ArrayList<ColumnDefInPkConstraint>(); 
		try {
			// PhoenixSQL.g:512:5: (p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )* )
			// PhoenixSQL.g:512:9: p= col_name_with_sort_order_rowtimestamp ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			{
			pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2500);
			p=col_name_with_sort_order_rowtimestamp();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:512:65: ( COMMA p= col_name_with_sort_order_rowtimestamp )*
			loop34:
			while (true) {
				int alt34=2;
				int LA34_0 = input.LA(1);
				if ( (LA34_0==COMMA) ) {
					alt34=1;
				}

				switch (alt34) {
				case 1 :
					// PhoenixSQL.g:512:66: COMMA p= col_name_with_sort_order_rowtimestamp
					{
					match(input,COMMA,FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list2506); if (state.failed) return ret;
					pushFollow(FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2512);
					p=col_name_with_sort_order_rowtimestamp();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop34;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp_list"



	// $ANTLR start "col_name_with_sort_order_rowtimestamp"
	// PhoenixSQL.g:515:1: col_name_with_sort_order_rowtimestamp returns [ColumnDefInPkConstraint ret] : f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? ;
	public final ColumnDefInPkConstraint col_name_with_sort_order_rowtimestamp() throws RecognitionException {
		ColumnDefInPkConstraint ret = null;


		Token order=null;
		Token rr=null;
		String f =null;

		try {
			// PhoenixSQL.g:516:5: (f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )
			// PhoenixSQL.g:516:9: f= identifier (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
			{
			pushFollow(FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp2539);
			f=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:516:22: (order= ASC |order= DESC )?
			int alt35=3;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==ASC) ) {
				alt35=1;
			}
			else if ( (LA35_0==DESC) ) {
				alt35=2;
			}
			switch (alt35) {
				case 1 :
					// PhoenixSQL.g:516:23: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp2544); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:516:33: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp2548); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:516:46: (rr= ROW_TIMESTAMP )?
			int alt36=2;
			int LA36_0 = input.LA(1);
			if ( (LA36_0==ROW_TIMESTAMP) ) {
				alt36=1;
			}
			switch (alt36) {
				case 1 :
					// PhoenixSQL.g:516:47: rr= ROW_TIMESTAMP
					{
					rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp2555); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDefInPkConstraint(factory.columnName(f), order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()), rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "col_name_with_sort_order_rowtimestamp"



	// $ANTLR start "ik_constraint"
	// PhoenixSQL.g:520:1: ik_constraint returns [IndexKeyConstraint ret] : x= expression_with_sort_order_list ;
	public final IndexKeyConstraint ik_constraint() throws RecognitionException {
		IndexKeyConstraint ret = null;


		List<Pair<ParseNode, SortOrder>> x =null;

		try {
			// PhoenixSQL.g:521:5: (x= expression_with_sort_order_list )
			// PhoenixSQL.g:521:9: x= expression_with_sort_order_list
			{
			pushFollow(FOLLOW_expression_with_sort_order_list_in_ik_constraint2590);
			x=expression_with_sort_order_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexKey(x); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "ik_constraint"



	// $ANTLR start "expression_with_sort_order_list"
	// PhoenixSQL.g:524:1: expression_with_sort_order_list returns [List<Pair<ParseNode, SortOrder>> ret] : p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* ;
	public final List<Pair<ParseNode, SortOrder>> expression_with_sort_order_list() throws RecognitionException {
		List<Pair<ParseNode, SortOrder>> ret = null;


		Pair<ParseNode, SortOrder> p =null;

		ret = new ArrayList<Pair<ParseNode, SortOrder>>(); 
		try {
			// PhoenixSQL.g:526:5: (p= expression_with_sort_order ( COMMA p= expression_with_sort_order )* )
			// PhoenixSQL.g:526:9: p= expression_with_sort_order ( COMMA p= expression_with_sort_order )*
			{
			pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2617);
			p=expression_with_sort_order();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(p);}
			// PhoenixSQL.g:526:54: ( COMMA p= expression_with_sort_order )*
			loop37:
			while (true) {
				int alt37=2;
				int LA37_0 = input.LA(1);
				if ( (LA37_0==COMMA) ) {
					alt37=1;
				}

				switch (alt37) {
				case 1 :
					// PhoenixSQL.g:526:55: COMMA p= expression_with_sort_order
					{
					match(input,COMMA,FOLLOW_COMMA_in_expression_with_sort_order_list2623); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2629);
					p=expression_with_sort_order();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(p);}
					}
					break;

				default :
					break loop37;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order_list"



	// $ANTLR start "expression_with_sort_order"
	// PhoenixSQL.g:529:1: expression_with_sort_order returns [Pair<ParseNode, SortOrder> ret] : (x= expression ) (order= ASC |order= DESC )? ;
	public final Pair<ParseNode, SortOrder> expression_with_sort_order() throws RecognitionException {
		Pair<ParseNode, SortOrder> ret = null;


		Token order=null;
		ParseNode x =null;

		try {
			// PhoenixSQL.g:530:5: ( (x= expression ) (order= ASC |order= DESC )? )
			// PhoenixSQL.g:530:9: (x= expression ) (order= ASC |order= DESC )?
			{
			// PhoenixSQL.g:530:9: (x= expression )
			// PhoenixSQL.g:530:10: x= expression
			{
			pushFollow(FOLLOW_expression_in_expression_with_sort_order2656);
			x=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:530:24: (order= ASC |order= DESC )?
			int alt38=3;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==ASC) ) {
				alt38=1;
			}
			else if ( (LA38_0==DESC) ) {
				alt38=2;
			}
			switch (alt38) {
				case 1 :
					// PhoenixSQL.g:530:25: order= ASC
					{
					order=(Token)match(input,ASC,FOLLOW_ASC_in_expression_with_sort_order2662); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:530:35: order= DESC
					{
					order=(Token)match(input,DESC,FOLLOW_DESC_in_expression_with_sort_order2666); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = Pair.newPair(x, order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()));}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression_with_sort_order"



	// $ANTLR start "fam_properties"
	// PhoenixSQL.g:533:1: fam_properties returns [ListMultimap<String,Pair<String,Object>> ret] : p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* ;
	public final ListMultimap<String,Pair<String,Object>> fam_properties() throws RecognitionException {
		ListMultimap<String,Pair<String,Object>> ret = null;


		PropertyName p =null;
		Object v =null;

		ret = ArrayListMultimap.<String,Pair<String,Object>>create(); 
		try {
			// PhoenixSQL.g:535:5: (p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:535:8: p= fam_prop_name EQ v= prop_value ( COMMA p= fam_prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_fam_prop_name_in_fam_properties2694);
			p=fam_prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_fam_properties2696); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_fam_properties2700);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
			// PhoenixSQL.g:535:119: ( COMMA p= fam_prop_name EQ v= prop_value )*
			loop39:
			while (true) {
				int alt39=2;
				int LA39_0 = input.LA(1);
				if ( (LA39_0==COMMA) ) {
					alt39=1;
				}

				switch (alt39) {
				case 1 :
					// PhoenixSQL.g:535:120: COMMA p= fam_prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_fam_properties2706); if (state.failed) return ret;
					pushFollow(FOLLOW_fam_prop_name_in_fam_properties2710);
					p=fam_prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_fam_properties2712); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_fam_properties2716);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(p.getFamilyName(),new Pair<String,Object>(p.getPropertyName(),v));}
					}
					break;

				default :
					break loop39;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_properties"



	// $ANTLR start "fam_prop_name"
	// PhoenixSQL.g:538:1: fam_prop_name returns [PropertyName ret] : (propName= identifier |familyName= identifier DOT propName= identifier );
	public final PropertyName fam_prop_name() throws RecognitionException {
		PropertyName ret = null;


		String propName =null;
		String familyName =null;

		try {
			// PhoenixSQL.g:539:5: (propName= identifier |familyName= identifier DOT propName= identifier )
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==NAME) ) {
				int LA40_1 = input.LA(2);
				if ( (LA40_1==EQ) ) {
					alt40=1;
				}
				else if ( (LA40_1==DOT) ) {
					alt40=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 40, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}

			switch (alt40) {
				case 1 :
					// PhoenixSQL.g:539:9: propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name2746);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(propName); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:540:9: familyName= identifier DOT propName= identifier
					{
					pushFollow(FOLLOW_identifier_in_fam_prop_name2760);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_fam_prop_name2762); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_fam_prop_name2766);
					propName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.propertyName(familyName, propName); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "fam_prop_name"



	// $ANTLR start "prop_value"
	// PhoenixSQL.g:543:1: prop_value returns [Object ret] : (v= identifier |l= literal );
	public final Object prop_value() throws RecognitionException {
		Object ret = null;


		String v =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:544:5: (v= identifier |l= literal )
			int alt41=2;
			int LA41_0 = input.LA(1);
			if ( (LA41_0==NAME) ) {
				int LA41_1 = input.LA(2);
				if ( (LA41_1==EOF||LA41_1==COMMA||LA41_1==SEMICOLON||LA41_1==SPLIT) ) {
					alt41=1;
				}
				else if ( (LA41_1==STRING_LITERAL) ) {
					alt41=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 41, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA41_0==DECIMAL||LA41_0==DOUBLE||LA41_0==FALSE||LA41_0==NULL||LA41_0==NUMBER||LA41_0==STRING_LITERAL||LA41_0==TRUE) ) {
				alt41=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 41, 0, input);
				throw nvae;
			}

			switch (alt41) {
				case 1 :
					// PhoenixSQL.g:544:9: v= identifier
					{
					pushFollow(FOLLOW_identifier_in_prop_value2797);
					v=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = v; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:545:9: l= literal
					{
					pushFollow(FOLLOW_literal_in_prop_value2811);
					l=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = l.getValue(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_value"



	// $ANTLR start "column_name"
	// PhoenixSQL.g:548:1: column_name returns [ColumnName ret] : (field= identifier |family= identifier DOT field= identifier );
	public final ColumnName column_name() throws RecognitionException {
		ColumnName ret = null;


		String field =null;
		String family =null;

		try {
			// PhoenixSQL.g:549:5: (field= identifier |family= identifier DOT field= identifier )
			int alt42=2;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==NAME) ) {
				int LA42_1 = input.LA(2);
				if ( (LA42_1==EOF||LA42_1==COMMA||LA42_1==EQ||LA42_1==NAME||LA42_1==RPAREN||LA42_1==SEMICOLON) ) {
					alt42=1;
				}
				else if ( (LA42_1==DOT) ) {
					alt42=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 42, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 42, 0, input);
				throw nvae;
			}

			switch (alt42) {
				case 1 :
					// PhoenixSQL.g:549:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name2842);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:550:9: family= identifier DOT field= identifier
					{
					pushFollow(FOLLOW_identifier_in_column_name2856);
					family=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_column_name2858); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_column_name2862);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.columnName(family, field); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_name"



	// $ANTLR start "column_names"
	// PhoenixSQL.g:553:1: column_names returns [List<ColumnName> ret] : v= column_name ( COMMA v= column_name )* ;
	public final List<ColumnName> column_names() throws RecognitionException {
		List<ColumnName> ret = null;


		ColumnName v =null;

		ret = new ArrayList<ColumnName>(); 
		try {
			// PhoenixSQL.g:555:5: (v= column_name ( COMMA v= column_name )* )
			// PhoenixSQL.g:555:8: v= column_name ( COMMA v= column_name )*
			{
			pushFollow(FOLLOW_column_name_in_column_names2894);
			v=column_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:555:40: ( COMMA v= column_name )*
			loop43:
			while (true) {
				int alt43=2;
				int LA43_0 = input.LA(1);
				if ( (LA43_0==COMMA) ) {
					alt43=1;
				}

				switch (alt43) {
				case 1 :
					// PhoenixSQL.g:555:41: COMMA v= column_name
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_names2900); if (state.failed) return ret;
					pushFollow(FOLLOW_column_name_in_column_names2906);
					v=column_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop43;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_names"



	// $ANTLR start "drop_table_node"
	// PhoenixSQL.g:560:1: drop_table_node returns [DropTableStatement ret] : DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? ;
	public final DropTableStatement drop_table_node() throws RecognitionException {
		DropTableStatement ret = null;


		Token v=null;
		Token ex=null;
		Token c=null;
		TableName t =null;

		try {
			// PhoenixSQL.g:561:5: ( DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )? )
			// PhoenixSQL.g:561:9: DROP (v= VIEW | TABLE ) ( IF ex= EXISTS )? t= from_table_name (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_table_node2933); if (state.failed) return ret;
			// PhoenixSQL.g:561:14: (v= VIEW | TABLE )
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==VIEW) ) {
				alt44=1;
			}
			else if ( (LA44_0==TABLE) ) {
				alt44=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 44, 0, input);
				throw nvae;
			}

			switch (alt44) {
				case 1 :
					// PhoenixSQL.g:561:15: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_drop_table_node2938); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:561:24: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_drop_table_node2942); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:561:31: ( IF ex= EXISTS )?
			int alt45=2;
			int LA45_0 = input.LA(1);
			if ( (LA45_0==IF) ) {
				alt45=1;
			}
			switch (alt45) {
				case 1 :
					// PhoenixSQL.g:561:32: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_table_node2946); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_table_node2950); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_drop_table_node2956);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:561:65: (c= CASCADE )?
			int alt46=2;
			int LA46_0 = input.LA(1);
			if ( (LA46_0==CASCADE) ) {
				alt46=1;
			}
			switch (alt46) {
				case 1 :
					// PhoenixSQL.g:561:66: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_table_node2961); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropTable(t, v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_table_node"



	// $ANTLR start "drop_schema_node"
	// PhoenixSQL.g:565:1: drop_schema_node returns [DropSchemaStatement ret] : DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? ;
	public final DropSchemaStatement drop_schema_node() throws RecognitionException {
		DropSchemaStatement ret = null;


		Token ex=null;
		Token c=null;
		String s =null;

		try {
			// PhoenixSQL.g:566:5: ( DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )? )
			// PhoenixSQL.g:566:9: DROP SCHEMA ( IF ex= EXISTS )? s= identifier (c= CASCADE )?
			{
			match(input,DROP,FOLLOW_DROP_in_drop_schema_node2996); if (state.failed) return ret;
			match(input,SCHEMA,FOLLOW_SCHEMA_in_drop_schema_node2998); if (state.failed) return ret;
			// PhoenixSQL.g:566:21: ( IF ex= EXISTS )?
			int alt47=2;
			int LA47_0 = input.LA(1);
			if ( (LA47_0==IF) ) {
				alt47=1;
			}
			switch (alt47) {
				case 1 :
					// PhoenixSQL.g:566:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_schema_node3001); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_schema_node3005); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_schema_node3011);
			s=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:566:50: (c= CASCADE )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==CASCADE) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// PhoenixSQL.g:566:51: c= CASCADE
					{
					c=(Token)match(input,CASCADE,FOLLOW_CASCADE_in_drop_schema_node3016); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.dropSchema(s, ex!=null, c!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_schema_node"



	// $ANTLR start "drop_index_node"
	// PhoenixSQL.g:572:1: drop_index_node returns [DropIndexStatement ret] : DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name ;
	public final DropIndexStatement drop_index_node() throws RecognitionException {
		DropIndexStatement ret = null;


		Token ex=null;
		NamedNode i =null;
		TableName t =null;

		try {
			// PhoenixSQL.g:573:5: ( DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name )
			// PhoenixSQL.g:573:7: DROP INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name
			{
			match(input,DROP,FOLLOW_DROP_in_drop_index_node3051); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_drop_index_node3053); if (state.failed) return ret;
			// PhoenixSQL.g:573:18: ( IF ex= EXISTS )?
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==IF) ) {
				alt49=1;
			}
			switch (alt49) {
				case 1 :
					// PhoenixSQL.g:573:19: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_index_node3056); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_index_node3060); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_drop_index_node3066);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_drop_index_node3068); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_drop_index_node3072);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropIndex(i, t, ex!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_index_node"



	// $ANTLR start "alter_index_node"
	// PhoenixSQL.g:578:1: alter_index_node returns [AlterIndexStatement ret] : ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name s= ( USABLE | UNUSABLE | REBUILD | DISABLE | ACTIVE ) (async= ASYNC )? ;
	public final AlterIndexStatement alter_index_node() throws RecognitionException {
		AlterIndexStatement ret = null;


		Token ex=null;
		Token s=null;
		Token async=null;
		NamedNode i =null;
		TableName t =null;

		try {
			// PhoenixSQL.g:579:5: ( ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name s= ( USABLE | UNUSABLE | REBUILD | DISABLE | ACTIVE ) (async= ASYNC )? )
			// PhoenixSQL.g:579:7: ALTER INDEX ( IF ex= EXISTS )? i= index_name ON t= from_table_name s= ( USABLE | UNUSABLE | REBUILD | DISABLE | ACTIVE ) (async= ASYNC )?
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_index_node3102); if (state.failed) return ret;
			match(input,INDEX,FOLLOW_INDEX_in_alter_index_node3104); if (state.failed) return ret;
			// PhoenixSQL.g:579:19: ( IF ex= EXISTS )?
			int alt50=2;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==IF) ) {
				alt50=1;
			}
			switch (alt50) {
				case 1 :
					// PhoenixSQL.g:579:20: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_alter_index_node3107); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_index_node3111); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_index_name_in_alter_index_node3117);
			i=index_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,ON,FOLLOW_ON_in_alter_index_node3119); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_alter_index_node3123);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			s=input.LT(1);
			if ( input.LA(1)==ACTIVE||input.LA(1)==DISABLE||input.LA(1)==REBUILD||input.LA(1)==UNUSABLE||input.LA(1)==USABLE ) {
				input.consume();
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			// PhoenixSQL.g:579:120: (async= ASYNC )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==ASYNC) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// PhoenixSQL.g:579:121: async= ASYNC
					{
					async=(Token)match(input,ASYNC,FOLLOW_ASYNC_in_alter_index_node3150); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.alterIndex(factory.namedTable(null, TableName.create(t.getSchemaName(), i.getName())), t.getTableName(), ex!=null, PIndexState.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), async!=null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_index_node"



	// $ANTLR start "trace_node"
	// PhoenixSQL.g:584:1: trace_node returns [TraceStatement ret] : TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) ;
	public final TraceStatement trace_node() throws RecognitionException {
		TraceStatement ret = null;


		Token flag=null;
		LiteralParseNode s =null;

		try {
			// PhoenixSQL.g:585:5: ( TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF ) )
			// PhoenixSQL.g:585:9: TRACE ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			{
			match(input,TRACE,FOLLOW_TRACE_in_trace_node3184); if (state.failed) return ret;
			// PhoenixSQL.g:585:15: ( (flag= ON ( WITH SAMPLING s= sampling_rate )? ) |flag= OFF )
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==ON) ) {
				alt53=1;
			}
			else if ( (LA53_0==OFF) ) {
				alt53=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 53, 0, input);
				throw nvae;
			}

			switch (alt53) {
				case 1 :
					// PhoenixSQL.g:585:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					{
					// PhoenixSQL.g:585:16: (flag= ON ( WITH SAMPLING s= sampling_rate )? )
					// PhoenixSQL.g:585:17: flag= ON ( WITH SAMPLING s= sampling_rate )?
					{
					flag=(Token)match(input,ON,FOLLOW_ON_in_trace_node3192); if (state.failed) return ret;
					// PhoenixSQL.g:585:28: ( WITH SAMPLING s= sampling_rate )?
					int alt52=2;
					int LA52_0 = input.LA(1);
					if ( (LA52_0==WITH) ) {
						alt52=1;
					}
					switch (alt52) {
						case 1 :
							// PhoenixSQL.g:585:30: WITH SAMPLING s= sampling_rate
							{
							match(input,WITH,FOLLOW_WITH_in_trace_node3197); if (state.failed) return ret;
							match(input,SAMPLING,FOLLOW_SAMPLING_in_trace_node3199); if (state.failed) return ret;
							pushFollow(FOLLOW_sampling_rate_in_trace_node3205);
							s=sampling_rate();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:585:67: flag= OFF
					{
					flag=(Token)match(input,OFF,FOLLOW_OFF_in_trace_node3216); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.trace(Tracing.isTraceOn(flag.getText()), s == null ? Tracing.isTraceOn(flag.getText()) ? 1.0 : 0.0 : (((BigDecimal)s.getValue())).doubleValue());}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "trace_node"



	// $ANTLR start "create_function_node"
	// PhoenixSQL.g:590:1: create_function_node returns [CreateFunctionStatement ret] : CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? ;
	public final CreateFunctionStatement create_function_node() throws RecognitionException {
		CreateFunctionStatement ret = null;


		Token replace=null;
		Token temp=null;
		String function =null;
		List<FunctionArgument> args =null;
		String r =null;
		LiteralParseNode className =null;
		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:591:5: ( CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )? )
			// PhoenixSQL.g:591:9: CREATE ( OR replace= REPLACE )? (temp= TEMPORARY )? FUNCTION function= identifier ( LPAREN args= zero_or_more_data_types RPAREN ) RETURNS r= identifier AS (className= jar_path ) ( USING JAR (jarPath= jar_path ) )?
			{
			match(input,CREATE,FOLLOW_CREATE_in_create_function_node3250); if (state.failed) return ret;
			// PhoenixSQL.g:591:16: ( OR replace= REPLACE )?
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==OR) ) {
				alt54=1;
			}
			switch (alt54) {
				case 1 :
					// PhoenixSQL.g:591:17: OR replace= REPLACE
					{
					match(input,OR,FOLLOW_OR_in_create_function_node3253); if (state.failed) return ret;
					replace=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_create_function_node3257); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:591:38: (temp= TEMPORARY )?
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==TEMPORARY) ) {
				alt55=1;
			}
			switch (alt55) {
				case 1 :
					// PhoenixSQL.g:591:39: temp= TEMPORARY
					{
					temp=(Token)match(input,TEMPORARY,FOLLOW_TEMPORARY_in_create_function_node3264); if (state.failed) return ret;
					}
					break;

			}

			match(input,FUNCTION,FOLLOW_FUNCTION_in_create_function_node3268); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3272);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:592:8: ( LPAREN args= zero_or_more_data_types RPAREN )
			// PhoenixSQL.g:592:9: LPAREN args= zero_or_more_data_types RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_create_function_node3283); if (state.failed) return ret;
			pushFollow(FOLLOW_zero_or_more_data_types_in_create_function_node3287);
			args=zero_or_more_data_types();
			state._fsp--;
			if (state.failed) return ret;
			match(input,RPAREN,FOLLOW_RPAREN_in_create_function_node3289); if (state.failed) return ret;
			}

			match(input,RETURNS,FOLLOW_RETURNS_in_create_function_node3299); if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_create_function_node3303);
			r=identifier();
			state._fsp--;
			if (state.failed) return ret;
			match(input,AS,FOLLOW_AS_in_create_function_node3305); if (state.failed) return ret;
			// PhoenixSQL.g:593:32: (className= jar_path )
			// PhoenixSQL.g:593:33: className= jar_path
			{
			pushFollow(FOLLOW_jar_path_in_create_function_node3311);
			className=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:594:8: ( USING JAR (jarPath= jar_path ) )?
			int alt56=2;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==USING) ) {
				alt56=1;
			}
			switch (alt56) {
				case 1 :
					// PhoenixSQL.g:594:9: USING JAR (jarPath= jar_path )
					{
					match(input,USING,FOLLOW_USING_in_create_function_node3322); if (state.failed) return ret;
					match(input,JAR,FOLLOW_JAR_in_create_function_node3324); if (state.failed) return ret;
					// PhoenixSQL.g:594:19: (jarPath= jar_path )
					// PhoenixSQL.g:594:20: jarPath= jar_path
					{
					pushFollow(FOLLOW_jar_path_in_create_function_node3331);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			            ret = factory.createFunction(new PFunction(SchemaUtil.normalizeIdentifier(function), args,r,(String)className.getValue(), jarPath == null ? null : (String)jarPath.getValue()), temp!=null, replace!=null);
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "create_function_node"



	// $ANTLR start "jar_path"
	// PhoenixSQL.g:600:1: jar_path returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode jar_path() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:601:5: (l= literal )
			// PhoenixSQL.g:601:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_jar_path3368);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "jar_path"



	// $ANTLR start "drop_function_node"
	// PhoenixSQL.g:604:1: drop_function_node returns [DropFunctionStatement ret] : DROP FUNCTION ( IF ex= EXISTS )? function= identifier ;
	public final DropFunctionStatement drop_function_node() throws RecognitionException {
		DropFunctionStatement ret = null;


		Token ex=null;
		String function =null;

		try {
			// PhoenixSQL.g:605:5: ( DROP FUNCTION ( IF ex= EXISTS )? function= identifier )
			// PhoenixSQL.g:605:7: DROP FUNCTION ( IF ex= EXISTS )? function= identifier
			{
			match(input,DROP,FOLLOW_DROP_in_drop_function_node3391); if (state.failed) return ret;
			match(input,FUNCTION,FOLLOW_FUNCTION_in_drop_function_node3393); if (state.failed) return ret;
			// PhoenixSQL.g:605:21: ( IF ex= EXISTS )?
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==IF) ) {
				alt57=1;
			}
			switch (alt57) {
				case 1 :
					// PhoenixSQL.g:605:22: IF ex= EXISTS
					{
					match(input,IF,FOLLOW_IF_in_drop_function_node3396); if (state.failed) return ret;
					ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_drop_function_node3400); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_identifier_in_drop_function_node3406);
			function=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.dropFunction(SchemaUtil.normalizeIdentifier(function), ex!=null);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "drop_function_node"



	// $ANTLR start "add_jars_node"
	// PhoenixSQL.g:608:1: add_jars_node returns [AddJarsStatement ret] : ADD JARS jarPaths= one_or_more_jarpaths ;
	public final AddJarsStatement add_jars_node() throws RecognitionException {
		AddJarsStatement ret = null;


		List<LiteralParseNode> jarPaths =null;

		try {
			// PhoenixSQL.g:609:5: ( ADD JARS jarPaths= one_or_more_jarpaths )
			// PhoenixSQL.g:609:7: ADD JARS jarPaths= one_or_more_jarpaths
			{
			match(input,ADD,FOLLOW_ADD_in_add_jars_node3429); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_add_jars_node3431); if (state.failed) return ret;
			pushFollow(FOLLOW_one_or_more_jarpaths_in_add_jars_node3437);
			jarPaths=one_or_more_jarpaths();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.addJars(jarPaths);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_jars_node"



	// $ANTLR start "list_jars_node"
	// PhoenixSQL.g:612:1: list_jars_node returns [ListJarsStatement ret] : LIST JARS ;
	public final ListJarsStatement list_jars_node() throws RecognitionException {
		ListJarsStatement ret = null;


		try {
			// PhoenixSQL.g:613:5: ( LIST JARS )
			// PhoenixSQL.g:613:7: LIST JARS
			{
			match(input,LIST,FOLLOW_LIST_in_list_jars_node3460); if (state.failed) return ret;
			match(input,JARS,FOLLOW_JARS_in_list_jars_node3462); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.listJars();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "list_jars_node"



	// $ANTLR start "delete_jar_node"
	// PhoenixSQL.g:616:1: delete_jar_node returns [DeleteJarStatement ret] : DELETE JAR jarPath= jar_path ;
	public final DeleteJarStatement delete_jar_node() throws RecognitionException {
		DeleteJarStatement ret = null;


		LiteralParseNode jarPath =null;

		try {
			// PhoenixSQL.g:617:5: ( DELETE JAR jarPath= jar_path )
			// PhoenixSQL.g:617:7: DELETE JAR jarPath= jar_path
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_jar_node3485); if (state.failed) return ret;
			match(input,JAR,FOLLOW_JAR_in_delete_jar_node3487); if (state.failed) return ret;
			pushFollow(FOLLOW_jar_path_in_delete_jar_node3493);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.deleteJar(jarPath);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_jar_node"



	// $ANTLR start "alter_session_node"
	// PhoenixSQL.g:621:1: alter_session_node returns [AlterSessionStatement ret] : ALTER SESSION ( SET p= properties ) ;
	public final AlterSessionStatement alter_session_node() throws RecognitionException {
		AlterSessionStatement ret = null;


		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:622:5: ( ALTER SESSION ( SET p= properties ) )
			// PhoenixSQL.g:622:9: ALTER SESSION ( SET p= properties )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_session_node3519); if (state.failed) return ret;
			match(input,SESSION,FOLLOW_SESSION_in_alter_session_node3521); if (state.failed) return ret;
			// PhoenixSQL.g:622:23: ( SET p= properties )
			// PhoenixSQL.g:622:24: SET p= properties
			{
			match(input,SET,FOLLOW_SET_in_alter_session_node3524); if (state.failed) return ret;
			pushFollow(FOLLOW_properties_in_alter_session_node3528);
			p=properties();
			state._fsp--;
			if (state.failed) return ret;
			}

			if ( state.backtracking==0 ) {ret = factory.alterSession(p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_session_node"



	// $ANTLR start "alter_table_node"
	// PhoenixSQL.g:627:1: alter_table_node returns [AlterTableStatement ret] : ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) | ( SET (p= fam_properties ) ) ) ;
	public final AlterTableStatement alter_table_node() throws RecognitionException {
		AlterTableStatement ret = null;


		Token v=null;
		Token ex=null;
		TableName t =null;
		List<ColumnName> c =null;
		List<ColumnDef> d =null;
		ListMultimap<String,Pair<String,Object>> p =null;

		try {
			// PhoenixSQL.g:628:5: ( ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) | ( SET (p= fam_properties ) ) ) )
			// PhoenixSQL.g:628:9: ALTER ( TABLE |v= VIEW ) t= from_table_name ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) | ( SET (p= fam_properties ) ) )
			{
			match(input,ALTER,FOLLOW_ALTER_in_alter_table_node3562); if (state.failed) return ret;
			// PhoenixSQL.g:628:15: ( TABLE |v= VIEW )
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==TABLE) ) {
				alt58=1;
			}
			else if ( (LA58_0==VIEW) ) {
				alt58=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 58, 0, input);
				throw nvae;
			}

			switch (alt58) {
				case 1 :
					// PhoenixSQL.g:628:16: TABLE
					{
					match(input,TABLE,FOLLOW_TABLE_in_alter_table_node3565); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:628:24: v= VIEW
					{
					v=(Token)match(input,VIEW,FOLLOW_VIEW_in_alter_table_node3571); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_from_table_name_in_alter_table_node3576);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:629:9: ( ( DROP COLUMN ( IF ex= EXISTS )? c= column_names ) | ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? ) | ( SET (p= fam_properties ) ) )
			int alt62=3;
			switch ( input.LA(1) ) {
			case DROP:
				{
				alt62=1;
				}
				break;
			case ADD:
				{
				alt62=2;
				}
				break;
			case SET:
				{
				alt62=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 62, 0, input);
				throw nvae;
			}
			switch (alt62) {
				case 1 :
					// PhoenixSQL.g:629:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					{
					// PhoenixSQL.g:629:11: ( DROP COLUMN ( IF ex= EXISTS )? c= column_names )
					// PhoenixSQL.g:629:12: DROP COLUMN ( IF ex= EXISTS )? c= column_names
					{
					match(input,DROP,FOLLOW_DROP_in_alter_table_node3589); if (state.failed) return ret;
					match(input,COLUMN,FOLLOW_COLUMN_in_alter_table_node3591); if (state.failed) return ret;
					// PhoenixSQL.g:629:24: ( IF ex= EXISTS )?
					int alt59=2;
					int LA59_0 = input.LA(1);
					if ( (LA59_0==IF) ) {
						alt59=1;
					}
					switch (alt59) {
						case 1 :
							// PhoenixSQL.g:629:25: IF ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node3594); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node3598); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_column_names_in_alter_table_node3604);
					c=column_names();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:629:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? )
					{
					// PhoenixSQL.g:629:58: ( ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )? )
					// PhoenixSQL.g:629:59: ADD ( IF NOT ex= EXISTS )? (d= column_defs ) (p= fam_properties )?
					{
					match(input,ADD,FOLLOW_ADD_in_alter_table_node3610); if (state.failed) return ret;
					// PhoenixSQL.g:629:63: ( IF NOT ex= EXISTS )?
					int alt60=2;
					int LA60_0 = input.LA(1);
					if ( (LA60_0==IF) ) {
						alt60=1;
					}
					switch (alt60) {
						case 1 :
							// PhoenixSQL.g:629:64: IF NOT ex= EXISTS
							{
							match(input,IF,FOLLOW_IF_in_alter_table_node3613); if (state.failed) return ret;
							match(input,NOT,FOLLOW_NOT_in_alter_table_node3615); if (state.failed) return ret;
							ex=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_alter_table_node3619); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:629:83: (d= column_defs )
					// PhoenixSQL.g:629:84: d= column_defs
					{
					pushFollow(FOLLOW_column_defs_in_alter_table_node3626);
					d=column_defs();
					state._fsp--;
					if (state.failed) return ret;
					}

					// PhoenixSQL.g:629:99: (p= fam_properties )?
					int alt61=2;
					int LA61_0 = input.LA(1);
					if ( (LA61_0==NAME) ) {
						alt61=1;
					}
					switch (alt61) {
						case 1 :
							// PhoenixSQL.g:629:100: p= fam_properties
							{
							pushFollow(FOLLOW_fam_properties_in_alter_table_node3632);
							p=fam_properties();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					}

					}
					break;
				case 3 :
					// PhoenixSQL.g:629:122: ( SET (p= fam_properties ) )
					{
					// PhoenixSQL.g:629:122: ( SET (p= fam_properties ) )
					// PhoenixSQL.g:629:123: SET (p= fam_properties )
					{
					match(input,SET,FOLLOW_SET_in_alter_table_node3640); if (state.failed) return ret;
					// PhoenixSQL.g:629:127: (p= fam_properties )
					// PhoenixSQL.g:629:128: p= fam_properties
					{
					pushFollow(FOLLOW_fam_properties_in_alter_table_node3645);
					p=fam_properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { PTableType tt = v==null ? (QueryConstants.SYSTEM_SCHEMA_NAME.equals(t.getSchemaName()) ? PTableType.SYSTEM : PTableType.TABLE) : PTableType.VIEW; ret = ( c == null ? factory.addColumn(factory.namedTable(null,t), tt, d, ex!=null, p) : factory.dropColumn(factory.namedTable(null,t), tt, c, ex!=null) ); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "alter_table_node"



	// $ANTLR start "update_statistics_node"
	// PhoenixSQL.g:633:1: update_statistics_node returns [UpdateStatisticsStatement ret] : UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? ;
	public final UpdateStatisticsStatement update_statistics_node() throws RecognitionException {
		UpdateStatisticsStatement ret = null;


		Token s=null;
		TableName t =null;
		Map<String,Object> p =null;

		try {
			// PhoenixSQL.g:634:2: ( UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )? )
			// PhoenixSQL.g:634:6: UPDATE STATISTICS t= from_table_name (s= INDEX |s= ALL |s= COLUMNS )? ( SET (p= properties ) )?
			{
			match(input,UPDATE,FOLLOW_UPDATE_in_update_statistics_node3679); if (state.failed) return ret;
			match(input,STATISTICS,FOLLOW_STATISTICS_in_update_statistics_node3681); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_update_statistics_node3685);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:634:42: (s= INDEX |s= ALL |s= COLUMNS )?
			int alt63=4;
			switch ( input.LA(1) ) {
				case INDEX:
					{
					alt63=1;
					}
					break;
				case ALL:
					{
					alt63=2;
					}
					break;
				case COLUMNS:
					{
					alt63=3;
					}
					break;
			}
			switch (alt63) {
				case 1 :
					// PhoenixSQL.g:634:43: s= INDEX
					{
					s=(Token)match(input,INDEX,FOLLOW_INDEX_in_update_statistics_node3690); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:634:53: s= ALL
					{
					s=(Token)match(input,ALL,FOLLOW_ALL_in_update_statistics_node3696); if (state.failed) return ret;
					}
					break;
				case 3 :
					// PhoenixSQL.g:634:61: s= COLUMNS
					{
					s=(Token)match(input,COLUMNS,FOLLOW_COLUMNS_in_update_statistics_node3702); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:634:73: ( SET (p= properties ) )?
			int alt64=2;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==SET) ) {
				alt64=1;
			}
			switch (alt64) {
				case 1 :
					// PhoenixSQL.g:634:74: SET (p= properties )
					{
					match(input,SET,FOLLOW_SET_in_update_statistics_node3707); if (state.failed) return ret;
					// PhoenixSQL.g:634:78: (p= properties )
					// PhoenixSQL.g:634:79: p= properties
					{
					pushFollow(FOLLOW_properties_in_update_statistics_node3712);
					p=properties();
					state._fsp--;
					if (state.failed) return ret;
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.updateStatistics(factory.namedTable(null, t), s == null ? StatisticsCollectionScope.getDefault() : StatisticsCollectionScope.valueOf(SchemaUtil.normalizeIdentifier(s.getText())), p);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_statistics_node"



	// $ANTLR start "execute_upgrade_node"
	// PhoenixSQL.g:638:1: execute_upgrade_node returns [ExecuteUpgradeStatement ret] : EXECUTE UPGRADE ;
	public final ExecuteUpgradeStatement execute_upgrade_node() throws RecognitionException {
		ExecuteUpgradeStatement ret = null;


		try {
			// PhoenixSQL.g:639:2: ( EXECUTE UPGRADE )
			// PhoenixSQL.g:639:6: EXECUTE UPGRADE
			{
			match(input,EXECUTE,FOLLOW_EXECUTE_in_execute_upgrade_node3736); if (state.failed) return ret;
			match(input,UPGRADE,FOLLOW_UPGRADE_in_execute_upgrade_node3738); if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.executeUpgrade();}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "execute_upgrade_node"



	// $ANTLR start "prop_name"
	// PhoenixSQL.g:643:1: prop_name returns [String ret] : p= identifier ;
	public final String prop_name() throws RecognitionException {
		String ret = null;


		String p =null;

		try {
			// PhoenixSQL.g:644:5: (p= identifier )
			// PhoenixSQL.g:644:9: p= identifier
			{
			pushFollow(FOLLOW_identifier_in_prop_name3764);
			p=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = SchemaUtil.normalizeIdentifier(p); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "prop_name"



	// $ANTLR start "properties"
	// PhoenixSQL.g:647:1: properties returns [Map<String,Object> ret] : k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* ;
	public final Map<String,Object> properties() throws RecognitionException {
		Map<String,Object> ret = null;


		String k =null;
		Object v =null;

		ret = new HashMap<String,Object>(); 
		try {
			// PhoenixSQL.g:649:5: (k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )* )
			// PhoenixSQL.g:649:8: k= prop_name EQ v= prop_value ( COMMA k= prop_name EQ v= prop_value )*
			{
			pushFollow(FOLLOW_prop_name_in_properties3798);
			k=prop_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_properties3800); if (state.failed) return ret;
			pushFollow(FOLLOW_prop_value_in_properties3804);
			v=prop_value();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.put(k,v);}
			// PhoenixSQL.g:649:54: ( COMMA k= prop_name EQ v= prop_value )*
			loop65:
			while (true) {
				int alt65=2;
				int LA65_0 = input.LA(1);
				if ( (LA65_0==COMMA) ) {
					alt65=1;
				}

				switch (alt65) {
				case 1 :
					// PhoenixSQL.g:649:55: COMMA k= prop_name EQ v= prop_value
					{
					match(input,COMMA,FOLLOW_COMMA_in_properties3810); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_name_in_properties3814);
					k=prop_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_properties3816); if (state.failed) return ret;
					pushFollow(FOLLOW_prop_value_in_properties3820);
					v=prop_value();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.put(k,v);}
					}
					break;

				default :
					break loop65;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "properties"



	// $ANTLR start "column_defs"
	// PhoenixSQL.g:652:1: column_defs returns [List<ColumnDef> ret] : v= column_def ( COMMA v= column_def )* ;
	public final List<ColumnDef> column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:654:5: (v= column_def ( COMMA v= column_def )* )
			// PhoenixSQL.g:654:8: v= column_def ( COMMA v= column_def )*
			{
			pushFollow(FOLLOW_column_def_in_column_defs3855);
			v=column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:654:39: ( COMMA v= column_def )*
			loop66:
			while (true) {
				int alt66=2;
				int LA66_0 = input.LA(1);
				if ( (LA66_0==COMMA) ) {
					int LA66_1 = input.LA(2);
					if ( (LA66_1==NAME) ) {
						alt66=1;
					}

				}

				switch (alt66) {
				case 1 :
					// PhoenixSQL.g:654:40: COMMA v= column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_column_defs3861); if (state.failed) return ret;
					pushFollow(FOLLOW_column_def_in_column_defs3867);
					v=column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop66;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_defs"



	// $ANTLR start "column_def"
	// PhoenixSQL.g:657:1: column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )? ;
	public final ColumnDef column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token nn=null;
		Token n=null;
		Token pk=null;
		Token order=null;
		Token rr=null;
		ColumnName c =null;
		String dt =null;
		ParseNode df =null;

		try {
			// PhoenixSQL.g:658:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )? )
			// PhoenixSQL.g:658:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ( (nn= NOT )? n= NULL )? ( DEFAULT df= expression )? (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )?
			{
			pushFollow(FOLLOW_column_name_in_column_def3893);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_column_def3897);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:658:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt68=2;
			int LA68_0 = input.LA(1);
			if ( (LA68_0==LPAREN) ) {
				alt68=1;
			}
			switch (alt68) {
				case 1 :
					// PhoenixSQL.g:658:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_column_def3900); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def3904); if (state.failed) return ret;
					// PhoenixSQL.g:658:54: ( COMMA s= NUMBER )?
					int alt67=2;
					int LA67_0 = input.LA(1);
					if ( (LA67_0==COMMA) ) {
						alt67=1;
					}
					switch (alt67) {
						case 1 :
							// PhoenixSQL.g:658:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_column_def3907); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def3911); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_column_def3915); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:658:83: (ar= ARRAY )?
			int alt69=2;
			int LA69_0 = input.LA(1);
			if ( (LA69_0==ARRAY) ) {
				alt69=1;
			}
			switch (alt69) {
				case 1 :
					// PhoenixSQL.g:658:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_column_def3921); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:658:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt71=2;
			int LA71_0 = input.LA(1);
			if ( (LA71_0==LSQUARE) ) {
				alt71=1;
			}
			switch (alt71) {
				case 1 :
					// PhoenixSQL.g:658:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_column_def3927); if (state.failed) return ret;
					// PhoenixSQL.g:658:104: (a= NUMBER )?
					int alt70=2;
					int LA70_0 = input.LA(1);
					if ( (LA70_0==NUMBER) ) {
						alt70=1;
					}
					switch (alt70) {
						case 1 :
							// PhoenixSQL.g:658:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column_def3932); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_column_def3936); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:658:126: ( (nn= NOT )? n= NULL )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( ((LA73_0 >= NOT && LA73_0 <= NULL)) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// PhoenixSQL.g:658:127: (nn= NOT )? n= NULL
					{
					// PhoenixSQL.g:658:129: (nn= NOT )?
					int alt72=2;
					int LA72_0 = input.LA(1);
					if ( (LA72_0==NOT) ) {
						alt72=1;
					}
					switch (alt72) {
						case 1 :
							// PhoenixSQL.g:658:129: nn= NOT
							{
							nn=(Token)match(input,NOT,FOLLOW_NOT_in_column_def3943); if (state.failed) return ret;
							}
							break;

					}

					n=(Token)match(input,NULL,FOLLOW_NULL_in_column_def3948); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:658:144: ( DEFAULT df= expression )?
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==DEFAULT) ) {
				alt74=1;
			}
			switch (alt74) {
				case 1 :
					// PhoenixSQL.g:658:145: DEFAULT df= expression
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_column_def3953); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_column_def3957);
					df=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:658:169: (pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )? )?
			int alt77=2;
			int LA77_0 = input.LA(1);
			if ( (LA77_0==PRIMARY) ) {
				alt77=1;
			}
			switch (alt77) {
				case 1 :
					// PhoenixSQL.g:658:170: pk= PRIMARY KEY (order= ASC |order= DESC )? (rr= ROW_TIMESTAMP )?
					{
					pk=(Token)match(input,PRIMARY,FOLLOW_PRIMARY_in_column_def3964); if (state.failed) return ret;
					match(input,KEY,FOLLOW_KEY_in_column_def3966); if (state.failed) return ret;
					// PhoenixSQL.g:658:185: (order= ASC |order= DESC )?
					int alt75=3;
					int LA75_0 = input.LA(1);
					if ( (LA75_0==ASC) ) {
						alt75=1;
					}
					else if ( (LA75_0==DESC) ) {
						alt75=2;
					}
					switch (alt75) {
						case 1 :
							// PhoenixSQL.g:658:186: order= ASC
							{
							order=(Token)match(input,ASC,FOLLOW_ASC_in_column_def3971); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:658:196: order= DESC
							{
							order=(Token)match(input,DESC,FOLLOW_DESC_in_column_def3975); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:658:211: (rr= ROW_TIMESTAMP )?
					int alt76=2;
					int LA76_0 = input.LA(1);
					if ( (LA76_0==ROW_TIMESTAMP) ) {
						alt76=1;
					}
					switch (alt76) {
						case 1 :
							// PhoenixSQL.g:658:211: rr= ROW_TIMESTAMP
							{
							rr=(Token)match(input,ROW_TIMESTAMP,FOLLOW_ROW_TIMESTAMP_in_column_def3981); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), nn!=null ? Boolean.FALSE : n!=null ? Boolean.TRUE : null, 
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            pk != null, 
			            order == null ? SortOrder.getDefault() : SortOrder.fromDDLValue(order.getText()),
			            df == null ? null : df.toString(),
			            rr != null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "column_def"



	// $ANTLR start "dyn_column_defs"
	// PhoenixSQL.g:668:1: dyn_column_defs returns [List<ColumnDef> ret] : v= dyn_column_def ( COMMA v= dyn_column_def )* ;
	public final List<ColumnDef> dyn_column_defs() throws RecognitionException {
		List<ColumnDef> ret = null;


		ColumnDef v =null;

		ret = new ArrayList<ColumnDef>(); 
		try {
			// PhoenixSQL.g:670:5: (v= dyn_column_def ( COMMA v= dyn_column_def )* )
			// PhoenixSQL.g:670:8: v= dyn_column_def ( COMMA v= dyn_column_def )*
			{
			pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4024);
			v=dyn_column_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(v);}
			// PhoenixSQL.g:670:43: ( COMMA v= dyn_column_def )*
			loop78:
			while (true) {
				int alt78=2;
				int LA78_0 = input.LA(1);
				if ( (LA78_0==COMMA) ) {
					alt78=1;
				}

				switch (alt78) {
				case 1 :
					// PhoenixSQL.g:670:44: COMMA v= dyn_column_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_dyn_column_defs4030); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_def_in_dyn_column_defs4036);
					v=dyn_column_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop78;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_defs"



	// $ANTLR start "dyn_column_def"
	// PhoenixSQL.g:673:1: dyn_column_def returns [ColumnDef ret] : c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? ;
	public final ColumnDef dyn_column_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:674:5: (c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )
			// PhoenixSQL.g:674:9: c= column_name dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_def4062);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			pushFollow(FOLLOW_identifier_in_dyn_column_def4066);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:674:37: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt80=2;
			int LA80_0 = input.LA(1);
			if ( (LA80_0==LPAREN) ) {
				alt80=1;
			}
			switch (alt80) {
				case 1 :
					// PhoenixSQL.g:674:38: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_def4069); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4073); if (state.failed) return ret;
					// PhoenixSQL.g:674:54: ( COMMA s= NUMBER )?
					int alt79=2;
					int LA79_0 = input.LA(1);
					if ( (LA79_0==COMMA) ) {
						alt79=1;
					}
					switch (alt79) {
						case 1 :
							// PhoenixSQL.g:674:55: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_dyn_column_def4076); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4080); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_def4084); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:674:83: (ar= ARRAY )?
			int alt81=2;
			int LA81_0 = input.LA(1);
			if ( (LA81_0==ARRAY) ) {
				alt81=1;
			}
			switch (alt81) {
				case 1 :
					// PhoenixSQL.g:674:83: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_def4090); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:674:91: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt83=2;
			int LA83_0 = input.LA(1);
			if ( (LA83_0==LSQUARE) ) {
				alt83=1;
			}
			switch (alt83) {
				case 1 :
					// PhoenixSQL.g:674:92: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_def4096); if (state.failed) return ret;
					// PhoenixSQL.g:674:104: (a= NUMBER )?
					int alt82=2;
					int LA82_0 = input.LA(1);
					if ( (LA82_0==NUMBER) ) {
						alt82=1;
					}
					switch (alt82) {
						case 1 :
							// PhoenixSQL.g:674:105: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_def4101); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_def4105); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_def"



	// $ANTLR start "dyn_column_name_or_def"
	// PhoenixSQL.g:683:1: dyn_column_name_or_def returns [ColumnDef ret] : c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? ;
	public final ColumnDef dyn_column_name_or_def() throws RecognitionException {
		ColumnDef ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		ColumnName c =null;
		String dt =null;

		try {
			// PhoenixSQL.g:684:5: (c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )? )
			// PhoenixSQL.g:684:9: c= column_name (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			{
			pushFollow(FOLLOW_column_name_in_dyn_column_name_or_def4142);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:684:23: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? )?
			int alt89=2;
			int LA89_0 = input.LA(1);
			if ( (LA89_0==NAME) ) {
				alt89=1;
			}
			switch (alt89) {
				case 1 :
					// PhoenixSQL.g:684:24: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					{
					pushFollow(FOLLOW_identifier_in_dyn_column_name_or_def4147);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:684:38: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
					int alt85=2;
					int LA85_0 = input.LA(1);
					if ( (LA85_0==LPAREN) ) {
						alt85=1;
					}
					switch (alt85) {
						case 1 :
							// PhoenixSQL.g:684:39: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_dyn_column_name_or_def4150); if (state.failed) return ret;
							l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4154); if (state.failed) return ret;
							// PhoenixSQL.g:684:55: ( COMMA s= NUMBER )?
							int alt84=2;
							int LA84_0 = input.LA(1);
							if ( (LA84_0==COMMA) ) {
								alt84=1;
							}
							switch (alt84) {
								case 1 :
									// PhoenixSQL.g:684:56: COMMA s= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_dyn_column_name_or_def4157); if (state.failed) return ret;
									s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4161); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_dyn_column_name_or_def4165); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:684:84: (ar= ARRAY )?
					int alt86=2;
					int LA86_0 = input.LA(1);
					if ( (LA86_0==ARRAY) ) {
						alt86=1;
					}
					switch (alt86) {
						case 1 :
							// PhoenixSQL.g:684:84: ar= ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_dyn_column_name_or_def4171); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:684:92: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
					int alt88=2;
					int LA88_0 = input.LA(1);
					if ( (LA88_0==LSQUARE) ) {
						alt88=1;
					}
					switch (alt88) {
						case 1 :
							// PhoenixSQL.g:684:93: lsq= LSQUARE (a= NUMBER )? RSQUARE
							{
							lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_dyn_column_name_or_def4177); if (state.failed) return ret;
							// PhoenixSQL.g:684:105: (a= NUMBER )?
							int alt87=2;
							int LA87_0 = input.LA(1);
							if ( (LA87_0==NUMBER) ) {
								alt87=1;
							}
							switch (alt87) {
								case 1 :
									// PhoenixSQL.g:684:106: a= NUMBER
									{
									a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_dyn_column_name_or_def4182); if (state.failed) return ret;
									}
									break;

							}

							match(input,RSQUARE,FOLLOW_RSQUARE_in_dyn_column_name_or_def4186); if (state.failed) return ret;
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.columnDef(c, dt, ar != null || lsq != null, a == null ? null :  Integer.parseInt( a.getText() ), Boolean.TRUE,
			            l == null ? null : Integer.parseInt( l.getText() ),
			            s == null ? null : Integer.parseInt( s.getText() ),
			            false, 
			            SortOrder.getDefault(),
			            false); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "dyn_column_name_or_def"



	// $ANTLR start "subquery_expression"
	// PhoenixSQL.g:693:1: subquery_expression returns [ParseNode ret] : s= select_node ;
	public final ParseNode subquery_expression() throws RecognitionException {
		ParseNode ret = null;


		SelectStatement s =null;

		try {
			// PhoenixSQL.g:694:5: (s= select_node )
			// PhoenixSQL.g:694:8: s= select_node
			{
			pushFollow(FOLLOW_select_node_in_subquery_expression4226);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.subquery(s, false);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subquery_expression"



	// $ANTLR start "single_select"
	// PhoenixSQL.g:697:1: single_select returns [SelectStatement ret] : SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? ;
	public final SelectStatement single_select() throws RecognitionException {
		SelectStatement ret = null;


		Token d=null;
		HintNode h =null;
		List<AliasedNode> sel =null;
		TableNode from =null;
		ParseNode where =null;
		List<ParseNode> group =null;
		ParseNode having =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:699:5: ( SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )? )
			// PhoenixSQL.g:699:9: SELECT (h= hintClause )? (d= DISTINCT | ALL )? sel= select_list ( FROM from= parseFrom )? ( WHERE where= expression )? ( GROUP BY group= group_by )? ( HAVING having= expression )?
			{
			match(input,SELECT,FOLLOW_SELECT_in_single_select4259); if (state.failed) return ret;
			// PhoenixSQL.g:699:16: (h= hintClause )?
			int alt90=2;
			int LA90_0 = input.LA(1);
			if ( (LA90_0==ML_HINT) ) {
				alt90=1;
			}
			switch (alt90) {
				case 1 :
					// PhoenixSQL.g:699:17: h= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_single_select4264);
					h=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:700:9: (d= DISTINCT | ALL )?
			int alt91=3;
			int LA91_0 = input.LA(1);
			if ( (LA91_0==DISTINCT) ) {
				alt91=1;
			}
			else if ( (LA91_0==ALL) ) {
				alt91=2;
			}
			switch (alt91) {
				case 1 :
					// PhoenixSQL.g:700:10: d= DISTINCT
					{
					d=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_single_select4280); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:700:23: ALL
					{
					match(input,ALL,FOLLOW_ALL_in_single_select4284); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_select_list_in_single_select4290);
			sel=select_list();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:701:9: ( FROM from= parseFrom )?
			int alt92=2;
			int LA92_0 = input.LA(1);
			if ( (LA92_0==FROM) ) {
				alt92=1;
			}
			switch (alt92) {
				case 1 :
					// PhoenixSQL.g:701:10: FROM from= parseFrom
					{
					match(input,FROM,FOLLOW_FROM_in_single_select4301); if (state.failed) return ret;
					pushFollow(FOLLOW_parseFrom_in_single_select4305);
					from=parseFrom();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:702:9: ( WHERE where= expression )?
			int alt93=2;
			int LA93_0 = input.LA(1);
			if ( (LA93_0==WHERE) ) {
				alt93=1;
			}
			switch (alt93) {
				case 1 :
					// PhoenixSQL.g:702:10: WHERE where= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_single_select4318); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select4322);
					where=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:703:9: ( GROUP BY group= group_by )?
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==GROUP) ) {
				alt94=1;
			}
			switch (alt94) {
				case 1 :
					// PhoenixSQL.g:703:10: GROUP BY group= group_by
					{
					match(input,GROUP,FOLLOW_GROUP_in_single_select4335); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_single_select4337); if (state.failed) return ret;
					pushFollow(FOLLOW_group_by_in_single_select4341);
					group=group_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:704:9: ( HAVING having= expression )?
			int alt95=2;
			int LA95_0 = input.LA(1);
			if ( (LA95_0==HAVING) ) {
				alt95=1;
			}
			switch (alt95) {
				case 1 :
					// PhoenixSQL.g:704:10: HAVING having= expression
					{
					match(input,HAVING,FOLLOW_HAVING_in_single_select4354); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_single_select4358);
					having=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(from, h, d!=null, sel, where, group, having, null, null,null, getBindCount(), context.isAggregate(), context.hasSequences(), null, new HashMap<String,UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "single_select"



	// $ANTLR start "unioned_selects"
	// PhoenixSQL.g:709:1: unioned_selects returns [List<SelectStatement> ret] : s= single_select ( UNION ALL s= single_select )* ;
	public final List<SelectStatement> unioned_selects() throws RecognitionException {
		List<SelectStatement> ret = null;


		SelectStatement s =null;

		ret = new ArrayList<SelectStatement>();
		try {
			// PhoenixSQL.g:711:5: (s= single_select ( UNION ALL s= single_select )* )
			// PhoenixSQL.g:711:9: s= single_select ( UNION ALL s= single_select )*
			{
			pushFollow(FOLLOW_single_select_in_unioned_selects4402);
			s=single_select();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(s);}
			// PhoenixSQL.g:711:39: ( UNION ALL s= single_select )*
			loop96:
			while (true) {
				int alt96=2;
				int LA96_0 = input.LA(1);
				if ( (LA96_0==UNION) ) {
					alt96=1;
				}

				switch (alt96) {
				case 1 :
					// PhoenixSQL.g:711:40: UNION ALL s= single_select
					{
					match(input,UNION,FOLLOW_UNION_in_unioned_selects4407); if (state.failed) return ret;
					match(input,ALL,FOLLOW_ALL_in_unioned_selects4409); if (state.failed) return ret;
					pushFollow(FOLLOW_single_select_in_unioned_selects4413);
					s=single_select();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(s);}
					}
					break;

				default :
					break loop96;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "unioned_selects"



	// $ANTLR start "select_node"
	// PhoenixSQL.g:715:1: select_node returns [SelectStatement ret] : u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset ( ROW | ROWS )? )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? ;
	public final SelectStatement select_node() throws RecognitionException {
		SelectStatement ret = null;


		List<SelectStatement> u =null;
		List<OrderByNode> order =null;
		LimitNode l =null;
		OffsetNode o =null;

		 contextStack.push(new ParseContext()); 
		try {
			// PhoenixSQL.g:717:5: (u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset ( ROW | ROWS )? )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )? )
			// PhoenixSQL.g:717:9: u= unioned_selects ( ORDER BY order= order_by )? ( LIMIT l= limit )? ( OFFSET o= offset ( ROW | ROWS )? )? ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			{
			pushFollow(FOLLOW_unioned_selects_in_select_node4451);
			u=unioned_selects();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:718:9: ( ORDER BY order= order_by )?
			int alt97=2;
			int LA97_0 = input.LA(1);
			if ( (LA97_0==ORDER) ) {
				alt97=1;
			}
			switch (alt97) {
				case 1 :
					// PhoenixSQL.g:718:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_select_node4462); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_select_node4464); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_select_node4468);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:719:9: ( LIMIT l= limit )?
			int alt98=2;
			int LA98_0 = input.LA(1);
			if ( (LA98_0==LIMIT) ) {
				alt98=1;
			}
			switch (alt98) {
				case 1 :
					// PhoenixSQL.g:719:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_select_node4481); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_select_node4485);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:720:9: ( OFFSET o= offset ( ROW | ROWS )? )?
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==OFFSET) ) {
				alt100=1;
			}
			switch (alt100) {
				case 1 :
					// PhoenixSQL.g:720:10: OFFSET o= offset ( ROW | ROWS )?
					{
					match(input,OFFSET,FOLLOW_OFFSET_in_select_node4498); if (state.failed) return ret;
					pushFollow(FOLLOW_offset_in_select_node4502);
					o=offset();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:720:26: ( ROW | ROWS )?
					int alt99=2;
					int LA99_0 = input.LA(1);
					if ( ((LA99_0 >= ROW && LA99_0 <= ROWS)) ) {
						alt99=1;
					}
					switch (alt99) {
						case 1 :
							// PhoenixSQL.g:
							{
							if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
								input.consume();
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							}
							break;

					}

					}
					break;

			}

			// PhoenixSQL.g:721:9: ( FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY )?
			int alt102=2;
			int LA102_0 = input.LA(1);
			if ( (LA102_0==FETCH) ) {
				alt102=1;
			}
			switch (alt102) {
				case 1 :
					// PhoenixSQL.g:721:10: FETCH ( FIRST | NEXT ) (l= limit )? ( ROW | ROWS ) ONLY
					{
					match(input,FETCH,FOLLOW_FETCH_in_select_node4524); if (state.failed) return ret;
					if ( input.LA(1)==FIRST||input.LA(1)==NEXT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					// PhoenixSQL.g:721:31: (l= limit )?
					int alt101=2;
					int LA101_0 = input.LA(1);
					if ( (LA101_0==BIND_NAME||LA101_0==NUMBER||LA101_0==QUESTION) ) {
						alt101=1;
					}
					switch (alt101) {
						case 1 :
							// PhoenixSQL.g:721:32: l= limit
							{
							pushFollow(FOLLOW_limit_in_select_node4537);
							l=limit();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					match(input,ONLY,FOLLOW_ONLY_in_select_node4549); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ParseContext context = contextStack.peek(); ret = factory.select(u, order, l, o, getBindCount(), context.isAggregate()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
			 contextStack.pop(); 
		}
		return ret;
	}
	// $ANTLR end "select_node"



	// $ANTLR start "upsert_node"
	// PhoenixSQL.g:727:1: upsert_node returns [UpsertStatement ret] : UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) ;
	public final UpsertStatement upsert_node() throws RecognitionException {
		UpsertStatement ret = null;


		Token ig=null;
		HintNode hint =null;
		TableName t =null;
		Pair<List<ColumnDef>,List<ColumnName>> p =null;
		List<ParseNode> v =null;
		List<Pair<ColumnName,ParseNode>> pairs =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:728:5: ( UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node ) )
			// PhoenixSQL.g:728:9: UPSERT (hint= hintClause )? INTO t= from_table_name ( LPAREN p= upsert_column_refs RPAREN )? ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			{
			match(input,UPSERT,FOLLOW_UPSERT_in_upsert_node4588); if (state.failed) return ret;
			// PhoenixSQL.g:728:16: (hint= hintClause )?
			int alt103=2;
			int LA103_0 = input.LA(1);
			if ( (LA103_0==ML_HINT) ) {
				alt103=1;
			}
			switch (alt103) {
				case 1 :
					// PhoenixSQL.g:728:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_upsert_node4593);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,INTO,FOLLOW_INTO_in_upsert_node4597); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_upsert_node4601);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:729:9: ( LPAREN p= upsert_column_refs RPAREN )?
			int alt104=2;
			int LA104_0 = input.LA(1);
			if ( (LA104_0==LPAREN) ) {
				alt104=1;
			}
			switch (alt104) {
				case 1 :
					// PhoenixSQL.g:729:10: LPAREN p= upsert_column_refs RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node4612); if (state.failed) return ret;
					pushFollow(FOLLOW_upsert_column_refs_in_upsert_node4616);
					p=upsert_column_refs();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node4618); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:730:9: ( ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? ) |s= select_node )
			int alt107=2;
			int LA107_0 = input.LA(1);
			if ( (LA107_0==VALUES) ) {
				alt107=1;
			}
			else if ( (LA107_0==SELECT) ) {
				alt107=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 107, 0, input);
				throw nvae;
			}

			switch (alt107) {
				case 1 :
					// PhoenixSQL.g:730:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					{
					// PhoenixSQL.g:730:10: ( VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )? )
					// PhoenixSQL.g:730:11: VALUES LPAREN v= one_or_more_expressions RPAREN ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					{
					match(input,VALUES,FOLLOW_VALUES_in_upsert_node4632); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_upsert_node4634); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_upsert_node4638);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_upsert_node4640); if (state.failed) return ret;
					// PhoenixSQL.g:730:58: ( ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) ) )?
					int alt106=2;
					int LA106_0 = input.LA(1);
					if ( (LA106_0==ON) ) {
						alt106=1;
					}
					switch (alt106) {
						case 1 :
							// PhoenixSQL.g:730:60: ON DUPLICATE KEY (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							{
							match(input,ON,FOLLOW_ON_in_upsert_node4644); if (state.failed) return ret;
							match(input,DUPLICATE,FOLLOW_DUPLICATE_in_upsert_node4646); if (state.failed) return ret;
							match(input,KEY,FOLLOW_KEY_in_upsert_node4648); if (state.failed) return ret;
							// PhoenixSQL.g:730:77: (ig= IGNORE | ( UPDATE pairs= update_column_pairs ) )
							int alt105=2;
							int LA105_0 = input.LA(1);
							if ( (LA105_0==IGNORE) ) {
								alt105=1;
							}
							else if ( (LA105_0==UPDATE) ) {
								alt105=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 105, 0, input);
								throw nvae;
							}

							switch (alt105) {
								case 1 :
									// PhoenixSQL.g:730:79: ig= IGNORE
									{
									ig=(Token)match(input,IGNORE,FOLLOW_IGNORE_in_upsert_node4654); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:730:91: ( UPDATE pairs= update_column_pairs )
									{
									// PhoenixSQL.g:730:91: ( UPDATE pairs= update_column_pairs )
									// PhoenixSQL.g:730:93: UPDATE pairs= update_column_pairs
									{
									match(input,UPDATE,FOLLOW_UPDATE_in_upsert_node4660); if (state.failed) return ret;
									pushFollow(FOLLOW_update_column_pairs_in_upsert_node4664);
									pairs=update_column_pairs();
									state._fsp--;
									if (state.failed) return ret;
									}

									}
									break;

							}

							}
							break;

					}

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:730:137: s= select_node
					{
					pushFollow(FOLLOW_select_node_in_upsert_node4679);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.upsert(
			            factory.namedTable(null,t,p == null ? null : p.getFirst()), 
			            hint, p == null ? null : p.getSecond(), 
			            v, s, getBindCount(), 
			            new HashMap<String, UDFParseNode>(udfParseNodes),
			            ig != null ? Collections.<Pair<ColumnName,ParseNode>>emptyList() : pairs != null ? pairs : null); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_node"



	// $ANTLR start "update_column_pairs"
	// PhoenixSQL.g:739:1: update_column_pairs returns [ List<Pair<ColumnName,ParseNode>> ret] : p= update_column_pair ( COMMA p= update_column_pair )* ;
	public final List<Pair<ColumnName,ParseNode>> update_column_pairs() throws RecognitionException {
		List<Pair<ColumnName,ParseNode>> ret = null;


		Pair<ColumnName,ParseNode> p =null;

		ret = new ArrayList<Pair<ColumnName,ParseNode>>(); 
		try {
			// PhoenixSQL.g:741:5: (p= update_column_pair ( COMMA p= update_column_pair )* )
			// PhoenixSQL.g:741:8: p= update_column_pair ( COMMA p= update_column_pair )*
			{
			pushFollow(FOLLOW_update_column_pair_in_update_column_pairs4720);
			p=update_column_pair();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(p); }
			// PhoenixSQL.g:742:8: ( COMMA p= update_column_pair )*
			loop108:
			while (true) {
				int alt108=2;
				int LA108_0 = input.LA(1);
				if ( (LA108_0==COMMA) ) {
					alt108=1;
				}

				switch (alt108) {
				case 1 :
					// PhoenixSQL.g:742:9: COMMA p= update_column_pair
					{
					match(input,COMMA,FOLLOW_COMMA_in_update_column_pairs4732); if (state.failed) return ret;
					pushFollow(FOLLOW_update_column_pair_in_update_column_pairs4736);
					p=update_column_pair();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret.add(p); }
					}
					break;

				default :
					break loop108;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pairs"



	// $ANTLR start "update_column_pair"
	// PhoenixSQL.g:745:1: update_column_pair returns [ Pair<ColumnName,ParseNode> ret ] : c= column_name EQ e= expression ;
	public final Pair<ColumnName,ParseNode> update_column_pair() throws RecognitionException {
		Pair<ColumnName,ParseNode> ret = null;


		ColumnName c =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:746:5: (c= column_name EQ e= expression )
			// PhoenixSQL.g:746:8: c= column_name EQ e= expression
			{
			pushFollow(FOLLOW_column_name_in_update_column_pair4761);
			c=column_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,EQ,FOLLOW_EQ_in_update_column_pair4763); if (state.failed) return ret;
			pushFollow(FOLLOW_expression_in_update_column_pair4767);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = new Pair<ColumnName,ParseNode>(c,e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "update_column_pair"



	// $ANTLR start "upsert_column_refs"
	// PhoenixSQL.g:750:1: upsert_column_refs returns [Pair<List<ColumnDef>,List<ColumnName>> ret] : d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* ;
	public final Pair<List<ColumnDef>,List<ColumnName>> upsert_column_refs() throws RecognitionException {
		Pair<List<ColumnDef>,List<ColumnName>> ret = null;


		ColumnDef d =null;

		ret = new Pair<List<ColumnDef>,List<ColumnName>>(new ArrayList<ColumnDef>(), new ArrayList<ColumnName>()); 
		try {
			// PhoenixSQL.g:752:5: (d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )* )
			// PhoenixSQL.g:752:8: d= dyn_column_name_or_def ( COMMA d= dyn_column_name_or_def )*
			{
			pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4796);
			d=dyn_column_name_or_def();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
			// PhoenixSQL.g:753:8: ( COMMA d= dyn_column_name_or_def )*
			loop109:
			while (true) {
				int alt109=2;
				int LA109_0 = input.LA(1);
				if ( (LA109_0==COMMA) ) {
					alt109=1;
				}

				switch (alt109) {
				case 1 :
					// PhoenixSQL.g:753:9: COMMA d= dyn_column_name_or_def
					{
					match(input,COMMA,FOLLOW_COMMA_in_upsert_column_refs4809); if (state.failed) return ret;
					pushFollow(FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4813);
					d=dyn_column_name_or_def();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { if (d.getDataType()!=null) { ret.getFirst().add(d); } ret.getSecond().add(d.getColumnDefName()); }
					}
					break;

				default :
					break loop109;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "upsert_column_refs"



	// $ANTLR start "declare_cursor_node"
	// PhoenixSQL.g:758:1: declare_cursor_node returns [DeclareCursorStatement ret] : DECLARE c= cursor_name CURSOR FOR s= select_node ;
	public final DeclareCursorStatement declare_cursor_node() throws RecognitionException {
		DeclareCursorStatement ret = null;


		CursorName c =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:759:5: ( DECLARE c= cursor_name CURSOR FOR s= select_node )
			// PhoenixSQL.g:759:10: DECLARE c= cursor_name CURSOR FOR s= select_node
			{
			match(input,DECLARE,FOLLOW_DECLARE_in_declare_cursor_node4841); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_declare_cursor_node4845);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			match(input,CURSOR,FOLLOW_CURSOR_in_declare_cursor_node4847); if (state.failed) return ret;
			match(input,FOR,FOLLOW_FOR_in_declare_cursor_node4849); if (state.failed) return ret;
			pushFollow(FOLLOW_select_node_in_declare_cursor_node4853);
			s=select_node();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.declareCursor(c, s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "declare_cursor_node"



	// $ANTLR start "cursor_open_node"
	// PhoenixSQL.g:763:1: cursor_open_node returns [OpenStatement ret] : OPEN c= cursor_name ;
	public final OpenStatement cursor_open_node() throws RecognitionException {
		OpenStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:764:5: ( OPEN c= cursor_name )
			// PhoenixSQL.g:764:10: OPEN c= cursor_name
			{
			match(input,OPEN,FOLLOW_OPEN_in_cursor_open_node4887); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_open_node4891);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.open(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_open_node"



	// $ANTLR start "cursor_close_node"
	// PhoenixSQL.g:767:1: cursor_close_node returns [CloseStatement ret] : CLOSE c= cursor_name ;
	public final CloseStatement cursor_close_node() throws RecognitionException {
		CloseStatement ret = null;


		CursorName c =null;

		try {
			// PhoenixSQL.g:768:5: ( CLOSE c= cursor_name )
			// PhoenixSQL.g:768:10: CLOSE c= cursor_name
			{
			match(input,CLOSE,FOLLOW_CLOSE_in_cursor_close_node4918); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_close_node4922);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.close(c);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_close_node"



	// $ANTLR start "cursor_fetch_node"
	// PhoenixSQL.g:771:1: cursor_fetch_node returns [FetchStatement ret] : FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name ;
	public final FetchStatement cursor_fetch_node() throws RecognitionException {
		FetchStatement ret = null;


		Token a=null;
		CursorName c =null;

		try {
			// PhoenixSQL.g:772:5: ( FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name )
			// PhoenixSQL.g:772:10: FETCH NEXT (a= NUMBER )? ( ROW | ROWS )? FROM c= cursor_name
			{
			match(input,FETCH,FOLLOW_FETCH_in_cursor_fetch_node4948); if (state.failed) return ret;
			match(input,NEXT,FOLLOW_NEXT_in_cursor_fetch_node4950); if (state.failed) return ret;
			// PhoenixSQL.g:772:21: (a= NUMBER )?
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==NUMBER) ) {
				alt110=1;
			}
			switch (alt110) {
				case 1 :
					// PhoenixSQL.g:772:22: a= NUMBER
					{
					a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_cursor_fetch_node4955); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:772:33: ( ROW | ROWS )?
			int alt111=2;
			int LA111_0 = input.LA(1);
			if ( ((LA111_0 >= ROW && LA111_0 <= ROWS)) ) {
				alt111=1;
			}
			switch (alt111) {
				case 1 :
					// PhoenixSQL.g:
					{
					if ( (input.LA(1) >= ROW && input.LA(1) <= ROWS) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_cursor_fetch_node4966); if (state.failed) return ret;
			pushFollow(FOLLOW_cursor_name_in_cursor_fetch_node4970);
			c=cursor_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.fetch(c,true, a == null ? 1 :  Integer.parseInt( a.getText() )); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_fetch_node"



	// $ANTLR start "delete_node"
	// PhoenixSQL.g:776:1: delete_node returns [DeleteStatement ret] : DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? ;
	public final DeleteStatement delete_node() throws RecognitionException {
		DeleteStatement ret = null;


		HintNode hint =null;
		TableName t =null;
		ParseNode v =null;
		List<OrderByNode> order =null;
		LimitNode l =null;

		try {
			// PhoenixSQL.g:777:5: ( DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )? )
			// PhoenixSQL.g:777:9: DELETE (hint= hintClause )? FROM t= from_table_name ( WHERE v= expression )? ( ORDER BY order= order_by )? ( LIMIT l= limit )?
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete_node4996); if (state.failed) return ret;
			// PhoenixSQL.g:777:16: (hint= hintClause )?
			int alt112=2;
			int LA112_0 = input.LA(1);
			if ( (LA112_0==ML_HINT) ) {
				alt112=1;
			}
			switch (alt112) {
				case 1 :
					// PhoenixSQL.g:777:17: hint= hintClause
					{
					pushFollow(FOLLOW_hintClause_in_delete_node5001);
					hint=hintClause();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			match(input,FROM,FOLLOW_FROM_in_delete_node5005); if (state.failed) return ret;
			pushFollow(FOLLOW_from_table_name_in_delete_node5009);
			t=from_table_name();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:778:9: ( WHERE v= expression )?
			int alt113=2;
			int LA113_0 = input.LA(1);
			if ( (LA113_0==WHERE) ) {
				alt113=1;
			}
			switch (alt113) {
				case 1 :
					// PhoenixSQL.g:778:10: WHERE v= expression
					{
					match(input,WHERE,FOLLOW_WHERE_in_delete_node5020); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_delete_node5024);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:779:9: ( ORDER BY order= order_by )?
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==ORDER) ) {
				alt114=1;
			}
			switch (alt114) {
				case 1 :
					// PhoenixSQL.g:779:10: ORDER BY order= order_by
					{
					match(input,ORDER,FOLLOW_ORDER_in_delete_node5037); if (state.failed) return ret;
					match(input,BY,FOLLOW_BY_in_delete_node5039); if (state.failed) return ret;
					pushFollow(FOLLOW_order_by_in_delete_node5043);
					order=order_by();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:780:9: ( LIMIT l= limit )?
			int alt115=2;
			int LA115_0 = input.LA(1);
			if ( (LA115_0==LIMIT) ) {
				alt115=1;
			}
			switch (alt115) {
				case 1 :
					// PhoenixSQL.g:780:10: LIMIT l= limit
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_delete_node5056); if (state.failed) return ret;
					pushFollow(FOLLOW_limit_in_delete_node5060);
					l=limit();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.delete(factory.namedTable(null,t), hint, v, order, l, getBindCount(), new HashMap<String, UDFParseNode>(udfParseNodes)); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "delete_node"



	// $ANTLR start "limit"
	// PhoenixSQL.g:784:1: limit returns [LimitNode ret] : (b= bind_expression |l= int_or_long_literal );
	public final LimitNode limit() throws RecognitionException {
		LimitNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:785:5: (b= bind_expression |l= int_or_long_literal )
			int alt116=2;
			int LA116_0 = input.LA(1);
			if ( (LA116_0==BIND_NAME||LA116_0==QUESTION) ) {
				alt116=1;
			}
			else if ( (LA116_0==NUMBER) ) {
				alt116=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 116, 0, input);
				throw nvae;
			}

			switch (alt116) {
				case 1 :
					// PhoenixSQL.g:785:7: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_limit5095);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(b); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:786:7: l= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_limit5107);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.limit(l); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "limit"



	// $ANTLR start "offset"
	// PhoenixSQL.g:789:1: offset returns [OffsetNode ret] : (b= bind_expression |l= int_or_long_literal );
	public final OffsetNode offset() throws RecognitionException {
		OffsetNode ret = null;


		BindParseNode b =null;
		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:790:2: (b= bind_expression |l= int_or_long_literal )
			int alt117=2;
			int LA117_0 = input.LA(1);
			if ( (LA117_0==BIND_NAME||LA117_0==QUESTION) ) {
				alt117=1;
			}
			else if ( (LA117_0==NUMBER) ) {
				alt117=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 117, 0, input);
				throw nvae;
			}

			switch (alt117) {
				case 1 :
					// PhoenixSQL.g:790:4: b= bind_expression
					{
					pushFollow(FOLLOW_bind_expression_in_offset5133);
					b=bind_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.offset(b); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:791:7: l= int_or_long_literal
					{
					pushFollow(FOLLOW_int_or_long_literal_in_offset5145);
					l=int_or_long_literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.offset(l); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "offset"



	// $ANTLR start "sampling_rate"
	// PhoenixSQL.g:794:1: sampling_rate returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode sampling_rate() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:795:5: (l= literal )
			// PhoenixSQL.g:795:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_sampling_rate5170);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "sampling_rate"



	// $ANTLR start "tableSampleNode"
	// PhoenixSQL.g:798:1: tableSampleNode returns [LiteralParseNode ret] : l= literal ;
	public final LiteralParseNode tableSampleNode() throws RecognitionException {
		LiteralParseNode ret = null;


		LiteralParseNode l =null;

		try {
			// PhoenixSQL.g:799:5: (l= literal )
			// PhoenixSQL.g:799:7: l= literal
			{
			pushFollow(FOLLOW_literal_in_tableSampleNode5195);
			l=literal();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "tableSampleNode"



	// $ANTLR start "hintClause"
	// PhoenixSQL.g:802:1: hintClause returns [HintNode ret] : c= ML_HINT ;
	public final HintNode hintClause() throws RecognitionException {
		HintNode ret = null;


		Token c=null;

		try {
			// PhoenixSQL.g:803:5: (c= ML_HINT )
			// PhoenixSQL.g:803:8: c= ML_HINT
			{
			c=(Token)match(input,ML_HINT,FOLLOW_ML_HINT_in_hintClause5221); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.hint(c.getText()); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "hintClause"



	// $ANTLR start "select_list"
	// PhoenixSQL.g:807:1: select_list returns [List<AliasedNode> ret] : (n= selectable ( COMMA n= selectable )* | ASTERISK );
	public final List<AliasedNode> select_list() throws RecognitionException {
		List<AliasedNode> ret = null;


		AliasedNode n =null;

		ret = new ArrayList<AliasedNode>();
		try {
			// PhoenixSQL.g:809:5: (n= selectable ( COMMA n= selectable )* | ASTERISK )
			int alt119=2;
			int LA119_0 = input.LA(1);
			if ( (LA119_0==ARRAY||LA119_0==BIND_NAME||(LA119_0 >= CASE && LA119_0 <= CAST)||LA119_0==CURRENT||LA119_0==DECIMAL||LA119_0==DOUBLE||LA119_0==EXISTS||LA119_0==FALSE||LA119_0==LPAREN||LA119_0==MINUS||(LA119_0 >= NAME && LA119_0 <= NEXT)||(LA119_0 >= NOT && LA119_0 <= NULL)||LA119_0==NUMBER||LA119_0==QUESTION||LA119_0==STRING_LITERAL||LA119_0==TRUE) ) {
				alt119=1;
			}
			else if ( (LA119_0==ASTERISK) ) {
				alt119=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 119, 0, input);
				throw nvae;
			}

			switch (alt119) {
				case 1 :
					// PhoenixSQL.g:809:9: n= selectable ( COMMA n= selectable )*
					{
					pushFollow(FOLLOW_selectable_in_select_list5253);
					n=selectable();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(n);}
					// PhoenixSQL.g:809:36: ( COMMA n= selectable )*
					loop118:
					while (true) {
						int alt118=2;
						int LA118_0 = input.LA(1);
						if ( (LA118_0==COMMA) ) {
							alt118=1;
						}

						switch (alt118) {
						case 1 :
							// PhoenixSQL.g:809:37: COMMA n= selectable
							{
							match(input,COMMA,FOLLOW_COMMA_in_select_list5258); if (state.failed) return ret;
							pushFollow(FOLLOW_selectable_in_select_list5262);
							n=selectable();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret.add(n);}
							}
							break;

						default :
							break loop118;
						}
					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:810:7: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_select_list5274); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = Collections.<AliasedNode>singletonList(factory.aliasedNode(null, factory.wildcard()));}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "select_list"



	// $ANTLR start "selectable"
	// PhoenixSQL.g:814:1: selectable returns [AliasedNode ret] : (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK );
	public final AliasedNode selectable() throws RecognitionException {
		AliasedNode ret = null;


		ParseNode field =null;
		String a =null;
		String familyName =null;
		String s =null;
		String t =null;

		try {
			// PhoenixSQL.g:815:5: (field= expression (a= parseAlias )? |familyName= identifier DOT ASTERISK |s= identifier DOT t= identifier DOT ASTERISK )
			int alt121=3;
			int LA121_0 = input.LA(1);
			if ( (LA121_0==ARRAY||LA121_0==BIND_NAME||(LA121_0 >= CASE && LA121_0 <= CAST)||LA121_0==CURRENT||LA121_0==DECIMAL||LA121_0==DOUBLE||LA121_0==EXISTS||LA121_0==FALSE||LA121_0==LPAREN||LA121_0==MINUS||LA121_0==NEXT||(LA121_0 >= NOT && LA121_0 <= NULL)||LA121_0==NUMBER||LA121_0==QUESTION||LA121_0==STRING_LITERAL||LA121_0==TRUE) ) {
				alt121=1;
			}
			else if ( (LA121_0==NAME) ) {
				int LA121_2 = input.LA(2);
				if ( (LA121_2==EOF||LA121_2==AND||LA121_2==AS||LA121_2==ASTERISK||LA121_2==BETWEEN||LA121_2==COMMA||LA121_2==CONCAT||LA121_2==DIVIDE||LA121_2==EQ||LA121_2==FETCH||LA121_2==FROM||(LA121_2 >= GROUP && LA121_2 <= HAVING)||LA121_2==ILIKE||LA121_2==IN||LA121_2==IS||(LA121_2 >= LIKE && LA121_2 <= LIMIT)||(LA121_2 >= LPAREN && LA121_2 <= LT)||LA121_2==MINUS||LA121_2==NAME||(LA121_2 >= NOEQ1 && LA121_2 <= NOT)||LA121_2==OFFSET||(LA121_2 >= OR && LA121_2 <= ORDER)||(LA121_2 >= PERCENT && LA121_2 <= PLUS)||LA121_2==RPAREN||LA121_2==SEMICOLON||LA121_2==STRING_LITERAL||LA121_2==UNION||LA121_2==WHERE) ) {
					alt121=1;
				}
				else if ( (LA121_2==DOT) ) {
					int LA121_3 = input.LA(3);
					if ( (LA121_3==ASTERISK) ) {
						alt121=2;
					}
					else if ( (LA121_3==NAME) ) {
						int LA121_5 = input.LA(4);
						if ( (LA121_5==EOF||LA121_5==AND||LA121_5==AS||LA121_5==ASTERISK||LA121_5==BETWEEN||LA121_5==COMMA||LA121_5==CONCAT||LA121_5==DIVIDE||LA121_5==EQ||LA121_5==FETCH||LA121_5==FROM||(LA121_5 >= GROUP && LA121_5 <= HAVING)||LA121_5==ILIKE||LA121_5==IN||LA121_5==IS||(LA121_5 >= LIKE && LA121_5 <= LIMIT)||(LA121_5 >= LSQUARE && LA121_5 <= LT)||LA121_5==MINUS||LA121_5==NAME||(LA121_5 >= NOEQ1 && LA121_5 <= NOT)||LA121_5==OFFSET||(LA121_5 >= OR && LA121_5 <= ORDER)||(LA121_5 >= PERCENT && LA121_5 <= PLUS)||LA121_5==RPAREN||LA121_5==SEMICOLON||LA121_5==UNION||LA121_5==WHERE) ) {
							alt121=1;
						}
						else if ( (LA121_5==DOT) ) {
							int LA121_6 = input.LA(5);
							if ( (LA121_6==ASTERISK) ) {
								alt121=3;
							}
							else if ( (LA121_6==NAME) ) {
								alt121=1;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 121, 6, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 121, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 121, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 121, 0, input);
				throw nvae;
			}

			switch (alt121) {
				case 1 :
					// PhoenixSQL.g:815:9: field= expression (a= parseAlias )?
					{
					pushFollow(FOLLOW_expression_in_selectable5303);
					field=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:815:26: (a= parseAlias )?
					int alt120=2;
					int LA120_0 = input.LA(1);
					if ( (LA120_0==AS||LA120_0==NAME) ) {
						alt120=1;
					}
					switch (alt120) {
						case 1 :
							// PhoenixSQL.g:815:27: a= parseAlias
							{
							pushFollow(FOLLOW_parseAlias_in_selectable5308);
							a=parseAlias();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.aliasedNode(a, field); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:816:8: familyName= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable5323);
					familyName=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5325); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable5327); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.family(familyName));}
					}
					break;
				case 3 :
					// PhoenixSQL.g:817:9: s= identifier DOT t= identifier DOT ASTERISK
					{
					pushFollow(FOLLOW_identifier_in_selectable5342);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5344); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_selectable5348);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_selectable5350); if (state.failed) return ret;
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectable5352); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.aliasedNode(null, factory.tableWildcard(factory.table(s, t))); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "selectable"



	// $ANTLR start "group_by"
	// PhoenixSQL.g:822:1: group_by returns [List<ParseNode> ret] : expr= expression ( COMMA expr= expression )* ;
	public final List<ParseNode> group_by() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode expr =null;

		ret = new ArrayList<ParseNode>();
		try {
			// PhoenixSQL.g:824:5: (expr= expression ( COMMA expr= expression )* )
			// PhoenixSQL.g:824:9: expr= expression ( COMMA expr= expression )*
			{
			pushFollow(FOLLOW_expression_in_group_by5385);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(expr); }
			// PhoenixSQL.g:825:9: ( COMMA expr= expression )*
			loop122:
			while (true) {
				int alt122=2;
				int LA122_0 = input.LA(1);
				if ( (LA122_0==COMMA) ) {
					alt122=1;
				}

				switch (alt122) {
				case 1 :
					// PhoenixSQL.g:825:10: COMMA expr= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_group_by5398); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_group_by5404);
					expr=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(expr); }
					}
					break;

				default :
					break loop122;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "group_by"



	// $ANTLR start "order_by"
	// PhoenixSQL.g:829:1: order_by returns [List<OrderByNode> ret] : field= parseOrderByField ( COMMA field= parseOrderByField )* ;
	public final List<OrderByNode> order_by() throws RecognitionException {
		List<OrderByNode> ret = null;


		OrderByNode field =null;

		ret = new ArrayList<OrderByNode>();
		try {
			// PhoenixSQL.g:831:5: (field= parseOrderByField ( COMMA field= parseOrderByField )* )
			// PhoenixSQL.g:831:9: field= parseOrderByField ( COMMA field= parseOrderByField )*
			{
			pushFollow(FOLLOW_parseOrderByField_in_order_by5438);
			field=parseOrderByField();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret.add(field); }
			// PhoenixSQL.g:832:9: ( COMMA field= parseOrderByField )*
			loop123:
			while (true) {
				int alt123=2;
				int LA123_0 = input.LA(1);
				if ( (LA123_0==COMMA) ) {
					alt123=1;
				}

				switch (alt123) {
				case 1 :
					// PhoenixSQL.g:832:10: COMMA field= parseOrderByField
					{
					match(input,COMMA,FOLLOW_COMMA_in_order_by5451); if (state.failed) return ret;
					pushFollow(FOLLOW_parseOrderByField_in_order_by5457);
					field=parseOrderByField();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(field); }
					}
					break;

				default :
					break loop123;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "order_by"



	// $ANTLR start "parseOrderByField"
	// PhoenixSQL.g:836:1: parseOrderByField returns [OrderByNode ret] : (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? ;
	public final OrderByNode parseOrderByField() throws RecognitionException {
		OrderByNode ret = null;


		ParseNode expr =null;

		boolean isAscending = true; boolean nullsLast = false;
		try {
			// PhoenixSQL.g:838:5: ( (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )? )
			// PhoenixSQL.g:838:9: (expr= expression ) ( ASC | DESC )? ( NULLS ( FIRST | LAST ) )?
			{
			// PhoenixSQL.g:838:9: (expr= expression )
			// PhoenixSQL.g:838:10: expr= expression
			{
			pushFollow(FOLLOW_expression_in_parseOrderByField5494);
			expr=expression();
			state._fsp--;
			if (state.failed) return ret;
			}

			// PhoenixSQL.g:839:9: ( ASC | DESC )?
			int alt124=3;
			int LA124_0 = input.LA(1);
			if ( (LA124_0==ASC) ) {
				alt124=1;
			}
			else if ( (LA124_0==DESC) ) {
				alt124=2;
			}
			switch (alt124) {
				case 1 :
					// PhoenixSQL.g:839:10: ASC
					{
					match(input,ASC,FOLLOW_ASC_in_parseOrderByField5506); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = true;}
					}
					break;
				case 2 :
					// PhoenixSQL.g:839:38: DESC
					{
					match(input,DESC,FOLLOW_DESC_in_parseOrderByField5512); if (state.failed) return ret;
					if ( state.backtracking==0 ) {isAscending = false;}
					}
					break;

			}

			// PhoenixSQL.g:840:9: ( NULLS ( FIRST | LAST ) )?
			int alt126=2;
			int LA126_0 = input.LA(1);
			if ( (LA126_0==NULLS) ) {
				alt126=1;
			}
			switch (alt126) {
				case 1 :
					// PhoenixSQL.g:840:10: NULLS ( FIRST | LAST )
					{
					match(input,NULLS,FOLLOW_NULLS_in_parseOrderByField5527); if (state.failed) return ret;
					// PhoenixSQL.g:840:16: ( FIRST | LAST )
					int alt125=2;
					int LA125_0 = input.LA(1);
					if ( (LA125_0==FIRST) ) {
						alt125=1;
					}
					else if ( (LA125_0==LAST) ) {
						alt125=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 125, 0, input);
						throw nvae;
					}

					switch (alt125) {
						case 1 :
							// PhoenixSQL.g:840:17: FIRST
							{
							match(input,FIRST,FOLLOW_FIRST_in_parseOrderByField5530); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = false;}
							}
							break;
						case 2 :
							// PhoenixSQL.g:840:46: LAST
							{
							match(input,LAST,FOLLOW_LAST_in_parseOrderByField5536); if (state.failed) return ret;
							if ( state.backtracking==0 ) {nullsLast = true;}
							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) { ret = factory.orderBy(expr, nullsLast, isAscending); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseOrderByField"



	// $ANTLR start "parseFrom"
	// PhoenixSQL.g:844:1: parseFrom returns [TableNode ret] : t= table_list ;
	public final TableNode parseFrom() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;

		try {
			// PhoenixSQL.g:845:5: (t= table_list )
			// PhoenixSQL.g:845:9: t= table_list
			{
			pushFollow(FOLLOW_table_list_in_parseFrom5576);
			t=table_list();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseFrom"



	// $ANTLR start "table_list"
	// PhoenixSQL.g:848:1: table_list returns [TableNode ret] : t= table_ref ( COMMA s= table_ref )* ;
	public final TableNode table_list() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		TableNode s =null;

		try {
			// PhoenixSQL.g:849:5: (t= table_ref ( COMMA s= table_ref )* )
			// PhoenixSQL.g:849:9: t= table_ref ( COMMA s= table_ref )*
			{
			pushFollow(FOLLOW_table_ref_in_table_list5607);
			t=table_ref();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = t;}
			// PhoenixSQL.g:849:33: ( COMMA s= table_ref )*
			loop127:
			while (true) {
				int alt127=2;
				int LA127_0 = input.LA(1);
				if ( (LA127_0==COMMA) ) {
					alt127=1;
				}

				switch (alt127) {
				case 1 :
					// PhoenixSQL.g:849:34: COMMA s= table_ref
					{
					match(input,COMMA,FOLLOW_COMMA_in_table_list5612); if (state.failed) return ret;
					pushFollow(FOLLOW_table_ref_in_table_list5616);
					s=table_ref();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(JoinTableNode.JoinType.Inner, ret, s, null, false); }
					}
					break;

				default :
					break loop127;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_list"



	// $ANTLR start "table_ref"
	// PhoenixSQL.g:852:1: table_ref returns [TableNode ret] : l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* ;
	public final TableNode table_ref() throws RecognitionException {
		TableNode ret = null;


		TableNode l =null;
		JoinTableNode.JoinType j =null;
		TableNode r =null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:853:2: (l= table_factor (j= join_type JOIN r= table_factor ON e= expression )* )
			// PhoenixSQL.g:853:4: l= table_factor (j= join_type JOIN r= table_factor ON e= expression )*
			{
			pushFollow(FOLLOW_table_factor_in_table_ref5640);
			l=table_factor();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = l; }
			// PhoenixSQL.g:853:33: (j= join_type JOIN r= table_factor ON e= expression )*
			loop128:
			while (true) {
				int alt128=2;
				int LA128_0 = input.LA(1);
				if ( (LA128_0==FULL||LA128_0==INNER||LA128_0==JOIN||LA128_0==LEFT||LA128_0==RIGHT) ) {
					alt128=1;
				}

				switch (alt128) {
				case 1 :
					// PhoenixSQL.g:853:34: j= join_type JOIN r= table_factor ON e= expression
					{
					pushFollow(FOLLOW_join_type_in_table_ref5647);
					j=join_type();
					state._fsp--;
					if (state.failed) return ret;
					match(input,JOIN,FOLLOW_JOIN_in_table_ref5649); if (state.failed) return ret;
					pushFollow(FOLLOW_table_factor_in_table_ref5653);
					r=table_factor();
					state._fsp--;
					if (state.failed) return ret;
					match(input,ON,FOLLOW_ON_in_table_ref5655); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_table_ref5659);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.join(j, ret, r, e, false); }
					}
					break;

				default :
					break loop128;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_ref"



	// $ANTLR start "table_factor"
	// PhoenixSQL.g:856:1: table_factor returns [TableNode ret] : ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? );
	public final TableNode table_factor() throws RecognitionException {
		TableNode ret = null;


		TableNode t =null;
		String n =null;
		String alias =null;
		TableName f =null;
		List<ColumnDef> cdefs =null;
		LiteralParseNode tableSample =null;
		SelectStatement s =null;

		try {
			// PhoenixSQL.g:857:5: ( LPAREN t= table_list RPAREN |n= bind_name ( ( AS )? alias= identifier )? |f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )? | LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )? )
			int alt137=4;
			switch ( input.LA(1) ) {
			case LPAREN:
				{
				int LA137_1 = input.LA(2);
				if ( (LA137_1==BIND_NAME||LA137_1==LPAREN||LA137_1==NAME||LA137_1==QUESTION) ) {
					alt137=1;
				}
				else if ( (LA137_1==SELECT) ) {
					alt137=4;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 137, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case BIND_NAME:
			case QUESTION:
				{
				alt137=2;
				}
				break;
			case NAME:
				{
				alt137=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 137, 0, input);
				throw nvae;
			}
			switch (alt137) {
				case 1 :
					// PhoenixSQL.g:857:9: LPAREN t= table_list RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor5683); if (state.failed) return ret;
					pushFollow(FOLLOW_table_list_in_table_factor5687);
					t=table_list();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor5689); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = t; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:858:9: n= bind_name ( ( AS )? alias= identifier )?
					{
					pushFollow(FOLLOW_bind_name_in_table_factor5703);
					n=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:858:21: ( ( AS )? alias= identifier )?
					int alt130=2;
					int LA130_0 = input.LA(1);
					if ( (LA130_0==AS||LA130_0==NAME) ) {
						alt130=1;
					}
					switch (alt130) {
						case 1 :
							// PhoenixSQL.g:858:22: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:858:22: ( AS )?
							int alt129=2;
							int LA129_0 = input.LA(1);
							if ( (LA129_0==AS) ) {
								alt129=1;
							}
							switch (alt129) {
								case 1 :
									// PhoenixSQL.g:858:23: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor5707); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor5713);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.bindTable(alias, factory.table(null,n)); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:859:9: f= from_table_name ( ( AS )? alias= identifier )? ( LPAREN cdefs= dyn_column_defs RPAREN )? ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					{
					pushFollow(FOLLOW_from_table_name_in_table_factor5730);
					f=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:859:27: ( ( AS )? alias= identifier )?
					int alt132=2;
					int LA132_0 = input.LA(1);
					if ( (LA132_0==AS||LA132_0==NAME) ) {
						alt132=1;
					}
					switch (alt132) {
						case 1 :
							// PhoenixSQL.g:859:28: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:859:28: ( AS )?
							int alt131=2;
							int LA131_0 = input.LA(1);
							if ( (LA131_0==AS) ) {
								alt131=1;
							}
							switch (alt131) {
								case 1 :
									// PhoenixSQL.g:859:29: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor5734); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor5740);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:859:53: ( LPAREN cdefs= dyn_column_defs RPAREN )?
					int alt133=2;
					int LA133_0 = input.LA(1);
					if ( (LA133_0==LPAREN) ) {
						alt133=1;
					}
					switch (alt133) {
						case 1 :
							// PhoenixSQL.g:859:54: LPAREN cdefs= dyn_column_defs RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor5745); if (state.failed) return ret;
							pushFollow(FOLLOW_dyn_column_defs_in_table_factor5749);
							cdefs=dyn_column_defs();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor5751); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:859:92: ( TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN )?
					int alt134=2;
					int LA134_0 = input.LA(1);
					if ( (LA134_0==TABLESAMPLE) ) {
						alt134=1;
					}
					switch (alt134) {
						case 1 :
							// PhoenixSQL.g:859:93: TABLESAMPLE LPAREN tableSample= tableSampleNode RPAREN
							{
							match(input,TABLESAMPLE,FOLLOW_TABLESAMPLE_in_table_factor5756); if (state.failed) return ret;
							match(input,LPAREN,FOLLOW_LPAREN_in_table_factor5758); if (state.failed) return ret;
							pushFollow(FOLLOW_tableSampleNode_in_table_factor5762);
							tableSample=tableSampleNode();
							state._fsp--;
							if (state.failed) return ret;
							match(input,RPAREN,FOLLOW_RPAREN_in_table_factor5764); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.namedTable(alias,f,cdefs, tableSample);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:860:9: LPAREN s= select_node RPAREN ( ( AS )? alias= identifier )?
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_table_factor5778); if (state.failed) return ret;
					pushFollow(FOLLOW_select_node_in_table_factor5782);
					s=select_node();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_table_factor5784); if (state.failed) return ret;
					// PhoenixSQL.g:860:37: ( ( AS )? alias= identifier )?
					int alt136=2;
					int LA136_0 = input.LA(1);
					if ( (LA136_0==AS||LA136_0==NAME) ) {
						alt136=1;
					}
					switch (alt136) {
						case 1 :
							// PhoenixSQL.g:860:38: ( AS )? alias= identifier
							{
							// PhoenixSQL.g:860:38: ( AS )?
							int alt135=2;
							int LA135_0 = input.LA(1);
							if ( (LA135_0==AS) ) {
								alt135=1;
							}
							switch (alt135) {
								case 1 :
									// PhoenixSQL.g:860:39: AS
									{
									match(input,AS,FOLLOW_AS_in_table_factor5788); if (state.failed) return ret;
									}
									break;

							}

							pushFollow(FOLLOW_identifier_in_table_factor5794);
							alias=identifier();
							state._fsp--;
							if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = factory.derivedTable(alias, s); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_factor"



	// $ANTLR start "join_type"
	// PhoenixSQL.g:863:1: join_type returns [JoinTableNode.JoinType ret] : ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? );
	public final JoinTableNode.JoinType join_type() throws RecognitionException {
		JoinTableNode.JoinType ret = null;


		try {
			// PhoenixSQL.g:864:5: ( ( INNER )? | LEFT ( OUTER )? | RIGHT ( OUTER )? | FULL ( OUTER )? )
			int alt142=4;
			switch ( input.LA(1) ) {
			case INNER:
			case JOIN:
				{
				alt142=1;
				}
				break;
			case LEFT:
				{
				alt142=2;
				}
				break;
			case RIGHT:
				{
				alt142=3;
				}
				break;
			case FULL:
				{
				alt142=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 142, 0, input);
				throw nvae;
			}
			switch (alt142) {
				case 1 :
					// PhoenixSQL.g:864:9: ( INNER )?
					{
					// PhoenixSQL.g:864:9: ( INNER )?
					int alt138=2;
					int LA138_0 = input.LA(1);
					if ( (LA138_0==INNER) ) {
						alt138=1;
					}
					switch (alt138) {
						case 1 :
							// PhoenixSQL.g:864:9: INNER
							{
							match(input,INNER,FOLLOW_INNER_in_join_type5821); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Inner; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:865:9: LEFT ( OUTER )?
					{
					match(input,LEFT,FOLLOW_LEFT_in_join_type5836); if (state.failed) return ret;
					// PhoenixSQL.g:865:14: ( OUTER )?
					int alt139=2;
					int LA139_0 = input.LA(1);
					if ( (LA139_0==OUTER) ) {
						alt139=1;
					}
					switch (alt139) {
						case 1 :
							// PhoenixSQL.g:865:14: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type5838); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Left; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:866:9: RIGHT ( OUTER )?
					{
					match(input,RIGHT,FOLLOW_RIGHT_in_join_type5853); if (state.failed) return ret;
					// PhoenixSQL.g:866:15: ( OUTER )?
					int alt140=2;
					int LA140_0 = input.LA(1);
					if ( (LA140_0==OUTER) ) {
						alt140=1;
					}
					switch (alt140) {
						case 1 :
							// PhoenixSQL.g:866:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type5855); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Right; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:867:9: FULL ( OUTER )?
					{
					match(input,FULL,FOLLOW_FULL_in_join_type5869); if (state.failed) return ret;
					// PhoenixSQL.g:867:15: ( OUTER )?
					int alt141=2;
					int LA141_0 = input.LA(1);
					if ( (LA141_0==OUTER) ) {
						alt141=1;
					}
					switch (alt141) {
						case 1 :
							// PhoenixSQL.g:867:15: OUTER
							{
							match(input,OUTER,FOLLOW_OUTER_in_join_type5872); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) { ret = JoinTableNode.JoinType.Full; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "join_type"



	// $ANTLR start "parseAlias"
	// PhoenixSQL.g:870:1: parseAlias returns [String ret] : ( AS )? alias= parseNoReserved ;
	public final String parseAlias() throws RecognitionException {
		String ret = null;


		String alias =null;

		try {
			// PhoenixSQL.g:871:5: ( ( AS )? alias= parseNoReserved )
			// PhoenixSQL.g:871:9: ( AS )? alias= parseNoReserved
			{
			// PhoenixSQL.g:871:9: ( AS )?
			int alt143=2;
			int LA143_0 = input.LA(1);
			if ( (LA143_0==AS) ) {
				alt143=1;
			}
			switch (alt143) {
				case 1 :
					// PhoenixSQL.g:871:9: AS
					{
					match(input,AS,FOLLOW_AS_in_parseAlias5903); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_parseNoReserved_in_parseAlias5908);
			alias=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = alias; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseAlias"



	// $ANTLR start "expression"
	// PhoenixSQL.g:875:1: expression returns [ParseNode ret] : e= or_expression ;
	public final ParseNode expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;

		try {
			// PhoenixSQL.g:876:5: (e= or_expression )
			// PhoenixSQL.g:876:9: e= or_expression
			{
			pushFollow(FOLLOW_or_expression_in_expression5936);
			e=or_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = e; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "expression"



	// $ANTLR start "or_expression"
	// PhoenixSQL.g:880:1: or_expression returns [ParseNode ret] : i= and_expression ( OR i= and_expression )* ;
	public final ParseNode or_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:882:5: (i= and_expression ( OR i= and_expression )* )
			// PhoenixSQL.g:882:9: i= and_expression ( OR i= and_expression )*
			{
			pushFollow(FOLLOW_and_expression_in_or_expression5968);
			i=and_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:882:38: ( OR i= and_expression )*
			loop144:
			while (true) {
				int alt144=2;
				int LA144_0 = input.LA(1);
				if ( (LA144_0==OR) ) {
					alt144=1;
				}

				switch (alt144) {
				case 1 :
					// PhoenixSQL.g:882:39: OR i= and_expression
					{
					match(input,OR,FOLLOW_OR_in_or_expression5973); if (state.failed) return ret;
					pushFollow(FOLLOW_and_expression_in_or_expression5977);
					i=and_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop144;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.or(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "or_expression"



	// $ANTLR start "and_expression"
	// PhoenixSQL.g:886:1: and_expression returns [ParseNode ret] : i= not_expression ( AND i= not_expression )* ;
	public final ParseNode and_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:888:5: (i= not_expression ( AND i= not_expression )* )
			// PhoenixSQL.g:888:9: i= not_expression ( AND i= not_expression )*
			{
			pushFollow(FOLLOW_not_expression_in_and_expression6013);
			i=not_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:888:38: ( AND i= not_expression )*
			loop145:
			while (true) {
				int alt145=2;
				int LA145_0 = input.LA(1);
				if ( (LA145_0==AND) ) {
					alt145=1;
				}

				switch (alt145) {
				case 1 :
					// PhoenixSQL.g:888:39: AND i= not_expression
					{
					match(input,AND,FOLLOW_AND_in_and_expression6018); if (state.failed) return ret;
					pushFollow(FOLLOW_not_expression_in_and_expression6022);
					i=not_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop145;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.and(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "and_expression"



	// $ANTLR start "not_expression"
	// PhoenixSQL.g:892:1: not_expression returns [ParseNode ret] : ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN );
	public final ParseNode not_expression() throws RecognitionException {
		ParseNode ret = null;


		Token n=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:893:5: ( ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression | (n= NOT )? LPAREN e= expression RPAREN )
			int alt148=2;
			int LA148_0 = input.LA(1);
			if ( (LA148_0==NOT) ) {
				int LA148_1 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt148=1;
				}
				else if ( (true) ) {
					alt148=2;
				}

			}
			else if ( (LA148_0==MINUS) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==STRING_LITERAL) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==NUMBER) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==DECIMAL) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==DOUBLE) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==NULL) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==TRUE) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==FALSE) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==NAME) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==BIND_NAME) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==QUESTION) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==ARRAY) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==CASE) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==LPAREN) ) {
				int LA148_15 = input.LA(2);
				if ( (synpred1_PhoenixSQL()) ) {
					alt148=1;
				}
				else if ( (true) ) {
					alt148=2;
				}

			}
			else if ( (LA148_0==CAST) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==NEXT) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==CURRENT) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}
			else if ( (LA148_0==EXISTS) && (synpred1_PhoenixSQL())) {
				alt148=1;
			}

			switch (alt148) {
				case 1 :
					// PhoenixSQL.g:893:9: ( ( NOT )? boolean_expression )=> (n= NOT )? e= boolean_expression
					{
					// PhoenixSQL.g:893:40: (n= NOT )?
					int alt146=2;
					int LA146_0 = input.LA(1);
					if ( (LA146_0==NOT) ) {
						alt146=1;
					}
					switch (alt146) {
						case 1 :
							// PhoenixSQL.g:893:40: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6064); if (state.failed) return ret;
							}
							break;

					}

					pushFollow(FOLLOW_boolean_expression_in_not_expression6069);
					e=boolean_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:894:9: (n= NOT )? LPAREN e= expression RPAREN
					{
					// PhoenixSQL.g:894:10: (n= NOT )?
					int alt147=2;
					int LA147_0 = input.LA(1);
					if ( (LA147_0==NOT) ) {
						alt147=1;
					}
					switch (alt147) {
						case 1 :
							// PhoenixSQL.g:894:10: n= NOT
							{
							n=(Token)match(input,NOT,FOLLOW_NOT_in_not_expression6083); if (state.failed) return ret;
							}
							break;

					}

					match(input,LPAREN,FOLLOW_LPAREN_in_not_expression6086); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_not_expression6090);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_not_expression6092); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = n == null ? e : factory.not(e); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "not_expression"



	// $ANTLR start "comparison_op"
	// PhoenixSQL.g:897:1: comparison_op returns [CompareOp ret] : ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) );
	public final CompareOp comparison_op() throws RecognitionException {
		CompareOp ret = null;


		try {
			// PhoenixSQL.g:898:2: ( EQ | LT | GT | LT EQ | GT EQ | ( NOEQ1 | NOEQ2 ) )
			int alt149=6;
			switch ( input.LA(1) ) {
			case EQ:
				{
				alt149=1;
				}
				break;
			case LT:
				{
				int LA149_2 = input.LA(2);
				if ( (LA149_2==EQ) ) {
					alt149=4;
				}
				else if ( (LA149_2==ALL||(LA149_2 >= ANY && LA149_2 <= ARRAY)||LA149_2==BIND_NAME||(LA149_2 >= CASE && LA149_2 <= CAST)||LA149_2==CURRENT||LA149_2==DECIMAL||LA149_2==DOUBLE||LA149_2==FALSE||LA149_2==LPAREN||LA149_2==MINUS||(LA149_2 >= NAME && LA149_2 <= NEXT)||LA149_2==NULL||LA149_2==NUMBER||LA149_2==QUESTION||LA149_2==STRING_LITERAL||LA149_2==TRUE) ) {
					alt149=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 149, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case GT:
				{
				int LA149_3 = input.LA(2);
				if ( (LA149_3==EQ) ) {
					alt149=5;
				}
				else if ( (LA149_3==ALL||(LA149_3 >= ANY && LA149_3 <= ARRAY)||LA149_3==BIND_NAME||(LA149_3 >= CASE && LA149_3 <= CAST)||LA149_3==CURRENT||LA149_3==DECIMAL||LA149_3==DOUBLE||LA149_3==FALSE||LA149_3==LPAREN||LA149_3==MINUS||(LA149_3 >= NAME && LA149_3 <= NEXT)||LA149_3==NULL||LA149_3==NUMBER||LA149_3==QUESTION||LA149_3==STRING_LITERAL||LA149_3==TRUE) ) {
					alt149=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 149, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case NOEQ1:
			case NOEQ2:
				{
				alt149=6;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 149, 0, input);
				throw nvae;
			}
			switch (alt149) {
				case 1 :
					// PhoenixSQL.g:898:4: EQ
					{
					match(input,EQ,FOLLOW_EQ_in_comparison_op6112); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.EQUAL; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:899:4: LT
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6119); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.LESS; }
					}
					break;
				case 3 :
					// PhoenixSQL.g:900:4: GT
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6126); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.GREATER; }
					}
					break;
				case 4 :
					// PhoenixSQL.g:901:4: LT EQ
					{
					match(input,LT,FOLLOW_LT_in_comparison_op6133); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6135); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.LESS_OR_EQUAL; }
					}
					break;
				case 5 :
					// PhoenixSQL.g:902:4: GT EQ
					{
					match(input,GT,FOLLOW_GT_in_comparison_op6142); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_comparison_op6144); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = CompareOp.GREATER_OR_EQUAL; }
					}
					break;
				case 6 :
					// PhoenixSQL.g:903:4: ( NOEQ1 | NOEQ2 )
					{
					if ( (input.LA(1) >= NOEQ1 && input.LA(1) <= NOEQ2) ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					if ( state.backtracking==0 ) { ret = CompareOp.NOT_EQUAL; }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "comparison_op"



	// $ANTLR start "boolean_expression"
	// PhoenixSQL.g:906:1: boolean_expression returns [ParseNode ret] : (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN );
	public final ParseNode boolean_expression() throws RecognitionException {
		ParseNode ret = null;


		Token all=null;
		Token any=null;
		Token n=null;
		ParseNode l =null;
		CompareOp op =null;
		ParseNode r =null;
		ParseNode r1 =null;
		ParseNode r2 =null;
		List<ParseNode> v =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:907:5: (l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |) | EXISTS LPAREN s= subquery_expression RPAREN )
			int alt158=2;
			int LA158_0 = input.LA(1);
			if ( (LA158_0==ARRAY||LA158_0==BIND_NAME||(LA158_0 >= CASE && LA158_0 <= CAST)||LA158_0==CURRENT||LA158_0==DECIMAL||LA158_0==DOUBLE||LA158_0==FALSE||LA158_0==LPAREN||LA158_0==MINUS||(LA158_0 >= NAME && LA158_0 <= NEXT)||LA158_0==NULL||LA158_0==NUMBER||LA158_0==QUESTION||LA158_0==STRING_LITERAL||LA158_0==TRUE) ) {
				alt158=1;
			}
			else if ( (LA158_0==EXISTS) ) {
				alt158=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 158, 0, input);
				throw nvae;
			}

			switch (alt158) {
				case 1 :
					// PhoenixSQL.g:907:9: l= value_expression ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					{
					pushFollow(FOLLOW_value_expression_in_boolean_expression6182);
					l=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:907:28: ( (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) ) | ( IS (n= NOT )? NULL ) | ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) ) |)
					int alt157=4;
					switch ( input.LA(1) ) {
					case EQ:
					case GT:
					case LT:
					case NOEQ1:
					case NOEQ2:
						{
						alt157=1;
						}
						break;
					case IS:
						{
						alt157=2;
						}
						break;
					case BETWEEN:
					case ILIKE:
					case IN:
					case LIKE:
					case NOT:
						{
						alt157=3;
						}
						break;
					case EOF:
					case AND:
					case AS:
					case ASC:
					case COMMA:
					case CONSTRAINT:
					case DESC:
					case ELSE:
					case END:
					case FETCH:
					case FROM:
					case FULL:
					case GROUP:
					case HAVING:
					case INNER:
					case JOIN:
					case LEFT:
					case LIMIT:
					case MAXVALUE:
					case MINVALUE:
					case NAME:
					case NULLS:
					case OFFSET:
					case OR:
					case ORDER:
					case PRIMARY:
					case RIGHT:
					case RPAREN:
					case RSQUARE:
					case SEMICOLON:
					case THEN:
					case UNION:
					case WHEN:
					case WHERE:
						{
						alt157=4;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 157, 0, input);
						throw nvae;
					}
					switch (alt157) {
						case 1 :
							// PhoenixSQL.g:907:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							{
							// PhoenixSQL.g:907:29: (op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) ) )
							// PhoenixSQL.g:907:30: op= comparison_op (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							{
							pushFollow(FOLLOW_comparison_op_in_boolean_expression6188);
							op=comparison_op();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:907:47: (r= value_expression | ( LPAREN r= subquery_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN ) | ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN ) )
							int alt152=4;
							switch ( input.LA(1) ) {
							case ARRAY:
							case BIND_NAME:
							case CASE:
							case CAST:
							case CURRENT:
							case DECIMAL:
							case DOUBLE:
							case FALSE:
							case MINUS:
							case NAME:
							case NEXT:
							case NULL:
							case NUMBER:
							case QUESTION:
							case STRING_LITERAL:
							case TRUE:
								{
								alt152=1;
								}
								break;
							case LPAREN:
								{
								int LA152_2 = input.LA(2);
								if ( (LA152_2==ARRAY||LA152_2==BIND_NAME||(LA152_2 >= CASE && LA152_2 <= CAST)||LA152_2==CURRENT||LA152_2==DECIMAL||LA152_2==DOUBLE||LA152_2==EXISTS||LA152_2==FALSE||LA152_2==LPAREN||LA152_2==MINUS||(LA152_2 >= NAME && LA152_2 <= NEXT)||(LA152_2 >= NOT && LA152_2 <= NULL)||LA152_2==NUMBER||LA152_2==QUESTION||LA152_2==STRING_LITERAL||LA152_2==TRUE) ) {
									alt152=1;
								}
								else if ( (LA152_2==SELECT) ) {
									alt152=2;
								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 152, 2, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ALL:
								{
								int LA152_3 = input.LA(2);
								if ( (LA152_3==LPAREN) ) {
									int LA152_6 = input.LA(3);
									if ( (LA152_6==ARRAY||LA152_6==BIND_NAME||(LA152_6 >= CASE && LA152_6 <= CAST)||LA152_6==CURRENT||LA152_6==DECIMAL||LA152_6==DOUBLE||LA152_6==FALSE||LA152_6==LPAREN||LA152_6==MINUS||(LA152_6 >= NAME && LA152_6 <= NEXT)||LA152_6==NULL||LA152_6==NUMBER||LA152_6==QUESTION||LA152_6==STRING_LITERAL||LA152_6==TRUE) ) {
										alt152=3;
									}
									else if ( (LA152_6==SELECT) ) {
										alt152=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 152, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 152, 3, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case ANY:
								{
								int LA152_4 = input.LA(2);
								if ( (LA152_4==LPAREN) ) {
									int LA152_6 = input.LA(3);
									if ( (LA152_6==ARRAY||LA152_6==BIND_NAME||(LA152_6 >= CASE && LA152_6 <= CAST)||LA152_6==CURRENT||LA152_6==DECIMAL||LA152_6==DOUBLE||LA152_6==FALSE||LA152_6==LPAREN||LA152_6==MINUS||(LA152_6 >= NAME && LA152_6 <= NEXT)||LA152_6==NULL||LA152_6==NUMBER||LA152_6==QUESTION||LA152_6==STRING_LITERAL||LA152_6==TRUE) ) {
										alt152=3;
									}
									else if ( (LA152_6==SELECT) ) {
										alt152=4;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 152, 6, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									if (state.backtracking>0) {state.failed=true; return ret;}
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 152, 4, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 152, 0, input);
								throw nvae;
							}
							switch (alt152) {
								case 1 :
									// PhoenixSQL.g:907:48: r= value_expression
									{
									pushFollow(FOLLOW_value_expression_in_boolean_expression6193);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:907:69: ( LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:907:69: ( LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:907:70: LPAREN r= subquery_expression RPAREN
									{
									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6198); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6202);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6204); if (state.failed) return ret;
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:907:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									{
									// PhoenixSQL.g:907:109: ( (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN )
									// PhoenixSQL.g:907:110: (all= ALL |any= ANY ) LPAREN r= value_expression RPAREN
									{
									// PhoenixSQL.g:907:110: (all= ALL |any= ANY )
									int alt150=2;
									int LA150_0 = input.LA(1);
									if ( (LA150_0==ALL) ) {
										alt150=1;
									}
									else if ( (LA150_0==ANY) ) {
										alt150=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 150, 0, input);
										throw nvae;
									}

									switch (alt150) {
										case 1 :
											// PhoenixSQL.g:907:111: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6213); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:907:121: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6219); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6222); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6226);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6228); if (state.failed) return ret;
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:907:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									{
									// PhoenixSQL.g:907:167: ( (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN )
									// PhoenixSQL.g:907:168: (all= ALL |any= ANY ) LPAREN r= subquery_expression RPAREN
									{
									// PhoenixSQL.g:907:168: (all= ALL |any= ANY )
									int alt151=2;
									int LA151_0 = input.LA(1);
									if ( (LA151_0==ALL) ) {
										alt151=1;
									}
									else if ( (LA151_0==ANY) ) {
										alt151=2;
									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 151, 0, input);
										throw nvae;
									}

									switch (alt151) {
										case 1 :
											// PhoenixSQL.g:907:169: all= ALL
											{
											all=(Token)match(input,ALL,FOLLOW_ALL_in_boolean_expression6238); if (state.failed) return ret;
											}
											break;
										case 2 :
											// PhoenixSQL.g:907:179: any= ANY
											{
											any=(Token)match(input,ANY,FOLLOW_ANY_in_boolean_expression6244); if (state.failed) return ret;
											}
											break;

									}

									match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6247); if (state.failed) return ret;
									pushFollow(FOLLOW_subquery_expression_in_boolean_expression6251);
									r=subquery_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6253); if (state.failed) return ret;
									}

									}
									break;

							}

							if ( state.backtracking==0 ) {ret = all != null ? factory.wrapInAll(op, l, r) : any != null ? factory.wrapInAny(op, l, r) : factory.comparison(op,l,r); }
							}

							}
							break;
						case 2 :
							// PhoenixSQL.g:908:22: ( IS (n= NOT )? NULL )
							{
							// PhoenixSQL.g:908:22: ( IS (n= NOT )? NULL )
							// PhoenixSQL.g:908:23: IS (n= NOT )? NULL
							{
							match(input,IS,FOLLOW_IS_in_boolean_expression6283); if (state.failed) return ret;
							// PhoenixSQL.g:908:27: (n= NOT )?
							int alt153=2;
							int LA153_0 = input.LA(1);
							if ( (LA153_0==NOT) ) {
								alt153=1;
							}
							switch (alt153) {
								case 1 :
									// PhoenixSQL.g:908:27: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression6287); if (state.failed) return ret;
									}
									break;

							}

							match(input,NULL,FOLLOW_NULL_in_boolean_expression6290); if (state.failed) return ret;
							if ( state.backtracking==0 ) {ret = factory.isNull(l,n!=null); }
							}

							}
							break;
						case 3 :
							// PhoenixSQL.g:909:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							{
							// PhoenixSQL.g:909:22: ( (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) ) )
							// PhoenixSQL.g:909:24: (n= NOT )? ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							{
							// PhoenixSQL.g:909:25: (n= NOT )?
							int alt154=2;
							int LA154_0 = input.LA(1);
							if ( (LA154_0==NOT) ) {
								alt154=1;
							}
							switch (alt154) {
								case 1 :
									// PhoenixSQL.g:909:25: n= NOT
									{
									n=(Token)match(input,NOT,FOLLOW_NOT_in_boolean_expression6321); if (state.failed) return ret;
									}
									break;

							}

							// PhoenixSQL.g:909:31: ( ( LIKE r= value_expression ) | ( ILIKE r= value_expression ) | ( BETWEEN r1= value_expression AND r2= value_expression ) | ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) ) )
							int alt156=4;
							switch ( input.LA(1) ) {
							case LIKE:
								{
								alt156=1;
								}
								break;
							case ILIKE:
								{
								alt156=2;
								}
								break;
							case BETWEEN:
								{
								alt156=3;
								}
								break;
							case IN:
								{
								alt156=4;
								}
								break;
							default:
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 156, 0, input);
								throw nvae;
							}
							switch (alt156) {
								case 1 :
									// PhoenixSQL.g:909:32: ( LIKE r= value_expression )
									{
									// PhoenixSQL.g:909:32: ( LIKE r= value_expression )
									// PhoenixSQL.g:909:33: LIKE r= value_expression
									{
									match(input,LIKE,FOLLOW_LIKE_in_boolean_expression6326); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6330);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_SENSITIVE); }
									}

									}
									break;
								case 2 :
									// PhoenixSQL.g:910:32: ( ILIKE r= value_expression )
									{
									// PhoenixSQL.g:910:32: ( ILIKE r= value_expression )
									// PhoenixSQL.g:910:33: ILIKE r= value_expression
									{
									match(input,ILIKE,FOLLOW_ILIKE_in_boolean_expression6368); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6372);
									r=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.like(l,r,n!=null,LikeType.CASE_INSENSITIVE); }
									}

									}
									break;
								case 3 :
									// PhoenixSQL.g:911:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									{
									// PhoenixSQL.g:911:32: ( BETWEEN r1= value_expression AND r2= value_expression )
									// PhoenixSQL.g:911:33: BETWEEN r1= value_expression AND r2= value_expression
									{
									match(input,BETWEEN,FOLLOW_BETWEEN_in_boolean_expression6410); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6414);
									r1=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									match(input,AND,FOLLOW_AND_in_boolean_expression6416); if (state.failed) return ret;
									pushFollow(FOLLOW_value_expression_in_boolean_expression6420);
									r2=value_expression();
									state._fsp--;
									if (state.failed) return ret;
									if ( state.backtracking==0 ) {ret = factory.between(l,r1,r2,n!=null); }
									}

									}
									break;
								case 4 :
									// PhoenixSQL.g:912:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									{
									// PhoenixSQL.g:912:32: ( ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) ) )
									// PhoenixSQL.g:912:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									{
									// PhoenixSQL.g:912:33: ( IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) ) )
									// PhoenixSQL.g:912:34: IN ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									{
									match(input,IN,FOLLOW_IN_in_boolean_expression6459); if (state.failed) return ret;
									// PhoenixSQL.g:912:37: ( (r= bind_expression ) | ( LPAREN r= subquery_expression RPAREN ) | ( LPAREN v= one_or_more_expressions RPAREN ) )
									int alt155=3;
									int LA155_0 = input.LA(1);
									if ( (LA155_0==BIND_NAME||LA155_0==QUESTION) ) {
										alt155=1;
									}
									else if ( (LA155_0==LPAREN) ) {
										int LA155_2 = input.LA(2);
										if ( (LA155_2==SELECT) ) {
											alt155=2;
										}
										else if ( (LA155_2==ARRAY||LA155_2==BIND_NAME||(LA155_2 >= CASE && LA155_2 <= CAST)||LA155_2==CURRENT||LA155_2==DECIMAL||LA155_2==DOUBLE||LA155_2==EXISTS||LA155_2==FALSE||LA155_2==LPAREN||LA155_2==MINUS||(LA155_2 >= NAME && LA155_2 <= NEXT)||(LA155_2 >= NOT && LA155_2 <= NULL)||LA155_2==NUMBER||LA155_2==QUESTION||LA155_2==STRING_LITERAL||LA155_2==TRUE) ) {
											alt155=3;
										}

										else {
											if (state.backtracking>0) {state.failed=true; return ret;}
											int nvaeMark = input.mark();
											try {
												input.consume();
												NoViableAltException nvae =
													new NoViableAltException("", 155, 2, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										if (state.backtracking>0) {state.failed=true; return ret;}
										NoViableAltException nvae =
											new NoViableAltException("", 155, 0, input);
										throw nvae;
									}

									switch (alt155) {
										case 1 :
											// PhoenixSQL.g:912:38: (r= bind_expression )
											{
											// PhoenixSQL.g:912:38: (r= bind_expression )
											// PhoenixSQL.g:912:39: r= bind_expression
											{
											pushFollow(FOLLOW_bind_expression_in_boolean_expression6465);
											r=bind_expression();
											state._fsp--;
											if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.inList(Arrays.asList(l,r),n!=null);}
											}

											}
											break;
										case 2 :
											// PhoenixSQL.g:913:35: ( LPAREN r= subquery_expression RPAREN )
											{
											// PhoenixSQL.g:913:35: ( LPAREN r= subquery_expression RPAREN )
											// PhoenixSQL.g:913:36: LPAREN r= subquery_expression RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6506); if (state.failed) return ret;
											pushFollow(FOLLOW_subquery_expression_in_boolean_expression6510);
											r=subquery_expression();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6512); if (state.failed) return ret;
											if ( state.backtracking==0 ) {ret = factory.in(l,r,n!=null,false);}
											}

											}
											break;
										case 3 :
											// PhoenixSQL.g:914:35: ( LPAREN v= one_or_more_expressions RPAREN )
											{
											// PhoenixSQL.g:914:35: ( LPAREN v= one_or_more_expressions RPAREN )
											// PhoenixSQL.g:914:36: LPAREN v= one_or_more_expressions RPAREN
											{
											match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6553); if (state.failed) return ret;
											pushFollow(FOLLOW_one_or_more_expressions_in_boolean_expression6557);
											v=one_or_more_expressions();
											state._fsp--;
											if (state.failed) return ret;
											match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6559); if (state.failed) return ret;
											if ( state.backtracking==0 ) {List<ParseNode> il = new ArrayList<ParseNode>(v.size() + 1); il.add(l); il.addAll(v); ret = factory.inList(il,n!=null);}
											}

											}
											break;

									}

									}

									}

									}
									break;

							}

							}

							}
							break;
						case 4 :
							// PhoenixSQL.g:917:23: 
							{
							if ( state.backtracking==0 ) { ret = l; }
							}
							break;

					}

					}
					break;
				case 2 :
					// PhoenixSQL.g:918:9: EXISTS LPAREN s= subquery_expression RPAREN
					{
					match(input,EXISTS,FOLLOW_EXISTS_in_boolean_expression6659); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_boolean_expression6661); if (state.failed) return ret;
					pushFollow(FOLLOW_subquery_expression_in_boolean_expression6665);
					s=subquery_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_boolean_expression6667); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.exists(s,false);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "boolean_expression"



	// $ANTLR start "bind_expression"
	// PhoenixSQL.g:921:1: bind_expression returns [BindParseNode ret] : b= bind_name ;
	public final BindParseNode bind_expression() throws RecognitionException {
		BindParseNode ret = null;


		String b =null;

		try {
			// PhoenixSQL.g:922:5: (b= bind_name )
			// PhoenixSQL.g:922:9: b= bind_name
			{
			pushFollow(FOLLOW_bind_name_in_bind_expression6695);
			b=bind_name();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = factory.bind(b); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_expression"



	// $ANTLR start "value_expression"
	// PhoenixSQL.g:925:1: value_expression returns [ParseNode ret] : i= add_expression ;
	public final ParseNode value_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		try {
			// PhoenixSQL.g:926:5: (i= add_expression )
			// PhoenixSQL.g:926:9: i= add_expression
			{
			pushFollow(FOLLOW_add_expression_in_value_expression6726);
			i=add_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = i; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression"



	// $ANTLR start "add_expression"
	// PhoenixSQL.g:929:1: add_expression returns [ParseNode ret] : i= subtract_expression ( PLUS i= subtract_expression )* ;
	public final ParseNode add_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:931:5: (i= subtract_expression ( PLUS i= subtract_expression )* )
			// PhoenixSQL.g:931:9: i= subtract_expression ( PLUS i= subtract_expression )*
			{
			pushFollow(FOLLOW_subtract_expression_in_add_expression6757);
			i=subtract_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:931:43: ( PLUS i= subtract_expression )*
			loop159:
			while (true) {
				int alt159=2;
				int LA159_0 = input.LA(1);
				if ( (LA159_0==PLUS) ) {
					alt159=1;
				}

				switch (alt159) {
				case 1 :
					// PhoenixSQL.g:931:44: PLUS i= subtract_expression
					{
					match(input,PLUS,FOLLOW_PLUS_in_add_expression6762); if (state.failed) return ret;
					pushFollow(FOLLOW_subtract_expression_in_add_expression6766);
					i=subtract_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop159;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.add(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "add_expression"



	// $ANTLR start "subtract_expression"
	// PhoenixSQL.g:934:1: subtract_expression returns [ParseNode ret] : i= concat_expression ( MINUS i= concat_expression )* ;
	public final ParseNode subtract_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:936:5: (i= concat_expression ( MINUS i= concat_expression )* )
			// PhoenixSQL.g:936:9: i= concat_expression ( MINUS i= concat_expression )*
			{
			pushFollow(FOLLOW_concat_expression_in_subtract_expression6801);
			i=concat_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:936:41: ( MINUS i= concat_expression )*
			loop160:
			while (true) {
				int alt160=2;
				int LA160_0 = input.LA(1);
				if ( (LA160_0==MINUS) ) {
					alt160=1;
				}

				switch (alt160) {
				case 1 :
					// PhoenixSQL.g:936:42: MINUS i= concat_expression
					{
					match(input,MINUS,FOLLOW_MINUS_in_subtract_expression6806); if (state.failed) return ret;
					pushFollow(FOLLOW_concat_expression_in_subtract_expression6810);
					i=concat_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop160;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.subtract(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "subtract_expression"



	// $ANTLR start "concat_expression"
	// PhoenixSQL.g:939:1: concat_expression returns [ParseNode ret] : i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* ;
	public final ParseNode concat_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode i =null;

		List<ParseNode> l = new ArrayList<ParseNode>(4); 
		try {
			// PhoenixSQL.g:941:5: (i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )* )
			// PhoenixSQL.g:941:9: i= multiply_divide_modulo_expression ( CONCAT i= multiply_divide_modulo_expression )*
			{
			pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression6845);
			i=multiply_divide_modulo_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {l.add(i);}
			// PhoenixSQL.g:941:57: ( CONCAT i= multiply_divide_modulo_expression )*
			loop161:
			while (true) {
				int alt161=2;
				int LA161_0 = input.LA(1);
				if ( (LA161_0==CONCAT) ) {
					alt161=1;
				}

				switch (alt161) {
				case 1 :
					// PhoenixSQL.g:941:58: CONCAT i= multiply_divide_modulo_expression
					{
					match(input,CONCAT,FOLLOW_CONCAT_in_concat_expression6850); if (state.failed) return ret;
					pushFollow(FOLLOW_multiply_divide_modulo_expression_in_concat_expression6854);
					i=multiply_divide_modulo_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {l.add(i);}
					}
					break;

				default :
					break loop161;
				}
			}

			if ( state.backtracking==0 ) { ret = l.size() == 1 ? l.get(0) : factory.concat(l); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "concat_expression"



	// $ANTLR start "multiply_divide_modulo_expression"
	// PhoenixSQL.g:944:1: multiply_divide_modulo_expression returns [ParseNode ret] : i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* ;
	public final ParseNode multiply_divide_modulo_expression() throws RecognitionException {
		ParseNode ret = null;


		Token op=null;
		ParseNode i =null;
		ParseNode rhs =null;

		ParseNode lhs = null; List<ParseNode> l;
		try {
			// PhoenixSQL.g:946:5: (i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )* )
			// PhoenixSQL.g:946:9: i= negate_expression (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			{
			pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression6889);
			i=negate_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {lhs = i;}
			// PhoenixSQL.g:947:9: (op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression )*
			loop162:
			while (true) {
				int alt162=2;
				int LA162_0 = input.LA(1);
				if ( (LA162_0==ASTERISK||LA162_0==DIVIDE||LA162_0==PERCENT) ) {
					alt162=1;
				}

				switch (alt162) {
				case 1 :
					// PhoenixSQL.g:947:10: op= ( ASTERISK | DIVIDE | PERCENT ) rhs= negate_expression
					{
					op=input.LT(1);
					if ( input.LA(1)==ASTERISK||input.LA(1)==DIVIDE||input.LA(1)==PERCENT ) {
						input.consume();
						state.errorRecovery=false;
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_negate_expression_in_multiply_divide_modulo_expression6919);
					rhs=negate_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            l = Arrays.asList(lhs, rhs); 
					            // determine the expression type based on the operator found
					            lhs = op.getType() == ASTERISK ? factory.multiply(l)
					                : op.getType() == DIVIDE   ? factory.divide(l)
					                : factory.modulus(l);
					            }
					}
					break;

				default :
					break loop162;
				}
			}

			if ( state.backtracking==0 ) { ret = lhs; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "multiply_divide_modulo_expression"



	// $ANTLR start "use_schema_node"
	// PhoenixSQL.g:958:1: use_schema_node returns [UseSchemaStatement ret] : USE ( DEFAULT |s= identifier ) ;
	public final UseSchemaStatement use_schema_node() throws RecognitionException {
		UseSchemaStatement ret = null;


		String s =null;

		try {
			// PhoenixSQL.g:959:2: ( USE ( DEFAULT |s= identifier ) )
			// PhoenixSQL.g:959:6: USE ( DEFAULT |s= identifier )
			{
			match(input,USE,FOLLOW_USE_in_use_schema_node6962); if (state.failed) return ret;
			// PhoenixSQL.g:959:10: ( DEFAULT |s= identifier )
			int alt163=2;
			int LA163_0 = input.LA(1);
			if ( (LA163_0==DEFAULT) ) {
				alt163=1;
			}
			else if ( (LA163_0==NAME) ) {
				alt163=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 163, 0, input);
				throw nvae;
			}

			switch (alt163) {
				case 1 :
					// PhoenixSQL.g:959:11: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_use_schema_node6965); if (state.failed) return ret;
					}
					break;
				case 2 :
					// PhoenixSQL.g:959:21: s= identifier
					{
					pushFollow(FOLLOW_identifier_in_use_schema_node6971);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) {ret = factory.useSchema(s); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "use_schema_node"



	// $ANTLR start "negate_expression"
	// PhoenixSQL.g:963:1: negate_expression returns [ParseNode ret] : (m= MINUS )? e= array_expression ;
	public final ParseNode negate_expression() throws RecognitionException {
		ParseNode ret = null;


		Token m=null;
		ParseNode e =null;

		try {
			// PhoenixSQL.g:964:5: ( (m= MINUS )? e= array_expression )
			// PhoenixSQL.g:964:9: (m= MINUS )? e= array_expression
			{
			// PhoenixSQL.g:964:10: (m= MINUS )?
			int alt164=2;
			int LA164_0 = input.LA(1);
			if ( (LA164_0==MINUS) ) {
				alt164=1;
			}
			switch (alt164) {
				case 1 :
					// PhoenixSQL.g:964:10: m= MINUS
					{
					m=(Token)match(input,MINUS,FOLLOW_MINUS_in_negate_expression7007); if (state.failed) return ret;
					}
					break;

			}

			pushFollow(FOLLOW_array_expression_in_negate_expression7012);
			e=array_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = m==null ? e : factory.negate(e); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "negate_expression"



	// $ANTLR start "array_expression"
	// PhoenixSQL.g:968:1: array_expression returns [ParseNode ret] : e= term ( LSQUARE s= value_expression RSQUARE )? ;
	public final ParseNode array_expression() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e =null;
		ParseNode s =null;

		try {
			// PhoenixSQL.g:969:5: (e= term ( LSQUARE s= value_expression RSQUARE )? )
			// PhoenixSQL.g:969:9: e= term ( LSQUARE s= value_expression RSQUARE )?
			{
			pushFollow(FOLLOW_term_in_array_expression7040);
			e=term();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:969:16: ( LSQUARE s= value_expression RSQUARE )?
			int alt165=2;
			int LA165_0 = input.LA(1);
			if ( (LA165_0==LSQUARE) ) {
				alt165=1;
			}
			switch (alt165) {
				case 1 :
					// PhoenixSQL.g:969:17: LSQUARE s= value_expression RSQUARE
					{
					match(input,LSQUARE,FOLLOW_LSQUARE_in_array_expression7043); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_array_expression7047);
					s=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_array_expression7049); if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { if (s == null) { ret = e; } else { ret = factory.arrayElemRef(Arrays.<ParseNode>asList(e,s)); } }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "array_expression"



	// $ANTLR start "term"
	// PhoenixSQL.g:972:1: term returns [ParseNode ret] : (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name );
	public final ParseNode term() throws RecognitionException {
		ParseNode ret = null;


		Token ex=null;
		Token a=null;
		Token wg=null;
		Token t=null;
		Token length=null;
		Token scale=null;
		Token ar=null;
		Token n=null;
		ParseNode e =null;
		String field =null;
		List<ParseNode> v =null;
		TableName tableName =null;
		List<ParseNode> l =null;
		List<ParseNode> l2 =null;
		String dt =null;
		TableName s =null;
		ParseNode lorb =null;

		try {
			// PhoenixSQL.g:973:5: (e= literal_or_bind |field= identifier |ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE |tableName= table_name DOT field= identifier |field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )? |field= identifier LPAREN t= ASTERISK RPAREN |field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN |e= case_statement | LPAREN l= one_or_more_expressions RPAREN | CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN | (n= NEXT | CURRENT ) VALUE FOR s= from_table_name | (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name )
			int alt172=12;
			switch ( input.LA(1) ) {
			case BIND_NAME:
			case DECIMAL:
			case DOUBLE:
			case FALSE:
			case NULL:
			case NUMBER:
			case QUESTION:
			case STRING_LITERAL:
			case TRUE:
				{
				alt172=1;
				}
				break;
			case NAME:
				{
				switch ( input.LA(2) ) {
				case STRING_LITERAL:
					{
					alt172=1;
					}
					break;
				case EOF:
				case AND:
				case AS:
				case ASC:
				case ASTERISK:
				case BETWEEN:
				case CACHE:
				case COMMA:
				case CONCAT:
				case CONSTRAINT:
				case CYCLE:
				case DESC:
				case DIVIDE:
				case ELSE:
				case END:
				case EQ:
				case FETCH:
				case FROM:
				case FULL:
				case GROUP:
				case GT:
				case HAVING:
				case ILIKE:
				case IN:
				case INCREMENT:
				case INNER:
				case IS:
				case JOIN:
				case LEFT:
				case LIKE:
				case LIMIT:
				case LSQUARE:
				case LT:
				case MAXVALUE:
				case MINUS:
				case MINVALUE:
				case NAME:
				case NOEQ1:
				case NOEQ2:
				case NOT:
				case NULLS:
				case OFFSET:
				case OR:
				case ORDER:
				case PERCENT:
				case PLUS:
				case PRIMARY:
				case RIGHT:
				case RPAREN:
				case RSQUARE:
				case SEMICOLON:
				case THEN:
				case UNION:
				case WHEN:
				case WHERE:
					{
					alt172=2;
					}
					break;
				case DOT:
					{
					alt172=4;
					}
					break;
				case LPAREN:
					{
					switch ( input.LA(3) ) {
					case ASTERISK:
						{
						alt172=6;
						}
						break;
					case DISTINCT:
						{
						alt172=7;
						}
						break;
					case ARRAY:
					case BIND_NAME:
					case CASE:
					case CAST:
					case COMMA:
					case CURRENT:
					case DECIMAL:
					case DOUBLE:
					case EXISTS:
					case FALSE:
					case LPAREN:
					case MINUS:
					case NAME:
					case NEXT:
					case NOT:
					case NULL:
					case NUMBER:
					case QUESTION:
					case RPAREN:
					case STRING_LITERAL:
					case TRUE:
						{
						alt172=5;
						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 172, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
					}
					break;
				default:
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 172, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case ARRAY:
				{
				alt172=3;
				}
				break;
			case CASE:
				{
				alt172=8;
				}
				break;
			case LPAREN:
				{
				alt172=9;
				}
				break;
			case CAST:
				{
				alt172=10;
				}
				break;
			case NEXT:
				{
				int LA172_7 = input.LA(2);
				if ( (LA172_7==VALUE) ) {
					alt172=11;
				}
				else if ( (LA172_7==BIND_NAME||LA172_7==DECIMAL||LA172_7==DOUBLE||LA172_7==FALSE||LA172_7==NAME||LA172_7==NULL||LA172_7==NUMBER||LA172_7==QUESTION||LA172_7==STRING_LITERAL||LA172_7==TRUE) ) {
					alt172=12;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 172, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case CURRENT:
				{
				alt172=11;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 172, 0, input);
				throw nvae;
			}
			switch (alt172) {
				case 1 :
					// PhoenixSQL.g:973:9: e= literal_or_bind
					{
					pushFollow(FOLLOW_literal_or_bind_in_term7082);
					e=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:974:9: field= identifier
					{
					pushFollow(FOLLOW_identifier_in_term7096);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(null,field,field); }
					}
					break;
				case 3 :
					// PhoenixSQL.g:975:9: ex= ARRAY LSQUARE v= one_or_more_expressions RSQUARE
					{
					ex=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term7110); if (state.failed) return ret;
					match(input,LSQUARE,FOLLOW_LSQUARE_in_term7112); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term7116);
					v=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RSQUARE,FOLLOW_RSQUARE_in_term7118); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.upsertStmtArrayNode(v);}
					}
					break;
				case 4 :
					// PhoenixSQL.g:976:9: tableName= table_name DOT field= identifier
					{
					pushFollow(FOLLOW_table_name_in_term7132);
					tableName=table_name();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_term7134); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term7138);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.column(tableName, field, field); }
					}
					break;
				case 5 :
					// PhoenixSQL.g:977:9: field= identifier LPAREN l= zero_or_more_expressions RPAREN wg= ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					{
					pushFollow(FOLLOW_identifier_in_term7152);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7154); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7158);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7160); if (state.failed) return ret;
					// PhoenixSQL.g:977:70: ( WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN )?
					int alt167=2;
					int LA167_0 = input.LA(1);
					if ( (LA167_0==WITHIN) ) {
						alt167=1;
					}
					switch (alt167) {
						case 1 :
							// PhoenixSQL.g:977:71: WITHIN GROUP LPAREN ORDER BY l2= one_or_more_expressions (a= ASC | DESC ) RPAREN
							{
							wg=(Token)match(input,WITHIN,FOLLOW_WITHIN_in_term7165); if (state.failed) return ret;
							wg=(Token)match(input,GROUP,FOLLOW_GROUP_in_term7167); if (state.failed) return ret;
							wg=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_term7169); if (state.failed) return ret;
							wg=(Token)match(input,ORDER,FOLLOW_ORDER_in_term7171); if (state.failed) return ret;
							wg=(Token)match(input,BY,FOLLOW_BY_in_term7173); if (state.failed) return ret;
							pushFollow(FOLLOW_one_or_more_expressions_in_term7177);
							l2=one_or_more_expressions();
							state._fsp--;
							if (state.failed) return ret;
							// PhoenixSQL.g:977:127: (a= ASC | DESC )
							int alt166=2;
							int LA166_0 = input.LA(1);
							if ( (LA166_0==ASC) ) {
								alt166=1;
							}
							else if ( (LA166_0==DESC) ) {
								alt166=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return ret;}
								NoViableAltException nvae =
									new NoViableAltException("", 166, 0, input);
								throw nvae;
							}

							switch (alt166) {
								case 1 :
									// PhoenixSQL.g:977:128: a= ASC
									{
									a=(Token)match(input,ASC,FOLLOW_ASC_in_term7182); if (state.failed) return ret;
									}
									break;
								case 2 :
									// PhoenixSQL.g:977:136: DESC
									{
									wg=(Token)match(input,DESC,FOLLOW_DESC_in_term7186); if (state.failed) return ret;
									}
									break;

							}

							wg=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_term7189); if (state.failed) return ret;
							}
							break;

					}

					if ( state.backtracking==0 ) {
					            FunctionParseNode f = wg==null ? factory.function(field, l) : factory.function(field,l,l2,a!=null);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 6 :
					// PhoenixSQL.g:986:9: field= identifier LPAREN t= ASTERISK RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7214);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7216); if (state.failed) return ret;
					t=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_term7220); if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7222); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            if (!isCountFunction(field)) {
					                throwRecognitionException(t);
					            }
					            FunctionParseNode f = factory.function(field, LiteralParseNode.STAR);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 7 :
					// PhoenixSQL.g:998:9: field= identifier LPAREN t= DISTINCT l= zero_or_more_expressions RPAREN
					{
					pushFollow(FOLLOW_identifier_in_term7246);
					field=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7248); if (state.failed) return ret;
					t=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_term7252); if (state.failed) return ret;
					pushFollow(FOLLOW_zero_or_more_expressions_in_term7256);
					l=zero_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7258); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            FunctionParseNode f = factory.functionDistinct(field, l);
					            if (!contextStack.isEmpty()) {
					            	contextStack.peek().setAggregate(f.isAggregate());
					            }
					            if(f instanceof UDFParseNode) udfParseNodes.put(f.getName(),(UDFParseNode)f);
					            ret = f;
					        }
					}
					break;
				case 8 :
					// PhoenixSQL.g:1007:9: e= case_statement
					{
					pushFollow(FOLLOW_case_statement_in_term7281);
					e=case_statement();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 9 :
					// PhoenixSQL.g:1008:9: LPAREN l= one_or_more_expressions RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_term7293); if (state.failed) return ret;
					pushFollow(FOLLOW_one_or_more_expressions_in_term7297);
					l=one_or_more_expressions();
					state._fsp--;
					if (state.failed) return ret;
					match(input,RPAREN,FOLLOW_RPAREN_in_term7299); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					    		if(l.size() == 1) {
					    			ret = l.get(0);
					    		}	
					    		else {
					    			ret = factory.rowValueConstructor(l);
					    		}	 
					    	}
					}
					break;
				case 10 :
					// PhoenixSQL.g:1017:9: CAST LPAREN e= expression AS dt= identifier ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )? ar= ( ARRAY | ( LSQUARE RSQUARE ) )? RPAREN
					{
					match(input,CAST,FOLLOW_CAST_in_term7317); if (state.failed) return ret;
					match(input,LPAREN,FOLLOW_LPAREN_in_term7319); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_term7323);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					match(input,AS,FOLLOW_AS_in_term7325); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_term7329);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1017:51: ( LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN )?
					int alt169=2;
					int LA169_0 = input.LA(1);
					if ( (LA169_0==LPAREN) ) {
						alt169=1;
					}
					switch (alt169) {
						case 1 :
							// PhoenixSQL.g:1017:52: LPAREN length= NUMBER ( COMMA scale= NUMBER )? RPAREN
							{
							match(input,LPAREN,FOLLOW_LPAREN_in_term7332); if (state.failed) return ret;
							length=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term7336); if (state.failed) return ret;
							// PhoenixSQL.g:1017:73: ( COMMA scale= NUMBER )?
							int alt168=2;
							int LA168_0 = input.LA(1);
							if ( (LA168_0==COMMA) ) {
								alt168=1;
							}
							switch (alt168) {
								case 1 :
									// PhoenixSQL.g:1017:74: COMMA scale= NUMBER
									{
									match(input,COMMA,FOLLOW_COMMA_in_term7339); if (state.failed) return ret;
									scale=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_term7343); if (state.failed) return ret;
									}
									break;

							}

							match(input,RPAREN,FOLLOW_RPAREN_in_term7347); if (state.failed) return ret;
							}
							break;

					}

					// PhoenixSQL.g:1017:107: ( ARRAY | ( LSQUARE RSQUARE ) )?
					int alt170=3;
					int LA170_0 = input.LA(1);
					if ( (LA170_0==ARRAY) ) {
						alt170=1;
					}
					else if ( (LA170_0==LSQUARE) ) {
						alt170=2;
					}
					switch (alt170) {
						case 1 :
							// PhoenixSQL.g:1017:108: ARRAY
							{
							ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_term7354); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1017:116: ( LSQUARE RSQUARE )
							{
							// PhoenixSQL.g:1017:116: ( LSQUARE RSQUARE )
							// PhoenixSQL.g:1017:117: LSQUARE RSQUARE
							{
							ar=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_term7359); if (state.failed) return ret;
							ar=(Token)match(input,RSQUARE,FOLLOW_RSQUARE_in_term7361); if (state.failed) return ret;
							}

							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_term7366); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.cast(e, dt,
					                     length == null ? null : Integer.parseInt(length.getText()),
					                     scale == null ? null : Integer.parseInt(scale.getText()),
					                     ar!=null);
					        }
					}
					break;
				case 11 :
					// PhoenixSQL.g:1023:9: (n= NEXT | CURRENT ) VALUE FOR s= from_table_name
					{
					// PhoenixSQL.g:1023:9: (n= NEXT | CURRENT )
					int alt171=2;
					int LA171_0 = input.LA(1);
					if ( (LA171_0==NEXT) ) {
						alt171=1;
					}
					else if ( (LA171_0==CURRENT) ) {
						alt171=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						NoViableAltException nvae =
							new NoViableAltException("", 171, 0, input);
						throw nvae;
					}

					switch (alt171) {
						case 1 :
							// PhoenixSQL.g:1023:10: n= NEXT
							{
							n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term7389); if (state.failed) return ret;
							}
							break;
						case 2 :
							// PhoenixSQL.g:1023:19: CURRENT
							{
							match(input,CURRENT,FOLLOW_CURRENT_in_term7393); if (state.failed) return ret;
							}
							break;

					}

					match(input,VALUE,FOLLOW_VALUE_in_term7396); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term7398); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term7402);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = n==null ? factory.currentValueFor(s) : factory.nextValueFor(s, null); }
					}
					break;
				case 12 :
					// PhoenixSQL.g:1026:9: (n= NEXT ) lorb= literal_or_bind VALUES FOR s= from_table_name
					{
					// PhoenixSQL.g:1026:9: (n= NEXT )
					// PhoenixSQL.g:1026:10: n= NEXT
					{
					n=(Token)match(input,NEXT,FOLLOW_NEXT_in_term7430); if (state.failed) return ret;
					}

					pushFollow(FOLLOW_literal_or_bind_in_term7435);
					lorb=literal_or_bind();
					state._fsp--;
					if (state.failed) return ret;
					match(input,VALUES,FOLLOW_VALUES_in_term7437); if (state.failed) return ret;
					match(input,FOR,FOLLOW_FOR_in_term7439); if (state.failed) return ret;
					pushFollow(FOLLOW_from_table_name_in_term7443);
					s=from_table_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { contextStack.peek().hasSequences(true);
					          ret = factory.nextValueFor(s, lorb); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "term"



	// $ANTLR start "one_or_more_expressions"
	// PhoenixSQL.g:1031:1: one_or_more_expressions returns [List<ParseNode> ret] : e= expression ( COMMA e= expression )* ;
	public final List<ParseNode> one_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1033:5: (e= expression ( COMMA e= expression )* )
			// PhoenixSQL.g:1033:8: e= expression ( COMMA e= expression )*
			{
			pushFollow(FOLLOW_expression_in_one_or_more_expressions7488);
			e=expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1033:39: ( COMMA e= expression )*
			loop173:
			while (true) {
				int alt173=2;
				int LA173_0 = input.LA(1);
				if ( (LA173_0==COMMA) ) {
					alt173=1;
				}

				switch (alt173) {
				case 1 :
					// PhoenixSQL.g:1033:40: COMMA e= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_expressions7494); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_one_or_more_expressions7500);
					e=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop173;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_expressions"



	// $ANTLR start "one_or_more_jarpaths"
	// PhoenixSQL.g:1036:1: one_or_more_jarpaths returns [List<LiteralParseNode> ret] : jarPath= jar_path ( COMMA jarPath= jar_path )* ;
	public final List<LiteralParseNode> one_or_more_jarpaths() throws RecognitionException {
		List<LiteralParseNode> ret = null;


		LiteralParseNode jarPath =null;

		ret = new ArrayList<LiteralParseNode>(); 
		try {
			// PhoenixSQL.g:1038:5: (jarPath= jar_path ( COMMA jarPath= jar_path )* )
			// PhoenixSQL.g:1038:8: jarPath= jar_path ( COMMA jarPath= jar_path )*
			{
			pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths7531);
			jarPath=jar_path();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(jarPath);}
			// PhoenixSQL.g:1038:49: ( COMMA jarPath= jar_path )*
			loop174:
			while (true) {
				int alt174=2;
				int LA174_0 = input.LA(1);
				if ( (LA174_0==COMMA) ) {
					alt174=1;
				}

				switch (alt174) {
				case 1 :
					// PhoenixSQL.g:1038:50: COMMA jarPath= jar_path
					{
					match(input,COMMA,FOLLOW_COMMA_in_one_or_more_jarpaths7537); if (state.failed) return ret;
					pushFollow(FOLLOW_jar_path_in_one_or_more_jarpaths7543);
					jarPath=jar_path();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(jarPath);}
					}
					break;

				default :
					break loop174;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "one_or_more_jarpaths"



	// $ANTLR start "zero_or_more_expressions"
	// PhoenixSQL.g:1041:1: zero_or_more_expressions returns [List<ParseNode> ret] : (v= expression )? ( COMMA v= expression )* ;
	public final List<ParseNode> zero_or_more_expressions() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode v =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1043:5: ( (v= expression )? ( COMMA v= expression )* )
			// PhoenixSQL.g:1043:8: (v= expression )? ( COMMA v= expression )*
			{
			// PhoenixSQL.g:1043:8: (v= expression )?
			int alt175=2;
			int LA175_0 = input.LA(1);
			if ( (LA175_0==ARRAY||LA175_0==BIND_NAME||(LA175_0 >= CASE && LA175_0 <= CAST)||LA175_0==CURRENT||LA175_0==DECIMAL||LA175_0==DOUBLE||LA175_0==EXISTS||LA175_0==FALSE||LA175_0==LPAREN||LA175_0==MINUS||(LA175_0 >= NAME && LA175_0 <= NEXT)||(LA175_0 >= NOT && LA175_0 <= NULL)||LA175_0==NUMBER||LA175_0==QUESTION||LA175_0==STRING_LITERAL||LA175_0==TRUE) ) {
				alt175=1;
			}
			switch (alt175) {
				case 1 :
					// PhoenixSQL.g:1043:9: v= expression
					{
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions7576);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

			}

			// PhoenixSQL.g:1043:42: ( COMMA v= expression )*
			loop176:
			while (true) {
				int alt176=2;
				int LA176_0 = input.LA(1);
				if ( (LA176_0==COMMA) ) {
					alt176=1;
				}

				switch (alt176) {
				case 1 :
					// PhoenixSQL.g:1043:43: COMMA v= expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_expressions7584); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_zero_or_more_expressions7590);
					v=expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(v);}
					}
					break;

				default :
					break loop176;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_expressions"



	// $ANTLR start "zero_or_more_data_types"
	// PhoenixSQL.g:1046:1: zero_or_more_data_types returns [List<FunctionArgument> ret] : (fa= function_argument )? ( COMMA fa= function_argument )* ;
	public final List<FunctionArgument> zero_or_more_data_types() throws RecognitionException {
		List<FunctionArgument> ret = null;


		FunctionArgument fa =null;

		ret = new ArrayList<FunctionArgument>(); 
		try {
			// PhoenixSQL.g:1048:5: ( (fa= function_argument )? ( COMMA fa= function_argument )* )
			// PhoenixSQL.g:1048:7: (fa= function_argument )? ( COMMA fa= function_argument )*
			{
			// PhoenixSQL.g:1048:7: (fa= function_argument )?
			int alt177=2;
			int LA177_0 = input.LA(1);
			if ( (LA177_0==NAME) ) {
				alt177=1;
			}
			switch (alt177) {
				case 1 :
					// PhoenixSQL.g:1048:8: fa= function_argument
					{
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types7621);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

			}

			// PhoenixSQL.g:1048:49: ( COMMA fa= function_argument )*
			loop178:
			while (true) {
				int alt178=2;
				int LA178_0 = input.LA(1);
				if ( (LA178_0==COMMA) ) {
					alt178=1;
				}

				switch (alt178) {
				case 1 :
					// PhoenixSQL.g:1048:50: COMMA fa= function_argument
					{
					match(input,COMMA,FOLLOW_COMMA_in_zero_or_more_data_types7628); if (state.failed) return ret;
					pushFollow(FOLLOW_function_argument_in_zero_or_more_data_types7634);
					fa=function_argument();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(fa);}
					}
					break;

				default :
					break loop178;
				}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "zero_or_more_data_types"



	// $ANTLR start "function_argument"
	// PhoenixSQL.g:1051:1: function_argument returns [FunctionArgument ret] : (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) ;
	public final FunctionArgument function_argument() throws RecognitionException {
		FunctionArgument ret = null;


		Token l=null;
		Token s=null;
		Token ar=null;
		Token lsq=null;
		Token a=null;
		Token c=null;
		String dt =null;
		ParseNode dv =null;
		ParseNode minv =null;
		ParseNode maxv =null;

		try {
			// PhoenixSQL.g:1052:2: ( (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? ) )
			// PhoenixSQL.g:1052:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			{
			// PhoenixSQL.g:1052:4: (dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )? )
			// PhoenixSQL.g:1052:5: dt= identifier ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )? (ar= ARRAY )? (lsq= LSQUARE (a= NUMBER )? RSQUARE )? (c= CONSTANT )? ( DEFAULTVALUE EQ dv= expression )? ( MINVALUE EQ minv= expression )? ( MAXVALUE EQ maxv= expression )?
			{
			pushFollow(FOLLOW_identifier_in_function_argument7659);
			dt=identifier();
			state._fsp--;
			if (state.failed) return ret;
			// PhoenixSQL.g:1052:21: ( LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN )?
			int alt180=2;
			int LA180_0 = input.LA(1);
			if ( (LA180_0==LPAREN) ) {
				alt180=1;
			}
			switch (alt180) {
				case 1 :
					// PhoenixSQL.g:1052:22: LPAREN l= NUMBER ( COMMA s= NUMBER )? RPAREN
					{
					match(input,LPAREN,FOLLOW_LPAREN_in_function_argument7662); if (state.failed) return ret;
					l=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument7666); if (state.failed) return ret;
					// PhoenixSQL.g:1052:38: ( COMMA s= NUMBER )?
					int alt179=2;
					int LA179_0 = input.LA(1);
					if ( (LA179_0==COMMA) ) {
						alt179=1;
					}
					switch (alt179) {
						case 1 :
							// PhoenixSQL.g:1052:39: COMMA s= NUMBER
							{
							match(input,COMMA,FOLLOW_COMMA_in_function_argument7669); if (state.failed) return ret;
							s=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument7673); if (state.failed) return ret;
							}
							break;

					}

					match(input,RPAREN,FOLLOW_RPAREN_in_function_argument7677); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1052:67: (ar= ARRAY )?
			int alt181=2;
			int LA181_0 = input.LA(1);
			if ( (LA181_0==ARRAY) ) {
				alt181=1;
			}
			switch (alt181) {
				case 1 :
					// PhoenixSQL.g:1052:67: ar= ARRAY
					{
					ar=(Token)match(input,ARRAY,FOLLOW_ARRAY_in_function_argument7683); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1052:75: (lsq= LSQUARE (a= NUMBER )? RSQUARE )?
			int alt183=2;
			int LA183_0 = input.LA(1);
			if ( (LA183_0==LSQUARE) ) {
				alt183=1;
			}
			switch (alt183) {
				case 1 :
					// PhoenixSQL.g:1052:76: lsq= LSQUARE (a= NUMBER )? RSQUARE
					{
					lsq=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_function_argument7689); if (state.failed) return ret;
					// PhoenixSQL.g:1052:88: (a= NUMBER )?
					int alt182=2;
					int LA182_0 = input.LA(1);
					if ( (LA182_0==NUMBER) ) {
						alt182=1;
					}
					switch (alt182) {
						case 1 :
							// PhoenixSQL.g:1052:89: a= NUMBER
							{
							a=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_function_argument7694); if (state.failed) return ret;
							}
							break;

					}

					match(input,RSQUARE,FOLLOW_RSQUARE_in_function_argument7698); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1052:110: (c= CONSTANT )?
			int alt184=2;
			int LA184_0 = input.LA(1);
			if ( (LA184_0==CONSTANT) ) {
				alt184=1;
			}
			switch (alt184) {
				case 1 :
					// PhoenixSQL.g:1052:111: c= CONSTANT
					{
					c=(Token)match(input,CONSTANT,FOLLOW_CONSTANT_in_function_argument7707); if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1052:126: ( DEFAULTVALUE EQ dv= expression )?
			int alt185=2;
			int LA185_0 = input.LA(1);
			if ( (LA185_0==DEFAULTVALUE) ) {
				alt185=1;
			}
			switch (alt185) {
				case 1 :
					// PhoenixSQL.g:1052:127: DEFAULTVALUE EQ dv= expression
					{
					match(input,DEFAULTVALUE,FOLLOW_DEFAULTVALUE_in_function_argument7712); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument7714); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument7720);
					dv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1052:161: ( MINVALUE EQ minv= expression )?
			int alt186=2;
			int LA186_0 = input.LA(1);
			if ( (LA186_0==MINVALUE) ) {
				alt186=1;
			}
			switch (alt186) {
				case 1 :
					// PhoenixSQL.g:1052:162: MINVALUE EQ minv= expression
					{
					match(input,MINVALUE,FOLLOW_MINVALUE_in_function_argument7725); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument7727); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument7733);
					minv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			// PhoenixSQL.g:1052:195: ( MAXVALUE EQ maxv= expression )?
			int alt187=2;
			int LA187_0 = input.LA(1);
			if ( (LA187_0==MAXVALUE) ) {
				alt187=1;
			}
			switch (alt187) {
				case 1 :
					// PhoenixSQL.g:1052:196: MAXVALUE EQ maxv= expression
					{
					match(input,MAXVALUE,FOLLOW_MAXVALUE_in_function_argument7739); if (state.failed) return ret;
					match(input,EQ,FOLLOW_EQ_in_function_argument7741); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_function_argument7747);
					maxv=expression();
					state._fsp--;
					if (state.failed) return ret;
					}
					break;

			}

			if ( state.backtracking==0 ) { ret = new FunctionArgument(dt,  ar != null || lsq != null, c!=null, 
			    dv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)dv).getValue()), 
			    minv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)minv).getValue()), 
			    maxv == null ? null : LiteralExpression.newConstant(((LiteralParseNode)maxv).getValue()));}
			}

			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "function_argument"



	// $ANTLR start "value_expression_list"
	// PhoenixSQL.g:1059:1: value_expression_list returns [List<ParseNode> ret] : LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN ;
	public final List<ParseNode> value_expression_list() throws RecognitionException {
		List<ParseNode> ret = null;


		ParseNode e =null;

		ret = new ArrayList<ParseNode>(); 
		try {
			// PhoenixSQL.g:1061:5: ( LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN )
			// PhoenixSQL.g:1061:8: LPAREN e= value_expression ( COMMA e= value_expression )* RPAREN
			{
			match(input,LPAREN,FOLLOW_LPAREN_in_value_expression_list7777); if (state.failed) return ret;
			pushFollow(FOLLOW_value_expression_in_value_expression_list7783);
			e=value_expression();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret.add(e);}
			// PhoenixSQL.g:1061:52: ( COMMA e= value_expression )*
			loop188:
			while (true) {
				int alt188=2;
				int LA188_0 = input.LA(1);
				if ( (LA188_0==COMMA) ) {
					alt188=1;
				}

				switch (alt188) {
				case 1 :
					// PhoenixSQL.g:1061:53: COMMA e= value_expression
					{
					match(input,COMMA,FOLLOW_COMMA_in_value_expression_list7789); if (state.failed) return ret;
					pushFollow(FOLLOW_value_expression_in_value_expression_list7795);
					e=value_expression();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret.add(e);}
					}
					break;

				default :
					break loop188;
				}
			}

			match(input,RPAREN,FOLLOW_RPAREN_in_value_expression_list7802); if (state.failed) return ret;
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "value_expression_list"



	// $ANTLR start "index_name"
	// PhoenixSQL.g:1064:1: index_name returns [NamedNode ret] : name= identifier ;
	public final NamedNode index_name() throws RecognitionException {
		NamedNode ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1065:5: (name= identifier )
			// PhoenixSQL.g:1065:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_index_name7823);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.indexName(name); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "index_name"



	// $ANTLR start "cursor_name"
	// PhoenixSQL.g:1068:1: cursor_name returns [CursorName ret] : name= identifier ;
	public final CursorName cursor_name() throws RecognitionException {
		CursorName ret = null;


		String name =null;

		try {
			// PhoenixSQL.g:1069:5: (name= identifier )
			// PhoenixSQL.g:1069:9: name= identifier
			{
			pushFollow(FOLLOW_identifier_in_cursor_name7850);
			name=identifier();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) {ret = factory.cursorName(name);}
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "cursor_name"



	// $ANTLR start "table_name"
	// PhoenixSQL.g:1073:1: table_name returns [TableName ret] : (t= identifier |s= identifier DOT t= identifier );
	public final TableName table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1074:5: (t= identifier |s= identifier DOT t= identifier )
			int alt189=2;
			int LA189_0 = input.LA(1);
			if ( (LA189_0==NAME) ) {
				int LA189_1 = input.LA(2);
				if ( (LA189_1==DOT) ) {
					int LA189_2 = input.LA(3);
					if ( (LA189_2==NAME) ) {
						int LA189_3 = input.LA(4);
						if ( (LA189_3==EOF||LA189_3==AND||(LA189_3 >= AS && LA189_3 <= ASTERISK)||LA189_3==BETWEEN||LA189_3==CACHE||LA189_3==COMMA||LA189_3==CONCAT||LA189_3==CONSTRAINT||LA189_3==CYCLE||LA189_3==DESC||LA189_3==DIVIDE||(LA189_3 >= ELSE && LA189_3 <= END)||LA189_3==EQ||LA189_3==FETCH||(LA189_3 >= FROM && LA189_3 <= FULL)||(LA189_3 >= GROUP && LA189_3 <= HAVING)||LA189_3==ILIKE||LA189_3==IN||LA189_3==INCREMENT||LA189_3==INNER||LA189_3==IS||LA189_3==JOIN||LA189_3==LEFT||(LA189_3 >= LIKE && LA189_3 <= LIMIT)||(LA189_3 >= LSQUARE && LA189_3 <= MINVALUE)||LA189_3==NAME||(LA189_3 >= NOEQ1 && LA189_3 <= NOT)||LA189_3==NULLS||LA189_3==OFFSET||(LA189_3 >= OR && LA189_3 <= ORDER)||(LA189_3 >= PERCENT && LA189_3 <= PLUS)||LA189_3==PRIMARY||LA189_3==RIGHT||(LA189_3 >= RPAREN && LA189_3 <= RSQUARE)||LA189_3==SEMICOLON||LA189_3==THEN||LA189_3==UNION||(LA189_3 >= WHEN && LA189_3 <= WHERE)) ) {
							alt189=1;
						}
						else if ( (LA189_3==DOT) ) {
							alt189=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return ret;}
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 189, 3, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return ret;}
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 189, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 189, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 189, 0, input);
				throw nvae;
			}

			switch (alt189) {
				case 1 :
					// PhoenixSQL.g:1074:9: t= identifier
					{
					pushFollow(FOLLOW_identifier_in_table_name7878);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1075:9: s= identifier DOT t= identifier
					{
					pushFollow(FOLLOW_identifier_in_table_name7892);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_table_name7894); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_table_name7898);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "table_name"



	// $ANTLR start "from_table_name"
	// PhoenixSQL.g:1079:1: from_table_name returns [TableName ret] : (t= identifier |s= identifier DOT t= identifier );
	public final TableName from_table_name() throws RecognitionException {
		TableName ret = null;


		String t =null;
		String s =null;

		try {
			// PhoenixSQL.g:1080:5: (t= identifier |s= identifier DOT t= identifier )
			int alt190=2;
			int LA190_0 = input.LA(1);
			if ( (LA190_0==NAME) ) {
				int LA190_1 = input.LA(2);
				if ( (LA190_1==EOF||(LA190_1 >= ACTIVE && LA190_1 <= ALL)||LA190_1==AND||(LA190_1 >= AS && LA190_1 <= ASTERISK)||LA190_1==BETWEEN||(LA190_1 >= CACHE && LA190_1 <= CASCADE)||(LA190_1 >= COLUMNS && LA190_1 <= COMMA)||LA190_1==CONCAT||LA190_1==CONSTRAINT||LA190_1==CYCLE||LA190_1==DESC||LA190_1==DISABLE||LA190_1==DIVIDE||LA190_1==DROP||(LA190_1 >= ELSE && LA190_1 <= END)||LA190_1==EQ||LA190_1==FETCH||(LA190_1 >= FROM && LA190_1 <= FULL)||(LA190_1 >= GROUP && LA190_1 <= HAVING)||LA190_1==ILIKE||LA190_1==IN||(LA190_1 >= INCREMENT && LA190_1 <= INNER)||LA190_1==IS||LA190_1==JOIN||LA190_1==LEFT||(LA190_1 >= LIKE && LA190_1 <= LIMIT)||(LA190_1 >= LPAREN && LA190_1 <= MINVALUE)||LA190_1==NAME||(LA190_1 >= NOEQ1 && LA190_1 <= NOT)||LA190_1==NULLS||(LA190_1 >= OFFSET && LA190_1 <= ON)||(LA190_1 >= OR && LA190_1 <= ORDER)||(LA190_1 >= PERCENT && LA190_1 <= PLUS)||LA190_1==PRIMARY||LA190_1==REBUILD||LA190_1==RIGHT||(LA190_1 >= RPAREN && LA190_1 <= RSQUARE)||(LA190_1 >= SELECT && LA190_1 <= SEMICOLON)||LA190_1==SET||LA190_1==START||LA190_1==TABLESAMPLE||LA190_1==THEN||(LA190_1 >= UNION && LA190_1 <= UNUSABLE)||LA190_1==USABLE||LA190_1==VALUES||(LA190_1 >= WHEN && LA190_1 <= WHERE)) ) {
					alt190=1;
				}
				else if ( (LA190_1==DOT) ) {
					alt190=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 190, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 190, 0, input);
				throw nvae;
			}

			switch (alt190) {
				case 1 :
					// PhoenixSQL.g:1080:9: t= identifier
					{
					pushFollow(FOLLOW_identifier_in_from_table_name7926);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(null, t); }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1081:9: s= identifier DOT t= identifier
					{
					pushFollow(FOLLOW_identifier_in_from_table_name7940);
					s=identifier();
					state._fsp--;
					if (state.failed) return ret;
					match(input,DOT,FOLLOW_DOT_in_from_table_name7942); if (state.failed) return ret;
					pushFollow(FOLLOW_identifier_in_from_table_name7946);
					t=identifier();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.table(s, t); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "from_table_name"



	// $ANTLR start "literal_or_bind"
	// PhoenixSQL.g:1085:1: literal_or_bind returns [ParseNode ret] : (e= literal |b= bind_name );
	public final ParseNode literal_or_bind() throws RecognitionException {
		ParseNode ret = null;


		LiteralParseNode e =null;
		String b =null;

		try {
			// PhoenixSQL.g:1086:5: (e= literal |b= bind_name )
			int alt191=2;
			int LA191_0 = input.LA(1);
			if ( (LA191_0==DECIMAL||LA191_0==DOUBLE||LA191_0==FALSE||LA191_0==NAME||LA191_0==NULL||LA191_0==NUMBER||LA191_0==STRING_LITERAL||LA191_0==TRUE) ) {
				alt191=1;
			}
			else if ( (LA191_0==BIND_NAME||LA191_0==QUESTION) ) {
				alt191=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 191, 0, input);
				throw nvae;
			}

			switch (alt191) {
				case 1 :
					// PhoenixSQL.g:1086:9: e= literal
					{
					pushFollow(FOLLOW_literal_in_literal_or_bind7978);
					e=literal();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = e; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1087:9: b= bind_name
					{
					pushFollow(FOLLOW_bind_name_in_literal_or_bind7992);
					b=bind_name();
					state._fsp--;
					if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = factory.bind(b); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal_or_bind"



	// $ANTLR start "literal"
	// PhoenixSQL.g:1091:1: literal returns [LiteralParseNode ret] : (s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL );
	public final LiteralParseNode literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token s=null;
		Token n=null;
		Token d=null;
		Token dbl=null;
		Token t=null;
		String dt =null;

		try {
			// PhoenixSQL.g:1092:5: (s= STRING_LITERAL |n= NUMBER |d= DECIMAL |dbl= DOUBLE | NULL | TRUE | FALSE |dt= identifier t= STRING_LITERAL )
			int alt192=8;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt192=1;
				}
				break;
			case NUMBER:
				{
				alt192=2;
				}
				break;
			case DECIMAL:
				{
				alt192=3;
				}
				break;
			case DOUBLE:
				{
				alt192=4;
				}
				break;
			case NULL:
				{
				alt192=5;
				}
				break;
			case TRUE:
				{
				alt192=6;
				}
				break;
			case FALSE:
				{
				alt192=7;
				}
				break;
			case NAME:
				{
				alt192=8;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 192, 0, input);
				throw nvae;
			}
			switch (alt192) {
				case 1 :
					// PhoenixSQL.g:1092:9: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal8024); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(s.getText()); 
					        }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1095:9: n= NUMBER
					{
					n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_literal8038); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.wholeNumber(n.getText());
					        }
					}
					break;
				case 3 :
					// PhoenixSQL.g:1098:9: d= DECIMAL
					{
					d=(Token)match(input,DECIMAL,FOLLOW_DECIMAL_in_literal8052); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.realNumber(d.getText());
					        }
					}
					break;
				case 4 :
					// PhoenixSQL.g:1101:9: dbl= DOUBLE
					{
					dbl=(Token)match(input,DOUBLE,FOLLOW_DOUBLE_in_literal8067); if (state.failed) return ret;
					if ( state.backtracking==0 ) {
					            ret = factory.literal(Double.valueOf(dbl.getText()));
					        }
					}
					break;
				case 5 :
					// PhoenixSQL.g:1104:9: NULL
					{
					match(input,NULL,FOLLOW_NULL_in_literal8084); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(null);}
					}
					break;
				case 6 :
					// PhoenixSQL.g:1105:9: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_literal8096); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.TRUE);}
					}
					break;
				case 7 :
					// PhoenixSQL.g:1106:9: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_literal8109); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.literal(Boolean.FALSE);}
					}
					break;
				case 8 :
					// PhoenixSQL.g:1107:9: dt= identifier t= STRING_LITERAL
					{
					pushFollow(FOLLOW_identifier_in_literal8123);
					dt=identifier();
					state._fsp--;
					if (state.failed) return ret;
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal8127); if (state.failed) return ret;
					if ( state.backtracking==0 ) { 
					            try {
					                ret = factory.literal(t.getText(), dt);
					            } catch (SQLException e) {
					                throw new RuntimeException(e);
					            }
					        }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "literal"



	// $ANTLR start "int_or_long_literal"
	// PhoenixSQL.g:1116:1: int_or_long_literal returns [LiteralParseNode ret] : n= NUMBER ;
	public final LiteralParseNode int_or_long_literal() throws RecognitionException {
		LiteralParseNode ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1117:5: (n= NUMBER )
			// PhoenixSQL.g:1117:9: n= NUMBER
			{
			n=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_int_or_long_literal8158); if (state.failed) return ret;
			if ( state.backtracking==0 ) {
			            ret = factory.intOrLong(n.getText());
			        }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "int_or_long_literal"



	// $ANTLR start "bind_name"
	// PhoenixSQL.g:1123:1: bind_name returns [String ret] : (n= BIND_NAME | QUESTION );
	public final String bind_name() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1124:5: (n= BIND_NAME | QUESTION )
			int alt193=2;
			int LA193_0 = input.LA(1);
			if ( (LA193_0==BIND_NAME) ) {
				alt193=1;
			}
			else if ( (LA193_0==QUESTION) ) {
				alt193=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 193, 0, input);
				throw nvae;
			}

			switch (alt193) {
				case 1 :
					// PhoenixSQL.g:1124:9: n= BIND_NAME
					{
					n=(Token)match(input,BIND_NAME,FOLLOW_BIND_NAME_in_bind_name8186); if (state.failed) return ret;
					if ( state.backtracking==0 ) { String bind = n.getText().substring(1); updateBind(bind); ret = bind; }
					}
					break;
				case 2 :
					// PhoenixSQL.g:1125:9: QUESTION
					{
					match(input,QUESTION,FOLLOW_QUESTION_in_bind_name8199); if (state.failed) return ret;
					if ( state.backtracking==0 ) { ret = nextBind(); }
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "bind_name"



	// $ANTLR start "identifier"
	// PhoenixSQL.g:1129:1: identifier returns [String ret] : c= parseNoReserved ;
	public final String identifier() throws RecognitionException {
		String ret = null;


		String c =null;

		try {
			// PhoenixSQL.g:1130:5: (c= parseNoReserved )
			// PhoenixSQL.g:1130:9: c= parseNoReserved
			{
			pushFollow(FOLLOW_parseNoReserved_in_identifier8228);
			c=parseNoReserved();
			state._fsp--;
			if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = c; }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "identifier"



	// $ANTLR start "parseNoReserved"
	// PhoenixSQL.g:1133:1: parseNoReserved returns [String ret] : n= NAME ;
	public final String parseNoReserved() throws RecognitionException {
		String ret = null;


		Token n=null;

		try {
			// PhoenixSQL.g:1134:5: (n= NAME )
			// PhoenixSQL.g:1134:9: n= NAME
			{
			n=(Token)match(input,NAME,FOLLOW_NAME_in_parseNoReserved8255); if (state.failed) return ret;
			if ( state.backtracking==0 ) { ret = n.getText(); }
			}

		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "parseNoReserved"



	// $ANTLR start "case_statement"
	// PhoenixSQL.g:1137:1: case_statement returns [ParseNode ret] : ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END );
	public final ParseNode case_statement() throws RecognitionException {
		ParseNode ret = null;


		ParseNode e1 =null;
		ParseNode e2 =null;
		ParseNode t =null;
		ParseNode el =null;
		ParseNode c =null;

		List<ParseNode> w = new ArrayList<ParseNode>(4);
		try {
			// PhoenixSQL.g:1139:5: ( CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END | CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END )
			int alt198=2;
			int LA198_0 = input.LA(1);
			if ( (LA198_0==CASE) ) {
				int LA198_1 = input.LA(2);
				if ( (LA198_1==ARRAY||LA198_1==BIND_NAME||(LA198_1 >= CASE && LA198_1 <= CAST)||LA198_1==CURRENT||LA198_1==DECIMAL||LA198_1==DOUBLE||LA198_1==EXISTS||LA198_1==FALSE||LA198_1==LPAREN||LA198_1==MINUS||(LA198_1 >= NAME && LA198_1 <= NEXT)||(LA198_1 >= NOT && LA198_1 <= NULL)||LA198_1==NUMBER||LA198_1==QUESTION||LA198_1==STRING_LITERAL||LA198_1==TRUE) ) {
					alt198=1;
				}
				else if ( (LA198_1==WHEN) ) {
					alt198=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return ret;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 198, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return ret;}
				NoViableAltException nvae =
					new NoViableAltException("", 198, 0, input);
				throw nvae;
			}

			switch (alt198) {
				case 1 :
					// PhoenixSQL.g:1139:7: CASE e1= expression ( WHEN e2= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement8282); if (state.failed) return ret;
					pushFollow(FOLLOW_expression_in_case_statement8286);
					e1=expression();
					state._fsp--;
					if (state.failed) return ret;
					// PhoenixSQL.g:1139:26: ( WHEN e2= expression THEN t= expression )+
					int cnt194=0;
					loop194:
					while (true) {
						int alt194=2;
						int LA194_0 = input.LA(1);
						if ( (LA194_0==WHEN) ) {
							alt194=1;
						}

						switch (alt194) {
						case 1 :
							// PhoenixSQL.g:1139:27: WHEN e2= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement8289); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8293);
							e2=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement8295); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8299);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(factory.equal(e1,e2));}
							}
							break;

						default :
							if ( cnt194 >= 1 ) break loop194;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(194, input);
							throw eee;
						}
						cnt194++;
					}

					// PhoenixSQL.g:1139:106: ( ELSE el= expression )?
					int alt195=2;
					int LA195_0 = input.LA(1);
					if ( (LA195_0==ELSE) ) {
						alt195=1;
					}
					switch (alt195) {
						case 1 :
							// PhoenixSQL.g:1139:107: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement8306); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8310);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement8316); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;
				case 2 :
					// PhoenixSQL.g:1140:7: CASE ( WHEN c= expression THEN t= expression )+ ( ELSE el= expression )? END
					{
					match(input,CASE,FOLLOW_CASE_in_case_statement8326); if (state.failed) return ret;
					// PhoenixSQL.g:1140:12: ( WHEN c= expression THEN t= expression )+
					int cnt196=0;
					loop196:
					while (true) {
						int alt196=2;
						int LA196_0 = input.LA(1);
						if ( (LA196_0==WHEN) ) {
							alt196=1;
						}

						switch (alt196) {
						case 1 :
							// PhoenixSQL.g:1140:13: WHEN c= expression THEN t= expression
							{
							match(input,WHEN,FOLLOW_WHEN_in_case_statement8329); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8333);
							c=expression();
							state._fsp--;
							if (state.failed) return ret;
							match(input,THEN,FOLLOW_THEN_in_case_statement8335); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8339);
							t=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(t);w.add(c);}
							}
							break;

						default :
							if ( cnt196 >= 1 ) break loop196;
							if (state.backtracking>0) {state.failed=true; return ret;}
							EarlyExitException eee = new EarlyExitException(196, input);
							throw eee;
						}
						cnt196++;
					}

					// PhoenixSQL.g:1140:72: ( ELSE el= expression )?
					int alt197=2;
					int LA197_0 = input.LA(1);
					if ( (LA197_0==ELSE) ) {
						alt197=1;
					}
					switch (alt197) {
						case 1 :
							// PhoenixSQL.g:1140:73: ELSE el= expression
							{
							match(input,ELSE,FOLLOW_ELSE_in_case_statement8346); if (state.failed) return ret;
							pushFollow(FOLLOW_expression_in_case_statement8350);
							el=expression();
							state._fsp--;
							if (state.failed) return ret;
							if ( state.backtracking==0 ) {w.add(el);}
							}
							break;

					}

					match(input,END,FOLLOW_END_in_case_statement8356); if (state.failed) return ret;
					if ( state.backtracking==0 ) {ret = factory.caseWhen(w);}
					}
					break;

			}
		}

		    catch (RecognitionException re) {
		        throw re;
		    }

		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "case_statement"

	// $ANTLR start synpred1_PhoenixSQL
	public final void synpred1_PhoenixSQL_fragment() throws RecognitionException {
		// PhoenixSQL.g:893:9: ( ( NOT )? boolean_expression )
		// PhoenixSQL.g:893:10: ( NOT )? boolean_expression
		{
		// PhoenixSQL.g:893:10: ( NOT )?
		int alt199=2;
		int LA199_0 = input.LA(1);
		if ( (LA199_0==NOT) ) {
			alt199=1;
		}
		switch (alt199) {
			case 1 :
				// PhoenixSQL.g:893:10: NOT
				{
				match(input,NOT,FOLLOW_NOT_in_synpred1_PhoenixSQL6053); if (state.failed) return;
				}
				break;

		}

		pushFollow(FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6056);
		boolean_expression();
		state._fsp--;
		if (state.failed) return;
		}

	}
	// $ANTLR end synpred1_PhoenixSQL

	// Delegated rules

	public final boolean synpred1_PhoenixSQL() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_PhoenixSQL_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}



	public static final BitSet FOLLOW_oneStatement_in_nextStatement1244 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_SEMICOLON_in_nextStatement1248 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EOF_in_nextStatement1257 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_oneStatement_in_statement1283 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_statement1287 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_query1313 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_query1315 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_oneStatement1347 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_upsert_node_in_oneStatement1357 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_node_in_oneStatement1369 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_table_node_in_oneStatement1381 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_schema_node_in_oneStatement1393 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_view_node_in_oneStatement1405 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_index_node_in_oneStatement1417 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_open_node_in_oneStatement1429 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_close_node_in_oneStatement1441 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cursor_fetch_node_in_oneStatement1453 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_declare_cursor_node_in_oneStatement1465 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_table_node_in_oneStatement1477 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_index_node_in_oneStatement1489 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_index_node_in_oneStatement1501 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_table_node_in_oneStatement1513 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_trace_node_in_oneStatement1525 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_function_node_in_oneStatement1537 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_function_node_in_oneStatement1549 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_jars_node_in_oneStatement1561 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_list_jars_node_in_oneStatement1573 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_jar_node_in_oneStatement1585 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alter_session_node_in_oneStatement1597 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_sequence_node_in_oneStatement1607 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_sequence_node_in_oneStatement1617 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_schema_node_in_oneStatement1627 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_use_schema_node_in_oneStatement1637 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_statistics_node_in_oneStatement1649 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_execute_upgrade_node_in_oneStatement1661 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_explain_node_in_oneStatement1673 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXPLAIN_in_explain_node1706 = new BitSet(new long[]{0x50401208020000A0L,0x0080000200000002L,0x000002A200004000L});
	public static final BitSet FOLLOW_oneStatement_in_explain_node1710 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_table_node1736 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L,0x0000000008000000L});
	public static final BitSet FOLLOW_IMMUTABLE_in_create_table_node1741 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_TABLE_in_create_table_node1745 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_create_table_node1748 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_create_table_node1750 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_table_node1754 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_table_node1760 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_table_node1772 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_table_node1776 = new BitSet(new long[]{0x0000000420000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_pk_constraint_in_create_table_node1781 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_create_table_node1785 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_fam_properties_in_create_table_node1799 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_SPLIT_in_create_table_node1812 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_create_table_node1814 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_table_node1818 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_schema_node1857 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_SCHEMA_in_create_schema_node1859 = new BitSet(new long[]{0x0000040000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_create_schema_node1862 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_create_schema_node1864 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_schema_node1868 = new BitSet(new long[]{0x0000040000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_DEFAULT_in_create_schema_node1873 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_create_schema_node1879 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_view_node1914 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_VIEW_in_create_view_node1916 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_create_view_node1919 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_create_view_node1921 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_view_node1925 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node1931 = new BitSet(new long[]{0x0000000000000802L,0x0000080800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_view_node1943 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_defs_in_create_view_node1947 = new BitSet(new long[]{0x0000000420000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_pk_constraint_in_create_view_node1952 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_create_view_node1956 = new BitSet(new long[]{0x0000000000000802L,0x0000080000000000L});
	public static final BitSet FOLLOW_AS_in_create_view_node1970 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_SELECT_in_create_view_node1972 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_create_view_node1974 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_create_view_node1986 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_view_node1990 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_WHERE_in_create_view_node2003 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_create_view_node2007 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L});
	public static final BitSet FOLLOW_fam_properties_in_create_view_node2025 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_index_node2061 = new BitSet(new long[]{0x0000000000000000L,0x0000000400080000L});
	public static final BitSet FOLLOW_LOCAL_in_create_index_node2065 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_INDEX_in_create_index_node2068 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_create_index_node2071 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_create_index_node2073 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_index_node2077 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_index_name_in_create_index_node2083 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2085 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_index_node2089 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2100 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_ik_constraint_in_create_index_node2104 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2106 = new BitSet(new long[]{0x0000000000004002L,0x0000080000020000L,0x0000000000800000L});
	public static final BitSet FOLLOW_INCLUDE_in_create_index_node2118 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_index_node2121 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_names_in_create_index_node2125 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_create_index_node2127 = new BitSet(new long[]{0x0000000000004002L,0x0000080000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_ASYNC_in_create_index_node2143 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_fam_properties_in_create_index_node2158 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_SPLIT_in_create_index_node2171 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_create_index_node2173 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_value_expression_list_in_create_index_node2177 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_sequence_node2213 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_SEQUENCE_in_create_sequence_node2215 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_create_sequence_node2219 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_create_sequence_node2221 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_create_sequence_node2225 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_create_sequence_node2231 = new BitSet(new long[]{0x0000004000080002L,0x0000014000040000L,0x0000000001000000L});
	public static final BitSet FOLLOW_START_in_create_sequence_node2242 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0001000404000002L});
	public static final BitSet FOLLOW_WITH_in_create_sequence_node2244 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2249 = new BitSet(new long[]{0x0000004000080002L,0x0000014000040000L});
	public static final BitSet FOLLOW_INCREMENT_in_create_sequence_node2262 = new BitSet(new long[]{0x0008011000660400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_BY_in_create_sequence_node2264 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2269 = new BitSet(new long[]{0x0000004000080002L,0x0000014000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_create_sequence_node2282 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2286 = new BitSet(new long[]{0x0000004000080002L,0x0000004000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_create_sequence_node2299 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_create_sequence_node2303 = new BitSet(new long[]{0x0000004000080002L});
	public static final BitSet FOLLOW_CYCLE_in_create_sequence_node2318 = new BitSet(new long[]{0x0000000000080002L});
	public static final BitSet FOLLOW_CACHE_in_create_sequence_node2332 = new BitSet(new long[]{0x0000000000020000L,0x0004000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_int_literal_or_bind_in_create_sequence_node2336 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_int_literal_or_bind2367 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_int_literal_or_bind2379 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_sequence_node2405 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_SEQUENCE_in_drop_sequence_node2407 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_drop_sequence_node2411 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_sequence_node2415 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_sequence_node2421 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pk_constraint2450 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_CONSTRAINT_in_pk_constraint2453 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_pk_constraint2457 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_PRIMARY_in_pk_constraint2459 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_KEY_in_pk_constraint2461 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_pk_constraint2463 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_list_in_pk_constraint2467 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_pk_constraint2469 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2500 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_col_name_with_sort_order_rowtimestamp_list2506 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_col_name_with_sort_order_rowtimestamp_in_col_name_with_sort_order_rowtimestamp_list2512 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_col_name_with_sort_order_rowtimestamp2539 = new BitSet(new long[]{0x0000200000001002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_ASC_in_col_name_with_sort_order_rowtimestamp2544 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_DESC_in_col_name_with_sort_order_rowtimestamp2548 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_col_name_with_sort_order_rowtimestamp2555 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_list_in_ik_constraint2590 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2617 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_expression_with_sort_order_list2623 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_with_sort_order_in_expression_with_sort_order_list2629 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_expression_with_sort_order2656 = new BitSet(new long[]{0x0000200000001002L});
	public static final BitSet FOLLOW_ASC_in_expression_with_sort_order2662 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESC_in_expression_with_sort_order2666 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties2694 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_fam_properties2696 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000404000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties2700 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_fam_properties2706 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_fam_prop_name_in_fam_properties2710 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_fam_properties2712 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000404000000L});
	public static final BitSet FOLLOW_prop_value_in_fam_properties2716 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name2746 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name2760 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_fam_prop_name2762 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_fam_prop_name2766 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_value2797 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_prop_value2811 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name2842 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_column_name2856 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_column_name2858 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_column_name2862 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_column_names2894 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_column_names2900 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_name_in_column_names2906 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_DROP_in_drop_table_node2933 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200008000000L});
	public static final BitSet FOLLOW_VIEW_in_drop_table_node2938 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_TABLE_in_drop_table_node2942 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_drop_table_node2946 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_table_node2950 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_table_node2956 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_table_node2961 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_schema_node2996 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_SCHEMA_in_drop_schema_node2998 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_drop_schema_node3001 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_schema_node3005 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_schema_node3011 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_CASCADE_in_drop_schema_node3016 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_index_node3051 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_INDEX_in_drop_index_node3053 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_drop_index_node3056 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_index_node3060 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_index_name_in_drop_index_node3066 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_drop_index_node3068 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_drop_index_node3072 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_index_node3102 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_INDEX_in_alter_index_node3104 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_alter_index_node3107 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_index_node3111 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_index_name_in_alter_index_node3117 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_alter_index_node3119 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_index_node3123 = new BitSet(new long[]{0x0000800000000010L,0x0000000000000000L,0x0000011000000008L});
	public static final BitSet FOLLOW_set_in_alter_index_node3127 = new BitSet(new long[]{0x0000000000004002L});
	public static final BitSet FOLLOW_ASYNC_in_alter_index_node3150 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRACE_in_trace_node3184 = new BitSet(new long[]{0x0000000000000000L,0x0028000000000000L});
	public static final BitSet FOLLOW_ON_in_trace_node3192 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_WITH_in_trace_node3197 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_SAMPLING_in_trace_node3199 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000404000000L});
	public static final BitSet FOLLOW_sampling_rate_in_trace_node3205 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OFF_in_trace_node3216 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create_function_node3250 = new BitSet(new long[]{0x0000000000000000L,0x0100000000000080L,0x0000000040000000L});
	public static final BitSet FOLLOW_OR_in_create_function_node3253 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_REPLACE_in_create_function_node3257 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L,0x0000000040000000L});
	public static final BitSet FOLLOW_TEMPORARY_in_create_function_node3264 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_FUNCTION_in_create_function_node3268 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3272 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_create_function_node3283 = new BitSet(new long[]{0x0000000020000000L,0x0000080000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_zero_or_more_data_types_in_create_function_node3287 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_create_function_node3289 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_RETURNS_in_create_function_node3299 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_create_function_node3303 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_create_function_node3305 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000404000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3311 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_USING_in_create_function_node3322 = new BitSet(new long[]{0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_JAR_in_create_function_node3324 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000404000000L});
	public static final BitSet FOLLOW_jar_path_in_create_function_node3331 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_jar_path3368 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop_function_node3391 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_FUNCTION_in_drop_function_node3393 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_drop_function_node3396 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_drop_function_node3400 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_drop_function_node3406 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_add_jars_node3429 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_JARS_in_add_jars_node3431 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000404000000L});
	public static final BitSet FOLLOW_one_or_more_jarpaths_in_add_jars_node3437 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LIST_in_list_jars_node3460 = new BitSet(new long[]{0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_JARS_in_list_jars_node3462 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_jar_node3485 = new BitSet(new long[]{0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_JAR_in_delete_jar_node3487 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000404000000L});
	public static final BitSet FOLLOW_jar_path_in_delete_jar_node3493 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_session_node3519 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_SESSION_in_alter_session_node3521 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_SET_in_alter_session_node3524 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_properties_in_alter_session_node3528 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALTER_in_alter_table_node3562 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000200008000000L});
	public static final BitSet FOLLOW_TABLE_in_alter_table_node3565 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_VIEW_in_alter_table_node3571 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_alter_table_node3576 = new BitSet(new long[]{0x0040000000000020L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_DROP_in_alter_table_node3589 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_COLUMN_in_alter_table_node3591 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node3594 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node3598 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_names_in_alter_table_node3604 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_alter_table_node3610 = new BitSet(new long[]{0x0000000000000000L,0x0000080000001000L});
	public static final BitSet FOLLOW_IF_in_alter_table_node3613 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_NOT_in_alter_table_node3615 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_EXISTS_in_alter_table_node3619 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_defs_in_alter_table_node3626 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node3632 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SET_in_alter_table_node3640 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_fam_properties_in_alter_table_node3645 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_update_statistics_node3679 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_STATISTICS_in_update_statistics_node3681 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_update_statistics_node3685 = new BitSet(new long[]{0x0000000010000042L,0x0000000000080000L,0x0000000000040000L});
	public static final BitSet FOLLOW_INDEX_in_update_statistics_node3690 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_ALL_in_update_statistics_node3696 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_COLUMNS_in_update_statistics_node3702 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_SET_in_update_statistics_node3707 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_properties_in_update_statistics_node3712 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXECUTE_in_execute_upgrade_node3736 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_UPGRADE_in_execute_upgrade_node3738 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_prop_name3764 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prop_name_in_properties3798 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_properties3800 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000404000000L});
	public static final BitSet FOLLOW_prop_value_in_properties3804 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_properties3810 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_prop_name_in_properties3814 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_properties3816 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000404000000L});
	public static final BitSet FOLLOW_prop_value_in_properties3820 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_def_in_column_defs3855 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_column_defs3861 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_column_def_in_column_defs3867 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_column_def3893 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_column_def3897 = new BitSet(new long[]{0x0000040000000402L,0x0001801800000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_LPAREN_in_column_def3900 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def3904 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_column_def3907 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_column_def3911 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_column_def3915 = new BitSet(new long[]{0x0000040000000402L,0x0001801000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_ARRAY_in_column_def3921 = new BitSet(new long[]{0x0000040000000002L,0x0001801000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_LSQUARE_in_column_def3927 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_NUMBER_in_column_def3932 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_column_def3936 = new BitSet(new long[]{0x0000040000000002L,0x0001800000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_NOT_in_column_def3943 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NULL_in_column_def3948 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_DEFAULT_in_column_def3953 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_column_def3957 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_PRIMARY_in_column_def3964 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_KEY_in_column_def3966 = new BitSet(new long[]{0x0000200000001002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_ASC_in_column_def3971 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_DESC_in_column_def3975 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_ROW_TIMESTAMP_in_column_def3981 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4024 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_defs4030 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_dyn_column_def_in_dyn_column_defs4036 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_def4062 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_def4066 = new BitSet(new long[]{0x0000000000000402L,0x0000001800000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_def4069 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4073 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_def4076 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4080 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_def4084 = new BitSet(new long[]{0x0000000000000402L,0x0000001000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_def4090 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_def4096 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_def4101 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_def4105 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_column_name_in_dyn_column_name_or_def4142 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_dyn_column_name_or_def4147 = new BitSet(new long[]{0x0000000000000402L,0x0000001800000000L});
	public static final BitSet FOLLOW_LPAREN_in_dyn_column_name_or_def4150 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4154 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_dyn_column_name_or_def4157 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4161 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_dyn_column_name_or_def4165 = new BitSet(new long[]{0x0000000000000402L,0x0000001000000000L});
	public static final BitSet FOLLOW_ARRAY_in_dyn_column_name_or_def4171 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_dyn_column_name_or_def4177 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_NUMBER_in_dyn_column_name_or_def4182 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_dyn_column_name_or_def4186 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_subquery_expression4226 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_single_select4259 = new BitSet(new long[]{0x2009011000622440L,0x00059C8800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_hintClause_in_single_select4264 = new BitSet(new long[]{0x2009011000622440L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_DISTINCT_in_single_select4280 = new BitSet(new long[]{0x2008011000622400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_ALL_in_single_select4284 = new BitSet(new long[]{0x2008011000622400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_select_list_in_single_select4290 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000520L,0x0000800000000000L});
	public static final BitSet FOLLOW_FROM_in_single_select4301 = new BitSet(new long[]{0x0000000000020000L,0x0000080800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_parseFrom_in_single_select4305 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000500L,0x0000800000000000L});
	public static final BitSet FOLLOW_WHERE_in_single_select4318 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_single_select4322 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000500L});
	public static final BitSet FOLLOW_GROUP_in_single_select4335 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_single_select4337 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_group_by_in_single_select4341 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000400L});
	public static final BitSet FOLLOW_HAVING_in_single_select4354 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_single_select4358 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects4402 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_UNION_in_unioned_selects4407 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_ALL_in_unioned_selects4409 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_single_select_in_unioned_selects4413 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_unioned_selects_in_select_node4451 = new BitSet(new long[]{0x0000000000000002L,0x0210000100000002L});
	public static final BitSet FOLLOW_ORDER_in_select_node4462 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_select_node4464 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_order_by_in_select_node4468 = new BitSet(new long[]{0x0000000000000002L,0x0010000100000002L});
	public static final BitSet FOLLOW_LIMIT_in_select_node4481 = new BitSet(new long[]{0x0000000000020000L,0x0004000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_limit_in_select_node4485 = new BitSet(new long[]{0x0000000000000002L,0x0010000000000002L});
	public static final BitSet FOLLOW_OFFSET_in_select_node4498 = new BitSet(new long[]{0x0000000000020000L,0x0004000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_offset_in_select_node4502 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000002L,0x0000000000000180L});
	public static final BitSet FOLLOW_FETCH_in_select_node4524 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000008L});
	public static final BitSet FOLLOW_set_in_select_node4526 = new BitSet(new long[]{0x0000000000020000L,0x0004000000000000L,0x0000000000000182L});
	public static final BitSet FOLLOW_limit_in_select_node4537 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000180L});
	public static final BitSet FOLLOW_set_in_select_node4541 = new BitSet(new long[]{0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_ONLY_in_select_node4549 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPSERT_in_upsert_node4588 = new BitSet(new long[]{0x0000000000000000L,0x0000040000200000L});
	public static final BitSet FOLLOW_hintClause_in_upsert_node4593 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_INTO_in_upsert_node4597 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_upsert_node4601 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L,0x0000100000004000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node4612 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_upsert_column_refs_in_upsert_node4616 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node4618 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000004000L});
	public static final BitSet FOLLOW_VALUES_in_upsert_node4632 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_upsert_node4634 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_upsert_node4638 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_upsert_node4640 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_upsert_node4644 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_DUPLICATE_in_upsert_node4646 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_KEY_in_upsert_node4648 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000002000000000L});
	public static final BitSet FOLLOW_IGNORE_in_upsert_node4654 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UPDATE_in_upsert_node4660 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_update_column_pairs_in_upsert_node4664 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_select_node_in_upsert_node4679 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs4720 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_update_column_pairs4732 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_update_column_pair_in_update_column_pairs4736 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_column_name_in_update_column_pair4761 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_update_column_pair4763 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_update_column_pair4767 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4796 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_upsert_column_refs4809 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_dyn_column_name_or_def_in_upsert_column_refs4813 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_DECLARE_in_declare_cursor_node4841 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_cursor_name_in_declare_cursor_node4845 = new BitSet(new long[]{0x0000002000000000L});
	public static final BitSet FOLLOW_CURSOR_in_declare_cursor_node4847 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_declare_cursor_node4849 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_select_node_in_declare_cursor_node4853 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_in_cursor_open_node4887 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_open_node4891 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_in_cursor_close_node4918 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_close_node4922 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FETCH_in_cursor_fetch_node4948 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_NEXT_in_cursor_fetch_node4950 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000020L,0x0000000000000180L});
	public static final BitSet FOLLOW_NUMBER_in_cursor_fetch_node4955 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L,0x0000000000000180L});
	public static final BitSet FOLLOW_FROM_in_cursor_fetch_node4966 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_cursor_name_in_cursor_fetch_node4970 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete_node4996 = new BitSet(new long[]{0x0000000000000000L,0x0000040000000020L});
	public static final BitSet FOLLOW_hintClause_in_delete_node5001 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_FROM_in_delete_node5005 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_delete_node5009 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_WHERE_in_delete_node5020 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_delete_node5024 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L});
	public static final BitSet FOLLOW_ORDER_in_delete_node5037 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_delete_node5039 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_order_by_in_delete_node5043 = new BitSet(new long[]{0x0000000000000002L,0x0000000100000000L});
	public static final BitSet FOLLOW_LIMIT_in_delete_node5056 = new BitSet(new long[]{0x0000000000020000L,0x0004000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_limit_in_delete_node5060 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_limit5095 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_limit5107 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_offset5133 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_int_or_long_literal_in_offset5145 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_sampling_rate5170 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_tableSampleNode5195 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ML_HINT_in_hintClause5221 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectable_in_select_list5253 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_select_list5258 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_selectable_in_select_list5262 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_ASTERISK_in_select_list5274 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_selectable5303 = new BitSet(new long[]{0x0000000000000802L,0x0000080000000000L});
	public static final BitSet FOLLOW_parseAlias_in_selectable5308 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable5323 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5325 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable5327 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_selectable5342 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5344 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_selectable5348 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_selectable5350 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectable5352 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_group_by5385 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_group_by5398 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_group_by5404 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by5438 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_order_by5451 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_parseOrderByField_in_order_by5457 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_parseOrderByField5494 = new BitSet(new long[]{0x0000200000001002L,0x0002000000000000L});
	public static final BitSet FOLLOW_ASC_in_parseOrderByField5506 = new BitSet(new long[]{0x0000000000000002L,0x0002000000000000L});
	public static final BitSet FOLLOW_DESC_in_parseOrderByField5512 = new BitSet(new long[]{0x0000000000000002L,0x0002000000000000L});
	public static final BitSet FOLLOW_NULLS_in_parseOrderByField5527 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000008L});
	public static final BitSet FOLLOW_FIRST_in_parseOrderByField5530 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LAST_in_parseOrderByField5536 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_list_in_parseFrom5576 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_ref_in_table_list5607 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_table_list5612 = new BitSet(new long[]{0x0000000000020000L,0x0000080800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_table_ref_in_table_list5616 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_table_factor_in_table_ref5640 = new BitSet(new long[]{0x0000000000000002L,0x0000000022100040L,0x0000000000000040L});
	public static final BitSet FOLLOW_join_type_in_table_ref5647 = new BitSet(new long[]{0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_JOIN_in_table_ref5649 = new BitSet(new long[]{0x0000000000020000L,0x0000080800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_table_factor_in_table_ref5653 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_ON_in_table_ref5655 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_table_ref5659 = new BitSet(new long[]{0x0000000000000002L,0x0000000022100040L,0x0000000000000040L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor5683 = new BitSet(new long[]{0x0000000000020000L,0x0000080800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_table_list_in_table_factor5687 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor5689 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_table_factor5703 = new BitSet(new long[]{0x0000000000000802L,0x0000080000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor5707 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor5713 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_from_table_name_in_table_factor5730 = new BitSet(new long[]{0x0000000000000802L,0x0000080800000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_AS_in_table_factor5734 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor5740 = new BitSet(new long[]{0x0000000000000002L,0x0000000800000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor5745 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_dyn_column_defs_in_table_factor5749 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor5751 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_TABLESAMPLE_in_table_factor5756 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor5758 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000404000000L});
	public static final BitSet FOLLOW_tableSampleNode_in_table_factor5762 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor5764 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_table_factor5778 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_select_node_in_table_factor5782 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_table_factor5784 = new BitSet(new long[]{0x0000000000000802L,0x0000080000000000L});
	public static final BitSet FOLLOW_AS_in_table_factor5788 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_table_factor5794 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INNER_in_join_type5821 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEFT_in_join_type5836 = new BitSet(new long[]{0x0000000000000002L,0x0800000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type5838 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHT_in_join_type5853 = new BitSet(new long[]{0x0000000000000002L,0x0800000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type5855 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FULL_in_join_type5869 = new BitSet(new long[]{0x0000000000000002L,0x0800000000000000L});
	public static final BitSet FOLLOW_OUTER_in_join_type5872 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AS_in_parseAlias5903 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_parseNoReserved_in_parseAlias5908 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_or_expression_in_expression5936 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_and_expression_in_or_expression5968 = new BitSet(new long[]{0x0000000000000002L,0x0100000000000000L});
	public static final BitSet FOLLOW_OR_in_or_expression5973 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_and_expression_in_or_expression5977 = new BitSet(new long[]{0x0000000000000002L,0x0100000000000000L});
	public static final BitSet FOLLOW_not_expression_in_and_expression6013 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AND_in_and_expression6018 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_not_expression_in_and_expression6022 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_NOT_in_not_expression6064 = new BitSet(new long[]{0x2008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_boolean_expression_in_not_expression6069 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_not_expression6083 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_not_expression6086 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_not_expression6090 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_not_expression6092 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6112 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6119 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6126 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_comparison_op6133 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6135 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GT_in_comparison_op6142 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_comparison_op6144 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_comparison_op6151 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6182 = new BitSet(new long[]{0x0800000000010002L,0x0000E02080414200L});
	public static final BitSet FOLLOW_comparison_op_in_boolean_expression6188 = new BitSet(new long[]{0x0008011000620640L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6193 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6198 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6202 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6204 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6213 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6219 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6222 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6226 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6228 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_boolean_expression6238 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_ANY_in_boolean_expression6244 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6247 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6251 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6253 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_boolean_expression6283 = new BitSet(new long[]{0x0000000000000000L,0x0001800000000000L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression6287 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_NULL_in_boolean_expression6290 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_boolean_expression6321 = new BitSet(new long[]{0x0000000000010000L,0x0000000080014000L});
	public static final BitSet FOLLOW_LIKE_in_boolean_expression6326 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6330 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ILIKE_in_boolean_expression6368 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6372 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BETWEEN_in_boolean_expression6410 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6414 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_AND_in_boolean_expression6416 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_boolean_expression6420 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_boolean_expression6459 = new BitSet(new long[]{0x0000000000020000L,0x0000000800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_bind_expression_in_boolean_expression6465 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6506 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6510 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6512 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6553 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_boolean_expression6557 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6559 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXISTS_in_boolean_expression6659 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_boolean_expression6661 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_subquery_expression_in_boolean_expression6665 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_boolean_expression6667 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_bind_expression6695 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_expression_in_value_expression6726 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression6757 = new BitSet(new long[]{0x0000000000000002L,0x4000000000000000L});
	public static final BitSet FOLLOW_PLUS_in_add_expression6762 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_subtract_expression_in_add_expression6766 = new BitSet(new long[]{0x0000000000000002L,0x4000000000000000L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression6801 = new BitSet(new long[]{0x0000000000000002L,0x0000008000000000L});
	public static final BitSet FOLLOW_MINUS_in_subtract_expression6806 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_concat_expression_in_subtract_expression6810 = new BitSet(new long[]{0x0000000000000002L,0x0000008000000000L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression6845 = new BitSet(new long[]{0x0000000100000002L});
	public static final BitSet FOLLOW_CONCAT_in_concat_expression6850 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_multiply_divide_modulo_expression_in_concat_expression6854 = new BitSet(new long[]{0x0000000100000002L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression6889 = new BitSet(new long[]{0x0002000000002002L,0x2000000000000000L});
	public static final BitSet FOLLOW_set_in_multiply_divide_modulo_expression6905 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_negate_expression_in_multiply_divide_modulo_expression6919 = new BitSet(new long[]{0x0002000000002002L,0x2000000000000000L});
	public static final BitSet FOLLOW_USE_in_use_schema_node6962 = new BitSet(new long[]{0x0000040000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_DEFAULT_in_use_schema_node6965 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_use_schema_node6971 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_negate_expression7007 = new BitSet(new long[]{0x0008011000620400L,0x0005180800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_array_expression_in_negate_expression7012 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_array_expression7040 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_array_expression7043 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_array_expression7047 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_array_expression7049 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_or_bind_in_term7082 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7096 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ARRAY_in_term7110 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_term7112 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7116 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_term7118 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_table_name_in_term7132 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_term7134 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_term7138 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7152 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7154 = new BitSet(new long[]{0x2008011020620400L,0x0005988800000001L,0x0000000404000402L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7158 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7160 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_WITHIN_in_term7165 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_GROUP_in_term7167 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7169 = new BitSet(new long[]{0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_ORDER_in_term7171 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_BY_in_term7173 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7177 = new BitSet(new long[]{0x0000200000001000L});
	public static final BitSet FOLLOW_ASC_in_term7182 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_DESC_in_term7186 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7189 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7214 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7216 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_ASTERISK_in_term7220 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7222 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_term7246 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7248 = new BitSet(new long[]{0x0001000000000000L});
	public static final BitSet FOLLOW_DISTINCT_in_term7252 = new BitSet(new long[]{0x2008011020620400L,0x0005988800000001L,0x0000000404000402L});
	public static final BitSet FOLLOW_zero_or_more_expressions_in_term7256 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7258 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_case_statement_in_term7281 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_term7293 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_one_or_more_expressions_in_term7297 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7299 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CAST_in_term7317 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_LPAREN_in_term7319 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_term7323 = new BitSet(new long[]{0x0000000000000800L});
	public static final BitSet FOLLOW_AS_in_term7325 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_term7329 = new BitSet(new long[]{0x0000000000000400L,0x0000001800000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_LPAREN_in_term7332 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term7336 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_term7339 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_term7343 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7347 = new BitSet(new long[]{0x0000000000000400L,0x0000001000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_ARRAY_in_term7354 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_LSQUARE_in_term7359 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_term7361 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_term7366 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term7389 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_CURRENT_in_term7393 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_VALUE_in_term7396 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_term7398 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term7402 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEXT_in_term7430 = new BitSet(new long[]{0x0008010000020000L,0x0005080000000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_literal_or_bind_in_term7435 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_VALUES_in_term7437 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_FOR_in_term7439 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_from_table_name_in_term7443 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions7488 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_expressions7494 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_one_or_more_expressions7500 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths7531 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_one_or_more_jarpaths7537 = new BitSet(new long[]{0x0008010000000000L,0x0005080000000001L,0x0000000404000000L});
	public static final BitSet FOLLOW_jar_path_in_one_or_more_jarpaths7543 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions7576 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_expressions7584 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_zero_or_more_expressions7590 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types7621 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_COMMA_in_zero_or_more_data_types7628 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_function_argument_in_zero_or_more_data_types7634 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_identifier_in_function_argument7659 = new BitSet(new long[]{0x0000080200000402L,0x0000015800000000L});
	public static final BitSet FOLLOW_LPAREN_in_function_argument7662 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument7666 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_function_argument7669 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument7673 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_function_argument7677 = new BitSet(new long[]{0x0000080200000402L,0x0000015000000000L});
	public static final BitSet FOLLOW_ARRAY_in_function_argument7683 = new BitSet(new long[]{0x0000080200000002L,0x0000015000000000L});
	public static final BitSet FOLLOW_LSQUARE_in_function_argument7689 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_NUMBER_in_function_argument7694 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_RSQUARE_in_function_argument7698 = new BitSet(new long[]{0x0000080200000002L,0x0000014000000000L});
	public static final BitSet FOLLOW_CONSTANT_in_function_argument7707 = new BitSet(new long[]{0x0000080000000002L,0x0000014000000000L});
	public static final BitSet FOLLOW_DEFAULTVALUE_in_function_argument7712 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument7714 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_function_argument7720 = new BitSet(new long[]{0x0000000000000002L,0x0000014000000000L});
	public static final BitSet FOLLOW_MINVALUE_in_function_argument7725 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument7727 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_function_argument7733 = new BitSet(new long[]{0x0000000000000002L,0x0000004000000000L});
	public static final BitSet FOLLOW_MAXVALUE_in_function_argument7739 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_EQ_in_function_argument7741 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_function_argument7747 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_value_expression_list7777 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list7783 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_COMMA_in_value_expression_list7789 = new BitSet(new long[]{0x0008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_value_expression_in_value_expression_list7795 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_RPAREN_in_value_expression_list7802 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_index_name7823 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_cursor_name7850 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_table_name7878 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_table_name7892 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_table_name7894 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_table_name7898 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_from_table_name7926 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_from_table_name7940 = new BitSet(new long[]{0x0004000000000000L});
	public static final BitSet FOLLOW_DOT_in_from_table_name7942 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_identifier_in_from_table_name7946 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_literal_in_literal_or_bind7978 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_name_in_literal_or_bind7992 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal8024 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_literal8038 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_in_literal8052 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_in_literal8067 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NULL_in_literal8084 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_literal8096 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_literal8109 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_identifier_in_literal8123 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_literal8127 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_int_or_long_literal8158 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIND_NAME_in_bind_name8186 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_bind_name8199 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_parseNoReserved_in_identifier8228 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_parseNoReserved8255 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement8282 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8286 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement8289 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8293 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement8295 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8299 = new BitSet(new long[]{0x0300000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement8306 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8310 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement8316 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CASE_in_case_statement8326 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_WHEN_in_case_statement8329 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8333 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_THEN_in_case_statement8335 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8339 = new BitSet(new long[]{0x0300000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_ELSE_in_case_statement8346 = new BitSet(new long[]{0x2008011000620400L,0x0005988800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_expression_in_case_statement8350 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_END_in_case_statement8356 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_synpred1_PhoenixSQL6053 = new BitSet(new long[]{0x2008011000620400L,0x0005188800000001L,0x0000000404000002L});
	public static final BitSet FOLLOW_boolean_expression_in_synpred1_PhoenixSQL6056 = new BitSet(new long[]{0x0000000000000002L});
}
