/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.MutatingParallelIteratorFactory;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ProjectionCompiler;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.SubqueryRewriter;
import org.apache.phoenix.compile.SubselectRewriter;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexBuilder;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.QueryOptimizer;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.UpsertStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.DelegateColumn;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.UpsertColumnsValuesMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class UpsertCompiler {
    private final PhoenixStatement statement;
    private final PhoenixStatement.Operation operation;

    private static void setValues(byte[][] values, int[] pkSlotIndex, int[] columnIndexes, PTable table, Map<ImmutableBytesPtr, MutationState.RowMutationState> mutation, PhoenixStatement statement, boolean useServerTimestamp, IndexMaintainer maintainer, byte[][] viewConstants, byte[] onDupKeyBytes, int numSplColumns) throws SQLException {
        HashMap columnValues = Maps.newHashMapWithExpectedSize((int)columnIndexes.length);
        byte[][] pkValues = new byte[table.getPKColumns().size()][];
        if (table.getBucketNum() != null) {
            pkValues[0] = new byte[]{0};
        }
        for (int i = 0; i < numSplColumns; ++i) {
            pkValues[i + (table.getBucketNum() != null ? 1 : 0)] = values[i];
        }
        Long rowTimestamp = null;
        MutationState.RowTimestampColInfo rowTsColInfo = new MutationState.RowTimestampColInfo(useServerTimestamp, rowTimestamp);
        int i = 0;
        int j = numSplColumns;
        while (j < values.length) {
            byte[] value = values[j];
            PColumn column = table.getColumns().get(columnIndexes[i]);
            if (SchemaUtil.isPKColumn(column)) {
                pkValues[pkSlotIndex[i]] = value;
                if (SchemaUtil.getPKPosition(table, column) == table.getRowTimestampColPos() && !useServerTimestamp) {
                    PColumn rowTimestampCol = table.getPKColumns().get(table.getRowTimestampColPos());
                    rowTimestamp = PLong.INSTANCE.getCodec().decodeLong(value, 0, rowTimestampCol.getSortOrder());
                    if (rowTimestamp < 0L) {
                        throw new IllegalDataException("Value of a column designated as ROW_TIMESTAMP cannot be less than zero");
                    }
                    rowTsColInfo = new MutationState.RowTimestampColInfo(useServerTimestamp, rowTimestamp);
                }
            } else {
                columnValues.put(column, value);
            }
            ++j;
            ++i;
        }
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        table.newKey(ptr, pkValues);
        if (table.getIndexType() == PTable.IndexType.LOCAL && maintainer != null) {
            byte[] regionPrefix;
            byte[] rowKey = maintainer.buildDataRowKey(ptr, viewConstants);
            HRegionLocation region = statement.getConnection().getQueryServices().getTableRegionLocation(table.getParentName().getBytes(), rowKey);
            byte[] byArray = regionPrefix = region.getRegionInfo().getStartKey().length == 0 ? new byte[region.getRegionInfo().getEndKey().length] : region.getRegionInfo().getStartKey();
            if (regionPrefix.length != 0) {
                ptr.set(ScanRanges.prefixKey(ptr.get(), 0, regionPrefix, regionPrefix.length));
            }
        }
        mutation.put(ptr, new MutationState.RowMutationState(columnValues, statement.getConnection().getStatementExecutionCounter(), rowTsColInfo, onDupKeyBytes));
    }

    public static MutationState upsertSelect(StatementContext childContext, TableRef tableRef, RowProjector projector, ResultIterator iterator, int[] columnIndexes, int[] pkSlotIndexes, boolean useServerTimestamp, boolean prefixSysColValues) throws SQLException {
        PhoenixStatement statement = childContext.getStatement();
        PhoenixConnection connection = statement.getConnection();
        ConnectionQueryServices services = connection.getQueryServices();
        int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 250000);
        int maxSizeBytes = services.getProps().getInt("phoenix.mutate.maxSizeBytes", 50485760);
        int batchSize = Math.min(connection.getMutateBatchSize(), maxSize);
        boolean isAutoCommit = connection.getAutoCommit();
        int numSplColumns = (tableRef.getTable().isMultiTenant() ? 1 : 0) + (tableRef.getTable().getViewIndexId() != null ? 1 : 0);
        byte[][] values = new byte[columnIndexes.length + numSplColumns][];
        if (prefixSysColValues) {
            int i = 0;
            if (tableRef.getTable().isMultiTenant()) {
                values[i++] = connection.getTenantId().getBytes();
            }
            if (tableRef.getTable().getViewIndexId() != null) {
                values[i++] = PSmallint.INSTANCE.toBytes(tableRef.getTable().getViewIndexId());
            }
        }
        int rowCount = 0;
        HashMap mutation = Maps.newHashMapWithExpectedSize((int)batchSize);
        PTable table = tableRef.getTable();
        IndexMaintainer indexMaintainer = null;
        byte[][] viewConstants = null;
        if (table.getIndexType() == PTable.IndexType.LOCAL) {
            PTable parentTable = statement.getConnection().getMetaDataCache().getTableRef(new PTableKey(statement.getConnection().getTenantId(), table.getParentName().getString())).getTable();
            indexMaintainer = table.getIndexMaintainer(parentTable, connection);
            viewConstants = IndexUtil.getViewConstants(parentTable);
        }
        try (PhoenixResultSet rs = new PhoenixResultSet(iterator, projector, childContext);){
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            while (rs.next()) {
                int i = 0;
                int j = numSplColumns;
                while (j < values.length) {
                    Integer scale;
                    PColumn column = table.getColumns().get(columnIndexes[i]);
                    byte[] bytes = rs.getBytes(i + 1);
                    ptr.set(bytes == null ? ByteUtil.EMPTY_BYTE_ARRAY : bytes);
                    Object value = rs.getObject(i + 1);
                    int rsPrecision = rs.getMetaData().getPrecision(i + 1);
                    Integer precision = rsPrecision == 0 ? null : Integer.valueOf(rsPrecision);
                    int rsScale = rs.getMetaData().getScale(i + 1);
                    Integer n = scale = rsScale == 0 ? null : Integer.valueOf(rsScale);
                    if (!column.getDataType().isSizeCompatible(ptr, value, column.getDataType(), SortOrder.getDefault(), precision, scale, column.getMaxLength(), column.getScale())) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY).setColumnName(column.getName().getString()).setMessage("value=" + column.getDataType().toStringLiteral(ptr, (Format)null)).build().buildException();
                    }
                    column.getDataType().coerceBytes(ptr, value, column.getDataType(), precision, scale, SortOrder.getDefault(), column.getMaxLength(), column.getScale(), column.getSortOrder(), table.rowKeyOrderOptimizable());
                    values[j] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                    ++j;
                    ++i;
                }
                UpsertCompiler.setValues(values, pkSlotIndexes, columnIndexes, table, mutation, statement, useServerTimestamp, indexMaintainer, viewConstants, null, numSplColumns);
                if (!isAutoCommit || ++rowCount % batchSize != 0) continue;
                MutationState state2 = new MutationState(tableRef, mutation, 0L, maxSize, maxSizeBytes, connection);
                connection.getMutationState().join(state2);
                connection.getMutationState().send();
                mutation.clear();
            }
            MutationState mutationState = new MutationState(tableRef, mutation, rowCount / batchSize * batchSize, maxSize, maxSizeBytes, connection);
            return mutationState;
        }
    }

    public UpsertCompiler(PhoenixStatement statement, PhoenixStatement.Operation operation) {
        this.statement = statement;
        this.operation = operation;
    }

    private static LiteralParseNode getNodeForRowTimestampColumn(PColumn col) {
        PDataType type = col.getDataType();
        long dummyValue = 0L;
        if (type.isCoercibleTo(PTimestamp.INSTANCE)) {
            return new LiteralParseNode(new Timestamp(dummyValue), PTimestamp.INSTANCE);
        }
        if (type == PLong.INSTANCE || type == PUnsignedLong.INSTANCE) {
            return new LiteralParseNode(dummyValue, PLong.INSTANCE);
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    public MutationPlan compile(UpsertStatement upsert) throws SQLException {
        int nValuesToSet;
        ArrayList targetColumns;
        int[] pkSlotIndexesToBe;
        int[] columnIndexesToBe;
        final PhoenixConnection connection = this.statement.getConnection();
        ConnectionQueryServices services = connection.getQueryServices();
        final int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 250000);
        final int maxSizeBytes = services.getProps().getInt("phoenix.mutate.maxSizeBytes", 50485760);
        List<ColumnName> columnNodes = upsert.getColumns();
        TableRef tableRefToBe = null;
        PTable table = null;
        Set<Object> addViewColumnsToBe = Collections.emptySet();
        HashSet overlapViewColumnsToBe = Collections.emptySet();
        List<Object> allColumnsToBe = Collections.emptyList();
        boolean isTenantSpecific = false;
        boolean isSharedViewIndex = false;
        String tenantIdStr = null;
        ColumnResolver resolver = null;
        int nColumnsToSet = 0;
        List<ParseNode> valueNodes = upsert.getValues();
        NamedTableNode tableNode = upsert.getTable();
        String tableName = tableNode.getName().getTableName();
        String schemaName = tableNode.getName().getSchemaName();
        QueryPlan queryPlanToBe = null;
        boolean sameTable = false;
        boolean runOnServer = false;
        boolean serverUpsertSelectEnabled = services.getProps().getBoolean("phoenix.client.enable.server.upsert.select", false);
        UpsertingParallelIteratorFactory parallelIteratorFactoryToBe = null;
        boolean useServerTimestampToBe = false;
        resolver = FromCompiler.getResolverForMutation(upsert, connection);
        tableRefToBe = resolver.getTables().get(0);
        table = tableRefToBe.getTable();
        if (table.getType() == PTableType.VIEW && table.getViewType().isReadOnly()) {
            throw new ReadOnlyTableException(schemaName, tableName);
        }
        if (connection.isBuildingIndex() && table.getType() != PTableType.INDEX) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.ONLY_INDEX_UPDATABLE_AT_SCN).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
        if (table.isTransactional() && connection.getSCN() != null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SPECIFY_SCN_FOR_TXN_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
        boolean isSalted = table.getBucketNum() != null;
        isTenantSpecific = table.isMultiTenant() && connection.getTenantId() != null;
        isSharedViewIndex = table.getViewIndexId() != null;
        tenantIdStr = isTenantSpecific ? connection.getTenantId().getString() : null;
        int posOffset = isSalted ? 1 : 0;
        allColumnsToBe = table.getColumns();
        nColumnsToSet = 0;
        if (table.getViewType() == PTable.ViewType.UPDATABLE) {
            addViewColumnsToBe = Sets.newLinkedHashSetWithExpectedSize((int)allColumnsToBe.size());
            for (PColumn pColumn : allColumnsToBe) {
                if (pColumn.getViewConstant() == null) continue;
                addViewColumnsToBe.add(pColumn);
            }
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        if (columnNodes.isEmpty() || columnNodes.size() == upsert.getTable().getDynamicColumns().size()) {
            void var34_32;
            nColumnsToSet = allColumnsToBe.size() - posOffset;
            columnIndexesToBe = new int[nColumnsToSet];
            pkSlotIndexesToBe = new int[columnIndexesToBe.length];
            targetColumns = Lists.newArrayListWithExpectedSize((int)columnIndexesToBe.length);
            targetColumns.addAll(Collections.nCopies(columnIndexesToBe.length, null));
            int n = 0;
            if (isSharedViewIndex) {
                PColumn indexIdColumn = table.getPKColumns().get(n);
                columnIndexesToBe[n] = indexIdColumn.getPosition();
                targetColumns.set(n, indexIdColumn);
                ++var34_32;
            }
            if (isTenantSpecific) {
                void var34_33;
                PColumn tenantColumn = table.getPKColumns().get((int)var34_32);
                columnIndexesToBe[var34_32] = tenantColumn.getPosition();
                targetColumns.set((int)var34_32, tenantColumn);
                ++var34_33;
            }
            int j = 0;
            for (int i = posOffset; i < allColumnsToBe.size(); ++i) {
                int n2;
                PColumn column = (PColumn)allColumnsToBe.get(i);
                if (SchemaUtil.isPKColumn(column)) {
                    pkSlotIndexesToBe[i - posOffset] = j + posOffset;
                    if (j++ < n2) continue;
                    n2 = 0;
                }
                columnIndexesToBe[i - posOffset + n2] = i;
                targetColumns.set(i - posOffset + n2, column);
            }
            if (!addViewColumnsToBe.isEmpty()) {
                overlapViewColumnsToBe = addViewColumnsToBe;
                addViewColumnsToBe = Collections.emptySet();
            }
        } else {
            int n = columnNodes.size();
            nColumnsToSet = n + addViewColumnsToBe.size() + (isTenantSpecific ? 1 : 0) + (isSharedViewIndex ? 1 : 0);
            columnIndexesToBe = new int[nColumnsToSet];
            pkSlotIndexesToBe = new int[columnIndexesToBe.length];
            targetColumns = Lists.newArrayListWithExpectedSize((int)columnIndexesToBe.length);
            targetColumns.addAll(Collections.nCopies(columnIndexesToBe.length, null));
            Arrays.fill(columnIndexesToBe, -1);
            Arrays.fill(pkSlotIndexesToBe, -1);
            BitSet pkColumnsSet = new BitSet(table.getPKColumns().size());
            int i = 0;
            if (isSharedViewIndex) {
                PColumn indexIdColumn = table.getPKColumns().get(i + posOffset);
                columnIndexesToBe[i] = indexIdColumn.getPosition();
                pkSlotIndexesToBe[i] = i + posOffset;
                pkColumnsSet.set(pkSlotIndexesToBe[i]);
                targetColumns.set(i, indexIdColumn);
                ++i;
            }
            if (isTenantSpecific) {
                PColumn tenantColumn = table.getPKColumns().get(i + posOffset);
                columnIndexesToBe[i] = tenantColumn.getPosition();
                pkSlotIndexesToBe[i] = i + posOffset;
                pkColumnsSet.set(pkSlotIndexesToBe[i]);
                targetColumns.set(i, tenantColumn);
                ++i;
            }
            for (ColumnName columnName : columnNodes) {
                ColumnRef ref = resolver.resolveColumn(null, columnName.getFamilyName(), columnName.getColumnName());
                PColumn column = ref.getColumn();
                if (IndexUtil.getViewConstantValue(column, ptr)) {
                    if (overlapViewColumnsToBe.isEmpty()) {
                        overlapViewColumnsToBe = Sets.newHashSetWithExpectedSize((int)addViewColumnsToBe.size());
                    }
                    --nColumnsToSet;
                    overlapViewColumnsToBe.add(column);
                    addViewColumnsToBe.remove(column);
                }
                columnIndexesToBe[i] = ref.getColumnPosition();
                targetColumns.set(i, column);
                if (SchemaUtil.isPKColumn(column)) {
                    pkSlotIndexesToBe[i] = ref.getPKSlotPosition();
                    pkColumnsSet.set(pkSlotIndexesToBe[i]);
                }
                ++i;
            }
            for (PColumn pColumn : addViewColumnsToBe) {
                columnIndexesToBe[i] = pColumn.getPosition();
                targetColumns.set(i, pColumn);
                if (SchemaUtil.isPKColumn(pColumn)) {
                    pkSlotIndexesToBe[i] = SchemaUtil.getPKPosition(table, pColumn);
                    pkColumnsSet.set(pkSlotIndexesToBe[i]);
                }
                ++i;
            }
            boolean bl = useServerTimestampToBe = table.getRowTimestampColPos() != -1 && !UpsertCompiler.isRowTimestampSet(pkSlotIndexesToBe, table);
            if (useServerTimestampToBe) {
                PColumn rowTimestampCol = table.getPKColumns().get(table.getRowTimestampColPos());
                columnIndexesToBe = Arrays.copyOf(columnIndexesToBe, columnIndexesToBe.length + 1);
                pkSlotIndexesToBe = Arrays.copyOf(pkSlotIndexesToBe, pkSlotIndexesToBe.length + 1);
                columnIndexesToBe[i] = rowTimestampCol.getPosition();
                pkSlotIndexesToBe[i] = table.getRowTimestampColPos();
                pkColumnsSet.set(pkSlotIndexesToBe[i]);
                targetColumns.add(rowTimestampCol);
                if (valueNodes != null && !valueNodes.isEmpty()) {
                    valueNodes.add(UpsertCompiler.getNodeForRowTimestampColumn(rowTimestampCol));
                }
                ++nColumnsToSet;
            }
            for (i = posOffset; i < table.getPKColumns().size(); ++i) {
                PColumn pkCol = table.getPKColumns().get(i);
                if (pkColumnsSet.get(i) || pkCol.isNullable() || pkCol.getExpressionStr() != null) continue;
                throw new ConstraintViolationException(table.getName().getString() + "." + pkCol.getName().getString() + " may not be null");
            }
        }
        boolean bl = connection.getAutoCommit();
        if (valueNodes == null) {
            void var38_56;
            QueryCompiler compiler;
            SelectStatement select = upsert.getSelect();
            assert (select != null);
            select = SubselectRewriter.flatten(select, connection);
            ColumnResolver selectResolver = FromCompiler.getResolverForQuery(select, connection, false, upsert.getTable().getName());
            select = StatementNormalizer.normalize(select, selectResolver);
            SelectStatement transformedSelect = SubqueryRewriter.transform(select = UpsertCompiler.prependTenantAndViewConstants(table, select, tenantIdStr, addViewColumnsToBe, useServerTimestampToBe), selectResolver, connection);
            if (transformedSelect != select) {
                selectResolver = FromCompiler.getResolverForQuery(transformedSelect, connection, false, upsert.getTable().getName());
                select = StatementNormalizer.normalize(transformedSelect, selectResolver);
            }
            boolean bl2 = sameTable = !select.isJoin() && tableRefToBe.equals(selectResolver.getTables().get(0));
            if (!(select.isAggregate() || select.isDistinct() || select.getLimit() != null || select.hasSequence())) {
                parallelIteratorFactoryToBe = new UpsertingParallelIteratorFactory(connection, tableRefToBe, useServerTimestampToBe);
                boolean bl3 = SchemaUtil.hasGlobalIndex(table) && !table.isImmutableRows();
                runOnServer = (sameTable || serverUpsertSelectEnabled && !bl3) && bl && !table.isTransactional() && (!table.isImmutableRows() || table.getIndexes().isEmpty()) && !select.isJoin() && table.getRowTimestampColPos() == -1;
            }
            HintNode hintNode = upsert.getHint();
            if (!upsert.getHint().hasHint(HintNode.Hint.USE_INDEX_OVER_DATA_TABLE)) {
                HintNode hintNode2 = HintNode.create(hintNode, HintNode.Hint.USE_DATA_OVER_INDEX_TABLE);
            }
            if ((queryPlanToBe = (compiler = new QueryCompiler(this.statement, select = SelectStatement.create(select, (HintNode)var38_56), selectResolver, targetColumns, parallelIteratorFactoryToBe, new SequenceManager(this.statement), false)).compile()).getTableRef().getTable().getType() == PTableType.PROJECTED || queryPlanToBe.getTableRef().getTable().getType() == PTableType.SUBQUERY) {
                parallelIteratorFactoryToBe = null;
            }
            nValuesToSet = queryPlanToBe.getProjector().getColumnCount();
        } else {
            nValuesToSet = valueNodes.size() + addViewColumnsToBe.size() + (isTenantSpecific ? 1 : 0) + (isSharedViewIndex ? 1 : 0);
        }
        if (columnNodes.isEmpty() && columnIndexesToBe.length >= nValuesToSet) {
            nColumnsToSet = nValuesToSet;
            columnIndexesToBe = Arrays.copyOf(columnIndexesToBe, nValuesToSet);
            pkSlotIndexesToBe = Arrays.copyOf(pkSlotIndexesToBe, nValuesToSet);
        }
        if (nValuesToSet != nColumnsToSet) {
            throw new UpsertColumnsValuesMismatchException(schemaName, tableName, "Numbers of columns: " + nColumnsToSet + ". Number of values: " + nValuesToSet);
        }
        final QueryPlan originalQueryPlan = queryPlanToBe;
        RowProjector projectorToBe = null;
        if (valueNodes == null) {
            queryPlanToBe = new QueryOptimizer(services).optimize(queryPlanToBe, this.statement, targetColumns, parallelIteratorFactoryToBe);
            projectorToBe = queryPlanToBe.getProjector();
        }
        final List<Object> allColumns = allColumnsToBe;
        final RowProjector rowProjector = projectorToBe;
        final QueryPlan queryPlan = queryPlanToBe;
        final TableRef tableRef = tableRefToBe;
        final Set<Object> addViewColumns = addViewColumnsToBe;
        final LinkedHashSet overlapViewColumns = overlapViewColumnsToBe;
        final UpsertingParallelIteratorFactory parallelIteratorFactory = parallelIteratorFactoryToBe;
        final int[] columnIndexes = columnIndexesToBe;
        final int[] pkSlotIndexes = pkSlotIndexesToBe;
        final boolean useServerTimestamp = useServerTimestampToBe;
        if (table.getRowTimestampColPos() == -1 && useServerTimestamp) {
            throw new IllegalStateException("For a table without row timestamp column, useServerTimestamp cannot be true");
        }
        if (valueNodes == null) {
            UpsertCompiler.throwIfNotUpdatable(tableRef, overlapViewColumnsToBe, targetColumns, rowProjector, sameTable);
            if (runOnServer) {
                int[] allColumnsIndexes = Arrays.copyOf(columnIndexes, columnIndexes.length + nValuesToSet);
                int[] reverseColumnIndexes = new int[table.getColumns().size()];
                ArrayList projectedExpressions = Lists.newArrayListWithExpectedSize((int)reverseColumnIndexes.length);
                Arrays.fill(reverseColumnIndexes, -1);
                for (int i = 0; i < nValuesToSet; ++i) {
                    projectedExpressions.add(rowProjector.getColumnProjector(i).getExpression());
                    reverseColumnIndexes[columnIndexes[i]] = i;
                }
                int offset = table.getBucketNum() == null ? 0 : 1;
                for (int i = 0; i < table.getPKColumns().size() - offset; ++i) {
                    PColumn column = table.getPKColumns().get(i + offset);
                    int pos = reverseColumnIndexes[column.getPosition()];
                    if (pos == -1) {
                        if (column.getDataType().isFixedWidth()) continue;
                        pos = projectedExpressions.size();
                        LiteralExpression literalNull = LiteralExpression.newConstant(null, column.getDataType(), Determinism.ALWAYS);
                        projectedExpressions.add(literalNull);
                        allColumnsIndexes[pos] = column.getPosition();
                    }
                    Collections.swap(projectedExpressions, i, pos);
                    int tempPos = allColumnsIndexes[i];
                    allColumnsIndexes[i] = allColumnsIndexes[pos];
                    allColumnsIndexes[pos] = tempPos;
                    reverseColumnIndexes[tempPos] = pos;
                    reverseColumnIndexes[i] = i;
                }
                if (!serverUpsertSelectEnabled && ExpressionUtil.isPkPositionChanging(new TableRef(table), projectedExpressions)) {
                    runOnServer = false;
                }
                if (runOnServer) {
                    ArrayList projectedColumns = Lists.newArrayListWithExpectedSize((int)projectedExpressions.size());
                    int posOff = table.getBucketNum() != null ? 1 : 0;
                    for (int i = 0; i < projectedExpressions.size(); ++i) {
                        PColumn column = (PColumn)allColumns.get(allColumnsIndexes[i]);
                        projectedColumns.add(column.getPosition() == i + posOff ? column : new PColumnImpl(column, i + posOff));
                    }
                    PTableImpl projectedTable = PTableImpl.makePTable(table, projectedColumns, PNameFactory.newName(SchemaUtil.getEmptyColumnFamily(table)));
                    SelectStatement select = SelectStatement.create(SelectStatement.COUNT_ONE, upsert.getHint());
                    StatementContext statementContext = queryPlan.getContext();
                    RowProjector aggProjectorToBe = ProjectionCompiler.compile(statementContext, select, GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
                    statementContext.getAggregationManager().compile(queryPlan.getContext(), GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
                    if (queryPlan.getProjector().projectEveryRow()) {
                        aggProjectorToBe = new RowProjector(aggProjectorToBe, true);
                    }
                    final RowProjector aggProjector = aggProjectorToBe;
                    final StatementContext context = queryPlan.getContext();
                    final Scan scan = context.getScan();
                    scan.setAttribute("_UpsertSelectTable", UngroupedAggregateRegionObserver.serialize(projectedTable));
                    scan.setAttribute("_UpsertSelectExprs", UngroupedAggregateRegionObserver.serialize(projectedExpressions));
                    final AggregatePlan aggPlan = new AggregatePlan(context, select, statementContext.getCurrentTable(), aggProjector, null, null, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, null, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, null);
                    return new MutationPlan(){

                        @Override
                        public ParameterMetaData getParameterMetaData() {
                            return queryPlan.getContext().getBindManager().getParameterMetaData();
                        }

                        @Override
                        public StatementContext getContext() {
                            return queryPlan.getContext();
                        }

                        @Override
                        public TableRef getTargetRef() {
                            return tableRef;
                        }

                        @Override
                        public Set<TableRef> getSourceRefs() {
                            return originalQueryPlan.getSourceRefs();
                        }

                        @Override
                        public PhoenixStatement.Operation getOperation() {
                            return UpsertCompiler.this.operation;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public MutationState execute() throws SQLException {
                            byte[] txState;
                            ImmutableBytesWritable ptr = context.getTempPtr();
                            PTable table = tableRef.getTable();
                            table.getIndexMaintainers(ptr, context.getConnection());
                            byte[] byArray = txState = table.isTransactional() ? connection.getMutationState().encodeTransaction() : ByteUtil.EMPTY_BYTE_ARRAY;
                            if (ptr.getLength() > 0) {
                                byte[] uuidValue = ServerCacheClient.generateId();
                                scan.setAttribute("IdxUUID", uuidValue);
                                scan.setAttribute("IdxProtoMD", ptr.get());
                                scan.setAttribute("_TxState", txState);
                            }
                            try (ResultIterator iterator = aggPlan.iterator();){
                                Tuple row = iterator.next();
                                final long mutationCount = (Long)aggProjector.getColumnProjector(0).getValue(row, PLong.INSTANCE, ptr);
                                MutationState mutationState = new MutationState(maxSize, maxSizeBytes, connection){

                                    @Override
                                    public long getUpdateCount() {
                                        return mutationCount;
                                    }
                                };
                                return mutationState;
                            }
                        }

                        @Override
                        public ExplainPlan getExplainPlan() throws SQLException {
                            List<String> queryPlanSteps = aggPlan.getExplainPlan().getPlanSteps();
                            ArrayList planSteps = Lists.newArrayListWithExpectedSize((int)(queryPlanSteps.size() + 1));
                            planSteps.add("UPSERT ROWS");
                            planSteps.addAll(queryPlanSteps);
                            return new ExplainPlan(planSteps);
                        }

                        @Override
                        public Long getEstimatedRowsToScan() throws SQLException {
                            return aggPlan.getEstimatedRowsToScan();
                        }

                        @Override
                        public Long getEstimatedBytesToScan() throws SQLException {
                            return aggPlan.getEstimatedBytesToScan();
                        }

                        @Override
                        public Long getEstimateInfoTimestamp() throws SQLException {
                            return aggPlan.getEstimateInfoTimestamp();
                        }
                    };
                }
            }
            return new MutationPlan(){

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return queryPlan.getContext().getBindManager().getParameterMetaData();
                }

                @Override
                public StatementContext getContext() {
                    return queryPlan.getContext();
                }

                @Override
                public TableRef getTargetRef() {
                    return tableRef;
                }

                @Override
                public Set<TableRef> getSourceRefs() {
                    return originalQueryPlan.getSourceRefs();
                }

                @Override
                public PhoenixStatement.Operation getOperation() {
                    return UpsertCompiler.this.operation;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public MutationState execute() throws SQLException {
                    ResultIterator iterator = queryPlan.iterator();
                    if (parallelIteratorFactory == null) {
                        return UpsertCompiler.upsertSelect(new StatementContext(UpsertCompiler.this.statement), tableRef, rowProjector, iterator, columnIndexes, pkSlotIndexes, useServerTimestamp, false);
                    }
                    try {
                        Tuple tuple;
                        parallelIteratorFactory.setRowProjector(rowProjector);
                        parallelIteratorFactory.setColumnIndexes(columnIndexes);
                        parallelIteratorFactory.setPkSlotIndexes(pkSlotIndexes);
                        long totalRowCount = 0L;
                        StatementContext context = queryPlan.getContext();
                        while ((tuple = iterator.next()) != null) {
                            Cell kv = tuple.getValue(0);
                            totalRowCount += PLong.INSTANCE.getCodec().decodeLong(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault());
                        }
                        MutationState mutationState = new MutationState((long)maxSize, (long)maxSizeBytes, UpsertCompiler.this.statement.getConnection(), totalRowCount);
                        mutationState.setReadMetricQueue(context.getReadMetricsQueue());
                        MutationState mutationState2 = mutationState;
                        return mutationState2;
                    }
                    finally {
                        iterator.close();
                    }
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    List<String> queryPlanSteps = queryPlan.getExplainPlan().getPlanSteps();
                    ArrayList planSteps = Lists.newArrayListWithExpectedSize((int)(queryPlanSteps.size() + 1));
                    planSteps.add("UPSERT SELECT");
                    planSteps.addAll(queryPlanSteps);
                    return new ExplainPlan(planSteps);
                }

                @Override
                public Long getEstimatedRowsToScan() throws SQLException {
                    return queryPlan.getEstimatedRowsToScan();
                }

                @Override
                public Long getEstimatedBytesToScan() throws SQLException {
                    return queryPlan.getEstimatedBytesToScan();
                }

                @Override
                public Long getEstimateInfoTimestamp() throws SQLException {
                    return queryPlan.getEstimateInfoTimestamp();
                }
            };
        }
        final byte[][] values = new byte[nValuesToSet][];
        int nodeIndex = 0;
        if (isSharedViewIndex) {
            values[nodeIndex++] = MetaDataUtil.getViewIndexIdDataType().toBytes(table.getViewIndexId());
        }
        if (isTenantSpecific) {
            PName tenantId = connection.getTenantId();
            values[nodeIndex++] = ScanUtil.getTenantIdBytes(table.getRowKeySchema(), table.getBucketNum() != null, tenantId, isSharedViewIndex);
        }
        final int nodeIndexOffset = nodeIndex;
        final StatementContext context = new StatementContext(this.statement, resolver, new Scan(), new SequenceManager(this.statement));
        UpsertValuesCompiler expressionBuilder = new UpsertValuesCompiler(context);
        final ArrayList constantExpressions = Lists.newArrayListWithExpectedSize((int)valueNodes.size());
        for (ParseNode valueNode : valueNodes) {
            if (!valueNode.isStateless()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.VALUE_IN_UPSERT_NOT_CONSTANT).build().buildException();
            }
            PColumn column = (PColumn)allColumns.get(columnIndexes[nodeIndex]);
            expressionBuilder.setColumn(column);
            Expression expression = valueNode.accept(expressionBuilder);
            if (expression.getDataType() != null && !expression.getDataType().isCastableTo(column.getDataType())) {
                throw TypeMismatchException.newException(expression.getDataType(), column.getDataType(), "expression: " + expression.toString() + " in column " + column);
            }
            constantExpressions.add(expression);
            ++nodeIndex;
        }
        byte[] onDupKeyBytesToBe = null;
        List<Pair<ColumnName, ParseNode>> onDupKeyPairs = upsert.getOnDupKeyPairs();
        if (onDupKeyPairs != null) {
            if (table.isImmutableRows()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_USE_ON_DUP_KEY_FOR_IMMUTABLE).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
            }
            if (table.isTransactional()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_USE_ON_DUP_KEY_FOR_TRANSACTIONAL).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
            }
            if (connection.getSCN() != null) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_SCN_IN_ON_DUP_KEY).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
            }
            if (SchemaUtil.hasGlobalIndex(table)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_USE_ON_DUP_KEY_WITH_GLOBAL_IDX).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
            }
            if (onDupKeyPairs.isEmpty()) {
                onDupKeyBytesToBe = PhoenixIndexBuilder.serializeOnDupKeyIgnore();
            } else {
                int position = table.getBucketNum() == null ? 0 : 1;
                UpdateColumnCompiler compiler = new UpdateColumnCompiler(context);
                int nColumns = onDupKeyPairs.size();
                ArrayList updateExpressions = Lists.newArrayListWithExpectedSize((int)nColumns);
                LinkedHashSet updateColumns = Sets.newLinkedHashSetWithExpectedSize((int)(nColumns + 1));
                updateColumns.add(new PColumnImpl(table.getPKColumns().get(position).getName(), null, PVarbinary.INSTANCE, null, null, false, position, SortOrder.getDefault(), 0, null, false, null, false, false, null));
                ++position;
                for (Pair<ColumnName, ParseNode> columnPair : onDupKeyPairs) {
                    int columnPosition;
                    ColumnName colName = (ColumnName)columnPair.getFirst();
                    PColumn updateColumn = resolver.resolveColumn(null, colName.getFamilyName(), colName.getColumnName()).getColumn();
                    if (SchemaUtil.isPKColumn(updateColumn)) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_UPDATE_PK_ON_DUP_KEY).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).setColumnName(updateColumn.getName().getString()).build().buildException();
                    }
                    if (!updateColumns.add(new DelegateColumn(updateColumn, columnPosition = position++){
                        final /* synthetic */ int val$columnPosition;
                        {
                            this.val$columnPosition = n;
                            super(x0);
                        }

                        @Override
                        public int getPosition() {
                            return this.val$columnPosition;
                        }
                    })) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.DUPLICATE_COLUMN_IN_ON_DUP_KEY).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).setColumnName(updateColumn.getName().getString()).build().buildException();
                    }
                    ParseNode updateNode = (ParseNode)columnPair.getSecond();
                    compiler.setColumn(updateColumn);
                    Expression updateExpression = updateNode.accept(compiler);
                    if (updateExpression.getDataType() != null && !updateExpression.getDataType().isCastableTo(updateColumn.getDataType())) {
                        throw TypeMismatchException.newException(updateExpression.getDataType(), updateColumn.getDataType(), "expression: " + updateExpression.toString() + " for column " + updateColumn);
                    }
                    if (compiler.isAggregate()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.AGGREGATION_NOT_ALLOWED_IN_ON_DUP_KEY).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).setColumnName(updateColumn.getName().getString()).build().buildException();
                    }
                    updateExpressions.add(updateExpression);
                }
                PTableImpl onDupKeyTable = PTableImpl.makePTable(table, updateColumns);
                onDupKeyBytesToBe = PhoenixIndexBuilder.serializeOnDupKeyUpdate(onDupKeyTable, updateExpressions);
            }
        }
        final byte[] onDupKeyBytes = onDupKeyBytesToBe;
        return new MutationPlan(){

            @Override
            public ParameterMetaData getParameterMetaData() {
                return context.getBindManager().getParameterMetaData();
            }

            @Override
            public StatementContext getContext() {
                return context;
            }

            @Override
            public TableRef getTargetRef() {
                return tableRef;
            }

            @Override
            public Set<TableRef> getSourceRefs() {
                return Collections.emptySet();
            }

            @Override
            public PhoenixStatement.Operation getOperation() {
                return UpsertCompiler.this.operation;
            }

            @Override
            public MutationState execute() throws SQLException {
                ImmutableBytesWritable ptr = context.getTempPtr();
                SequenceManager sequenceManager = context.getSequenceManager();
                int nodeIndex = nodeIndexOffset;
                PTable table = tableRef.getTable();
                Tuple tuple = sequenceManager.getSequenceCount() == 0 ? null : sequenceManager.newSequenceTuple(null);
                for (Expression constantExpression : constantExpressions) {
                    PColumn column = (PColumn)allColumns.get(columnIndexes[nodeIndex]);
                    constantExpression.evaluate(tuple, ptr);
                    Object value = null;
                    if (constantExpression.getDataType() != null) {
                        value = constantExpression.getDataType().toObject(ptr, constantExpression.getSortOrder(), constantExpression.getMaxLength(), constantExpression.getScale());
                        if (!constantExpression.getDataType().isCoercibleTo(column.getDataType(), value)) {
                            throw TypeMismatchException.newException(constantExpression.getDataType(), column.getDataType(), "expression: " + constantExpression.toString() + " in column " + column);
                        }
                        if (!column.getDataType().isSizeCompatible(ptr, value, constantExpression.getDataType(), constantExpression.getSortOrder(), constantExpression.getMaxLength(), constantExpression.getScale(), column.getMaxLength(), column.getScale())) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY).setColumnName(column.getName().getString()).setMessage("value=" + constantExpression.toString()).build().buildException();
                        }
                    }
                    column.getDataType().coerceBytes(ptr, value, constantExpression.getDataType(), constantExpression.getMaxLength(), constantExpression.getScale(), constantExpression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder(), table.rowKeyOrderOptimizable());
                    if (overlapViewColumns.contains(column) && Bytes.compareTo((byte[])ptr.get(), (int)ptr.getOffset(), (int)ptr.getLength(), (byte[])column.getViewConstant(), (int)0, (int)(column.getViewConstant().length - 1)) != 0) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_UPDATE_VIEW_COLUMN).setColumnName(column.getName().getString()).setMessage("value=" + constantExpression.toString()).build().buildException();
                    }
                    values[nodeIndex] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                    ++nodeIndex;
                }
                for (PColumn column : addViewColumns) {
                    if (IndexUtil.getViewConstantValue(column, ptr)) {
                        values[nodeIndex++] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                        continue;
                    }
                    throw new IllegalStateException();
                }
                HashMap mutation = Maps.newHashMapWithExpectedSize((int)1);
                IndexMaintainer indexMaintainer = null;
                byte[][] viewConstants = null;
                if (table.getIndexType() == PTable.IndexType.LOCAL) {
                    PTable parentTable = UpsertCompiler.this.statement.getConnection().getMetaDataCache().getTableRef(new PTableKey(UpsertCompiler.this.statement.getConnection().getTenantId(), table.getParentName().getString())).getTable();
                    indexMaintainer = table.getIndexMaintainer(parentTable, connection);
                    viewConstants = IndexUtil.getViewConstants(parentTable);
                }
                UpsertCompiler.setValues(values, pkSlotIndexes, columnIndexes, table, mutation, UpsertCompiler.this.statement, useServerTimestamp, indexMaintainer, viewConstants, onDupKeyBytes, 0);
                return new MutationState(tableRef, mutation, 0L, maxSize, maxSizeBytes, connection);
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                ArrayList planSteps = Lists.newArrayListWithExpectedSize((int)2);
                if (context.getSequenceManager().getSequenceCount() > 0) {
                    planSteps.add("CLIENT RESERVE " + context.getSequenceManager().getSequenceCount() + " SEQUENCES");
                }
                planSteps.add("PUT SINGLE ROW");
                return new ExplainPlan(planSteps);
            }

            @Override
            public Long getEstimatedRowsToScan() throws SQLException {
                return 0L;
            }

            @Override
            public Long getEstimatedBytesToScan() throws SQLException {
                return 0L;
            }

            @Override
            public Long getEstimateInfoTimestamp() throws SQLException {
                return 0L;
            }
        };
    }

    private static boolean isRowTimestampSet(int[] pkSlotIndexes, PTable table) {
        Preconditions.checkArgument((table.getRowTimestampColPos() != -1 ? 1 : 0) != 0, (Object)"Call this method only for tables with row timestamp column");
        int rowTimestampColPKSlot = table.getRowTimestampColPos();
        for (int pkSlot : pkSlotIndexes) {
            if (pkSlot != rowTimestampColPKSlot) continue;
            return true;
        }
        return false;
    }

    private static SelectStatement prependTenantAndViewConstants(PTable table, SelectStatement select, String tenantId, Set<PColumn> addViewColumns, boolean useServerTimestamp) {
        if (!(table.isMultiTenant() && tenantId != null || table.getViewIndexId() != null || !addViewColumns.isEmpty() || useServerTimestamp)) {
            return select;
        }
        ArrayList selectNodes = Lists.newArrayListWithCapacity((int)(select.getSelect().size() + 1 + addViewColumns.size()));
        if (table.getViewIndexId() != null) {
            selectNodes.add(new AliasedNode(null, new LiteralParseNode(table.getViewIndexId())));
        }
        if (table.isMultiTenant() && tenantId != null) {
            selectNodes.add(new AliasedNode(null, new LiteralParseNode(tenantId)));
        }
        selectNodes.addAll(select.getSelect());
        for (PColumn column : addViewColumns) {
            byte[] byteValue = column.getViewConstant();
            Object value = column.getDataType().toObject(byteValue, 0, byteValue.length - 1);
            selectNodes.add(new AliasedNode(null, new LiteralParseNode(value)));
        }
        if (useServerTimestamp) {
            PColumn rowTimestampCol = table.getPKColumns().get(table.getRowTimestampColPos());
            selectNodes.add(new AliasedNode(null, UpsertCompiler.getNodeForRowTimestampColumn(rowTimestampCol)));
        }
        return SelectStatement.create(select, selectNodes);
    }

    private static void throwIfNotUpdatable(TableRef tableRef, Set<PColumn> overlapViewColumns, List<PColumn> targetColumns, RowProjector projector, boolean sameTable) throws SQLException {
        PTable table = tableRef.getTable();
        if (table.getViewType() == PTable.ViewType.UPDATABLE && !overlapViewColumns.isEmpty()) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            for (int i = 0; i < targetColumns.size(); ++i) {
                PColumn targetColumn = targetColumns.get(i);
                if (!overlapViewColumns.contains(targetColumn)) continue;
                Expression source = projector.getColumnProjector(i).getExpression();
                if (source.isStateless()) {
                    source.evaluate(null, ptr);
                    if (Bytes.compareTo((byte[])ptr.get(), (int)ptr.getOffset(), (int)ptr.getLength(), (byte[])targetColumn.getViewConstant(), (int)0, (int)(targetColumn.getViewConstant().length - 1)) == 0) continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_UPDATE_VIEW_COLUMN).setColumnName(targetColumn.getName().getString()).build().buildException();
            }
        }
    }

    private static class UpsertValuesCompiler
    extends UpdateColumnCompiler {
        private UpsertValuesCompiler(StatementContext context) {
            super(context);
        }

        @Override
        public Expression visit(SequenceValueParseNode node) throws SQLException {
            return this.context.getSequenceManager().newSequenceReference(node);
        }
    }

    private static class UpdateColumnCompiler
    extends ExpressionCompiler {
        private PColumn column;

        private UpdateColumnCompiler(StatementContext context) {
            super(context);
        }

        public void setColumn(PColumn column) {
            this.column = column;
        }

        @Override
        public Expression visit(BindParseNode node) throws SQLException {
            if (this.isTopLevel()) {
                this.context.getBindManager().addParamMetaData(node, this.column);
                Object value = this.context.getBindManager().getBindValue(node);
                return LiteralExpression.newConstant(value, this.column.getDataType(), this.column.getSortOrder(), Determinism.ALWAYS);
            }
            return super.visit(node);
        }

        @Override
        public Expression visit(LiteralParseNode node) throws SQLException {
            if (this.isTopLevel()) {
                return LiteralExpression.newConstant(node.getValue(), this.column.getDataType(), this.column.getSortOrder(), Determinism.ALWAYS);
            }
            return super.visit(node);
        }
    }

    private static class UpsertingParallelIteratorFactory
    extends MutatingParallelIteratorFactory {
        private RowProjector projector;
        private int[] columnIndexes;
        private int[] pkSlotIndexes;
        private final TableRef tableRef;
        private final boolean useSeverTimestamp;

        private UpsertingParallelIteratorFactory(PhoenixConnection connection, TableRef tableRef, boolean useServerTimestamp) {
            super(connection);
            this.tableRef = tableRef;
            this.useSeverTimestamp = useServerTimestamp;
        }

        @Override
        protected MutationState mutate(StatementContext parentContext, ResultIterator iterator, PhoenixConnection connection) throws SQLException {
            if (parentContext.getSequenceManager().getSequenceCount() > 0) {
                throw new IllegalStateException("Cannot pipeline upsert when sequence is referenced");
            }
            PhoenixStatement statement = new PhoenixStatement(connection);
            StatementContext childContext = new StatementContext(statement, false);
            MutationState state2 = UpsertCompiler.upsertSelect(childContext, this.tableRef, this.projector.cloneIfNecessary(), iterator, this.columnIndexes, this.pkSlotIndexes, this.useSeverTimestamp, false);
            return state2;
        }

        public void setRowProjector(RowProjector projector) {
            this.projector = projector;
        }

        public void setColumnIndexes(int[] columnIndexes) {
            this.columnIndexes = columnIndexes;
        }

        public void setPkSlotIndexes(int[] pkSlotIndexes) {
            this.pkSlotIndexes = pkSlotIndexes;
        }
    }
}

