/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.hbase.index.builder.IndexBuilder;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;

public class IndexBuildManager
implements Stoppable {
    private static final Log LOG = LogFactory.getLog(IndexBuildManager.class);
    private final IndexBuilder delegate;
    private boolean stopped;

    public IndexBuildManager(RegionCoprocessorEnvironment env) throws IOException {
        this.delegate = IndexBuildManager.getIndexBuilder(env);
    }

    private static IndexBuilder getIndexBuilder(RegionCoprocessorEnvironment e) throws IOException {
        Configuration conf = e.getConfiguration();
        Class builderClass = conf.getClass("index.builder", null, IndexBuilder.class);
        try {
            IndexBuilder builder = (IndexBuilder)builderClass.newInstance();
            builder.setup(e);
            return builder;
        }
        catch (InstantiationException e1) {
            throw new IOException("Couldn't instantiate index builder:" + builderClass + ", disabling indexing on table " + e.getRegion().getTableDesc().getNameAsString());
        }
        catch (IllegalAccessException e1) {
            throw new IOException("Couldn't instantiate index builder:" + builderClass + ", disabling indexing on table " + e.getRegion().getTableDesc().getNameAsString());
        }
    }

    public Collection<Pair<Mutation, byte[]>> getIndexUpdate(MiniBatchOperationInProgress<Mutation> miniBatchOp, Collection<? extends Mutation> mutations) throws Throwable {
        IndexMetaData indexMetaData = this.delegate.getIndexMetaData(miniBatchOp);
        this.delegate.batchStarted(miniBatchOp, indexMetaData);
        ArrayList<Pair<Mutation, byte[]>> results = new ArrayList<Pair<Mutation, byte[]>>(mutations.size());
        for (Mutation mutation : mutations) {
            Collection<Pair<Mutation, byte[]>> updates = this.delegate.getIndexUpdate(mutation, indexMetaData);
            results.addAll(updates);
        }
        return results;
    }

    public Collection<Pair<Mutation, byte[]>> getIndexUpdateForFilteredRows(Collection<KeyValue> filtered, IndexMetaData indexMetaData) throws IOException {
        return this.delegate.getIndexUpdateForFilteredRows(filtered, indexMetaData);
    }

    public void batchCompleted(MiniBatchOperationInProgress<Mutation> miniBatchOp) {
        this.delegate.batchCompleted(miniBatchOp);
    }

    public void batchStarted(MiniBatchOperationInProgress<Mutation> miniBatchOp, IndexMetaData indexMetaData) throws IOException {
        this.delegate.batchStarted(miniBatchOp, indexMetaData);
    }

    public boolean isEnabled(Mutation m) throws IOException {
        return this.delegate.isEnabled(m);
    }

    public boolean isAtomicOp(Mutation m) throws IOException {
        return this.delegate.isAtomicOp(m);
    }

    public List<Mutation> executeAtomicOp(Increment inc) throws IOException {
        return this.delegate.executeAtomicOp(inc);
    }

    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.delegate.stop(why);
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public IndexBuilder getBuilderForTesting() {
        return this.delegate;
    }

    public BaseScannerRegionObserver.ReplayWrite getReplayWrite(Mutation m) throws IOException {
        return this.delegate.getReplayWrite(m);
    }
}

