/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.scanner;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.covered.KeyValueStore;
import org.apache.phoenix.hbase.index.covered.filter.ApplyAndFilterDeletesFilter;
import org.apache.phoenix.hbase.index.covered.filter.ColumnTrackingNextLargestTimestampFilter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;
import org.apache.phoenix.hbase.index.scanner.EmptyScanner;
import org.apache.phoenix.hbase.index.scanner.FilteredKeyValueScanner;
import org.apache.phoenix.hbase.index.scanner.Scanner;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class ScannerBuilder {
    private KeyValueStore memstore;
    private Mutation update;

    public ScannerBuilder(KeyValueStore memstore, Mutation update) {
        this.memstore = memstore;
        this.update = update;
    }

    public CoveredDeleteScanner buildIndexedColumnScanner(Collection<? extends ColumnReference> indexedColumns, ColumnTracker tracker, long ts, boolean returnNullIfRowNotFound) {
        Filter columnFilters = this.getColumnFilters(indexedColumns);
        FilterList filters = new FilterList((List)Lists.newArrayList((Object[])new Filter[]{columnFilters}));
        filters.addFilter((Filter)new ColumnTrackingNextLargestTimestampFilter(ts, tracker));
        ApplyAndFilterDeletesFilter deleteFilter = new ApplyAndFilterDeletesFilter(this.getAllFamilies(indexedColumns));
        filters.addFilter((Filter)deleteFilter);
        return this.getFilteredScanner((Filter)filters, returnNullIfRowNotFound, deleteFilter.getDeleteTracker());
    }

    private Filter getColumnFilters(Collection<? extends ColumnReference> columns) {
        FilterList columnFilters = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        for (ColumnReference columnReference : columns) {
            FamilyFilter columnFilter = new FamilyFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(columnReference.getFamily()));
            if (!Bytes.equals((byte[])ColumnReference.ALL_QUALIFIERS, (byte[])columnReference.getQualifier())) {
                columnFilter = new FilterList(new Filter[]{columnFilter, new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(columnReference.getQualifier()))});
            }
            columnFilters.addFilter((Filter)columnFilter);
        }
        return columnFilters;
    }

    private Set<ImmutableBytesPtr> getAllFamilies(Collection<? extends ColumnReference> columns) {
        HashSet<ImmutableBytesPtr> families = new HashSet<ImmutableBytesPtr>();
        for (ColumnReference columnReference : columns) {
            families.add(columnReference.getFamilyWritable());
        }
        return families;
    }

    private CoveredDeleteScanner getFilteredScanner(Filter filters, boolean returnNullIfRowNotFound, final ApplyAndFilterDeletesFilter.DeleteTracker deleteTracker) {
        final FilteredKeyValueScanner kvScanner = new FilteredKeyValueScanner(filters, this.memstore);
        KeyValue start = KeyValueUtil.createFirstOnRow((byte[])this.update.getRow());
        try {
            if (!kvScanner.seek((Cell)start)) {
                return returnNullIfRowNotFound ? null : new EmptyScanner(deleteTracker);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to seek to first key from update on the memstore scanner!", e);
        }
        return new CoveredDeleteScanner(){

            @Override
            public Cell next() {
                try {
                    return kvScanner.next();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading kvs from local memstore!");
                }
            }

            @Override
            public boolean seek(Cell next) throws IOException {
                Cell peek = kvScanner.peek();
                if (peek != null) {
                    int compare = KeyValue.COMPARATOR.compare(peek, next);
                    if (compare < 0) {
                        return kvScanner.reseek(next);
                    }
                    if (compare == 0) {
                        return true;
                    }
                }
                return kvScanner.seek(next);
            }

            @Override
            public Cell peek() throws IOException {
                return kvScanner.peek();
            }

            @Override
            public void close() throws IOException {
                kvScanner.close();
            }

            @Override
            public ApplyAndFilterDeletesFilter.DeleteTracker getDeleteTracker() {
                return deleteTracker;
            }
        };
    }

    public static interface CoveredDeleteScanner
    extends Scanner {
        public ApplyAndFilterDeletesFilter.DeleteTracker getDeleteTracker();
    }
}

