/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.util;

import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.builder.IndexBuildingFailureException;
import org.apache.phoenix.hbase.index.covered.Batch;
import org.apache.phoenix.hbase.index.covered.data.LazyValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.scanner.ScannerBuilder;

public class IndexManagementUtil {
    public static final String INDEX_WAL_EDIT_CODEC_CLASS_NAME = "org.apache.hadoop.hbase.regionserver.wal.IndexedWALEditCodec";
    public static final String HLOG_READER_IMPL_KEY = "hbase.regionserver.hlog.reader.impl";
    public static final String WAL_EDIT_CODEC_CLASS_KEY = "hbase.regionserver.wal.codec";
    private static final String INDEX_HLOG_READER_CLASS_NAME = "org.apache.hadoop.hbase.regionserver.wal.IndexedHLogReader";
    private static final Log LOG = LogFactory.getLog(IndexManagementUtil.class);

    private IndexManagementUtil() {
    }

    public static boolean isWALEditCodecSet(Configuration conf) {
        try {
            Class.forName(INDEX_WAL_EDIT_CODEC_CLASS_NAME);
        }
        catch (Throwable t) {
            return false;
        }
        return INDEX_WAL_EDIT_CODEC_CLASS_NAME.equals(conf.get(WAL_EDIT_CODEC_CLASS_KEY, null));
    }

    public static void ensureMutableIndexingCorrectlyConfigured(Configuration conf) throws IllegalStateException {
        if (IndexManagementUtil.isWALEditCodecSet(conf)) {
            return;
        }
        String codecClass = INDEX_WAL_EDIT_CODEC_CLASS_NAME;
        String indexLogReaderName = INDEX_HLOG_READER_CLASS_NAME;
        try {
            Class.forName(indexLogReaderName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(codecClass + " is not installed, but " + indexLogReaderName + " hasn't been installed in hbase-site.xml under " + HLOG_READER_IMPL_KEY);
        }
        if (indexLogReaderName.equals(conf.get(HLOG_READER_IMPL_KEY, indexLogReaderName))) {
            if (conf.getBoolean("hbase.regionserver.wal.enablecompression", false)) {
                throw new IllegalStateException("WAL Compression is only supported with " + codecClass + ". You can install in hbase-site.xml, under " + WAL_EDIT_CODEC_CLASS_KEY);
            }
        } else {
            throw new IllegalStateException(codecClass + " is not installed, but " + indexLogReaderName + " hasn't been installed in hbase-site.xml under " + HLOG_READER_IMPL_KEY);
        }
    }

    public static ValueGetter createGetterFromScanner(ScannerBuilder.CoveredDeleteScanner scanner, byte[] currentRow) {
        return scanner != null ? new LazyValueGetter(scanner, currentRow) : null;
    }

    public static boolean updateMatchesColumns(Collection<KeyValue> update, List<ColumnReference> columns) {
        boolean matches = false;
        block0: for (KeyValue kv : update) {
            for (ColumnReference ref : columns) {
                if (!ref.matchesFamily(kv.getFamily()) || !ref.matchesQualifier(kv.getQualifier())) continue;
                matches = true;
                break block0;
            }
        }
        return matches;
    }

    public static boolean columnMatchesUpdate(List<ColumnReference> columns, Collection<KeyValue> update) {
        boolean matches = false;
        block0: for (ColumnReference ref : columns) {
            for (KeyValue kv : update) {
                if (!ref.matchesFamily(kv.getFamily()) || !ref.matchesQualifier(kv.getQualifier())) continue;
                matches = true;
                break block0;
            }
        }
        return matches;
    }

    public static Scan newLocalStateScan(List<? extends Iterable<? extends ColumnReference>> refsArray) {
        return IndexManagementUtil.newLocalStateScan(null, refsArray);
    }

    public static Scan newLocalStateScan(Scan scan, List<? extends Iterable<? extends ColumnReference>> refsArray) {
        Scan s = scan;
        if (scan == null) {
            s = new Scan();
        }
        s.setRaw(true);
        for (Iterable<? extends ColumnReference> iterable : refsArray) {
            for (ColumnReference columnReference : iterable) {
                s.addFamily(columnReference.getFamily());
            }
        }
        s.setMaxVersions();
        return s;
    }

    public static void rethrowIndexingException(Throwable e) throws IOException {
        try {
            throw e;
        }
        catch (IOException e1) {
            LOG.info((Object)("Rethrowing " + e));
            throw e1;
        }
        catch (Throwable e1) {
            LOG.info((Object)("Rethrowing " + e1 + " as a " + IndexBuildingFailureException.class.getSimpleName()));
            throw new IndexBuildingFailureException("Failed to build index for unexpected reason!", e1);
        }
    }

    public static void setIfNotSet(Configuration conf, String key, int value) {
        if (conf.get(key) == null) {
            conf.setInt(key, value);
        }
    }

    public static void createTimestampBatchesFromKeyValues(Collection<KeyValue> kvs, Map<Long, Batch> batches) {
        for (KeyValue kv : kvs) {
            long ts = kv.getTimestamp();
            Batch batch = batches.get(ts);
            if (batch == null) {
                batch = new Batch(ts);
                batches.put(ts, batch);
            }
            batch.add(kv);
        }
    }

    public static Collection<Batch> createTimestampBatchesFromMutation(Mutation m) {
        HashMap<Long, Batch> batches = new HashMap<Long, Batch>();
        for (List family : m.getFamilyCellMap().values()) {
            List familyKVs = KeyValueUtil.ensureKeyValues((List)family);
            IndexManagementUtil.createTimestampBatchesFromKeyValues(familyKVs, batches);
        }
        ArrayList<Batch> sorted = new ArrayList<Batch>(batches.values());
        Collections.sort(sorted, new Comparator<Batch>(){

            @Override
            public int compare(Batch o1, Batch o2) {
                return Longs.compare((long)o1.getTimestamp(), (long)o2.getTimestamp());
            }
        });
        return sorted;
    }

    public static Collection<? extends Mutation> flattenMutationsByTimestamp(Collection<? extends Mutation> mutations) {
        ArrayList flattenedMutations = Lists.newArrayListWithExpectedSize((int)(mutations.size() * 10));
        for (Mutation mutation : mutations) {
            byte[] row = mutation.getRow();
            Collection<Batch> batches = IndexManagementUtil.createTimestampBatchesFromMutation(mutation);
            for (Batch batch : batches) {
                Cell firstCell = (Cell)batch.getKvs().get(0);
                Object mWithSameTS = KeyValue.Type.codeToType((byte)firstCell.getTypeByte()) == KeyValue.Type.Put ? new Put(row) : new Delete(row);
                if (mutation.getAttributesMap() != null) {
                    for (Map.Entry entry : mutation.getAttributesMap().entrySet()) {
                        mWithSameTS.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
                    }
                }
                for (Cell cell : batch.getKvs()) {
                    byte[] fam = CellUtil.cloneFamily((Cell)cell);
                    List famCells = (List)mWithSameTS.getFamilyCellMap().get(fam);
                    if (famCells == null) {
                        famCells = Lists.newArrayList();
                        mWithSameTS.getFamilyCellMap().put(fam, famCells);
                    }
                    famCells.add(cell);
                }
                flattenedMutations.add(mWithSameTS);
            }
        }
        return flattenedMutations;
    }
}

