/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.util.List;
import org.apache.phoenix.iterate.MergeSortResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.TupleUtil;

public class MergeSortRowKeyResultIterator
extends MergeSortResultIterator {
    private final int keyOffset;
    private final int factor;

    public MergeSortRowKeyResultIterator(ResultIterators iterators) {
        this(iterators, 0, false);
    }

    public MergeSortRowKeyResultIterator(ResultIterators iterators, int keyOffset, boolean isReverse) {
        super(iterators);
        this.keyOffset = keyOffset;
        this.factor = isReverse ? -1 : 1;
    }

    @Override
    protected int compare(Tuple t1, Tuple t2) {
        return this.factor * TupleUtil.compare(t1, t2, this.tempPtr, this.keyOffset);
    }

    @Override
    public void explain(List<String> planSteps) {
        this.resultIterators.explain(planSteps);
        planSteps.add("CLIENT MERGE SORT");
    }

    public String toString() {
        return "MergeSortRowKeyResultIterator [keyOffset=" + this.keyOffset + ", factor=" + this.factor + "]";
    }
}

