/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.iterate.DelegateResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;

public class OffsetResultIterator
extends DelegateResultIterator {
    private int rowCount;
    private int offset;

    public OffsetResultIterator(ResultIterator delegate, Integer offset) {
        super(delegate);
        this.offset = offset == null ? -1 : offset;
    }

    @Override
    public Tuple next() throws SQLException {
        while (this.rowCount < this.offset) {
            if (super.next() == null) {
                return null;
            }
            ++this.rowCount;
        }
        return super.next();
    }

    @Override
    public void explain(List<String> planSteps) {
        super.explain(planSteps);
        planSteps.add("CLIENT OFFSET " + this.offset);
    }

    public String toString() {
        return "OffsetResultIterator [rowCount=" + this.rowCount + ", offset=" + this.offset + "]";
    }

    public Integer getRemainingOffset() {
        return this.offset - this.rowCount > 0 ? this.offset - this.rowCount : 0;
    }
}

