/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.memory;

import org.apache.http.annotation.GuardedBy;
import org.apache.http.annotation.ThreadSafe;
import org.apache.phoenix.memory.DelegatingMemoryManager;
import org.apache.phoenix.memory.InsufficientMemoryException;
import org.apache.phoenix.memory.MemoryManager;

@ThreadSafe
public class ChildMemoryManager
extends DelegatingMemoryManager {
    private final Object sync = new Object();
    private final int maxPercOfTotal;
    @GuardedBy(value="sync")
    private long allocatedBytes;

    public ChildMemoryManager(MemoryManager mm, int maxPercOfTotal) {
        super(mm);
        if (mm instanceof ChildMemoryManager) {
            throw new IllegalStateException("ChildMemoryManager cannot delegate to another ChildMemoryManager");
        }
        this.maxPercOfTotal = maxPercOfTotal;
        if (maxPercOfTotal <= 0 || maxPercOfTotal > 100) {
            throw new IllegalArgumentException("Max percentage of total memory (" + maxPercOfTotal + "%) must be greater than zero and less than or equal to 100");
        }
    }

    private long adjustAllocation(long minBytes, long reqBytes) {
        assert (reqBytes >= minBytes);
        long availBytes = this.getAvailableMemory();
        if (minBytes > availBytes) {
            throw new InsufficientMemoryException("Attempt to allocate more memory than the max allowed of " + this.maxPercOfTotal + "%");
        }
        return Math.min(reqBytes, availBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryManager.MemoryChunk allocate(long minBytes, long nBytes) {
        Object object = this.sync;
        synchronized (object) {
            nBytes = this.adjustAllocation(minBytes, nBytes);
            final MemoryManager.MemoryChunk chunk = super.allocate(minBytes, nBytes);
            this.allocatedBytes += chunk.getSize();
            return new MemoryManager.MemoryChunk(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    Object object = ChildMemoryManager.this.sync;
                    synchronized (object) {
                        ChildMemoryManager.this.allocatedBytes -= chunk.getSize();
                        chunk.close();
                    }
                }

                @Override
                public long getSize() {
                    return chunk.getSize();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void resize(long nBytes) {
                    Object object = ChildMemoryManager.this.sync;
                    synchronized (object) {
                        long size = this.getSize();
                        long deltaBytes = nBytes - size;
                        if (deltaBytes > 0L) {
                            ChildMemoryManager.this.adjustAllocation(deltaBytes, deltaBytes);
                        }
                        chunk.resize(nBytes);
                        ChildMemoryManager.this.allocatedBytes += deltaBytes;
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAvailableMemory() {
        Object object = this.sync;
        synchronized (object) {
            long availBytes = this.getMaxMemory() - this.allocatedBytes;
            if (availBytes < 0L) {
                throw new IllegalStateException("Available memory has become negative: " + availBytes + " bytes.  Allocated memory: " + this.allocatedBytes + " bytes.");
            }
            return availBytes;
        }
    }

    @Override
    public long getMaxMemory() {
        return (long)this.maxPercOfTotal * super.getMaxMemory() / 100L;
    }
}

