/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateQueryServices;
import org.apache.phoenix.query.GuidePostsCache;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PMetaDataImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SequenceAllocation;
import org.apache.phoenix.schema.SequenceAlreadyExistsException;
import org.apache.phoenix.schema.SequenceInfo;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.SequenceUtil;

public class ConnectionlessQueryServicesImpl
extends DelegateQueryServices
implements ConnectionQueryServices {
    private static ServerName SERVER_NAME = ServerName.parseServerName((String)"localhost:2181");
    private PMetaData metaData;
    private final Map<SequenceKey, SequenceInfo> sequenceMap = Maps.newHashMap();
    private final String userName;
    private KeyValueBuilder kvBuilder;
    private volatile boolean initialized;
    private volatile SQLException initializationException;
    private final Map<String, List<HRegionLocation>> tableSplits = Maps.newHashMap();
    private final GuidePostsCache guidePostsCache;
    private final Configuration config;

    public ConnectionlessQueryServicesImpl(QueryServices services, PhoenixEmbeddedDriver.ConnectionInfo connInfo, Properties info) {
        super(services);
        this.userName = connInfo.getPrincipal();
        this.metaData = this.newEmptyMetaData();
        this.kvBuilder = GenericKeyValueBuilder.INSTANCE;
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        for (Map.Entry entry : services.getProps()) {
            config.set(entry.getKey(), entry.getValue());
        }
        if (info != null) {
            for (Object key : info.keySet()) {
                config.set((String)key, info.getProperty((String)key));
            }
        }
        for (Map.Entry entry : connInfo.asProps()) {
            config.set((String)entry.getKey(), (String)entry.getValue());
        }
        this.config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration(config);
        TransactionFactory.getTransactionFactory().getTransactionContext().setInMemoryTransactionClient(config);
        this.guidePostsCache = new GuidePostsCache(this, config);
    }

    private PMetaData newEmptyMetaData() {
        return new PMetaDataImpl(100, this.getProps());
    }

    @Override
    public ConnectionQueryServices getChildQueryServices(ImmutableBytesWritable childId) {
        return this;
    }

    @Override
    public HTableInterface getTable(byte[] tableName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<HRegionLocation> getAllTableRegions(byte[] tableName) throws SQLException {
        List<HRegionLocation> regions = this.tableSplits.get(Bytes.toString((byte[])tableName));
        if (regions != null) {
            return regions;
        }
        return Collections.singletonList(new HRegionLocation(new HRegionInfo(TableName.valueOf((byte[])tableName), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW), SERVER_NAME, -1L));
    }

    @Override
    public void addTable(PTable table, long resolvedTime) throws SQLException {
        this.metaData.addTable(table, resolvedTime);
    }

    @Override
    public void updateResolvedTimestamp(PTable table, long resolvedTimestamp) throws SQLException {
        this.metaData.updateResolvedTimestamp(table, resolvedTimestamp);
    }

    @Override
    public void removeTable(PName tenantId, String tableName, String parentTableName, long tableTimeStamp) throws SQLException {
        this.metaData.removeTable(tenantId, tableName, parentTableName, tableTimeStamp);
    }

    @Override
    public void removeColumn(PName tenantId, String tableName, List<PColumn> columnsToRemove, long tableTimeStamp, long tableSeqNum, long resolvedTime) throws SQLException {
        this.metaData.removeColumn(tenantId, tableName, columnsToRemove, tableTimeStamp, tableSeqNum, resolvedTime);
    }

    @Override
    public PhoenixConnection connect(String url, Properties info) throws SQLException {
        return new PhoenixConnection(this, url, info, this.metaData.clone());
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getTable(PName tenantId, byte[] schemaBytes, byte[] tableBytes, long tableTimestamp, long clientTimestamp) throws SQLException {
        try {
            String fullTableName = SchemaUtil.getTableName(schemaBytes, tableBytes);
            PTable table = this.metaData.getTableRef(new PTableKey(tenantId, fullTableName)).getTable();
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, 0L, table, true);
        }
        catch (TableNotFoundException e) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, 0L, null);
        }
    }

    private static byte[] getTableName(List<Mutation> tableMetaData, byte[] physicalTableName) {
        if (physicalTableName != null) {
            return physicalTableName;
        }
        byte[][] rowKeyMetadata = new byte[3][];
        Mutation m = MetaDataUtil.getTableHeaderRow(tableMetaData);
        byte[] key = m.getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        return SchemaUtil.getTableNameAsBytes(schemaBytes, tableBytes);
    }

    private static List<HRegionLocation> generateRegionLocations(byte[] physicalName, byte[][] splits) {
        byte[] startKey = HConstants.EMPTY_START_ROW;
        ArrayList regions = Lists.newArrayListWithExpectedSize((int)splits.length);
        for (byte[] split : splits) {
            regions.add(new HRegionLocation(new HRegionInfo(TableName.valueOf((byte[])physicalName), startKey, split), SERVER_NAME, -1L));
            startKey = split;
        }
        regions.add(new HRegionLocation(new HRegionInfo(TableName.valueOf((byte[])physicalName), startKey, HConstants.EMPTY_END_ROW), SERVER_NAME, -1L));
        return regions;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createTable(List<Mutation> tableMetaData, byte[] physicalName, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean isNamespaceMapped, boolean allocateIndexId) throws SQLException {
        if (splits != null) {
            byte[] tableName = ConnectionlessQueryServicesImpl.getTableName(tableMetaData, physicalName);
            this.tableSplits.put(Bytes.toString((byte[])tableName), ConnectionlessQueryServicesImpl.generateRegionLocations(tableName, splits));
        }
        if (!allocateIndexId) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, 0L, null);
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, 0, null, Short.MIN_VALUE);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropTable(List<Mutation> tableMetadata, PTableType tableType, boolean cascade) throws SQLException {
        byte[] tableName = ConnectionlessQueryServicesImpl.getTableName(tableMetadata, null);
        this.tableSplits.remove(Bytes.toString((byte[])tableName));
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, 0L, null);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult addColumn(List<Mutation> tableMetaData, PTable table, Map<String, List<Pair<String, Object>>> properties, Set<String> colFamiliesForPColumnsToBeAdded, List<PColumn> columnsToBeAdded) throws SQLException {
        ArrayList columns = Lists.newArrayList(table.getColumns());
        columns.addAll(columnsToBeAdded);
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, 0L, PTableImpl.makePTable(table, columns));
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropColumn(List<Mutation> tableMetadata, PTableType tableType) throws SQLException {
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, 0L, null);
    }

    @Override
    public void clearTableFromCache(byte[] tenantId, byte[] schemaName, byte[] tableName, long clientTS) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init(String url, Properties props) throws SQLException {
        if (this.initialized) {
            if (this.initializationException == null) return;
            throw this.initializationException;
        }
        ConnectionlessQueryServicesImpl connectionlessQueryServicesImpl = this;
        synchronized (connectionlessQueryServicesImpl) {
            if (this.initialized) {
                if (this.initializationException == null) return;
                throw this.initializationException;
            }
            SQLException sqlE = null;
            PhoenixConnection metaConnection = null;
            try {
                Properties scnProps = PropertiesUtil.deepCopy(props);
                scnProps.setProperty("CurrentSCN", Long.toString(28L));
                scnProps.remove("TenantId");
                String globalUrl = JDBCUtil.removeProperty(url, "TenantId");
                metaConnection = new PhoenixConnection(this, globalUrl, scnProps, this.newEmptyMetaData());
                metaConnection.setRunningUpgrade(true);
                try {
                    metaConnection.createStatement().executeUpdate(QueryConstants.CREATE_TABLE_METADATA);
                }
                catch (TableAlreadyExistsException tableAlreadyExistsException) {
                    // empty catch block
                }
                try {
                    int nSaltBuckets = this.getSequenceSaltBuckets();
                    String createTableStatement = Sequence.getCreateTableStatement(nSaltBuckets);
                    metaConnection.createStatement().executeUpdate(createTableStatement);
                }
                catch (NewerTableAlreadyExistsException newerTableAlreadyExistsException) {
                    // empty catch block
                }
                try {
                    metaConnection.createStatement().executeUpdate(QueryConstants.CREATE_STATS_TABLE_METADATA);
                }
                catch (NewerTableAlreadyExistsException newerTableAlreadyExistsException) {
                    // empty catch block
                }
                try {
                    metaConnection.createStatement().executeUpdate(QueryConstants.CREATE_FUNCTION_METADATA);
                }
                catch (NewerTableAlreadyExistsException newerTableAlreadyExistsException) {
                    // empty catch block
                }
            }
            catch (SQLException e) {
                sqlE = e;
            }
            finally {
                try {
                    if (metaConnection != null) {
                        metaConnection.close();
                    }
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    } else {
                        sqlE = e;
                    }
                }
                finally {
                    try {
                        if (sqlE != null) {
                            this.initializationException = sqlE;
                            throw sqlE;
                        }
                    }
                    finally {
                        this.initialized = true;
                    }
                }
            }
            return;
        }
    }

    @Override
    public MutationState updateData(MutationPlan plan) throws SQLException {
        return new MutationState(0L, 0L, plan.getContext().getConnection());
    }

    @Override
    public int getLowestClusterHBaseVersion() {
        return Integer.MAX_VALUE;
    }

    @Override
    public HBaseAdmin getAdmin() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult updateIndexState(List<Mutation> tableMetadata, String parentTableName) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetadata.get(0).getRow(), rowKeyMetadata);
        Mutation m = MetaDataUtil.getTableHeaderRow(tableMetadata);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        if (!MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.INDEX_STATE_BYTES, this.kvBuilder, ptr)) {
            throw new IllegalStateException();
        }
        PIndexState newState = PIndexState.fromSerializedValue(ptr.get()[ptr.getOffset()]);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        String schemaName = Bytes.toString((byte[])rowKeyMetadata[1]);
        String indexName = Bytes.toString((byte[])rowKeyMetadata[2]);
        String indexTableName = SchemaUtil.getTableName(schemaName, indexName);
        PName tenantId = tenantIdBytes.length == 0 ? null : PNameFactory.newName(tenantIdBytes);
        PTable index = this.metaData.getTableRef(new PTableKey(tenantId, indexTableName)).getTable();
        index = PTableImpl.makePTable(index, newState == PIndexState.USABLE ? PIndexState.ACTIVE : (newState == PIndexState.UNUSABLE ? PIndexState.INACTIVE : newState));
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, 0L, index);
    }

    @Override
    public HTableDescriptor getTableDescriptor(byte[] tableName) throws SQLException {
        return null;
    }

    @Override
    public void clearTableRegionCache(byte[] tableName) throws SQLException {
    }

    @Override
    public boolean hasIndexWALCodec() {
        return true;
    }

    @Override
    public long createSequence(String tenantId, String schemaName, String sequenceName, long startWith, long incrementBy, long cacheSize, long minValue, long maxValue, boolean cycle, long timestamp) throws SQLException {
        SequenceKey key = new SequenceKey(tenantId, schemaName, sequenceName, this.getSequenceSaltBuckets());
        if (this.sequenceMap.get(key) != null) {
            throw new SequenceAlreadyExistsException(schemaName, sequenceName);
        }
        this.sequenceMap.put(key, new SequenceInfo(startWith, incrementBy, minValue, maxValue, 1L, cycle));
        return timestamp;
    }

    @Override
    public long dropSequence(String tenantId, String schemaName, String sequenceName, long timestamp) throws SQLException {
        SequenceKey key = new SequenceKey(tenantId, schemaName, sequenceName, this.getSequenceSaltBuckets());
        if (this.sequenceMap.remove(key) == null) {
            throw new SequenceNotFoundException(schemaName, sequenceName);
        }
        return timestamp;
    }

    @Override
    public void validateSequences(List<SequenceAllocation> sequenceAllocations, long timestamp, long[] values, SQLException[] exceptions, Sequence.ValueOp action) throws SQLException {
        int i = 0;
        for (SequenceAllocation sequenceAllocation : sequenceAllocations) {
            SequenceInfo info = this.sequenceMap.get(sequenceAllocation.getSequenceKey());
            if (info == null) {
                exceptions[i] = new SequenceNotFoundException(sequenceAllocation.getSequenceKey().getSchemaName(), sequenceAllocation.getSequenceKey().getSequenceName());
            } else {
                values[i] = info.sequenceValue;
            }
            ++i;
        }
    }

    @Override
    public void incrementSequences(List<SequenceAllocation> sequenceAllocations, long timestamp, long[] values, SQLException[] exceptions) throws SQLException {
        int i = 0;
        for (SequenceAllocation sequenceAllocation : sequenceAllocations) {
            SequenceKey key = sequenceAllocation.getSequenceKey();
            SequenceInfo info = this.sequenceMap.get(key);
            if (info == null) {
                exceptions[i] = new SequenceNotFoundException(key.getSchemaName(), key.getSequenceName());
            } else {
                boolean increaseSeq;
                boolean bl = increaseSeq = info.incrementBy > 0L;
                if (info.limitReached) {
                    SQLExceptionCode code = increaseSeq ? SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE : SQLExceptionCode.SEQUENCE_VAL_REACHED_MIN_VALUE;
                    exceptions[i] = new SQLExceptionInfo.Builder(code).build().buildException();
                } else {
                    values[i] = info.sequenceValue;
                    info.sequenceValue += info.incrementBy * info.cacheSize;
                    info.limitReached = SequenceUtil.checkIfLimitReached(info);
                    if (info.limitReached && info.cycle) {
                        info.sequenceValue = increaseSeq ? info.minValue : info.maxValue;
                        info.limitReached = false;
                    }
                }
            }
            ++i;
        }
        i = 0;
        for (SQLException e : exceptions) {
            if (e != null) {
                this.sequenceMap.remove(sequenceAllocations.get(i).getSequenceKey());
            }
            ++i;
        }
    }

    @Override
    public long currentSequenceValue(SequenceKey sequenceKey, long timestamp) throws SQLException {
        SequenceInfo info = this.sequenceMap.get(sequenceKey);
        if (info == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        return info.sequenceValue;
    }

    @Override
    public void returnSequences(List<SequenceKey> sequenceKeys, long timestamp, SQLException[] exceptions) throws SQLException {
    }

    @Override
    public void addConnection(PhoenixConnection connection) throws SQLException {
    }

    @Override
    public void removeConnection(PhoenixConnection connection) throws SQLException {
    }

    @Override
    public KeyValueBuilder getKeyValueBuilder() {
        return this.kvBuilder;
    }

    @Override
    public boolean supportsFeature(ConnectionQueryServices.Feature feature) {
        return true;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public GuidePostsInfo getTableStats(GuidePostsKey key) {
        GuidePostsInfo info = (GuidePostsInfo)this.guidePostsCache.getCache().getIfPresent((Object)key);
        if (null == info) {
            return GuidePostsInfo.NO_GUIDEPOST;
        }
        return info;
    }

    @Override
    public long clearCache() throws SQLException {
        return 0L;
    }

    @Override
    public int getSequenceSaltBuckets() {
        return this.getProps().getInt("phoenix.sequence.saltBuckets", 0);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createFunction(List<Mutation> functionData, PFunction function, boolean temporary) throws SQLException {
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, 0L, null);
    }

    @Override
    public void addFunction(PFunction function) throws SQLException {
        this.metaData.addFunction(function);
    }

    @Override
    public void removeFunction(PName tenantId, String function, long functionTimeStamp) throws SQLException {
        this.metaData.removeFunction(tenantId, function, functionTimeStamp);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getFunctions(PName tenantId, List<Pair<byte[], Long>> functionNameAndTimeStampPairs, long clientTimestamp) throws SQLException {
        ArrayList<PFunction> functions = new ArrayList<PFunction>(functionNameAndTimeStampPairs.size());
        for (Pair<byte[], Long> functionInfo : functionNameAndTimeStampPairs) {
            try {
                PFunction function2 = this.metaData.getFunction(new PTableKey(tenantId, Bytes.toString((byte[])((byte[])functionInfo.getFirst()))));
                functions.add(function2);
            }
            catch (FunctionNotFoundException e) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, 0L, null);
            }
        }
        if (functions.isEmpty()) {
            return null;
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS, 0L, functions, true);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropFunction(List<Mutation> tableMetadata, boolean ifExists) throws SQLException {
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS, 0L, null);
    }

    @Override
    public long getRenewLeaseThresholdMilliSeconds() {
        return 0L;
    }

    @Override
    public boolean isRenewingLeasesEnabled() {
        return false;
    }

    @Override
    public HRegionLocation getTableRegionLocation(byte[] tableName, byte[] row) throws SQLException {
        List<HRegionLocation> regions = this.tableSplits.get(Bytes.toString((byte[])tableName));
        if (regions != null) {
            for (HRegionLocation region : regions) {
                if (Bytes.compareTo((byte[])region.getRegionInfo().getStartKey(), (byte[])row) > 0 || Bytes.compareTo((byte[])region.getRegionInfo().getEndKey(), (byte[])row) <= 0) continue;
                return region;
            }
        }
        return new HRegionLocation(new HRegionInfo(TableName.valueOf((byte[])tableName), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW), SERVER_NAME, -1L);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createSchema(List<Mutation> schemaMutations, String schemaName) {
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_NOT_FOUND, 0L, null);
    }

    @Override
    public void addSchema(PSchema schema) throws SQLException {
        this.metaData.addSchema(schema);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getSchema(String schemaName, long clientTimestamp) throws SQLException {
        try {
            PSchema schema = this.metaData.getSchema(new PTableKey(null, schemaName));
            new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_ALREADY_EXISTS, schema, 0L);
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            // empty catch block
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_NOT_FOUND, 0L, null);
    }

    @Override
    public void removeSchema(PSchema schema, long schemaTimeStamp) {
        this.metaData.removeSchema(schema, schemaTimeStamp);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropSchema(List<Mutation> schemaMetaData, String schemaName) {
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_ALREADY_EXISTS, 0L, null);
    }

    public void addTableStats(GuidePostsKey key, GuidePostsInfo info) {
        this.guidePostsCache.put(Objects.requireNonNull(key), info);
    }

    @Override
    public void invalidateStats(GuidePostsKey key) {
        this.guidePostsCache.invalidate(Objects.requireNonNull(key));
    }

    @Override
    public void upgradeSystemTables(String url, Properties props) throws SQLException {
    }

    @Override
    public boolean isUpgradeRequired() {
        return false;
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }
}

