/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.replication;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.phoenix.util.SchemaUtil;

public class SystemCatalogWALEntryFilter
implements WALEntryFilter {
    public WAL.Entry filter(WAL.Entry entry) {
        if (!SchemaUtil.isMetaTable(entry.getKey().getTablename().getName())) {
            return entry;
        }
        ArrayList cells = entry.getEdit().getCells();
        ArrayList cellsToRemove = Lists.newArrayList();
        for (Cell cell : cells) {
            if (this.isTenantRowCell(cell)) continue;
            cellsToRemove.add(cell);
        }
        cells.removeAll(cellsToRemove);
        if (cells.size() > 0) {
            return entry;
        }
        return null;
    }

    private boolean isTenantRowCell(Cell cell) {
        ImmutableBytesWritable key = new ImmutableBytesWritable(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
        return key.get()[key.getOffset()] != 0;
    }
}

