/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexStatementRewriter;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.SubselectRewriter;
import org.apache.phoenix.compile.TupleProjectionCompiler;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.BindTableNode;
import org.apache.phoenix.parse.BooleanParseNodeVisitor;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.ConcreteTableNode;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.EqualParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.IndexExpressionParseNodeRewriter;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.ParseNodeRewriter;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.StatelessTraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableNodeVisitor;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.LocalIndexDataColumnRef;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ProjectedColumn;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

public class JoinCompiler {
    private final PhoenixStatement statement;
    private final SelectStatement select;
    private final ColumnResolver origResolver;
    private final boolean useStarJoin;
    private final Map<ColumnRef, ColumnRefType> columnRefs;
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();

    private JoinCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver) {
        this.statement = statement;
        this.select = select;
        this.origResolver = resolver;
        this.useStarJoin = !select.getHint().hasHint(HintNode.Hint.NO_STAR_JOIN);
        this.columnRefs = new HashMap<ColumnRef, ColumnRefType>();
    }

    public static JoinTable compile(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver) throws SQLException {
        JoinTable joinTable;
        JoinTable joinTable2;
        JoinCompiler compiler;
        JoinCompiler joinCompiler = compiler = new JoinCompiler(statement, select, resolver);
        joinCompiler.getClass();
        JoinTableConstructor constructor = joinCompiler.new JoinTableConstructor();
        Pair<Table, List<JoinSpec>> res = select.getFrom().accept(constructor);
        if (res.getSecond() == null) {
            JoinCompiler joinCompiler2 = compiler;
            joinCompiler2.getClass();
            joinTable2 = joinCompiler2.new JoinTable((Table)res.getFirst());
        } else {
            JoinCompiler joinCompiler3 = compiler;
            joinCompiler3.getClass();
            joinTable2 = joinTable = joinCompiler3.new JoinTable((Table)res.getFirst(), (List)res.getSecond());
        }
        if (select.getWhere() != null) {
            joinTable.addFilter(select.getWhere());
        }
        ColumnRefParseNodeVisitor generalRefVisitor = new ColumnRefParseNodeVisitor(resolver, statement.getConnection());
        ColumnRefParseNodeVisitor joinLocalRefVisitor = new ColumnRefParseNodeVisitor(resolver, statement.getConnection());
        ColumnRefParseNodeVisitor prefilterRefVisitor = new ColumnRefParseNodeVisitor(resolver, statement.getConnection());
        joinTable.pushDownColumnRefVisitors(generalRefVisitor, joinLocalRefVisitor, prefilterRefVisitor);
        for (AliasedNode aliasedNode : select.getSelect()) {
            aliasedNode.getNode().accept(generalRefVisitor);
        }
        if (select.getGroupBy() != null) {
            for (ParseNode parseNode : select.getGroupBy()) {
                parseNode.accept(generalRefVisitor);
            }
        }
        if (select.getHaving() != null) {
            select.getHaving().accept(generalRefVisitor);
        }
        if (select.getOrderBy() != null) {
            for (OrderByNode orderByNode : select.getOrderBy()) {
                orderByNode.getNode().accept(generalRefVisitor);
            }
        }
        for (ColumnRef columnRef : generalRefVisitor.getColumnRefMap().keySet()) {
            compiler.columnRefs.put(columnRef, ColumnRefType.GENERAL);
        }
        for (ColumnRef columnRef : joinLocalRefVisitor.getColumnRefMap().keySet()) {
            if (compiler.columnRefs.containsKey(columnRef)) continue;
            compiler.columnRefs.put(columnRef, ColumnRefType.JOINLOCAL);
        }
        return joinTable;
    }

    private static boolean isFlat(SelectStatement select) {
        return !select.isJoin() && !select.isAggregate() && !select.isDistinct() && !(select.getFrom() instanceof DerivedTableNode) && select.getLimit() == null && select.getOffset() == null;
    }

    private static ParseNode combine(List<ParseNode> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        return NODE_FACTORY.and(nodes);
    }

    private List<AliasedNode> extractFromSelect(List<AliasedNode> select, TableRef tableRef, ColumnResolver resolver) throws SQLException {
        ArrayList<AliasedNode> ret = new ArrayList<AliasedNode>();
        ColumnRefParseNodeVisitor visitor = new ColumnRefParseNodeVisitor(resolver, this.statement.getConnection());
        for (AliasedNode aliasedNode : select) {
            ParseNode node = aliasedNode.getNode();
            if (node instanceof TableWildcardParseNode) {
                TableName tableName = ((TableWildcardParseNode)node).getTableName();
                if (!tableRef.equals(resolver.resolveTable(tableName.getSchemaName(), tableName.getTableName()))) continue;
                ret.clear();
                ret.add(aliasedNode);
                return ret;
            }
            node.accept(visitor);
            ColumnRefParseNodeVisitor.ColumnRefType type = visitor.getContentType(Collections.singletonList(tableRef));
            if (type == ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY) {
                ret.add(aliasedNode);
            } else if (type == ColumnRefParseNodeVisitor.ColumnRefType.COMPLEX) {
                for (Map.Entry<ColumnRef, ColumnParseNode> entry : visitor.getColumnRefMap().entrySet()) {
                    if (!entry.getKey().getTableRef().equals(tableRef)) continue;
                    ret.add(NODE_FACTORY.aliasedNode(null, entry.getValue()));
                }
            }
            visitor.reset();
        }
        return ret;
    }

    private static Expression compilePostFilterExpression(StatementContext context, List<ParseNode> postFilters) throws SQLException {
        if (postFilters.isEmpty()) {
            return null;
        }
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(context);
        ArrayList<Expression> expressions = new ArrayList<Expression>(postFilters.size());
        for (ParseNode postFilter : postFilters) {
            expressionCompiler.reset();
            Expression expression = postFilter.accept(expressionCompiler);
            expressions.add(expression);
        }
        if (expressions.size() == 1) {
            return (Expression)expressions.get(0);
        }
        return AndExpression.create(expressions);
    }

    public static SelectStatement optimize(PhoenixStatement statement, SelectStatement select, final ColumnResolver resolver) throws SQLException {
        Set<TableRef> set;
        TableRef groupByTableRef = null;
        TableRef orderByTableRef = null;
        if (select.getGroupBy() != null && !select.getGroupBy().isEmpty()) {
            ColumnRefParseNodeVisitor groupByVisitor = new ColumnRefParseNodeVisitor(resolver, statement.getConnection());
            for (ParseNode parseNode : select.getGroupBy()) {
                parseNode.accept(groupByVisitor);
            }
            set = groupByVisitor.getTableRefSet();
            if (set.size() == 1) {
                groupByTableRef = set.iterator().next();
            }
        } else if (select.getOrderBy() != null && !select.getOrderBy().isEmpty()) {
            ColumnRefParseNodeVisitor orderByVisitor = new ColumnRefParseNodeVisitor(resolver, statement.getConnection());
            for (OrderByNode orderByNode : select.getOrderBy()) {
                orderByNode.getNode().accept(orderByVisitor);
            }
            set = orderByVisitor.getTableRefSet();
            if (set.size() == 1) {
                orderByTableRef = set.iterator().next();
            }
        }
        JoinTable join = JoinCompiler.compile(statement, select, resolver);
        if (groupByTableRef != null || orderByTableRef != null) {
            QueryCompiler compiler = new QueryCompiler(statement, select, resolver, false);
            List<Object> list = statement.getParameters();
            StatementContext ctx = new StatementContext(statement, resolver, new Scan(), new SequenceManager(statement));
            QueryPlan plan = compiler.compileJoinQuery(ctx, list, join, false, false, null);
            TableRef table = plan.getTableRef();
            if (groupByTableRef != null && !groupByTableRef.equals(table)) {
                groupByTableRef = null;
            }
            if (orderByTableRef != null && !orderByTableRef.equals(table)) {
                orderByTableRef = null;
            }
        }
        final HashMap<TableRef, TableRef> replacement = new HashMap<TableRef, TableRef>();
        for (Table table : join.getTables()) {
            if (table.isSubselect()) continue;
            TableRef tableRef = table.getTableRef();
            List<ParseNode> groupBy = tableRef.equals(groupByTableRef) ? select.getGroupBy() : null;
            List<OrderByNode> orderBy = tableRef.equals(orderByTableRef) ? select.getOrderBy() : null;
            SelectStatement stmt = JoinCompiler.getSubqueryForOptimizedPlan(select.getHint(), table.getDynamicColumns(), table.getTableSamplingRate(), tableRef, join.getColumnRefs(), table.getPreFiltersCombined(), groupBy, orderBy, table.isWildCardSelect(), select.hasSequence(), select.getUdfParseNodes());
            QueryPlan plan = statement.getConnection().getQueryServices().getOptimizer().optimize(statement, stmt);
            if (plan.getTableRef().equals(tableRef)) continue;
            replacement.put(tableRef, plan.getTableRef());
        }
        if (replacement.isEmpty()) {
            return select;
        }
        TableNode tableNode = select.getFrom();
        TableNode newFrom = tableNode.accept(new TableNodeVisitor<TableNode>(){

            private TableRef resolveTable(String alias, TableName name) throws SQLException {
                if (alias != null) {
                    return resolver.resolveTable(null, alias);
                }
                return resolver.resolveTable(name.getSchemaName(), name.getTableName());
            }

            private TableName getReplacedTableName(TableRef tableRef) {
                String schemaName = tableRef.getTable().getSchemaName().getString();
                return TableName.create(schemaName.length() == 0 ? null : schemaName, tableRef.getTable().getTableName().getString());
            }

            @Override
            public TableNode visit(BindTableNode boundTableNode) throws SQLException {
                TableRef tableRef = this.resolveTable(boundTableNode.getAlias(), boundTableNode.getName());
                TableRef replaceRef = (TableRef)replacement.get(tableRef);
                if (replaceRef == null) {
                    return boundTableNode;
                }
                String alias = boundTableNode.getAlias();
                return NODE_FACTORY.bindTable(alias == null ? null : '\"' + alias + '\"', this.getReplacedTableName(replaceRef));
            }

            @Override
            public TableNode visit(JoinTableNode joinNode) throws SQLException {
                TableNode lhs = joinNode.getLHS();
                TableNode rhs = joinNode.getRHS();
                TableNode lhsReplace = lhs.accept(this);
                TableNode rhsReplace = rhs.accept(this);
                if (lhs == lhsReplace && rhs == rhsReplace) {
                    return joinNode;
                }
                return NODE_FACTORY.join(joinNode.getType(), lhsReplace, rhsReplace, joinNode.getOnNode(), joinNode.isSingleValueOnly());
            }

            @Override
            public TableNode visit(NamedTableNode namedTableNode) throws SQLException {
                TableRef tableRef = this.resolveTable(namedTableNode.getAlias(), namedTableNode.getName());
                TableRef replaceRef = (TableRef)replacement.get(tableRef);
                if (replaceRef == null) {
                    return namedTableNode;
                }
                String alias = namedTableNode.getAlias();
                return NODE_FACTORY.namedTable(alias == null ? null : '\"' + alias + '\"', this.getReplacedTableName(replaceRef), namedTableNode.getDynamicColumns(), namedTableNode.getTableSamplingRate());
            }

            @Override
            public TableNode visit(DerivedTableNode subselectNode) throws SQLException {
                return subselectNode;
            }
        });
        SelectStatement indexSelect = IndexStatementRewriter.translate(NODE_FACTORY.select(select, newFrom), resolver, replacement);
        for (TableRef indexTableRef : replacement.values()) {
            indexSelect = ParseNodeRewriter.rewrite(indexSelect, (ParseNodeRewriter)new IndexExpressionParseNodeRewriter(indexTableRef.getTable(), indexTableRef.getTableAlias(), statement.getConnection(), indexSelect.getUdfParseNodes()));
        }
        return indexSelect;
    }

    private static SelectStatement getSubqueryForOptimizedPlan(HintNode hintNode, List<ColumnDef> dynamicCols, Double tableSamplingRate, TableRef tableRef, Map<ColumnRef, ColumnRefType> columnRefs, ParseNode where, List<ParseNode> groupBy, List<OrderByNode> orderBy, boolean isWildCardSelect, boolean hasSequence, Map<String, UDFParseNode> udfParseNodes) {
        String schemaName = tableRef.getTable().getSchemaName().getString();
        TableName tName = TableName.create(schemaName.length() == 0 ? null : schemaName, tableRef.getTable().getTableName().getString());
        ArrayList<AliasedNode> selectList = new ArrayList<AliasedNode>();
        if (isWildCardSelect) {
            selectList.add(NODE_FACTORY.aliasedNode(null, WildcardParseNode.INSTANCE));
        } else {
            for (ColumnRef colRef : columnRefs.keySet()) {
                if (!colRef.getTableRef().equals(tableRef)) continue;
                ParseNode node = NODE_FACTORY.column(tName, '\"' + colRef.getColumn().getName().getString() + '\"', null);
                if (groupBy != null) {
                    node = NODE_FACTORY.function("COUNT", Collections.singletonList(node));
                }
                selectList.add(NODE_FACTORY.aliasedNode(null, node));
            }
        }
        String tableAlias = tableRef.getTableAlias();
        NamedTableNode from = NODE_FACTORY.namedTable(tableAlias == null ? null : '\"' + tableAlias + '\"', tName, dynamicCols, tableSamplingRate);
        return NODE_FACTORY.select(from, hintNode, false, selectList, where, groupBy, null, orderBy, null, null, 0, groupBy != null, hasSequence, Collections.emptyList(), udfParseNodes);
    }

    public static PTable joinProjectedTables(PTable left, PTable right, JoinTableNode.JoinType type) throws SQLException {
        Preconditions.checkArgument((left.getType() == PTableType.PROJECTED ? 1 : 0) != 0);
        Preconditions.checkArgument((right.getType() == PTableType.PROJECTED ? 1 : 0) != 0);
        ArrayList merged = Lists.newArrayList();
        if (type == JoinTableNode.JoinType.Full) {
            for (PColumn c : left.getColumns()) {
                merged.add(new ProjectedColumn(c.getName(), c.getFamilyName(), c.getPosition(), true, ((ProjectedColumn)c).getSourceColumnRef(), SchemaUtil.isPKColumn(c) ? null : c.getName().getBytes()));
            }
        } else {
            merged.addAll(left.getColumns());
        }
        int position = merged.size();
        for (PColumn c : right.getColumns()) {
            if (SchemaUtil.isPKColumn(c)) continue;
            ProjectedColumn column = new ProjectedColumn(c.getName(), c.getFamilyName(), position++, type == JoinTableNode.JoinType.Inner ? c.isNullable() : true, ((ProjectedColumn)c).getSourceColumnRef(), c.getName().getBytes());
            merged.add(column);
        }
        if (left.getBucketNum() != null) {
            merged.remove(0);
        }
        return PTableImpl.makePTable(left.getTenantId(), left.getSchemaName(), PNameFactory.newName(SchemaUtil.getTableName(left.getName().getString(), right.getName().getString())), left.getType(), left.getIndexState(), left.getTimeStamp(), left.getSequenceNumber(), left.getPKName(), left.getBucketNum(), merged, left.getParentSchemaName(), left.getParentTableName(), left.getIndexes(), left.isImmutableRows(), Collections.emptyList(), null, null, false, left.isMultiTenant(), left.getStoreNulls(), left.getViewType(), left.getViewIndexId(), left.getIndexType(), left.rowKeyOrderOptimizable(), left.isTransactional(), left.getUpdateCacheFrequency(), left.getIndexDisableTimestamp(), left.isNamespaceMapped(), left.getAutoPartitionSeqName(), left.isAppendOnlySchema(), PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, PTable.EncodedCQCounter.NULL_COUNTER, left.useStatsForParallelization());
    }

    private static class ColumnRefParseNodeVisitor
    extends StatelessTraverseAllParseNodeVisitor {
        private final ColumnResolver resolver;
        private final PhoenixConnection connection;
        private final Set<TableRef> tableRefSet;
        private final Map<ColumnRef, ColumnParseNode> columnRefMap;

        public ColumnRefParseNodeVisitor(ColumnResolver resolver, PhoenixConnection connection) {
            this.resolver = resolver;
            this.tableRefSet = new HashSet<TableRef>();
            this.columnRefMap = new HashMap<ColumnRef, ColumnParseNode>();
            this.connection = connection;
        }

        public void reset() {
            this.tableRefSet.clear();
            this.columnRefMap.clear();
        }

        @Override
        public Void visit(ColumnParseNode node) throws SQLException {
            ColumnRef columnRef = null;
            try {
                columnRef = this.resolver.resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
            }
            catch (ColumnNotFoundException e) {
                TableRef tableRef = this.resolver.resolveTable(node.getSchemaName(), node.getTableName());
                if (tableRef.getTable().getIndexType() == PTable.IndexType.LOCAL) {
                    TableRef parentTableRef = FromCompiler.getResolver(NODE_FACTORY.namedTable(null, TableName.create(tableRef.getTable().getSchemaName().getString(), tableRef.getTable().getParentTableName().getString())), this.connection).resolveTable(tableRef.getTable().getSchemaName().getString(), tableRef.getTable().getParentTableName().getString());
                    columnRef = new LocalIndexColumnRef(parentTableRef, IndexUtil.getDataColumnFamilyName(node.getName()), IndexUtil.getDataColumnName(node.getName()), tableRef);
                }
                throw e;
            }
            this.columnRefMap.put(columnRef, node);
            this.tableRefSet.add(columnRef.getTableRef());
            return null;
        }

        public Set<TableRef> getTableRefSet() {
            return this.tableRefSet;
        }

        public Map<ColumnRef, ColumnParseNode> getColumnRefMap() {
            return this.columnRefMap;
        }

        public ColumnRefType getContentType(List<TableRef> selfTableRefs) {
            if (this.tableRefSet.isEmpty()) {
                return ColumnRefType.NONE;
            }
            ColumnRefType ret = ColumnRefType.NONE;
            for (TableRef tRef : this.tableRefSet) {
                boolean isSelf = selfTableRefs.contains(tRef);
                switch (ret) {
                    case NONE: {
                        ret = isSelf ? ColumnRefType.SELF_ONLY : ColumnRefType.FOREIGN_ONLY;
                        break;
                    }
                    case SELF_ONLY: {
                        ret = isSelf ? ColumnRefType.SELF_ONLY : ColumnRefType.COMPLEX;
                        break;
                    }
                    case FOREIGN_ONLY: {
                        ret = isSelf ? ColumnRefType.COMPLEX : ColumnRefType.FOREIGN_ONLY;
                        break;
                    }
                }
                if (ret != ColumnRefType.COMPLEX) continue;
                break;
            }
            return ret;
        }

        public static enum ColumnRefType {
            NONE,
            SELF_ONLY,
            FOREIGN_ONLY,
            COMPLEX;

        }
    }

    private static class LocalIndexColumnRef
    extends ColumnRef {
        private final TableRef indexTableRef;

        public LocalIndexColumnRef(TableRef tableRef, String familyName, String columnName, TableRef indexTableRef) throws MetaDataEntityNotFoundException {
            super(tableRef, familyName, columnName);
            this.indexTableRef = indexTableRef;
        }

        @Override
        public TableRef getTableRef() {
            return this.indexTableRef;
        }
    }

    private static class OnNodeVisitor
    extends BooleanParseNodeVisitor<Void> {
        private List<EqualParseNode> onConditions;
        private Set<TableRef> dependencies;
        private JoinTable joinTable;
        private ColumnRefParseNodeVisitor columnRefVisitor;

        public OnNodeVisitor(ColumnResolver resolver, List<EqualParseNode> onConditions, Set<TableRef> dependencies, JoinTable joinTable, PhoenixConnection connection) {
            this.onConditions = onConditions;
            this.dependencies = dependencies;
            this.joinTable = joinTable;
            this.columnRefVisitor = new ColumnRefParseNodeVisitor(resolver, connection);
        }

        @Override
        protected boolean enterBooleanNode(ParseNode node) throws SQLException {
            return false;
        }

        @Override
        protected Void leaveBooleanNode(ParseNode node, List<Void> l) throws SQLException {
            this.columnRefVisitor.reset();
            node.accept(this.columnRefVisitor);
            ColumnRefParseNodeVisitor.ColumnRefType type = this.columnRefVisitor.getContentType(this.joinTable.getTableRefs());
            if (type == ColumnRefParseNodeVisitor.ColumnRefType.NONE || type == ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY) {
                this.joinTable.addFilter(node);
            } else {
                this.throwAmbiguousJoinConditionException();
            }
            return null;
        }

        @Override
        protected boolean enterNonBooleanNode(ParseNode node) throws SQLException {
            return false;
        }

        @Override
        protected Void leaveNonBooleanNode(ParseNode node, List<Void> l) throws SQLException {
            return null;
        }

        @Override
        public boolean visitEnter(AndParseNode node) throws SQLException {
            return true;
        }

        @Override
        public Void visitLeave(AndParseNode node, List<Void> l) throws SQLException {
            return null;
        }

        @Override
        public Void visitLeave(ComparisonParseNode node, List<Void> l) throws SQLException {
            if (!(node instanceof EqualParseNode)) {
                return this.leaveBooleanNode((ParseNode)node, (List)l);
            }
            this.columnRefVisitor.reset();
            node.getLHS().accept(this.columnRefVisitor);
            ColumnRefParseNodeVisitor.ColumnRefType lhsType = this.columnRefVisitor.getContentType(this.joinTable.getTableRefs());
            HashSet lhsTableRefSet = Sets.newHashSet(this.columnRefVisitor.getTableRefSet());
            this.columnRefVisitor.reset();
            node.getRHS().accept(this.columnRefVisitor);
            ColumnRefParseNodeVisitor.ColumnRefType rhsType = this.columnRefVisitor.getContentType(this.joinTable.getTableRefs());
            HashSet rhsTableRefSet = Sets.newHashSet(this.columnRefVisitor.getTableRefSet());
            if (!(lhsType != ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY && lhsType != ColumnRefParseNodeVisitor.ColumnRefType.NONE || rhsType != ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY && rhsType != ColumnRefParseNodeVisitor.ColumnRefType.NONE)) {
                this.joinTable.addFilter(node);
            } else if (lhsType == ColumnRefParseNodeVisitor.ColumnRefType.FOREIGN_ONLY && rhsType == ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY) {
                this.onConditions.add((EqualParseNode)node);
                this.dependencies.addAll(lhsTableRefSet);
            } else if (rhsType == ColumnRefParseNodeVisitor.ColumnRefType.FOREIGN_ONLY && lhsType == ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY) {
                this.onConditions.add(NODE_FACTORY.equal(node.getRHS(), node.getLHS()));
                this.dependencies.addAll(rhsTableRefSet);
            } else {
                this.throwAmbiguousJoinConditionException();
            }
            return null;
        }

        public void throwAmbiguousJoinConditionException() throws SQLException {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.AMBIGUOUS_JOIN_CONDITION).build().buildException();
        }
    }

    private static class WhereNodeVisitor
    extends BooleanParseNodeVisitor<Void> {
        private Table table;
        private List<ParseNode> postFilters;
        private List<TableRef> selfTableRefs;
        private boolean isPrefilterAccepted;
        private List<JoinSpec> prefilterAcceptedTables;
        ColumnRefParseNodeVisitor columnRefVisitor;

        public WhereNodeVisitor(ColumnResolver resolver, Table table, List<ParseNode> postFilters, List<TableRef> selfTableRefs, boolean isPrefilterAccepted, List<JoinSpec> prefilterAcceptedTables, PhoenixConnection connection) {
            this.table = table;
            this.postFilters = postFilters;
            this.selfTableRefs = selfTableRefs;
            this.isPrefilterAccepted = isPrefilterAccepted;
            this.prefilterAcceptedTables = prefilterAcceptedTables;
            this.columnRefVisitor = new ColumnRefParseNodeVisitor(resolver, connection);
        }

        @Override
        protected boolean enterBooleanNode(ParseNode node) throws SQLException {
            return false;
        }

        @Override
        protected Void leaveBooleanNode(ParseNode node, List<Void> l) throws SQLException {
            this.columnRefVisitor.reset();
            node.accept(this.columnRefVisitor);
            ColumnRefParseNodeVisitor.ColumnRefType type = this.columnRefVisitor.getContentType(this.selfTableRefs);
            switch (type) {
                case NONE: 
                case SELF_ONLY: {
                    if (this.isPrefilterAccepted) {
                        this.table.addFilter(node);
                        break;
                    }
                    this.postFilters.add(node);
                    break;
                }
                case FOREIGN_ONLY: {
                    JoinTable matched = null;
                    for (JoinSpec joinSpec : this.prefilterAcceptedTables) {
                        if (this.columnRefVisitor.getContentType(joinSpec.getJoinTable().getTableRefs()) != ColumnRefParseNodeVisitor.ColumnRefType.SELF_ONLY) continue;
                        matched = joinSpec.getJoinTable();
                        break;
                    }
                    if (matched != null) {
                        matched.addFilter(node);
                        break;
                    }
                    this.postFilters.add(node);
                    break;
                }
                default: {
                    this.postFilters.add(node);
                }
            }
            return null;
        }

        @Override
        protected boolean enterNonBooleanNode(ParseNode node) throws SQLException {
            return false;
        }

        @Override
        protected Void leaveNonBooleanNode(ParseNode node, List<Void> l) throws SQLException {
            return null;
        }

        @Override
        public boolean visitEnter(AndParseNode node) throws SQLException {
            return true;
        }

        @Override
        public Void visitLeave(AndParseNode node, List<Void> l) throws SQLException {
            return null;
        }

        @Override
        public Void visitLeave(ComparisonParseNode node, List<Void> l) throws SQLException {
            if (!(node instanceof EqualParseNode)) {
                return this.leaveBooleanNode((ParseNode)node, (List)l);
            }
            ListIterator<JoinSpec> iter = this.prefilterAcceptedTables.listIterator(this.prefilterAcceptedTables.size());
            while (iter.hasPrevious()) {
                JoinSpec joinSpec = iter.previous();
                if (joinSpec.getType() != JoinTableNode.JoinType.Inner || joinSpec.isSingleValueOnly()) continue;
                try {
                    joinSpec.addOnCondition(node);
                    return null;
                }
                catch (SQLException sQLException) {
                }
            }
            return this.leaveBooleanNode((ParseNode)node, (List)l);
        }
    }

    public class Table {
        private final TableNode tableNode;
        private final List<ColumnDef> dynamicColumns;
        private final Double tableSamplingRate;
        private final SelectStatement subselect;
        private final TableRef tableRef;
        private final List<AliasedNode> selectNodes;
        private final List<ParseNode> preFilters;
        private final List<ParseNode> postFilters;
        private final boolean isPostFilterConvertible;

        private Table(TableNode tableNode, List<ColumnDef> dynamicColumns, Double tableSamplingRate, List<AliasedNode> selectNodes, TableRef tableRef) {
            this.tableNode = tableNode;
            this.dynamicColumns = dynamicColumns;
            this.tableSamplingRate = tableSamplingRate;
            this.subselect = null;
            this.tableRef = tableRef;
            this.selectNodes = selectNodes;
            this.preFilters = new ArrayList<ParseNode>();
            this.postFilters = Collections.emptyList();
            this.isPostFilterConvertible = false;
        }

        private Table(DerivedTableNode tableNode, List<AliasedNode> selectNodes, TableRef tableRef) throws SQLException {
            this.tableNode = tableNode;
            this.dynamicColumns = Collections.emptyList();
            this.tableSamplingRate = ConcreteTableNode.DEFAULT_TABLE_SAMPLING_RATE;
            this.subselect = SubselectRewriter.flatten(tableNode.getSelect(), JoinCompiler.this.statement.getConnection());
            this.tableRef = tableRef;
            this.selectNodes = selectNodes;
            this.preFilters = new ArrayList<ParseNode>();
            this.postFilters = new ArrayList<ParseNode>();
            this.isPostFilterConvertible = SubselectRewriter.isPostFilterConvertible(this.subselect);
        }

        public TableNode getTableNode() {
            return this.tableNode;
        }

        public List<ColumnDef> getDynamicColumns() {
            return this.dynamicColumns;
        }

        public Double getTableSamplingRate() {
            return this.tableSamplingRate;
        }

        public boolean isSubselect() {
            return this.subselect != null;
        }

        public List<AliasedNode> getSelectNodes() {
            return this.selectNodes;
        }

        public List<ParseNode> getPreFilters() {
            return this.preFilters;
        }

        public List<ParseNode> getPostFilters() {
            return this.postFilters;
        }

        public TableRef getTableRef() {
            return this.tableRef;
        }

        public void addFilter(ParseNode filter) {
            if (!this.isSubselect() || this.isPostFilterConvertible) {
                this.preFilters.add(filter);
            } else {
                this.postFilters.add(filter);
            }
        }

        public ParseNode getPreFiltersCombined() {
            return JoinCompiler.combine(this.preFilters);
        }

        public Expression compilePostFilterExpression(StatementContext context) throws SQLException {
            return JoinCompiler.compilePostFilterExpression(context, this.postFilters);
        }

        public SelectStatement getAsSubquery(List<OrderByNode> orderBy) throws SQLException {
            if (this.isSubselect()) {
                return SubselectRewriter.applyOrderBy(SubselectRewriter.applyPostFilters(this.subselect, this.preFilters, this.tableNode.getAlias()), orderBy, this.tableNode.getAlias(), this.tableNode);
            }
            return NODE_FACTORY.select(this.tableNode, JoinCompiler.this.select.getHint(), false, this.selectNodes, this.getPreFiltersCombined(), null, null, orderBy, null, null, 0, false, JoinCompiler.this.select.hasSequence(), Collections.emptyList(), JoinCompiler.this.select.getUdfParseNodes());
        }

        public boolean hasFilters() {
            return this.isSubselect() ? !this.postFilters.isEmpty() || this.subselect.getWhere() != null || this.subselect.getHaving() != null : !this.preFilters.isEmpty();
        }

        public boolean isFlat() {
            return this.subselect == null || JoinCompiler.isFlat(this.subselect);
        }

        protected boolean isWildCardSelect() {
            return this.selectNodes.size() == 1 && this.selectNodes.get(0).getNode() instanceof TableWildcardParseNode;
        }

        public void projectColumns(Scan scan) {
            assert (!this.isSubselect());
            if (this.isWildCardSelect()) {
                scan.getFamilyMap().clear();
                return;
            }
            for (ColumnRef columnRef : JoinCompiler.this.columnRefs.keySet()) {
                if (!columnRef.getTableRef().equals(this.tableRef) || SchemaUtil.isPKColumn(columnRef.getColumn()) || columnRef instanceof LocalIndexColumnRef) continue;
                EncodedColumnsUtil.setColumns(columnRef.getColumn(), this.tableRef.getTable(), scan);
            }
        }

        public PTable createProjectedTable(boolean retainPKColumns, StatementContext context) throws SQLException {
            assert (!this.isSubselect());
            ArrayList<ColumnRef> sourceColumns = new ArrayList<ColumnRef>();
            PTable table = this.tableRef.getTable();
            if (retainPKColumns) {
                for (PColumn pColumn : table.getPKColumns()) {
                    sourceColumns.add(new ColumnRef(this.tableRef, pColumn.getPosition()));
                }
            }
            if (this.isWildCardSelect()) {
                for (PColumn pColumn : table.getColumns()) {
                    if (retainPKColumns && SchemaUtil.isPKColumn(pColumn)) continue;
                    sourceColumns.add(new ColumnRef(this.tableRef, pColumn.getPosition()));
                }
            } else {
                for (Map.Entry entry : JoinCompiler.this.columnRefs.entrySet()) {
                    ColumnRef columnRef = (ColumnRef)entry.getKey();
                    if (!columnRef.getTableRef().equals(this.tableRef) || retainPKColumns && SchemaUtil.isPKColumn(columnRef.getColumn())) continue;
                    if (columnRef instanceof LocalIndexColumnRef) {
                        sourceColumns.add(new LocalIndexDataColumnRef(context, IndexUtil.getIndexColumnName(columnRef.getColumn())));
                        continue;
                    }
                    sourceColumns.add(columnRef);
                }
            }
            return TupleProjectionCompiler.createProjectedTable(this.tableRef, sourceColumns, retainPKColumns);
        }

        public PTable createProjectedTable(RowProjector rowProjector) throws SQLException {
            assert (this.isSubselect());
            TableRef tableRef = FromCompiler.getResolverForCompiledDerivedTable(JoinCompiler.this.statement.getConnection(), this.tableRef, rowProjector).getTables().get(0);
            ArrayList<ColumnRef> sourceColumns = new ArrayList<ColumnRef>();
            PTable table = tableRef.getTable();
            for (PColumn column : table.getColumns()) {
                sourceColumns.add(new ColumnRef(tableRef, column.getPosition()));
            }
            return TupleProjectionCompiler.createProjectedTable(tableRef, sourceColumns, false);
        }
    }

    public class JoinSpec {
        private final JoinTableNode.JoinType type;
        private final List<EqualParseNode> onConditions;
        private final JoinTable joinTable;
        private final boolean singleValueOnly;
        private Set<TableRef> dependencies;
        private OnNodeVisitor onNodeVisitor;

        private JoinSpec(JoinTableNode.JoinType type, ParseNode onNode, JoinTable joinTable, boolean singleValueOnly, ColumnResolver resolver) throws SQLException {
            this.type = type;
            this.onConditions = new ArrayList<EqualParseNode>();
            this.joinTable = joinTable;
            this.singleValueOnly = singleValueOnly;
            this.dependencies = new HashSet<TableRef>();
            this.onNodeVisitor = new OnNodeVisitor(resolver, this.onConditions, this.dependencies, joinTable, JoinCompiler.this.statement.getConnection());
            if (onNode != null) {
                onNode.accept(this.onNodeVisitor);
            }
        }

        public void addOnCondition(ParseNode node) throws SQLException {
            node.accept(this.onNodeVisitor);
        }

        public JoinTableNode.JoinType getType() {
            return this.type;
        }

        public List<EqualParseNode> getOnConditions() {
            return this.onConditions;
        }

        public JoinTable getJoinTable() {
            return this.joinTable;
        }

        public boolean isSingleValueOnly() {
            return this.singleValueOnly;
        }

        public Set<TableRef> getDependencies() {
            return this.dependencies;
        }

        public Pair<List<Expression>, List<Expression>> compileJoinConditions(StatementContext lhsCtx, StatementContext rhsCtx, boolean sortExpressions) throws SQLException {
            if (this.onConditions.isEmpty()) {
                return new Pair(Collections.singletonList(LiteralExpression.newConstant(1)), Collections.singletonList(LiteralExpression.newConstant(1)));
            }
            ArrayList compiled = Lists.newArrayListWithExpectedSize((int)this.onConditions.size());
            ExpressionCompiler lhsCompiler = new ExpressionCompiler(lhsCtx);
            ExpressionCompiler rhsCompiler = new ExpressionCompiler(rhsCtx);
            for (EqualParseNode condition : this.onConditions) {
                lhsCompiler.reset();
                Expression left = condition.getLHS().accept(lhsCompiler);
                rhsCompiler.reset();
                Expression right = condition.getRHS().accept(rhsCompiler);
                PDataType toType = this.getCommonType(left.getDataType(), right.getDataType());
                if (left.getDataType() != toType || left.getSortOrder() == SortOrder.DESC) {
                    left = CoerceExpression.create(left, toType, SortOrder.ASC, left.getMaxLength());
                }
                if (right.getDataType() != toType || right.getSortOrder() == SortOrder.DESC) {
                    right = CoerceExpression.create(right, toType, SortOrder.ASC, right.getMaxLength());
                }
                compiled.add(new Pair((Object)left, (Object)right));
            }
            if (sortExpressions) {
                Collections.sort(compiled, new Comparator<Pair<Expression, Expression>>(){

                    @Override
                    public int compare(Pair<Expression, Expression> o1, Pair<Expression, Expression> o2) {
                        boolean isFixedNullable2;
                        Expression e1 = (Expression)o1.getFirst();
                        Expression e2 = (Expression)o2.getFirst();
                        boolean isFixed1 = e1.getDataType().isFixedWidth();
                        boolean isFixed2 = e2.getDataType().isFixedWidth();
                        boolean isFixedNullable1 = e1.isNullable() && isFixed1;
                        boolean bl = isFixedNullable2 = e2.isNullable() && isFixed2;
                        if (isFixedNullable1 == isFixedNullable2) {
                            if (isFixed1 == isFixed2) {
                                return 0;
                            }
                            if (isFixed1) {
                                return -1;
                            }
                            return 1;
                        }
                        if (isFixedNullable1) {
                            return 1;
                        }
                        return -1;
                    }
                });
            }
            ArrayList lConditions = Lists.newArrayListWithExpectedSize((int)compiled.size());
            ArrayList rConditions = Lists.newArrayListWithExpectedSize((int)compiled.size());
            for (Pair pair : compiled) {
                lConditions.add(pair.getFirst());
                rConditions.add(pair.getSecond());
            }
            return new Pair((Object)lConditions, (Object)rConditions);
        }

        private PDataType getCommonType(PDataType lType, PDataType rType) throws SQLException {
            if (lType == rType) {
                return lType;
            }
            if (!lType.isComparableTo(rType)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TYPE_MISMATCH).setMessage("On-clause LHS expression and RHS expression must be comparable. LHS type: " + lType + ", RHS type: " + rType).build().buildException();
            }
            if ((lType == null || lType.isCoercibleTo(PTinyint.INSTANCE)) && (rType == null || rType.isCoercibleTo(PTinyint.INSTANCE))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PSmallint.INSTANCE)) && (rType == null || rType.isCoercibleTo(PSmallint.INSTANCE))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PInteger.INSTANCE)) && (rType == null || rType.isCoercibleTo(PInteger.INSTANCE))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PLong.INSTANCE)) && (rType == null || rType.isCoercibleTo(PLong.INSTANCE))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PDouble.INSTANCE)) && (rType == null || rType.isCoercibleTo(PDouble.INSTANCE))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PDecimal.INSTANCE)) && (rType == null || rType.isCoercibleTo(PDecimal.INSTANCE))) {
                return PDecimal.INSTANCE;
            }
            if ((lType == null || lType.isCoercibleTo(PDate.INSTANCE)) && (rType == null || rType.isCoercibleTo(PDate.INSTANCE))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PTimestamp.INSTANCE)) && (rType == null || rType.isCoercibleTo(PTimestamp.INSTANCE))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PVarchar.INSTANCE)) && (rType == null || rType.isCoercibleTo(PVarchar.INSTANCE))) {
                return PVarchar.INSTANCE;
            }
            if ((lType == null || lType.isCoercibleTo(PBoolean.INSTANCE)) && (rType == null || rType.isCoercibleTo(PBoolean.INSTANCE))) {
                return PBoolean.INSTANCE;
            }
            return PVarbinary.INSTANCE;
        }
    }

    public class JoinTable {
        private final Table table;
        private final List<JoinSpec> joinSpecs;
        private final List<ParseNode> postFilters;
        private final List<Table> tables;
        private final List<TableRef> tableRefs;
        private final boolean allLeftJoin;
        private final boolean isPrefilterAccepted;
        private final List<JoinSpec> prefilterAcceptedTables;

        private JoinTable(Table table) {
            this.table = table;
            this.joinSpecs = Collections.emptyList();
            this.postFilters = Collections.emptyList();
            this.tables = Collections.singletonList(table);
            this.tableRefs = Collections.singletonList(table.getTableRef());
            this.allLeftJoin = false;
            this.isPrefilterAccepted = true;
            this.prefilterAcceptedTables = Collections.emptyList();
        }

        private JoinTable(Table table, List<JoinSpec> joinSpecs) {
            int i;
            JoinSpec joinSpec;
            this.table = table;
            this.joinSpecs = joinSpecs;
            this.postFilters = new ArrayList<ParseNode>();
            this.tables = new ArrayList<Table>();
            this.tableRefs = new ArrayList<TableRef>();
            this.tables.add(table);
            boolean allLeftJoin = true;
            int lastRightJoinIndex = -1;
            boolean hasFullJoin = false;
            for (int i2 = 0; i2 < joinSpecs.size(); ++i2) {
                joinSpec = joinSpecs.get(i2);
                this.tables.addAll(joinSpec.getJoinTable().getTables());
                allLeftJoin = allLeftJoin && joinSpec.getType() == JoinTableNode.JoinType.Left;
                boolean bl = hasFullJoin = hasFullJoin || joinSpec.getType() == JoinTableNode.JoinType.Full;
                if (joinSpec.getType() != JoinTableNode.JoinType.Right) continue;
                lastRightJoinIndex = i2;
            }
            for (Table t : this.tables) {
                this.tableRefs.add(t.getTableRef());
            }
            this.allLeftJoin = allLeftJoin;
            this.isPrefilterAccepted = !hasFullJoin && lastRightJoinIndex == -1;
            this.prefilterAcceptedTables = new ArrayList<JoinSpec>();
            int n = i = lastRightJoinIndex == -1 ? 0 : lastRightJoinIndex;
            while (i < joinSpecs.size()) {
                joinSpec = joinSpecs.get(i);
                if (joinSpec.getType() != JoinTableNode.JoinType.Left && joinSpec.getType() != JoinTableNode.JoinType.Anti && joinSpec.getType() != JoinTableNode.JoinType.Full) {
                    this.prefilterAcceptedTables.add(joinSpec);
                }
                ++i;
            }
        }

        public Table getTable() {
            return this.table;
        }

        public List<JoinSpec> getJoinSpecs() {
            return this.joinSpecs;
        }

        public List<Table> getTables() {
            return this.tables;
        }

        public List<TableRef> getTableRefs() {
            return this.tableRefs;
        }

        public boolean isAllLeftJoin() {
            return this.allLeftJoin;
        }

        public SelectStatement getStatement() {
            return JoinCompiler.this.select;
        }

        public ColumnResolver getOriginalResolver() {
            return JoinCompiler.this.origResolver;
        }

        public Map<ColumnRef, ColumnRefType> getColumnRefs() {
            return JoinCompiler.this.columnRefs;
        }

        public ParseNode getPostFiltersCombined() {
            return JoinCompiler.combine(this.postFilters);
        }

        public void addFilter(ParseNode filter) throws SQLException {
            if (this.joinSpecs.isEmpty()) {
                this.table.addFilter(filter);
                return;
            }
            WhereNodeVisitor visitor = new WhereNodeVisitor(JoinCompiler.this.origResolver, this.table, this.postFilters, Collections.singletonList(this.table.getTableRef()), this.isPrefilterAccepted, this.prefilterAcceptedTables, JoinCompiler.this.statement.getConnection());
            filter.accept(visitor);
        }

        public void pushDownColumnRefVisitors(ColumnRefParseNodeVisitor generalRefVisitor, ColumnRefParseNodeVisitor joinLocalRefVisitor, ColumnRefParseNodeVisitor prefilterRefVisitor) throws SQLException {
            for (ParseNode node : this.table.getPreFilters()) {
                node.accept(prefilterRefVisitor);
            }
            for (ParseNode node : this.table.getPostFilters()) {
                node.accept(generalRefVisitor);
            }
            for (ParseNode node : this.postFilters) {
                node.accept(generalRefVisitor);
            }
            for (JoinSpec joinSpec : this.joinSpecs) {
                JoinTable joinTable = joinSpec.getJoinTable();
                boolean hasSubJoin = !joinTable.getJoinSpecs().isEmpty();
                for (EqualParseNode node : joinSpec.getOnConditions()) {
                    node.getLHS().accept(generalRefVisitor);
                    if (hasSubJoin) {
                        node.getRHS().accept(generalRefVisitor);
                        continue;
                    }
                    node.getRHS().accept(joinLocalRefVisitor);
                }
                joinTable.pushDownColumnRefVisitors(generalRefVisitor, joinLocalRefVisitor, prefilterRefVisitor);
            }
        }

        public Expression compilePostFilterExpression(StatementContext context, Table table) throws SQLException {
            ArrayList filtersCombined = Lists.newArrayList(this.postFilters);
            if (table != null) {
                filtersCombined.addAll(table.getPostFilters());
            }
            return JoinCompiler.compilePostFilterExpression(context, filtersCombined);
        }

        public boolean[] getStarJoinVector() {
            int count = this.joinSpecs.size();
            if (!this.table.isFlat() || !JoinCompiler.this.useStarJoin && count > 1 && this.joinSpecs.get(count - 1).getType() != JoinTableNode.JoinType.Left && this.joinSpecs.get(count - 1).getType() != JoinTableNode.JoinType.Semi && this.joinSpecs.get(count - 1).getType() != JoinTableNode.JoinType.Anti && !this.joinSpecs.get(count - 1).isSingleValueOnly()) {
                return null;
            }
            boolean[] vector = new boolean[count];
            for (int i = 0; i < count; ++i) {
                JoinSpec joinSpec = this.joinSpecs.get(i);
                if (joinSpec.getType() != JoinTableNode.JoinType.Left && joinSpec.getType() != JoinTableNode.JoinType.Inner && joinSpec.getType() != JoinTableNode.JoinType.Semi && joinSpec.getType() != JoinTableNode.JoinType.Anti) {
                    return null;
                }
                vector[i] = true;
                Iterator<TableRef> iter = joinSpec.getDependencies().iterator();
                while (vector[i] && iter.hasNext()) {
                    TableRef tableRef = iter.next();
                    if (tableRef.equals(this.table.getTableRef())) continue;
                    vector[i] = false;
                }
            }
            return vector;
        }

        public JoinTable getSubJoinTableWithoutPostFilters() {
            return this.joinSpecs.size() > 1 ? new JoinTable(this.table, this.joinSpecs.subList(0, this.joinSpecs.size() - 1)) : new JoinTable(this.table);
        }

        public SelectStatement getAsSingleSubquery(SelectStatement query, boolean asSubquery) throws SQLException {
            assert (JoinCompiler.isFlat(query));
            if (asSubquery) {
                return query;
            }
            return NODE_FACTORY.select(JoinCompiler.this.select, query.getFrom(), query.getWhere());
        }

        public boolean hasPostReference() {
            for (Table table : this.tables) {
                if (!table.isWildCardSelect()) continue;
                return true;
            }
            for (Map.Entry entry : JoinCompiler.this.columnRefs.entrySet()) {
                if (entry.getValue() != ColumnRefType.GENERAL || !this.tableRefs.contains(((ColumnRef)entry.getKey()).getTableRef())) continue;
                return true;
            }
            return false;
        }

        public boolean hasFilters() {
            if (!this.postFilters.isEmpty()) {
                return true;
            }
            if (this.isPrefilterAccepted && this.table.hasFilters()) {
                return true;
            }
            for (JoinSpec joinSpec : this.prefilterAcceptedTables) {
                if (!joinSpec.getJoinTable().hasFilters()) continue;
                return true;
            }
            return false;
        }
    }

    private class JoinTableConstructor
    implements TableNodeVisitor<Pair<Table, List<JoinSpec>>> {
        private JoinTableConstructor() {
        }

        private TableRef resolveTable(String alias, TableName name) throws SQLException {
            if (alias != null) {
                return JoinCompiler.this.origResolver.resolveTable(null, alias);
            }
            return JoinCompiler.this.origResolver.resolveTable(name.getSchemaName(), name.getTableName());
        }

        @Override
        public Pair<Table, List<JoinSpec>> visit(BindTableNode boundTableNode) throws SQLException {
            TableRef tableRef = this.resolveTable(boundTableNode.getAlias(), boundTableNode.getName());
            List selectNodes = JoinCompiler.this.extractFromSelect(JoinCompiler.this.select.getSelect(), tableRef, JoinCompiler.this.origResolver);
            Table table = new Table(boundTableNode, Collections.emptyList(), boundTableNode.getTableSamplingRate(), selectNodes, tableRef);
            return new Pair((Object)table, null);
        }

        @Override
        public Pair<Table, List<JoinSpec>> visit(JoinTableNode joinNode) throws SQLException {
            Pair<Table, List<JoinSpec>> lhs = joinNode.getLHS().accept(this);
            Pair<Table, List<JoinSpec>> rhs = joinNode.getRHS().accept(this);
            JoinTable joinTable = rhs.getSecond() == null ? new JoinTable((Table)rhs.getFirst()) : new JoinTable((Table)rhs.getFirst(), (List)rhs.getSecond());
            ArrayList<JoinSpec> joinSpecs = (ArrayList<JoinSpec>)lhs.getSecond();
            if (joinSpecs == null) {
                joinSpecs = new ArrayList<JoinSpec>();
            }
            joinSpecs.add(new JoinSpec(joinNode.getType(), joinNode.getOnNode(), joinTable, joinNode.isSingleValueOnly(), JoinCompiler.this.origResolver));
            return new Pair(lhs.getFirst(), joinSpecs);
        }

        @Override
        public Pair<Table, List<JoinSpec>> visit(NamedTableNode namedTableNode) throws SQLException {
            TableRef tableRef = this.resolveTable(namedTableNode.getAlias(), namedTableNode.getName());
            List selectNodes = JoinCompiler.this.extractFromSelect(JoinCompiler.this.select.getSelect(), tableRef, JoinCompiler.this.origResolver);
            Table table = new Table(namedTableNode, namedTableNode.getDynamicColumns(), namedTableNode.getTableSamplingRate(), selectNodes, tableRef);
            return new Pair((Object)table, null);
        }

        @Override
        public Pair<Table, List<JoinSpec>> visit(DerivedTableNode subselectNode) throws SQLException {
            TableRef tableRef = this.resolveTable(subselectNode.getAlias(), null);
            List selectNodes = JoinCompiler.this.extractFromSelect(JoinCompiler.this.select.getSelect(), tableRef, JoinCompiler.this.origResolver);
            Table table = new Table(subselectNode, selectNodes, tableRef);
            return new Pair((Object)table, null);
        }
    }

    public static enum ColumnRefType {
        JOINLOCAL,
        GENERAL;

    }
}

