/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.execute.DelegateQueryPlan;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.BaseSingleExpression;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.iterate.DelegateResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PArrayDataTypeDecoder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;

public class UnnestArrayPlan
extends DelegateQueryPlan {
    private final Expression arrayExpression;
    private final boolean withOrdinality;

    public UnnestArrayPlan(QueryPlan delegate, Expression arrayExpression, boolean withOrdinality) {
        super(delegate);
        this.arrayExpression = arrayExpression;
        this.withOrdinality = withOrdinality;
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        return new UnnestArrayResultIterator(this.delegate.iterator(scanGrouper, scan));
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        List<String> planSteps = this.delegate.getExplainPlan().getPlanSteps();
        planSteps.add("UNNEST");
        return new ExplainPlan(planSteps);
    }

    @Override
    public Integer getLimit() {
        return null;
    }

    private static class UnnestArrayElemIndexExpression
    extends BaseTerminalExpression {
        private int index = 0;

        private UnnestArrayElemIndexExpression() {
        }

        public void setIndex(int index) {
            this.index = index;
        }

        @Override
        public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
            byte[] lengthBuf = new byte[PInteger.INSTANCE.getByteSize().intValue()];
            PInteger.INSTANCE.getCodec().encodeInt(this.index + 1, lengthBuf, 0);
            ptr.set(lengthBuf);
            return true;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> visitor) {
            return null;
        }

        @Override
        public PDataType getDataType() {
            return PInteger.INSTANCE;
        }
    }

    private static class UnnestArrayElemRefExpression
    extends BaseSingleExpression {
        private final PDataType type;
        private int index = 0;
        private ImmutableBytesWritable arrayPtr = new ImmutableBytesWritable();

        public UnnestArrayElemRefExpression(Expression arrayExpression) {
            super(arrayExpression);
            this.type = PDataType.fromTypeId(arrayExpression.getDataType().getSqlType() - 3000);
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setArrayPtr(ImmutableBytesWritable arrayPtr) {
            this.arrayPtr.set(arrayPtr.get(), arrayPtr.getOffset(), arrayPtr.getLength());
        }

        @Override
        public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
            ptr.set(this.arrayPtr.get(), this.arrayPtr.getOffset(), this.arrayPtr.getLength());
            PArrayDataTypeDecoder.positionAtArrayElement(ptr, this.index++, this.getDataType(), this.getMaxLength());
            return true;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> visitor) {
            return null;
        }

        @Override
        public PDataType getDataType() {
            return this.type;
        }
    }

    public class UnnestArrayResultIterator
    extends DelegateResultIterator {
        private final UnnestArrayElemRefExpression elemRefExpression;
        private final UnnestArrayElemIndexExpression elemIndexExpression;
        private final TupleProjector projector;
        private Tuple current;
        private ImmutableBytesWritable arrayPtr;
        private int length;
        private int index;
        private boolean closed;

        public UnnestArrayResultIterator(ResultIterator iterator) {
            Expression[] expressionArray;
            super(iterator);
            this.elemRefExpression = new UnnestArrayElemRefExpression(UnnestArrayPlan.this.arrayExpression);
            UnnestArrayElemIndexExpression unnestArrayElemIndexExpression = this.elemIndexExpression = UnnestArrayPlan.this.withOrdinality ? new UnnestArrayElemIndexExpression() : null;
            if (UnnestArrayPlan.this.withOrdinality) {
                Expression[] expressionArray2 = new Expression[2];
                expressionArray2[0] = this.elemRefExpression;
                expressionArray = expressionArray2;
                expressionArray2[1] = this.elemIndexExpression;
            } else {
                Expression[] expressionArray3 = new Expression[1];
                expressionArray = expressionArray3;
                expressionArray3[0] = this.elemRefExpression;
            }
            this.projector = new TupleProjector(expressionArray);
            this.arrayPtr = new ImmutableBytesWritable();
            this.length = 0;
            this.index = 0;
            this.closed = false;
        }

        @Override
        public Tuple next() throws SQLException {
            if (this.closed) {
                return null;
            }
            while (this.index >= this.length) {
                this.current = super.next();
                if (this.current == null) {
                    this.closed = true;
                    return null;
                }
                if (!UnnestArrayPlan.this.arrayExpression.evaluate(this.current, this.arrayPtr)) continue;
                this.length = PArrayDataType.getArrayLength(this.arrayPtr, this.elemRefExpression.getDataType(), UnnestArrayPlan.this.arrayExpression.getMaxLength());
                this.index = 0;
                this.elemRefExpression.setArrayPtr(this.arrayPtr);
            }
            this.elemRefExpression.setIndex(this.index);
            if (this.elemIndexExpression != null) {
                this.elemIndexExpression.setIndex(this.index);
            }
            ++this.index;
            return this.projector.projectResults(this.current);
        }

        @Override
        public void close() throws SQLException {
            super.close();
            this.closed = true;
        }
    }
}

