/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.BaseExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;

public abstract class BaseSingleExpression
extends BaseExpression {
    protected List<Expression> children;

    public BaseSingleExpression() {
    }

    public BaseSingleExpression(Expression expression) {
        this((List<Expression>)ImmutableList.of((Object)expression));
    }

    public BaseSingleExpression(List<Expression> children) {
        this.children = children;
    }

    @Override
    public List<Expression> getChildren() {
        return this.children;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        Expression expression = ExpressionType.values()[WritableUtils.readVInt((DataInput)input)].newInstance();
        expression.readFields(input);
        this.children = ImmutableList.of((Object)expression);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(this.children.get(0)).ordinal());
        this.children.get(0).write(output);
    }

    @Override
    public boolean isNullable() {
        return this.children.get(0).isNullable();
    }

    @Override
    public void reset() {
        this.children.get(0).reset();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.children.get(0).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseSingleExpression other = (BaseSingleExpression)obj;
        return this.children.get(0).equals(other.children.get(0));
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, null);
        if (l.isEmpty()) {
            return visitor.defaultReturn(this, l);
        }
        return l.get(0);
    }

    public Expression getChild() {
        return this.children.get(0);
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return this.children.get(0).requiresFinalEvaluation();
    }
}

