/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.expression.function.SingleAggregateFunction;
import org.apache.phoenix.schema.tuple.Tuple;

public class ServerAggregators
extends Aggregators {
    public static final ServerAggregators EMPTY_AGGREGATORS = new ServerAggregators(new SingleAggregateFunction[0], new Aggregator[0], new Expression[0], 0);
    private final Expression[] expressions;

    private ServerAggregators(SingleAggregateFunction[] functions, Aggregator[] aggregators, Expression[] expressions, int minNullableIndex) {
        super(functions, aggregators, minNullableIndex);
        if (aggregators.length != expressions.length) {
            throw new IllegalArgumentException("Number of aggregators (" + aggregators.length + ") must match the number of expressions (" + Arrays.toString(expressions) + ")");
        }
        this.expressions = expressions;
    }

    @Override
    public void aggregate(Aggregator[] aggregators, Tuple result) {
        for (int i = 0; i < this.expressions.length; ++i) {
            if (this.expressions[i].evaluate(result, this.ptr) && this.ptr.getLength() != 0) {
                aggregators[i].aggregate(result, this.ptr);
            }
            this.expressions[i].reset();
        }
    }

    public static byte[] serialize(List<SingleAggregateFunction> aggFuncs, int minNullableIndex) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt((DataOutput)output, (int)minNullableIndex);
            WritableUtils.writeVInt((DataOutput)output, (int)aggFuncs.size());
            for (int i = 0; i < aggFuncs.size(); ++i) {
                SingleAggregateFunction aggFunc = aggFuncs.get(i);
                WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(aggFunc).ordinal());
                aggFunc.write(output);
            }
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Aggregator[] newAggregators() {
        return this.newAggregators(null);
    }

    public Aggregator[] newAggregators(Configuration conf) {
        Aggregator[] aggregators = new Aggregator[this.functions.length];
        for (int i = 0; i < this.functions.length; ++i) {
            aggregators[i] = this.functions[i].newServerAggregator(conf);
        }
        return aggregators;
    }

    public static ServerAggregators deserialize(byte[] b, Configuration conf) {
        if (b == null) {
            return EMPTY_AGGREGATORS;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        try {
            DataInputStream input = new DataInputStream(stream);
            int minNullableIndex = WritableUtils.readVInt((DataInput)input);
            int len = WritableUtils.readVInt((DataInput)input);
            Aggregator[] aggregators = new Aggregator[len];
            Expression[] expressions = new Expression[len];
            SingleAggregateFunction[] functions = new SingleAggregateFunction[len];
            for (int i = 0; i < aggregators.length; ++i) {
                SingleAggregateFunction aggFunc = (SingleAggregateFunction)ExpressionType.values()[WritableUtils.readVInt((DataInput)input)].newInstance();
                aggFunc.readFields(input, conf);
                functions[i] = aggFunc;
                aggregators[i] = aggFunc.getAggregator();
                expressions[i] = aggFunc.getAggregatorExpression();
            }
            ServerAggregators serverAggregators = new ServerAggregators(functions, aggregators, expressions, minNullableIndex);
            return serverAggregators;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

