/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.EncodeFormat;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.Base62Encoder;

@FunctionParseNode.BuiltInFunction(name="ENCODE", args={@FunctionParseNode.Argument(allowedTypes={PLong.class}), @FunctionParseNode.Argument(enumeration="EncodeFormat")})
public class EncodeFunction
extends ScalarFunction {
    public static final String NAME = "ENCODE";

    public EncodeFunction() {
    }

    public EncodeFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression numExpr = this.getNumExpr();
        if (!numExpr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        long num = numExpr.getDataType().getCodec().decodeLong(ptr, numExpr.getSortOrder());
        Expression encodingExpression = this.getEncodingExpr();
        if (!encodingExpression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            throw new IllegalDataException(EncodeFunction.getMissingEncodeFormatMsg());
        }
        PDataType type = encodingExpression.getDataType();
        String encodingFormat = ((String)type.toObject(ptr)).toUpperCase();
        EncodeFormat format = EncodeFormat.valueOf(encodingFormat);
        switch (format) {
            case BASE62: {
                String encodedString = Base62Encoder.toString(num);
                ptr.set(PVarchar.INSTANCE.toBytes(encodedString));
                break;
            }
            default: {
                throw new IllegalDataException(EncodeFunction.getUnsupportedEncodeFormatMsg(encodingFormat));
            }
        }
        return true;
    }

    public static String getMissingEncodeFormatMsg() {
        return "Missing Encode Format";
    }

    public static String getUnsupportedEncodeFormatMsg(String encodeFormat) {
        return "Unsupported Encode Format : " + encodeFormat;
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Expression getNumExpr() {
        return (Expression)this.children.get(0);
    }

    private Expression getEncodingExpr() {
        return (Expression)this.children.get(1);
    }
}

