/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ScannerContextUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.PositionBasedResultTuple;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;

public abstract class RegionScannerFactory {
    protected RegionCoprocessorEnvironment env;
    protected boolean useNewValueColumnQualifier;
    protected PTable.QualifierEncodingScheme encodingScheme;

    public Region getRegion() {
        return this.env.getRegion();
    }

    public abstract RegionScanner getRegionScanner(Scan var1, RegionScanner var2) throws Throwable;

    public RegionScanner getWrappedScanner(final RegionCoprocessorEnvironment env, final RegionScanner s, final Set<KeyValueColumnExpression> arrayKVRefs, final Expression[] arrayFuncRefs, final int offset, final Scan scan, final ColumnReference[] dataColumns, final TupleProjector tupleProjector, final Region dataRegion, final IndexMaintainer indexMaintainer, PhoenixTransactionContext tx, final byte[][] viewConstants, final KeyValueSchema kvSchema, final ValueBitSet kvSchemaBitSet, final TupleProjector projector, final ImmutableBytesWritable ptr, final boolean useQualifierAsListIndex) {
        return new RegionScanner(){
            private boolean hasReferences = this.checkForReferenceFiles();
            private HRegionInfo regionInfo = env.getRegionInfo();
            private byte[] actualStartKey = this.getActualStartKey();

            private boolean checkForReferenceFiles() {
                if (!ScanUtil.isLocalIndex(scan)) {
                    return false;
                }
                for (byte[] family : scan.getFamilies()) {
                    if (!RegionScannerFactory.this.getRegion().getStore(family).hasReferences()) continue;
                    return true;
                }
                return false;
            }

            public byte[] getActualStartKey() {
                return ScanUtil.isLocalIndex(scan) ? ScanUtil.getActualStartRow(scan, this.regionInfo) : null;
            }

            public boolean next(List<Cell> results) throws IOException {
                try {
                    return s.next(results);
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(RegionScannerFactory.this.getRegion().getRegionInfo().getRegionNameAsString(), t);
                    return false;
                }
            }

            public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
                throw new IOException("Next with scannerContext should not be called in Phoenix environment");
            }

            public void close() throws IOException {
                s.close();
            }

            public HRegionInfo getRegionInfo() {
                return s.getRegionInfo();
            }

            public boolean isFilterDone() throws IOException {
                return s.isFilterDone();
            }

            public boolean reseek(byte[] row) throws IOException {
                return s.reseek(row);
            }

            public long getMvccReadPoint() {
                return s.getMvccReadPoint();
            }

            public boolean nextRaw(List<Cell> result) throws IOException {
                try {
                    boolean next = s.nextRaw(result);
                    Cell arrayElementCell = null;
                    if (result.size() == 0) {
                        return next;
                    }
                    if (arrayFuncRefs != null && arrayFuncRefs.length > 0 && arrayKVRefs.size() > 0) {
                        int arrayElementCellPosition = this.replaceArrayIndexElement(arrayKVRefs, arrayFuncRefs, result);
                        arrayElementCell = result.get(arrayElementCellPosition);
                    }
                    if (ScanUtil.isLocalIndex(scan) && !ScanUtil.isAnalyzeTable(scan)) {
                        if (this.hasReferences && this.actualStartKey != null) {
                            next = this.scanTillScanStartRow(s, arrayKVRefs, arrayFuncRefs, result, null, arrayElementCell);
                            if (result.isEmpty()) {
                                return next;
                            }
                        }
                        IndexUtil.wrapResultUsingOffset(env, result, offset, dataColumns, tupleProjector, dataRegion, indexMaintainer, viewConstants, ptr);
                    }
                    if (projector != null) {
                        BaseTuple toProject = useQualifierAsListIndex ? new PositionBasedResultTuple(result) : new ResultTuple(Result.create(result));
                        TupleProjector.ProjectedValueTuple tuple = projector.projectResults(toProject, RegionScannerFactory.this.useNewValueColumnQualifier);
                        result.clear();
                        result.add(tuple.getValue(0));
                        if (arrayElementCell != null) {
                            result.add(arrayElementCell);
                        }
                    }
                    return next;
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(RegionScannerFactory.this.getRegion().getRegionInfo().getRegionNameAsString(), t);
                    return false;
                }
            }

            public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
                boolean res = this.next(result);
                ScannerContextUtil.incrementSizeProgress(scannerContext, result);
                ScannerContextUtil.updateTimeProgress(scannerContext);
                return res;
            }

            private boolean scanTillScanStartRow(RegionScanner s2, Set<KeyValueColumnExpression> arrayKVRefs2, Expression[] arrayFuncRefs2, List<Cell> result, ScannerContext scannerContext, Cell arrayElementCell) throws IOException {
                boolean next = true;
                Cell firstCell = result.get(0);
                while (Bytes.compareTo((byte[])firstCell.getRowArray(), (int)firstCell.getRowOffset(), (int)firstCell.getRowLength(), (byte[])this.actualStartKey, (int)0, (int)this.actualStartKey.length) < 0) {
                    result.clear();
                    next = scannerContext == null ? s2.nextRaw(result) : s2.nextRaw(result, scannerContext);
                    if (result.isEmpty()) {
                        return next;
                    }
                    if (arrayFuncRefs2 != null && arrayFuncRefs2.length > 0 && arrayKVRefs2.size() > 0) {
                        int arrayElementCellPosition = this.replaceArrayIndexElement(arrayKVRefs2, arrayFuncRefs2, result);
                        arrayElementCell = result.get(arrayElementCellPosition);
                    }
                    firstCell = result.get(0);
                }
                return next;
            }

            private int replaceArrayIndexElement(Set<KeyValueColumnExpression> arrayKVRefs2, Expression[] arrayFuncRefs2, List<Cell> result) {
                MultiKeyValueTuple tuple = new MultiKeyValueTuple((List<Cell>)ImmutableList.copyOf(result));
                Cell rowKv = result.get(0);
                block0: for (KeyValueColumnExpression kvExp : arrayKVRefs2) {
                    if (!kvExp.evaluate(tuple, ptr)) continue;
                    ListIterator<Cell> itr = result.listIterator();
                    while (itr.hasNext()) {
                        Cell kv = itr.next();
                        if (!Bytes.equals((byte[])kvExp.getColumnFamily(), (int)0, (int)kvExp.getColumnFamily().length, (byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength()) || !Bytes.equals((byte[])kvExp.getColumnQualifier(), (int)0, (int)kvExp.getColumnQualifier().length, (byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength())) continue;
                        itr.remove();
                        continue block0;
                    }
                }
                byte[] value = kvSchema.toBytes(tuple, arrayFuncRefs2, kvSchemaBitSet, ptr);
                result.add((Cell)new KeyValue(rowKv.getRowArray(), rowKv.getRowOffset(), (int)rowKv.getRowLength(), QueryConstants.ARRAY_VALUE_COLUMN_FAMILY, 0, QueryConstants.ARRAY_VALUE_COLUMN_FAMILY.length, QueryConstants.ARRAY_VALUE_COLUMN_QUALIFIER, 0, QueryConstants.ARRAY_VALUE_COLUMN_QUALIFIER.length, Long.MAX_VALUE, KeyValue.Type.codeToType((byte)rowKv.getTypeByte()), value, 0, value.length));
                return result.size() - 1;
            }

            public long getMaxResultSize() {
                return s.getMaxResultSize();
            }

            public int getBatch() {
                return s.getBatch();
            }
        };
    }
}

