/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.phoenix.jdbc.DelegateConnection;
import org.apache.phoenix.jdbc.LoggingPhoenixPreparedStatement;
import org.apache.phoenix.jdbc.LoggingPhoenixResultSet;
import org.apache.phoenix.jdbc.LoggingPhoenixStatement;
import org.apache.phoenix.jdbc.PhoenixMetricsLog;
import org.apache.phoenix.util.PhoenixRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPhoenixConnection
extends DelegateConnection {
    private static final Logger logger = LoggerFactory.getLogger(LoggingPhoenixResultSet.class);
    private PhoenixMetricsLog phoenixMetricsLog;

    public LoggingPhoenixConnection(Connection conn, PhoenixMetricsLog phoenixMetricsLog) {
        super(conn);
        this.phoenixMetricsLog = phoenixMetricsLog;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new LoggingPhoenixStatement(super.createStatement(), this.phoenixMetricsLog);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new LoggingPhoenixStatement(super.createStatement(resultSetType, resultSetConcurrency), this.phoenixMetricsLog);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LoggingPhoenixStatement(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this.phoenixMetricsLog);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql), this.phoenixMetricsLog);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql, resultSetType, resultSetConcurrency), this.phoenixMetricsLog);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this.phoenixMetricsLog);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql, autoGeneratedKeys), this.phoenixMetricsLog);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql, columnIndexes), this.phoenixMetricsLog);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql, columnNames), this.phoenixMetricsLog);
    }

    @Override
    public void commit() throws SQLException {
        super.commit();
        this.phoenixMetricsLog.logWriteMetricsfoForMutations(logger, PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset(this.conn));
        this.phoenixMetricsLog.logReadMetricInfoForMutationsSinceLastReset(logger, PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset(this.conn));
        PhoenixRuntime.resetMetrics(this.conn);
    }
}

