/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.mapreduce.CsvBulkImportUtil;
import org.apache.phoenix.mapreduce.FormatToBytesWritableMapper;
import org.apache.phoenix.mapreduce.FormatToKeyValueReducer;
import org.apache.phoenix.mapreduce.MultiHfileOutputFormat;
import org.apache.phoenix.mapreduce.bulkload.TableRowkeyPair;
import org.apache.phoenix.mapreduce.bulkload.TargetTableRef;
import org.apache.phoenix.mapreduce.bulkload.TargetTableRefFunctions;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBulkLoadTool
extends Configured
implements Tool {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractBulkLoadTool.class);
    static final Option ZK_QUORUM_OPT = new Option("z", "zookeeper", true, "Supply zookeeper connection details (optional)");
    static final Option INPUT_PATH_OPT = new Option("i", "input", true, "Input path(s) (comma-separated, mandatory)");
    static final Option OUTPUT_PATH_OPT = new Option("o", "output", true, "Output path for temporary HFiles (optional)");
    static final Option SCHEMA_NAME_OPT = new Option("s", "schema", true, "Phoenix schema name (optional)");
    static final Option TABLE_NAME_OPT = new Option("t", "table", true, "Phoenix table name (mandatory)");
    static final Option INDEX_TABLE_NAME_OPT = new Option("it", "index-table", true, "Phoenix index table name when just loading this particualar index table");
    static final Option IMPORT_COLUMNS_OPT = new Option("c", "import-columns", true, "Comma-separated list of columns to be imported");
    static final Option IGNORE_ERRORS_OPT = new Option("g", "ignore-errors", false, "Ignore input errors");
    static final Option HELP_OPT = new Option("h", "help", false, "Show this help and quit");

    protected abstract void configureOptions(CommandLine var1, List<ColumnInfo> var2, Configuration var3) throws SQLException;

    protected abstract void setupJob(Job var1);

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(INPUT_PATH_OPT);
        options.addOption(TABLE_NAME_OPT);
        options.addOption(INDEX_TABLE_NAME_OPT);
        options.addOption(ZK_QUORUM_OPT);
        options.addOption(OUTPUT_PATH_OPT);
        options.addOption(SCHEMA_NAME_OPT);
        options.addOption(IMPORT_COLUMNS_OPT);
        options.addOption(IGNORE_ERRORS_OPT);
        options.addOption(HELP_OPT);
        return options;
    }

    protected CommandLine parseOptions(String[] args) {
        Options options = this.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("Error parsing command line options: " + e.getMessage(), options);
        }
        if (cmdLine.hasOption(HELP_OPT.getOpt())) {
            this.printHelpAndExit(options, 0);
        }
        if (!cmdLine.hasOption(TABLE_NAME_OPT.getOpt())) {
            throw new IllegalStateException(TABLE_NAME_OPT.getLongOpt() + " is a mandatory " + "parameter");
        }
        if (!cmdLine.getArgList().isEmpty()) {
            throw new IllegalStateException("Got unexpected extra parameters: " + cmdLine.getArgList());
        }
        return cmdLine;
    }

    private void printHelpAndExit(String errorMessage, Options options) {
        System.err.println(errorMessage);
        this.printHelpAndExit(options, 1);
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", options);
        System.exit(exitCode);
    }

    public int run(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create((Configuration)this.getConf());
        CommandLine cmdLine = null;
        try {
            cmdLine = this.parseOptions(args);
        }
        catch (IllegalStateException e) {
            this.printHelpAndExit(e.getMessage(), this.getOptions());
        }
        return this.loadData(conf, cmdLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadData(Configuration conf, CommandLine cmdLine) throws Exception {
        String tableName = cmdLine.getOptionValue(TABLE_NAME_OPT.getOpt());
        String schemaName = cmdLine.getOptionValue(SCHEMA_NAME_OPT.getOpt());
        String indexTableName = cmdLine.getOptionValue(INDEX_TABLE_NAME_OPT.getOpt());
        String qualifiedTableName = SchemaUtil.getQualifiedTableName(schemaName, tableName);
        String qualifiedIndexTableName = null;
        if (indexTableName != null) {
            qualifiedIndexTableName = SchemaUtil.getQualifiedTableName(schemaName, indexTableName);
        }
        if (cmdLine.hasOption(ZK_QUORUM_OPT.getOpt())) {
            String zkQuorum = cmdLine.getOptionValue(ZK_QUORUM_OPT.getOpt());
            PhoenixEmbeddedDriver.ConnectionInfo info = PhoenixEmbeddedDriver.ConnectionInfo.create(zkQuorum);
            LOG.info("Configuring HBase connection to {}", (Object)info);
            for (Map.Entry<String, String> entry : info.asProps()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting {} = {}", (Object)entry.getKey(), (Object)entry.getValue());
                }
                conf.set(entry.getKey(), entry.getValue());
            }
        }
        Connection conn = QueryUtil.getConnection(conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading columns from {} :: {}", (Object)((PhoenixConnection)conn).getURL(), (Object)qualifiedTableName);
        }
        List<ColumnInfo> importColumns = this.buildImportColumns(conn, cmdLine, qualifiedTableName);
        Preconditions.checkNotNull(importColumns);
        Preconditions.checkArgument((!importColumns.isEmpty() ? 1 : 0) != 0, (Object)"Column info list is empty");
        FormatToBytesWritableMapper.configureColumnInfoList(conf, importColumns);
        boolean ignoreInvalidRows = cmdLine.hasOption(IGNORE_ERRORS_OPT.getOpt()) ? cmdLine.hasOption(IGNORE_ERRORS_OPT.getOpt()) : true;
        conf.setBoolean("phoenix.mapreduce.import.ignoreinvalidrow", ignoreInvalidRows);
        conf.set("phoenix.mapreduce.import.tablename", qualifiedTableName);
        this.configureOptions(cmdLine, importColumns, conf);
        try {
            this.validateTable(conn, schemaName, tableName);
        }
        finally {
            conn.close();
        }
        String inputPaths = cmdLine.getOptionValue(INPUT_PATH_OPT.getOpt());
        Path outputPath = cmdLine.hasOption(OUTPUT_PATH_OPT.getOpt()) ? new Path(cmdLine.getOptionValue(OUTPUT_PATH_OPT.getOpt())) : new Path("/tmp/" + UUID.randomUUID());
        ArrayList<TargetTableRef> tablesToBeLoaded = new ArrayList<TargetTableRef>();
        PTable table = PhoenixRuntime.getTable(conn, qualifiedTableName);
        tablesToBeLoaded.add(new TargetTableRef(qualifiedTableName, table.getPhysicalName().getString()));
        boolean hasLocalIndexes = false;
        for (PTable index : table.getIndexes()) {
            if (index.getIndexType() == PTable.IndexType.LOCAL && (hasLocalIndexes = qualifiedIndexTableName == null ? true : index.getTableName().getString().equals(qualifiedIndexTableName))) break;
        }
        tablesToBeLoaded.addAll(this.getIndexTables(conn, schemaName, qualifiedTableName));
        if (qualifiedIndexTableName != null) {
            TargetTableRef targetIndexRef = null;
            for (TargetTableRef tmpTable : tablesToBeLoaded) {
                if (tmpTable.getLogicalName().compareToIgnoreCase(qualifiedIndexTableName) != 0) continue;
                targetIndexRef = tmpTable;
                break;
            }
            if (targetIndexRef == null) {
                throw new IllegalStateException("Bulk Loader error: index table " + qualifiedIndexTableName + " doesn't exist");
            }
            tablesToBeLoaded.clear();
            tablesToBeLoaded.add(targetIndexRef);
        }
        return this.submitJob(conf, tableName, inputPaths, outputPath, tablesToBeLoaded, hasLocalIndexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submitJob(Configuration conf, String qualifiedTableName, String inputPaths, Path outputPath, List<TargetTableRef> tablesToBeLoaded, boolean hasLocalIndexes) throws Exception {
        Job job = Job.getInstance((Configuration)conf, (String)("Phoenix MapReduce import for " + qualifiedTableName));
        if (inputPaths != null) {
            FileInputFormat.addInputPaths((Job)job, (String)inputPaths);
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapOutputKeyClass(TableRowkeyPair.class);
        job.setMapOutputValueClass(ImmutableBytesWritable.class);
        job.setOutputKeyClass(TableRowkeyPair.class);
        job.setOutputValueClass(KeyValue.class);
        job.setReducerClass(FormatToKeyValueReducer.class);
        byte[][] splitKeysBeforeJob = null;
        HTable table = null;
        if (hasLocalIndexes) {
            try {
                table = new HTable(job.getConfiguration(), qualifiedTableName);
                splitKeysBeforeJob = table.getRegionLocator().getStartKeys();
            }
            finally {
                if (table != null) {
                    table.close();
                }
            }
        }
        MultiHfileOutputFormat.configureIncrementalLoad(job, tablesToBeLoaded);
        String tableNamesAsJson = (String)TargetTableRefFunctions.NAMES_TO_JSON.apply(tablesToBeLoaded);
        String logicalNamesAsJson = (String)TargetTableRefFunctions.LOGICAL_NAMES_TO_JSON.apply(tablesToBeLoaded);
        job.getConfiguration().set("phoenix.mapreduce.import.tablenames", tableNamesAsJson);
        job.getConfiguration().set("phoenix.mapreduce.import.logicalnames", logicalNamesAsJson);
        this.setupJob(job);
        LOG.info("Running MapReduce import job from {} to {}", (Object)inputPaths, (Object)outputPath);
        boolean success = job.waitForCompletion(true);
        if (success) {
            if (hasLocalIndexes) {
                try {
                    table = new HTable(job.getConfiguration(), qualifiedTableName);
                    if (!IndexUtil.matchingSplitKeys(splitKeysBeforeJob, table.getRegionLocator().getStartKeys())) {
                        LOG.error("The table " + qualifiedTableName + " has local indexes and there is split key mismatch before and" + " after running bulkload job. Please rerun the job otherwise" + " there may be inconsistencies between actual data and index data.");
                        int n = -1;
                        return n;
                    }
                }
                finally {
                    if (table != null) {
                        table.close();
                    }
                }
            }
            LOG.info("Loading HFiles from {}", (Object)outputPath);
            this.completebulkload(conf, outputPath, tablesToBeLoaded);
            LOG.info("Removing output directory {}", (Object)outputPath);
            if (!outputPath.getFileSystem(conf).delete(outputPath, true)) {
                LOG.error("Failed to delete the output directory {}", (Object)outputPath);
            }
            return 0;
        }
        return -1;
    }

    private void completebulkload(Configuration conf, Path outputPath, List<TargetTableRef> tablesToBeLoaded) throws Exception {
        HashSet<String> tableNames = new HashSet<String>(tablesToBeLoaded.size());
        for (TargetTableRef table : tablesToBeLoaded) {
            if (tableNames.contains(table.getPhysicalName())) continue;
            tableNames.add(table.getPhysicalName());
            LoadIncrementalHFiles loader = new LoadIncrementalHFiles(conf);
            String tableName = table.getPhysicalName();
            Path tableOutputPath = CsvBulkImportUtil.getOutputPath(outputPath, tableName);
            HTable htable = new HTable(conf, tableName);
            LOG.info("Loading HFiles for {} from {}", (Object)tableName, (Object)tableOutputPath);
            loader.doBulkLoad(tableOutputPath, htable);
            LOG.info("Incremental load complete for table=" + tableName);
        }
    }

    List<ColumnInfo> buildImportColumns(Connection conn, CommandLine cmdLine, String qualifiedTableName) throws SQLException {
        ArrayList userSuppliedColumnNames = null;
        if (cmdLine.hasOption(IMPORT_COLUMNS_OPT.getOpt())) {
            userSuppliedColumnNames = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)cmdLine.getOptionValue(IMPORT_COLUMNS_OPT.getOpt())));
        }
        return SchemaUtil.generateColumnInfo(conn, qualifiedTableName, userSuppliedColumnNames, true);
    }

    private void validateTable(Connection conn, String schemaName, String tableName) throws SQLException {
        ResultSet rs = conn.getMetaData().getColumns(null, StringUtil.escapeLike(schemaName), StringUtil.escapeLike(tableName), null);
        while (rs.next()) {
            String familyName = rs.getString("COLUMN_FAMILY");
            if (familyName == null || !familyName.startsWith("_")) continue;
            if ("0".equals(familyName)) {
                throw new IllegalStateException("Bulk Loader error: All column names that are not part of the primary key constraint must be prefixed with a column family name (i.e. f.my_column VARCHAR)");
            }
            throw new IllegalStateException("Bulk Loader error: Column family name must not start with '_': " + familyName);
        }
        rs.close();
    }

    private List<TargetTableRef> getIndexTables(Connection conn, String schemaName, String qualifiedTableName) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, qualifiedTableName);
        ArrayList<TargetTableRef> indexTables = new ArrayList<TargetTableRef>();
        for (PTable indexTable : table.getIndexes()) {
            indexTables.add(new TargetTableRef(indexTable.getName().getString(), indexTable.getPhysicalName().getString()));
        }
        return indexTables;
    }
}

