/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputSplit;

public class ODPSInputSplit
extends InputSplit
implements Writable {
    private int idx;
    private long start;
    private long count;
    private long splitSize;

    public ODPSInputSplit() {
    }

    public ODPSInputSplit(int idx, long start, long count, long splitSize) {
        this.idx = idx;
        this.start = start;
        this.count = count;
        this.splitSize = splitSize;
    }

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeVInt((DataOutput)dataOutput, (int)this.idx);
        WritableUtils.writeVLong((DataOutput)dataOutput, (long)this.start);
        WritableUtils.writeVLong((DataOutput)dataOutput, (long)this.count);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.idx = WritableUtils.readVInt((DataInput)dataInput);
        this.start = WritableUtils.readVLong((DataInput)dataInput);
        this.count = WritableUtils.readVLong((DataInput)dataInput);
    }

    public long getLength() throws IOException, InterruptedException {
        return this.splitSize;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[]{""};
    }

    public int getIdx() {
        return this.idx;
    }

    public long getStart() {
        return this.start;
    }

    public long getCount() {
        return this.count;
    }

    public String toString() {
        return "ODPSInputSplit{idx=" + this.idx + ", start=" + this.start + ", count=" + this.count + ", splitSize=" + this.splitSize + '}';
    }
}

