/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import com.aliyun.odps.Odps;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.PhoenixInputFormat;
import org.apache.phoenix.mapreduce.PhoenixOutputFormat;
import org.apache.phoenix.mapreduce.bulkload.TableRowkeyPair;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;

public final class PhoenixMapReduceUtil {
    private PhoenixMapReduceUtil() {
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String tableName, String conditions, String ... fieldNames) {
        Configuration configuration = PhoenixMapReduceUtil.setInput(job, inputClass, tableName);
        if (conditions != null) {
            PhoenixConfigurationUtil.setInputTableConditions(configuration, conditions);
        }
        PhoenixConfigurationUtil.setSelectColumnNames(configuration, fieldNames);
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String tableName, String inputQuery) {
        Configuration configuration = PhoenixMapReduceUtil.setInput(job, inputClass, tableName);
        PhoenixConfigurationUtil.setInputQuery(configuration, inputQuery);
        PhoenixConfigurationUtil.setSchemaType(configuration, PhoenixConfigurationUtil.SchemaType.QUERY);
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String snapshotName, String tableName, Path restoreDir, String conditions, String ... fieldNames) throws IOException {
        Configuration configuration = PhoenixMapReduceUtil.setSnapshotInput(job, inputClass, snapshotName, tableName, restoreDir);
        if (conditions != null) {
            PhoenixConfigurationUtil.setInputTableConditions(configuration, conditions);
        }
        PhoenixConfigurationUtil.setSelectColumnNames(configuration, fieldNames);
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String snapshotName, String tableName, Path restoreDir, String inputQuery) throws IOException {
        Configuration configuration = PhoenixMapReduceUtil.setSnapshotInput(job, inputClass, snapshotName, tableName, restoreDir);
        if (inputQuery != null) {
            PhoenixConfigurationUtil.setInputQuery(configuration, inputQuery);
        }
    }

    private static Configuration setSnapshotInput(Job job, Class<? extends DBWritable> inputClass, String snapshotName, String tableName, Path restoreDir) {
        job.setInputFormatClass(PhoenixInputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setInputClass(configuration, inputClass);
        PhoenixConfigurationUtil.setSnapshotNameKey(configuration, snapshotName);
        PhoenixConfigurationUtil.setInputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setRestoreDirKey(configuration, new Path(restoreDir, UUID.randomUUID().toString()).toString());
        PhoenixConfigurationUtil.setSchemaType(configuration, PhoenixConfigurationUtil.SchemaType.QUERY);
        return configuration;
    }

    private static Configuration setInput(Job job, Class<? extends DBWritable> inputClass, String tableName) {
        job.setInputFormatClass(PhoenixInputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setInputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setInputClass(configuration, inputClass);
        return configuration;
    }

    public static void setInputCluster(Job job, String quorum) {
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setInputCluster(configuration, quorum);
    }

    public static void setOutput(Job job, String tableName, String columns) {
        job.setOutputFormatClass(PhoenixOutputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setOutputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setUpsertColumnNames(configuration, columns.split(","));
    }

    public static void setOutput(Job job, String tableName, String ... fieldNames) {
        job.setOutputFormatClass(PhoenixOutputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setOutputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setUpsertColumnNames(configuration, fieldNames);
    }

    public static void setOutputCluster(Job job, String quorum) {
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setOutputCluster(configuration, quorum);
    }

    public static TableTunnel.DownloadSession getDownloadSession(Configuration conf) throws TunnelException {
        String accessKeyId = conf.get("odps.access.key.id");
        String accessKeySecret = conf.get("odps.access.key.secret");
        String project = conf.get("odps.project.name");
        String odpsUrl = conf.get("odps.url");
        String tunnelUrl = conf.get("odps.tunnel.url");
        String tableName = conf.get("odps.table.name");
        String partitionSpec = conf.get("odps.table.partition.spec", "Non-Partitioned");
        AliyunAccount account = new AliyunAccount(accessKeyId, accessKeySecret);
        Odps odps = new Odps((Account)account);
        odps.setDefaultProject(project);
        odps.setEndpoint(odpsUrl);
        TableTunnel tunnel = new TableTunnel(odps);
        tunnel.setEndpoint(tunnelUrl);
        if (partitionSpec.equals("Non-Partitioned")) {
            return tunnel.createDownloadSession(project, tableName);
        }
        PartitionSpec parSpec = new PartitionSpec(partitionSpec);
        return tunnel.createDownloadSession(project, tableName, parSpec);
    }

    public static List<ColumnInfo> buildTargetTableColumns(Configuration conf) {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Splitter.on((String)"|").split((CharSequence)conf.get("phoenix.mapped.import.columninfos")), (Function)new Function<String, ColumnInfo>(){

            @Nullable
            public ColumnInfo apply(@Nullable String input) {
                if (input == null || input.isEmpty()) {
                    return null;
                }
                return ColumnInfo.fromString(input);
            }
        }));
    }

    public static List<Pair<Long, Long>> getRanges(long count, int numRanges) {
        ArrayList<Pair<Long, Long>> ranges = new ArrayList<Pair<Long, Long>>();
        if (count <= (long)numRanges) {
            ranges.add(new Pair((Object)0L, (Object)count));
        } else {
            long[] rangeSpans = new long[numRanges];
            long per = count / (long)numRanges;
            Arrays.fill(rangeSpans, per);
            long remainder = count - (long)numRanges * per + 1L;
            int i = 0;
            while ((long)i < remainder) {
                int n = i++;
                rangeSpans[n] = rangeSpans[n] + 1L;
            }
            long start = 0L;
            long end = 0L;
            for (int i2 = 0; i2 < numRanges && end < count; ++i2) {
                end = start + rangeSpans[i2] - 1L;
                end = end < count ? end : count;
                ranges.add((Pair<Long, Long>)new Pair((Object)start, (Object)end));
                start = start < count ? end + 1L : count;
            }
        }
        return ranges;
    }

    public static Map<byte[], Integer> initColumnIndexes(PhoenixConnection conn, List<String> logicalNames) throws SQLException {
        TreeMap<byte[], Integer> columnIndexes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        int columnIndex = 0;
        for (int index = 0; index < logicalNames.size(); ++index) {
            byte[] cfn;
            int i;
            PTable table = PhoenixRuntime.getTable(conn, logicalNames.get(index));
            if (!table.getImmutableStorageScheme().equals(PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN)) {
                List<PColumnFamily> cfs = table.getColumnFamilies();
                for (i = 0; i < cfs.size(); ++i) {
                    byte[] family = cfs.get(i).getName().getBytes();
                    cfn = Bytes.add((byte[])family, (byte[])QueryConstants.NAMESPACE_SEPARATOR_BYTES, (byte[])QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES);
                    columnIndexes.put(cfn, new Integer(columnIndex));
                    ++columnIndex;
                }
                continue;
            }
            List<PColumn> cls = table.getColumns();
            for (i = 0; i < cls.size(); ++i) {
                byte[] cq;
                PColumn c = cls.get(i);
                byte[] family = new byte[]{};
                if (!SchemaUtil.isPKColumn(c)) {
                    family = c.getFamilyName().getBytes();
                    cq = c.getColumnQualifierBytes();
                } else {
                    cq = c.getName().getBytes();
                }
                byte[] cfn2 = Bytes.add((byte[])family, (byte[])QueryConstants.NAMESPACE_SEPARATOR_BYTES, (byte[])cq);
                if (columnIndexes.containsKey(cfn2)) continue;
                columnIndexes.put(cfn2, new Integer(columnIndex));
                ++columnIndex;
            }
            byte[] emptyColumnFamily = SchemaUtil.getEmptyColumnFamily(table);
            byte[] emptyKeyValue = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(table).getFirst();
            cfn = Bytes.add((byte[])emptyColumnFamily, (byte[])QueryConstants.NAMESPACE_SEPARATOR_BYTES, (byte[])emptyKeyValue);
            columnIndexes.put(cfn, new Integer(columnIndex));
            ++columnIndex;
        }
        return columnIndexes;
    }

    private static int findIndex(Cell cell, Map<byte[], Integer> columnIndexes) throws IOException {
        byte[] cq;
        byte[] familyName = Bytes.copy((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength());
        byte[] cfn = Bytes.add((byte[])familyName, (byte[])QueryConstants.NAMESPACE_SEPARATOR_BYTES, (byte[])(cq = Bytes.copy((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength())));
        if (columnIndexes.containsKey(cfn)) {
            return columnIndexes.get(cfn);
        }
        return -1;
    }

    public static void writeAggregatedRow(Mapper.Context context, String tableName, List<KeyValue> lkv, Map<byte[], Integer> columnIndexes) throws IOException, InterruptedException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        DataOutputStream outputStream = new DataOutputStream(bos);
        ImmutableBytesWritable outputKey = null;
        if (!lkv.isEmpty()) {
            for (KeyValue cell : lkv) {
                int i;
                if (outputKey == null || Bytes.compareTo((byte[])outputKey.get(), (int)outputKey.getOffset(), (int)outputKey.getLength(), (byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()) != 0) {
                    if (outputKey != null) {
                        ImmutableBytesWritable aggregatedArray = new ImmutableBytesWritable(bos.toByteArray());
                        outputStream.close();
                        context.write((Object)new TableRowkeyPair(tableName, outputKey), (Object)aggregatedArray);
                    }
                    outputKey = new ImmutableBytesWritable(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
                    bos = new ByteArrayOutputStream(1024);
                    outputStream = new DataOutputStream(bos);
                }
                if ((i = PhoenixMapReduceUtil.findIndex((Cell)cell, columnIndexes)) == -1) continue;
                outputStream.writeByte(cell.getTypeByte());
                WritableUtils.writeVLong((DataOutput)outputStream, (long)cell.getTimestamp());
                WritableUtils.writeVInt((DataOutput)outputStream, (int)i);
                WritableUtils.writeVInt((DataOutput)outputStream, (int)cell.getValueLength());
                outputStream.write(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            }
            ImmutableBytesWritable aggregatedArray = new ImmutableBytesWritable(bos.toByteArray());
            outputStream.close();
            context.write((Object)new TableRowkeyPair(tableName, outputKey), (Object)aggregatedArray);
        }
    }
}

