/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.List;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.BindableStatement;
import org.apache.phoenix.parse.CursorName;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.SelectStatement;

public class DeclareCursorStatement
implements BindableStatement {
    private final CursorName cursorName;
    private final SelectStatement select;

    public DeclareCursorStatement(CursorName cursorName, SelectStatement select) {
        this.cursorName = cursorName;
        this.select = select;
    }

    public String getCursorName() {
        return this.cursorName.getName();
    }

    public String getQuerySQL() {
        if (this.select.getBindCount() > 0) {
            // empty if block
        }
        return this.select.toString();
    }

    public SelectStatement getSelect() {
        return this.select;
    }

    public List<OrderByNode> getSelectOrderBy() {
        return this.select.getOrderBy();
    }

    @Override
    public int getBindCount() {
        return this.select.getBindCount();
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return PhoenixStatement.Operation.UPSERT;
    }
}

