/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.ipc.controller.ClientRpcControllerFactory;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableRefFactory;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.ReadOnlyProps;

public class QueryServicesOptions {
    public static final int DEFAULT_KEEP_ALIVE_MS = 60000;
    public static final int DEFAULT_THREAD_POOL_SIZE = 64;
    public static final int DEFAULT_QUEUE_SIZE = 5000;
    public static final int DEFAULT_THREAD_TIMEOUT_MS = 600000;
    public static final int DEFAULT_SPOOL_THRESHOLD_BYTES = 0x1400000;
    public static final String DEFAULT_SPOOL_DIRECTORY = System.getProperty("java.io.tmpdir");
    public static final int DEFAULT_MAX_MEMORY_PERC = 15;
    public static final int DEFAULT_MAX_TENANT_MEMORY_PERC = 100;
    public static final long DEFAULT_MAX_SERVER_CACHE_SIZE = 0x6400000L;
    public static final int DEFAULT_TARGET_QUERY_CONCURRENCY = 32;
    public static final int DEFAULT_MAX_QUERY_CONCURRENCY = 32;
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DEFAULT_DATE_FORMAT_TIMEZONE = "GMT";
    public static final boolean DEFAULT_CALL_QUEUE_ROUND_ROBIN = true;
    public static final int DEFAULT_MAX_MUTATION_SIZE = 35000;
    public static final int DEFAULT_MAX_MUTATION_SIZE_BYTES = 0x9600000;
    public static final boolean DEFAULT_USE_INDEXES = true;
    public static final boolean DEFAULT_IMMUTABLE_ROWS = false;
    public static final boolean DEFAULT_DROP_METADATA = true;
    public static final long DEFAULT_DRIVER_SHUTDOWN_TIMEOUT_MS = 5000L;
    public static final boolean DEFAULT_TRACING_ENABLED = false;
    public static final int DEFAULT_TRACING_THREAD_POOL_SIZE = 5;
    public static final int DEFAULT_TRACING_BATCH_SIZE = 100;
    public static final int DEFAULT_TRACING_TRACE_BUFFER_SIZE = 1000;
    public static final int DEFAULT_MAX_INDEXES_PER_TABLE = 10;
    public static final int DEFAULT_MUTATE_BATCH_SIZE = 100;
    public static final long DEFAULT_MUTATE_BATCH_SIZE_BYTES = 2597152L;
    public static final int DEFAULT_MAX_SERVER_CACHE_TIME_TO_LIVE_MS = 30000;
    public static final int DEFAULT_SCAN_CACHE_SIZE = 100;
    public static final int DEFAULT_MAX_INTRA_REGION_PARALLELIZATION = 32;
    public static final int DEFAULT_DISTINCT_VALUE_COMPRESS_THRESHOLD = 0x100000;
    public static final int DEFAULT_INDEX_MUTATE_BATCH_SIZE_THRESHOLD = 3;
    public static final long DEFAULT_MAX_SPOOL_TO_DISK_BYTES = 1024000000L;
    public static final long DEFAULT_SCAN_RESULT_CHUNK_SIZE = 15000L;
    public static final boolean DEFAULT_IS_NAMESPACE_MAPPING_ENABLED = false;
    public static final boolean DEFAULT_IS_SYSTEM_TABLE_MAPPED_TO_NAMESPACE = true;
    public static boolean DEFAULT_GROUPBY_SPILLABLE = true;
    public static final int DEFAULT_GROUPBY_SPILL_FILES = 2;
    public static final long DEFAULT_GROUPBY_MAX_CACHE_MAX = 0x6400000L;
    public static final long DEFAULT_SEQUENCE_CACHE_SIZE = 100L;
    public static final long DEFAULT_MAX_SERVER_METADATA_CACHE_TIME_TO_LIVE_MS = 1800000L;
    public static final long DEFAULT_MAX_SERVER_METADATA_CACHE_SIZE = 0x1400000L;
    public static final long DEFAULT_MAX_CLIENT_METADATA_CACHE_SIZE = 0xA00000L;
    public static final int DEFAULT_GROUPBY_ESTIMATED_DISTINCT_VALUES = 1000;
    public static final int DEFAULT_CLOCK_SKEW_INTERVAL = 2000;
    public static final boolean DEFAULT_INDEX_FAILURE_HANDLING_REBUILD = true;
    public static final boolean DEFAULT_INDEX_FAILURE_BLOCK_WRITE = false;
    public static final boolean DEFAULT_INDEX_FAILURE_DISABLE_INDEX = true;
    public static final boolean DEFAULT_INDEX_FAILURE_THROW_EXCEPTION = true;
    public static final long DEFAULT_INDEX_FAILURE_HANDLING_REBUILD_INTERVAL = 60000L;
    public static final long DEFAULT_INDEX_REBUILD_TASK_INITIAL_DELAY = 10000L;
    public static final long DEFAULT_INDEX_FAILURE_HANDLING_REBUILD_OVERLAP_BACKWARD_TIME = 1L;
    public static final long DEFAULT_INDEX_FAILURE_HANDLING_REBUILD_OVERLAP_FORWARD_TIME = 30000L;
    public static final long DEFAULT_INDEX_REBUILD_QUERY_TIMEOUT = 9002100L;
    public static final long DEFAULT_INDEX_REBUILD_RPC_TIMEOUT = 3600000L;
    public static final long DEFAULT_INDEX_REBUILD_CLIENT_SCANNER_TIMEOUT = 3600000L;
    public static final int DEFAULT_INDEX_REBUILD_RPC_RETRIES_COUNTER = 5;
    public static final int DEFAULT_INDEX_REBUILD_DISABLE_TIMESTAMP_THRESHOLD = Integer.MAX_VALUE;
    public static final int DEFAULT_INDEX_PRIORITY = 1000;
    public static final int DEFAULT_METADATA_PRIORITY = 2000;
    public static final boolean DEFAULT_ALLOW_LOCAL_INDEX = false;
    public static final int DEFAULT_INDEX_HANDLER_COUNT = 20;
    public static final int DEFAULT_METADATA_HANDLER_COUNT = 30;
    public static final int DEFAULT_METADATA_WRITE_RETRIES_NUMBER = 20;
    public static final int DEFAULT_METADATA_WRITE_RETRY_PAUSE = 100;
    public static final int DEFAULT_TRACING_PAGE_SIZE = 100;
    public static final String DEFAULT_TRACING_STATS_TABLE_NAME = "SYSTEM.TRACING_STATS";
    public static final String DEFAULT_TRACING_FREQ = Tracing.Frequency.NEVER.getKey();
    public static final double DEFAULT_TRACING_PROBABILITY_THRESHOLD = 0.05;
    public static final int DEFAULT_STATS_UPDATE_FREQ_MS = 900000;
    public static final int DEFAULT_STATS_GUIDEPOST_PER_REGION = 0;
    public static final long DEFAULT_STATS_GUIDEPOST_WIDTH_BYTES = 314572800L;
    public static final boolean DEFAULT_STATS_USE_CURRENT_TIME = true;
    public static final boolean DEFAULT_RUN_UPDATE_STATS_ASYNC = true;
    public static final boolean DEFAULT_COMMIT_STATS_ASYNC = true;
    public static final int DEFAULT_STATS_POOL_SIZE = 4;
    public static final long DEFAULT_STATS_MAX_CACHE_SIZE = 0x10000000L;
    public static final boolean DEFAULT_USE_REVERSE_SCAN = true;
    public static final int DEFAULT_SEQUENCE_TABLE_SALT_BUCKETS = 0;
    public static final int DEFAULT_COPROCESSOR_PRIORITY = 0x2FFFFFFE;
    public static final boolean DEFAULT_EXPLAIN_CHUNK_COUNT = true;
    public static final boolean DEFAULT_EXPLAIN_ROW_COUNT = true;
    public static final boolean DEFAULT_ALLOW_ONLINE_TABLE_SCHEMA_UPDATE = true;
    public static final int DEFAULT_RETRIES_FOR_SCHEMA_UPDATE_CHECK = 10;
    public static final long DEFAULT_DELAY_FOR_SCHEMA_UPDATE_CHECK = 5000L;
    public static final boolean DEFAULT_KEEP_DELETED_CELLS = false;
    public static final boolean DEFAULT_STORE_NULLS = false;
    public static final boolean DEFAULT_AUTO_COMMIT = false;
    public static final boolean DEFAULT_TABLE_ISTRANSACTIONAL = false;
    public static final boolean DEFAULT_TRANSACTIONS_ENABLED = false;
    public static final boolean DEFAULT_IS_GLOBAL_METRICS_ENABLED = true;
    public static final boolean DEFAULT_TRANSACTIONAL = false;
    public static final boolean DEFAULT_AUTO_FLUSH = false;
    private static final String DEFAULT_CLIENT_RPC_CONTROLLER_FACTORY = ClientRpcControllerFactory.class.getName();
    public static final String DEFAULT_CONSISTENCY_LEVEL = Consistency.STRONG.toString();
    public static final boolean DEFAULT_USE_BYTE_BASED_REGEX = false;
    public static final boolean DEFAULT_FORCE_ROW_KEY_ORDER = false;
    public static final boolean DEFAULT_ALLOW_USER_DEFINED_FUNCTIONS = false;
    public static final boolean DEFAULT_REQUEST_LEVEL_METRICS_ENABLED = false;
    public static final boolean DEFAULT_ALLOW_VIEWS_ADD_NEW_CF_BASE_TABLE = true;
    public static final int DEFAULT_MAX_VERSIONS_TRANSACTIONAL = Integer.MAX_VALUE;
    public static final boolean DEFAULT_RETURN_SEQUENCE_VALUES = false;
    public static final String DEFAULT_EXTRA_JDBC_ARGUMENTS = "";
    public static final long DEFAULT_INDEX_POPULATION_SLEEP_TIME = 5000L;
    public static final String DEFAULT_QUERY_SERVER_SERIALIZATION = "PROTOBUF";
    public static final int DEFAULT_QUERY_SERVER_HTTP_PORT = 8765;
    public static final long DEFAULT_QUERY_SERVER_UGI_CACHE_MAX_SIZE = 1000L;
    public static final int DEFAULT_QUERY_SERVER_UGI_CACHE_INITIAL_SIZE = 100;
    public static final int DEFAULT_QUERY_SERVER_UGI_CACHE_CONCURRENCY = 10;
    public static final boolean DEFAULT_QUERY_SERVER_SPNEGO_AUTH_DISABLED = false;
    public static final boolean DEFAULT_QUERY_SERVER_WITH_REMOTEUSEREXTRACTOR = false;
    public static final String DEFAULT_QUERY_SERVER_REMOTEUSEREXTRACTOR_PARAM = "doAs";
    public static final boolean DEFAULT_QUERY_SERVER_DISABLE_KERBEROS_LOGIN = false;
    public static final boolean DEFAULT_RENEW_LEASE_ENABLED = true;
    public static final int DEFAULT_RUN_RENEW_LEASE_FREQUENCY_INTERVAL_MILLISECONDS = 30000;
    public static final int DEFAULT_RENEW_LEASE_THRESHOLD_MILLISECONDS = 45000;
    public static final int DEFAULT_RENEW_LEASE_THREAD_POOL_SIZE = 10;
    public static final boolean DEFAULT_LOCAL_INDEX_CLIENT_UPGRADE = true;
    public static final float DEFAULT_LIMITED_QUERY_SERIAL_THRESHOLD = 0.2f;
    public static final boolean DEFAULT_INDEX_ASYNC_BUILD_ENABLED = true;
    public static final String DEFAULT_CLIENT_CACHE_ENCODING = PTableRefFactory.Encoding.OBJECT.toString();
    public static final boolean DEFAULT_AUTO_UPGRADE_ENABLED = true;
    public static final int DEFAULT_CLIENT_CONNECTION_CACHE_MAX_DURATION = 86400000;
    public static final int DEFAULT_COLUMN_ENCODED_BYTES = PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS.getSerializedMetadataValue();
    public static final String DEFAULT_IMMUTABLE_STORAGE_SCHEME = PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS.toString();
    public static final String DEFAULT_MULTITENANT_IMMUTABLE_STORAGE_SCHEME = PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN.toString();
    public static final boolean DEFAULT_PHOENIX_QUERY_SERVER_LOADBALANCER_ENABLED = false;
    public static final String DEFAULT_PHOENIX_QUERY_SERVER_CLUSTER_BASE_PATH = "/phoenix";
    public static final String DEFAULT_PHOENIX_QUERY_SERVER_SERVICE_NAME = "queryserver";
    public static final String DEFAULT_PHOENIX_QUERY_SERVER_ZK_ACL_USERNAME = "phoenix";
    public static final String DEFAULT_PHOENIX_QUERY_SERVER_ZK_ACL_PASSWORD = "phoenix";
    public static final int DEFAULT_CLIENT_CONNECTION_MAX_ALLOWED_CONNECTIONS = 0;
    public static final boolean DEFAULT_STATS_COLLECTION_ENABLED = true;
    public static final boolean DEFAULT_USE_STATS_FOR_PARALLELIZATION = true;
    public static final int DEFAULT_UPDATE_CACHE_FREQUENCY = 0;
    public static final int DEFAULT_INDEX_UPDATE_RETRY_PAUSE = 500;
    public static final int DEFAULT_INDEX_CHECK_TABLE_EXISTS_FREQUENCY = 5;
    public static final int DEFAULT_INDEX_UPDATE_TIMEOUT = 5000;
    public static final int DEFAULT_INDEX_UPDATE_RETRY = 3;
    public static final Set<String> DEFAULT_QUERY_SERVER_SKIP_WORDS = new HashSet<String>(){
        {
            this.add("secret");
            this.add("passwd");
            this.add("password");
            this.add("credential");
        }
    };
    public static final String DEFAULT_SCHEMA = null;
    public static final String DEFAULT_UPLOAD_BINARY_DATA_TYPE_ENCODING = "BASE64";
    public static final boolean DEFAULT_ENABLE_SERVER_UPSERT_SELECT = false;
    private final Configuration config;

    private QueryServicesOptions(Configuration config) {
        this.config = config;
    }

    public ReadOnlyProps getProps(ReadOnlyProps defaultProps) {
        return new ReadOnlyProps(defaultProps, this.config.iterator());
    }

    public QueryServicesOptions setAll(ReadOnlyProps props) {
        for (Map.Entry<String, String> entry : props) {
            this.config.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public static QueryServicesOptions withDefaults() {
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        QueryServicesOptions options = new QueryServicesOptions(config).setIfUnset("phoenix.stats.useCurrentTime", true).setIfUnset("phoenix.update.stats.command.async", true).setIfUnset("phoenix.stats.commit.async", true).setIfUnset("phoenix.query.keepAliveMs", 60000).setIfUnset("phoenix.query.threadPoolSize", 64).setIfUnset("phoenix.query.queueSize", 5000).setIfUnset("phoenix.query.timeoutMs", 600000).setIfUnset("phoenix.query.spoolThresholdBytes", 0x1400000).setIfUnset("phoenix.spool.directory", DEFAULT_SPOOL_DIRECTORY).setIfUnset("phoenix.query.maxGlobalMemoryPercentage", 15).setIfUnset("phoenix.query.maxTenantMemoryPercentage", 100).setIfUnset("phoenix.query.maxServerCacheBytes", 0x6400000L).setIfUnset("hbase.client.scanner.caching", 100).setIfUnset("phoenix.query.dateFormat", DEFAULT_DATE_FORMAT).setIfUnset("phoenix.query.dateFormatTimeZone", DEFAULT_DATE_FORMAT_TIMEZONE).setIfUnset("phoenix.stats.updateFrequency", 900000).setIfUnset("ipc.server.callqueue.roundrobin", true).setIfUnset("phoenix.mutate.maxSize", 35000).setIfUnset("phoenix.query.rowKeyOrderSaltedTable", false).setIfUnset("phoenix.query.useIndexes", true).setIfUnset("phoenix.mutate.immutableRows", false).setIfUnset("phoenix.index.mutableBatchSizeThreshold", 3).setIfUnset("phoenix.query.maxSpoolToDiskBytes", 1024000000L).setIfUnset("phoenix.schema.dropMetaData", true).setIfUnset("phoenix.groupby.spillable", DEFAULT_GROUPBY_SPILLABLE).setIfUnset("phoenix.groupby.maxCacheSize", 0x6400000L).setIfUnset("phoenix.groupby.spillFiles", 2).setIfUnset("phoenix.sequence.cacheSize", 100L).setIfUnset("phoenix.query.scanResultChunkSize", 15000L).setIfUnset("hbase.online.schema.update.enable", true).setIfUnset("phoenix.schema.change.retries", 10).setIfUnset("phoenix.schema.change.delay", 5000L).setIfUnset("phoenix.query.global.metrics.enabled", true).setIfUnset("hbase.rpc.controllerfactory.class", DEFAULT_CLIENT_RPC_CONTROLLER_FACTORY).setIfUnset("phoenix.regex.byteBased", false).setIfUnset("phoenix.query.force.rowkeyorder", false).setIfUnset("phoenix.query.request.metrics.enabled", false).setIfUnset("phoenix.view.allowNewColumnFamily", true).setIfUnset("phoenix.view.allowNewColumnFamily", true).setIfUnset("phoenix.scanner.lease.threshold", 45000).setIfUnset("phoenix.scanner.lease.renew.interval", 30000).setIfUnset("phoenix.scanner.lease.pool.size", 10).setIfUnset("phoenix.schema.isNamespaceMappingEnabled", false).setIfUnset("phoenix.schema.mapSystemTablesToNamespace", true).setIfUnset("phoenix.client.localIndexUpgrade", true).setIfUnset("phoenix.autoupgrade.enabled", true).setIfUnset("phoenix.queryserver.loadbalancer.enabled", false).setIfUnset("phoenix.queryserver.base.path", DEFAULT_PHOENIX_QUERY_SERVER_CLUSTER_BASE_PATH).setIfUnset("phoenix.queryserver.service.name", DEFAULT_PHOENIX_QUERY_SERVER_SERVICE_NAME).setIfUnset("phoenix.queryserver.zookeeper.acl.username", "phoenix").setIfUnset("phoenix.queryserver.zookeeper.acl.password", "phoenix").setIfUnset("phoenix.upload.binaryDataType.encoding", DEFAULT_UPLOAD_BINARY_DATA_TYPE_ENCODING).setIfUnset("phoenix.trace.enabled", false).setIfUnset("phoenix.trace.batchSize", 100).setIfUnset("phoenix.trace.threadPoolSize", 5).setIfUnset("phoenix.stats.collection.enabled", true).setIfUnset("phoenix.use.stats.parallelization", true);
        int scanCaching = config.getInt("hbase.client.scanner.caching", 0);
        if (scanCaching == 1) {
            config.setInt("hbase.client.scanner.caching", 100);
        } else if (scanCaching <= 0) {
            config.setInt("hbase.client.scanner.caching", 1);
        }
        return options;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    private QueryServicesOptions setIfUnset(String name, int value) {
        this.config.setIfUnset(name, Integer.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, boolean value) {
        this.config.setIfUnset(name, Boolean.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, long value) {
        this.config.setIfUnset(name, Long.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, String value) {
        this.config.setIfUnset(name, value);
        return this;
    }

    public QueryServicesOptions setKeepAliveMs(int keepAliveMs) {
        return this.set("phoenix.query.keepAliveMs", keepAliveMs);
    }

    public QueryServicesOptions setThreadPoolSize(int threadPoolSize) {
        return this.set("phoenix.query.threadPoolSize", threadPoolSize);
    }

    public QueryServicesOptions setQueueSize(int queueSize) {
        this.config.setInt("phoenix.query.queueSize", queueSize);
        return this;
    }

    public QueryServicesOptions setThreadTimeoutMs(int threadTimeoutMs) {
        return this.set("phoenix.query.timeoutMs", threadTimeoutMs);
    }

    public QueryServicesOptions setSpoolThresholdBytes(int spoolThresholdBytes) {
        return this.set("phoenix.query.spoolThresholdBytes", spoolThresholdBytes);
    }

    public QueryServicesOptions setSpoolDirectory(String spoolDirectory) {
        return this.set("phoenix.spool.directory", spoolDirectory);
    }

    public QueryServicesOptions setMaxMemoryPerc(int maxMemoryPerc) {
        return this.set("phoenix.query.maxGlobalMemoryPercentage", maxMemoryPerc);
    }

    public QueryServicesOptions setMaxTenantMemoryPerc(int maxTenantMemoryPerc) {
        return this.set("phoenix.query.maxTenantMemoryPercentage", maxTenantMemoryPerc);
    }

    public QueryServicesOptions setMaxServerCacheSize(long maxServerCacheSize) {
        return this.set("phoenix.query.maxServerCacheBytes", maxServerCacheSize);
    }

    public QueryServicesOptions setMaxServerMetaDataCacheSize(long maxMetaDataCacheSize) {
        return this.set("phoenix.coprocessor.maxMetaDataCacheSize", maxMetaDataCacheSize);
    }

    public QueryServicesOptions setMaxClientMetaDataCacheSize(long maxMetaDataCacheSize) {
        return this.set("phoenix.client.maxMetaDataCacheSize", maxMetaDataCacheSize);
    }

    public QueryServicesOptions setScanFetchSize(int scanFetchSize) {
        return this.set("hbase.client.scanner.caching", scanFetchSize);
    }

    public QueryServicesOptions setDateFormat(String dateFormat) {
        return this.set("phoenix.query.dateFormat", dateFormat);
    }

    public QueryServicesOptions setCallQueueRoundRobin(boolean isRoundRobin) {
        return this.set("CALL_QUEUE_PRODUCER", isRoundRobin);
    }

    public QueryServicesOptions setMaxMutateSize(int maxMutateSize) {
        return this.set("phoenix.mutate.maxSize", maxMutateSize);
    }

    @Deprecated
    public QueryServicesOptions setMutateBatchSize(int mutateBatchSize) {
        return this.set("phoenix.mutate.batchSize", mutateBatchSize);
    }

    public QueryServicesOptions setDropMetaData(boolean dropMetadata) {
        return this.set("phoenix.schema.dropMetaData", dropMetadata);
    }

    public QueryServicesOptions setGroupBySpill(boolean enabled) {
        return this.set("phoenix.groupby.spillable", enabled);
    }

    public QueryServicesOptions setGroupBySpillMaxCacheSize(long size) {
        return this.set("phoenix.groupby.maxCacheSize", size);
    }

    public QueryServicesOptions setGroupBySpillNumSpillFiles(long num) {
        return this.set("phoenix.groupby.spillFiles", num);
    }

    private QueryServicesOptions set(String name, boolean value) {
        this.config.set(name, Boolean.toString(value));
        return this;
    }

    private QueryServicesOptions set(String name, int value) {
        this.config.set(name, Integer.toString(value));
        return this;
    }

    private QueryServicesOptions set(String name, String value) {
        this.config.set(name, value);
        return this;
    }

    private QueryServicesOptions set(String name, long value) {
        this.config.set(name, Long.toString(value));
        return this;
    }

    public int getKeepAliveMs() {
        return this.config.getInt("phoenix.query.keepAliveMs", 60000);
    }

    public int getThreadPoolSize() {
        return this.config.getInt("phoenix.query.threadPoolSize", 64);
    }

    public int getQueueSize() {
        return this.config.getInt("phoenix.query.queueSize", 5000);
    }

    public int getMaxMemoryPerc() {
        return this.config.getInt("phoenix.query.maxGlobalMemoryPercentage", 15);
    }

    public int getMaxMutateSize() {
        return this.config.getInt("phoenix.mutate.maxSize", 35000);
    }

    @Deprecated
    public int getMutateBatchSize() {
        return this.config.getInt("phoenix.mutate.batchSize", 100);
    }

    public boolean isUseIndexes() {
        return this.config.getBoolean("phoenix.query.useIndexes", true);
    }

    public boolean isImmutableRows() {
        return this.config.getBoolean("phoenix.mutate.immutableRows", false);
    }

    public boolean isDropMetaData() {
        return this.config.getBoolean("phoenix.schema.dropMetaData", true);
    }

    public boolean isSpillableGroupByEnabled() {
        return this.config.getBoolean("phoenix.groupby.spillable", DEFAULT_GROUPBY_SPILLABLE);
    }

    public long getSpillableGroupByMaxCacheSize() {
        return this.config.getLong("phoenix.groupby.maxCacheSize", 0x6400000L);
    }

    public int getSpillableGroupByNumSpillFiles() {
        return this.config.getInt("phoenix.groupby.spillFiles", 2);
    }

    public boolean isTracingEnabled() {
        return this.config.getBoolean("phoenix.trace.enabled", false);
    }

    public QueryServicesOptions setTracingEnabled(boolean enable) {
        this.config.setBoolean("phoenix.trace.enabled", enable);
        return this;
    }

    public int getTracingThreadPoolSize() {
        return this.config.getInt("phoenix.trace.threadPoolSize", 5);
    }

    public int getTracingBatchSize() {
        return this.config.getInt("phoenix.trace.batchSize", 100);
    }

    public int getTracingTraceBufferSize() {
        return this.config.getInt("phoenix.trace.traceBufferSize", 1000);
    }

    public String getTableName() {
        return this.config.get("phoenix.trace.statsTableName", DEFAULT_TRACING_STATS_TABLE_NAME);
    }

    public boolean isGlobalMetricsEnabled() {
        return this.config.getBoolean("phoenix.query.global.metrics.enabled", true);
    }

    public boolean isUseByteBasedRegex() {
        return this.config.getBoolean("phoenix.regex.byteBased", false);
    }

    public int getScanCacheSize() {
        return this.config.getInt("hbase.client.scanner.caching", 100);
    }

    public QueryServicesOptions setMaxServerCacheTTLMs(int ttl) {
        return this.set("phoenix.coprocessor.maxServerCacheTimeToLiveMs", ttl);
    }

    public QueryServicesOptions setMasterInfoPort(int port) {
        return this.set("hbase.master.info.port", port);
    }

    public QueryServicesOptions setRegionServerInfoPort(int port) {
        return this.set("hbase.regionserver.info.port", port);
    }

    public QueryServicesOptions setRegionServerLeasePeriodMs(int period) {
        return this.set("hbase.client.scanner.timeout.period", period);
    }

    public QueryServicesOptions setRpcTimeoutMs(int timeout) {
        return this.set("hbase.rpc.timeout", timeout);
    }

    public QueryServicesOptions setUseIndexes(boolean useIndexes) {
        return this.set("phoenix.query.useIndexes", useIndexes);
    }

    public QueryServicesOptions setImmutableRows(boolean isImmutableRows) {
        return this.set("phoenix.mutate.immutableRows", isImmutableRows);
    }

    public QueryServicesOptions setWALEditCodec(String walEditCodec) {
        return this.set("hbase.regionserver.wal.codec", walEditCodec);
    }

    public QueryServicesOptions setStatsHistogramDepthBytes(long byteDepth) {
        return this.set("phoenix.stats.guidepost.width", byteDepth);
    }

    public QueryServicesOptions setStatsUpdateFrequencyMs(int frequencyMs) {
        return this.set("phoenix.stats.updateFrequency", frequencyMs);
    }

    public QueryServicesOptions setMinStatsUpdateFrequencyMs(int frequencyMs) {
        return this.set("phoenix.stats.minUpdateFrequency", frequencyMs);
    }

    public QueryServicesOptions setSequenceSaltBuckets(int saltBuckets) {
        this.config.setInt("phoenix.sequence.saltBuckets", saltBuckets);
        return this;
    }

    public QueryServicesOptions setExplainChunkCount(boolean showChunkCount) {
        this.config.setBoolean("phoenix.explain.displayChunkCount", showChunkCount);
        return this;
    }

    public QueryServicesOptions setTransactionsEnabled(boolean transactionsEnabled) {
        this.config.setBoolean("phoenix.transactions.enabled", transactionsEnabled);
        return this;
    }

    public QueryServicesOptions setExplainRowCount(boolean showRowCount) {
        this.config.setBoolean("phoenix.explain.displayRowCount", showRowCount);
        return this;
    }

    public QueryServicesOptions setAllowOnlineSchemaUpdate(boolean allow) {
        this.config.setBoolean("hbase.online.schema.update.enable", allow);
        return this;
    }

    public QueryServicesOptions setNumRetriesForSchemaChangeCheck(int numRetries) {
        this.config.setInt("phoenix.schema.change.retries", numRetries);
        return this;
    }

    public QueryServicesOptions setDelayInMillisForSchemaChangeCheck(long delayInMillis) {
        this.config.setLong("phoenix.schema.change.delay", delayInMillis);
        return this;
    }

    public QueryServicesOptions setUseByteBasedRegex(boolean flag) {
        this.config.setBoolean("phoenix.regex.byteBased", flag);
        return this;
    }

    public QueryServicesOptions setForceRowKeyOrder(boolean forceRowKeyOrder) {
        this.config.setBoolean("phoenix.query.force.rowkeyorder", forceRowKeyOrder);
        return this;
    }

    public QueryServicesOptions setExtraJDBCArguments(String extraArgs) {
        this.config.set("phoenix.jdbc.extra.arguments", extraArgs);
        return this;
    }

    public QueryServicesOptions setRunUpdateStatsAsync(boolean flag) {
        this.config.setBoolean("phoenix.update.stats.command.async", flag);
        return this;
    }

    public QueryServicesOptions setCommitStatsAsync(boolean flag) {
        this.config.setBoolean("phoenix.stats.commit.async", flag);
        return this;
    }

    public QueryServicesOptions setEnableRenewLease(boolean enable) {
        this.config.setBoolean("phoenix.scanner.lease.renew.enabled", enable);
        return this;
    }

    public QueryServicesOptions setIndexHandlerCount(int count) {
        this.config.setInt("phoenix.rpc.index.handler.count", count);
        return this;
    }

    public QueryServicesOptions setMetadataHandlerCount(int count) {
        this.config.setInt("phoenix.rpc.metadata.handler.count", count);
        return this;
    }

    public QueryServicesOptions setHConnectionPoolCoreSize(int count) {
        this.config.setInt("hbase.hconnection.threads.core", count);
        return this;
    }

    public QueryServicesOptions setHConnectionPoolMaxSize(int count) {
        this.config.setInt("hbase.hconnection.threads.max", count);
        return this;
    }

    public QueryServicesOptions setMaxThreadsPerHTable(int count) {
        this.config.setInt("hbase.htable.threads.max", count);
        return this;
    }

    public QueryServicesOptions setDefaultIndexPopulationWaitTime(long waitTime) {
        this.config.setLong("phoenix.index.population.wait.time", waitTime);
        return this;
    }

    public QueryServicesOptions setUseStatsForParallelization(boolean flag) {
        this.config.setBoolean("phoenix.use.stats.parallelization", flag);
        return this;
    }

    public QueryServicesOptions setIndexRebuildTaskInitialDelay(long waitTime) {
        this.config.setLong("phoenix.index.rebuild.task.initial.delay", waitTime);
        return this;
    }

    public QueryServicesOptions setSequenceCacheSize(long sequenceCacheSize) {
        this.config.setLong("phoenix.sequence.cacheSize", sequenceCacheSize);
        return this;
    }

    public QueryServicesOptions setForceIndex(boolean value) {
        this.config.setBoolean("phoenix.force.index", value);
        return this;
    }
}

