/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexExpressionCompiler;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.PostDDLCompiler;
import org.apache.phoenix.compile.PostIndexDDLCompiler;
import org.apache.phoenix.compile.PostLocalIndexDDLCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.AddColumnStatement;
import org.apache.phoenix.parse.AlterIndexStatement;
import org.apache.phoenix.parse.CloseStatement;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnDefInPkConstraint;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.CreateFunctionStatement;
import org.apache.phoenix.parse.CreateIndexStatement;
import org.apache.phoenix.parse.CreateSchemaStatement;
import org.apache.phoenix.parse.CreateSequenceStatement;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.DeclareCursorStatement;
import org.apache.phoenix.parse.DropColumnStatement;
import org.apache.phoenix.parse.DropFunctionStatement;
import org.apache.phoenix.parse.DropIndexStatement;
import org.apache.phoenix.parse.DropSchemaStatement;
import org.apache.phoenix.parse.DropSequenceStatement;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.IndexKeyConstraint;
import org.apache.phoenix.parse.ModifyColumnStatement;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.OpenStatement;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.UpdateStatisticsStatement;
import org.apache.phoenix.parse.UseSchemaStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.ConcurrentTableMutationException;
import org.apache.phoenix.schema.DataTypeCastException;
import org.apache.phoenix.schema.DelegateColumn;
import org.apache.phoenix.schema.DelegateTable;
import org.apache.phoenix.schema.FunctionAlreadyExistsException;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.NewerFunctionAlreadyExistsException;
import org.apache.phoenix.schema.NewerSchemaAlreadyExistsException;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SchemaAlreadyExistsException;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.SequenceAlreadyExistsException;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.CursorUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TransactionUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataClient {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataClient.class);
    private static final ParseNodeFactory FACTORY = new ParseNodeFactory();
    private static final String SET_ASYNC_CREATED_DATE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,ASYNC_CREATED_DATE " + PDate.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?)";
    private static final String CREATE_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,TABLE_SEQ_NUM,COLUMN_COUNT,SALT_BUCKETS,PK_NAME,DATA_TABLE_NAME,INDEX_STATE,IMMUTABLE_ROWS,DEFAULT_COLUMN_FAMILY,VIEW_STATEMENT,DISABLE_WAL,MULTI_TENANT,VIEW_TYPE,INDEX_TYPE,STORE_NULLS,BASE_COLUMN_COUNT,TRANSACTIONAL,UPDATE_CACHE_FREQUENCY,IS_NAMESPACE_MAPPED,AUTO_PARTITION_SEQ,APPEND_ONLY_SCHEMA,GUIDE_POSTS_WIDTH,IMMUTABLE_STORAGE_SCHEME,ENCODING_SCHEME,USE_STATS_FOR_PARALLELIZATION) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String CREATE_SCHEMA = "UPSERT INTO SYSTEM.\"CATALOG\"( TABLE_SCHEM,TABLE_NAME) VALUES (?,?)";
    private static final String CREATE_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,LINK_TYPE,TABLE_SEQ_NUM,TABLE_TYPE) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String CREATE_VIEW_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,LINK_TYPE,PARENT_TENANT_ID " + PVarchar.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?, ?, ?)";
    public static final String UPDATE_ENCODED_COLUMN_COUNTER = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID, TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,QUALIFIER_COUNTER) VALUES (?, ?, ?, ?, ?)";
    private static final String CREATE_CHILD_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,LINK_TYPE) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INCREMENT_SEQ_NUM = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_SEQ_NUM) VALUES (?, ?, ?, ?)";
    public static final String MUTATE_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,TABLE_SEQ_NUM,COLUMN_COUNT) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_INDEX_STATE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,INDEX_STATE,ASYNC_REBUILD_TIMESTAMP " + PLong.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_INDEX_REBUILD_ASYNC_STATE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,ASYNC_REBUILD_TIMESTAMP " + PLong.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?)";
    private static final String UPDATE_INDEX_STATE_TO_ACTIVE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,INDEX_STATE,INDEX_DISABLE_TIMESTAMP,ASYNC_REBUILD_TIMESTAMP " + PLong.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_COLUMN_CREATE_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ,COLUMN_DEF,COLUMN_QUALIFIER, IS_ROW_TIMESTAMP) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_COLUMN_ALTER_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ,COLUMN_DEF,COLUMN_QUALIFIER) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String MODIFY_COLUMN_ALTER_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,COLUMN_SIZE,DECIMAL_DIGITS) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String ALTER_SYSCATALOG_TABLE_UPGRADE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ,COLUMN_DEF) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_COLUMN_POSITION = "UPSERT INTO SYSTEM.\"CATALOG\" ( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,ORDINAL_POSITION) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String CREATE_FUNCTION = "UPSERT INTO SYSTEM.\"FUNCTION\" ( TENANT_ID,FUNCTION_NAME,NUM_ARGS,CLASS_NAME,JAR_PATH,RETURN_TYPE) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_FUNCTION_ARGUMENT = "UPSERT INTO SYSTEM.\"FUNCTION\" ( TENANT_ID,FUNCTION_NAME,TYPE,ARG_POSITION,IS_ARRAY,IS_CONSTANT,DEFAULT_VALUE,MIN_VALUE,MAX_VALUE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String EMPTY_TABLE = " ";
    private final PhoenixConnection connection;

    public MetaDataClient(PhoenixConnection connection) {
        this.connection = connection;
    }

    public PhoenixConnection getConnection() {
        return this.connection;
    }

    public long getCurrentTime(String schemaName, String tableName) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result = this.updateCache(schemaName, tableName, true);
        return result.getMutationTime();
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName, String tableName) throws SQLException {
        return this.updateCache(schemaName, tableName, false);
    }

    private MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName, String tableName, boolean alwaysHitServer) throws SQLException {
        return this.updateCache(this.connection.getTenantId(), schemaName, tableName, alwaysHitServer);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(PName tenantId, String schemaName, String tableName) throws SQLException {
        return this.updateCache(tenantId, schemaName, tableName, false);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(PName tenantId, String schemaName, String tableName, boolean alwaysHitServer) throws SQLException {
        return this.updateCache(tenantId, schemaName, tableName, alwaysHitServer, null);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(List<String> functionNames) throws SQLException {
        return this.updateCache(functionNames, false);
    }

    private MetaDataProtocol.MetaDataMutationResult updateCache(List<String> functionNames, boolean alwaysHitServer) throws SQLException {
        return this.updateCache(this.connection.getTenantId(), functionNames, alwaysHitServer);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(PName tenantId, List<String> functionNames) throws SQLException {
        return this.updateCache(tenantId, functionNames, false);
    }

    private long getClientTimeStamp() {
        Long scn = this.connection.getSCN();
        long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
        return clientTimeStamp;
    }

    private long getCurrentScn() {
        Long scn = this.connection.getSCN();
        long currentScn = scn == null ? Long.MAX_VALUE : scn;
        return currentScn;
    }

    private MetaDataProtocol.MetaDataMutationResult updateCache(PName origTenantId, String schemaName, String tableName, boolean alwaysHitServer, Long resolvedTimestamp) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result;
        boolean isTransactional;
        boolean systemTable = "SYSTEM".equals(schemaName);
        PName tenantId = systemTable ? null : origTenantId;
        PTable table = null;
        PTableRef tableRef = null;
        String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
        long tableTimestamp = Long.MAX_VALUE;
        long tableResolvedTimestamp = Long.MAX_VALUE;
        try {
            tableRef = this.connection.getTableRef(new PTableKey(tenantId, fullTableName));
            table = tableRef.getTable();
            tableTimestamp = table.getTimeStamp();
            tableResolvedTimestamp = tableRef.getResolvedTimeStamp();
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        boolean defaultTransactional = this.connection.getQueryServices().getProps().getBoolean("phoenix.table.istransactional.default", false);
        boolean bl = isTransactional = defaultTransactional || table != null && table.isTransactional();
        if (!systemTable && isTransactional && !this.connection.getMutationState().isTransactionStarted()) {
            this.connection.getMutationState().startTransaction();
        }
        resolvedTimestamp = resolvedTimestamp == null ? TransactionUtil.getResolvedTimestamp(this.connection, isTransactional, Long.MAX_VALUE) : resolvedTimestamp;
        if (table != null && !alwaysHitServer && (systemTable || resolvedTimestamp == tableResolvedTimestamp || table.getRowTimestampColPos() == -1 && this.connection.getMetaDataCache().getAge(tableRef) < table.getUpdateCacheFrequency())) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, -1L, table);
        }
        int maxTryCount = tenantId == null ? 1 : 2;
        int tryCount = 0;
        do {
            byte[] schemaBytes = PVarchar.INSTANCE.toBytes(schemaName);
            byte[] tableBytes = PVarchar.INSTANCE.toBytes(tableName);
            ConnectionQueryServices queryServices = this.connection.getQueryServices();
            result = queryServices.getTable(tenantId, schemaBytes, tableBytes, tableTimestamp, resolvedTimestamp);
            if (table == null && result.getTable() != null && result.getTable().isTransactional() != isTransactional) {
                result = queryServices.getTable(tenantId, schemaBytes, tableBytes, tableTimestamp, TransactionUtil.getResolvedTimestamp(this.connection, result.getTable().isTransactional(), Long.MAX_VALUE));
            }
            if ("SYSTEM".equals(schemaName)) {
                if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS && result.getTable() == null) {
                    result.setTable(table);
                }
                return result;
            }
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            PTable resultTable = result.getTable();
            if (resultTable != null) {
                this.addTableToCache(result);
                return result;
            }
            if (table != null) {
                if (code == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                    result.setTable(table);
                    long resolvedTime = TransactionUtil.getResolvedTime(this.connection, result);
                    if (this.addIndexesFromParentTable(result, resolvedTimestamp)) {
                        this.connection.addTable(result.getTable(), resolvedTime);
                    } else {
                        this.connection.updateResolvedTimestamp(table, resolvedTime);
                    }
                    return result;
                }
                if (code == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND && tryCount + 1 == maxTryCount) {
                    this.connection.removeTable(origTenantId, fullTableName, table.getParentName() == null ? null : table.getParentName().getString(), table.getTimeStamp());
                }
            }
            tenantId = null;
        } while (++tryCount < maxTryCount);
        return result;
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName) throws SQLException {
        return this.updateCache(schemaName, false);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName, boolean alwaysHitServer) throws SQLException {
        long clientTimeStamp = this.getClientTimeStamp();
        PSchema schema = null;
        try {
            schema = this.connection.getMetaDataCache().getSchema(new PTableKey(null, schemaName));
            if (schema != null && !alwaysHitServer) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_ALREADY_EXISTS, schema, -1L);
            }
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            // empty catch block
        }
        MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().getSchema(schemaName, clientTimeStamp);
        return result;
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(PName tenantId, List<String> functionNames, boolean alwaysHitServer) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result;
        long clientTimeStamp = this.getClientTimeStamp();
        ArrayList<PFunction> functions = new ArrayList<PFunction>(functionNames.size());
        ArrayList<Long> functionTimeStamps = new ArrayList<Long>(functionNames.size());
        Iterator<String> iterator = functionNames.iterator();
        while (iterator.hasNext()) {
            PFunction function = null;
            try {
                String functionName = iterator.next();
                function = this.connection.getMetaDataCache().getFunction(new PTableKey(tenantId, functionName));
                if (function != null && !alwaysHitServer && function.getTimeStamp() == clientTimeStamp - 1L) {
                    functions.add(function);
                    iterator.remove();
                    continue;
                }
                if (function != null && function.getTimeStamp() != clientTimeStamp - 1L) {
                    functionTimeStamps.add(function.getTimeStamp());
                    continue;
                }
                functionTimeStamps.add(Long.MAX_VALUE);
            }
            catch (FunctionNotFoundException e) {
                functionTimeStamps.add(Long.MAX_VALUE);
            }
        }
        if (functionNames.isEmpty()) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS, -1L, functions, true);
        }
        int maxTryCount = tenantId == null ? 1 : 2;
        int tryCount = 0;
        do {
            ArrayList<Pair<byte[], Long>> functionsToFecth = new ArrayList<Pair<byte[], Long>>(functionNames.size());
            for (int i = 0; i < functionNames.size(); ++i) {
                functionsToFecth.add((Pair<byte[], Long>)new Pair((Object)PVarchar.INSTANCE.toBytes(functionNames.get(i)), functionTimeStamps.get(i)));
            }
            result = this.connection.getQueryServices().getFunctions(tenantId, functionsToFecth, clientTimeStamp);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            if (result.getFunctions() != null && !result.getFunctions().isEmpty()) {
                result.getFunctions().addAll(functions);
                this.addFunctionToCache(result);
                return result;
            }
            if (code == MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS) {
                result.getFunctions().addAll(functions);
                this.addFunctionToCache(result);
                return result;
            }
            if (code == MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND && tryCount + 1 == maxTryCount) {
                for (Pair pair : functionsToFecth) {
                    this.connection.removeFunction(tenantId, Bytes.toString((byte[])((byte[])pair.getFirst())), (Long)pair.getSecond());
                }
                throw new FunctionNotFoundException(functionNames.toString() + " not found");
            }
            tenantId = null;
        } while (++tryCount < maxTryCount);
        return result;
    }

    private boolean addIndexesFromParentTable(MetaDataProtocol.MetaDataMutationResult result, Long resolvedTimestamp) throws SQLException {
        PTable view = result.getTable();
        if (view.getType() != PTableType.VIEW || view.getViewType() == PTable.ViewType.MAPPED) {
            return false;
        }
        String parentName = view.getParentName().getString();
        String schemaName = SchemaUtil.getSchemaNameFromFullName(parentName);
        String tableName = SchemaUtil.getTableNameFromFullName(parentName);
        MetaDataProtocol.MetaDataMutationResult parentResult = this.updateCache(this.connection.getTenantId(), schemaName, tableName, false, resolvedTimestamp);
        PTable parentTable = parentResult.getTable();
        if (parentTable == null) {
            throw new TableNotFoundException(schemaName, tableName);
        }
        if (!result.wasUpdated() && !parentResult.wasUpdated()) {
            return false;
        }
        List<PTable> parentTableIndexes = parentTable.getIndexes();
        if (parentTableIndexes.isEmpty()) {
            return false;
        }
        ArrayList indexesToAdd = Lists.newArrayListWithExpectedSize((int)(parentTableIndexes.size() + view.getIndexes().size()));
        if (result.wasUpdated()) {
            indexesToAdd.addAll(view.getIndexes());
        } else {
            for (PTable index : view.getIndexes()) {
                if (index.getViewStatement() != null) continue;
                indexesToAdd.add(index);
            }
        }
        for (PTable index : parentTableIndexes) {
            boolean containsAllReqdCols = true;
            IndexMaintainer indexMaintainer = index.getIndexMaintainer(parentTable, this.connection);
            Set<Pair<String, String>> indexedColInfos = indexMaintainer.getIndexedColumnInfo();
            for (Pair<String, String> colInfo : indexedColInfos) {
                try {
                    String colFamily = (String)colInfo.getFirst();
                    String colName = (String)colInfo.getSecond();
                    if (colFamily == null) {
                        view.getColumnForColumnName(colName);
                        continue;
                    }
                    view.getColumnFamily(colFamily).getPColumnForColumnName(colName);
                }
                catch (ColumnNotFoundException e) {
                    containsAllReqdCols = false;
                    break;
                }
            }
            for (PColumn col : view.getColumns()) {
                if (col.getViewConstant() == null) continue;
                try {
                    String indexColumnName = IndexUtil.getIndexColumnName(col);
                    index.getColumnForColumnName(indexColumnName);
                }
                catch (ColumnNotFoundException e1) {
                    PColumn indexCol = null;
                    try {
                        String cf = col.getFamilyName() != null ? col.getFamilyName().getString() : null;
                        String colName = col.getName().getString();
                        indexCol = cf != null ? parentTable.getColumnFamily(cf).getPColumnForColumnName(colName) : parentTable.getColumnForColumnName(colName);
                    }
                    catch (ColumnNotFoundException e2) {
                        containsAllReqdCols = false;
                        break;
                    }
                    if (indexCol.getViewConstant() != null && Bytes.compareTo((byte[])indexCol.getViewConstant(), (byte[])col.getViewConstant()) == 0) continue;
                    containsAllReqdCols = false;
                    break;
                }
            }
            if (!containsAllReqdCols) continue;
            String viewStatement = IndexUtil.rewriteViewStatement(this.connection, index, parentTable, view.getViewStatement());
            PName modifiedIndexName = PNameFactory.newName(index.getSchemaName().getString() + "#" + index.getName().getString() + "#" + view.getName().getString());
            indexesToAdd.add(PTableImpl.makePTable(index, modifiedIndexName, viewStatement, Long.MAX_VALUE, view.getTenantId()));
        }
        PTableImpl allIndexesTable = PTableImpl.makePTable(view, view.getTimeStamp(), indexesToAdd);
        result.setTable(allIndexesTable);
        return true;
    }

    private void addColumnMutation(String schemaName, String tableName, PColumn column, PreparedStatement colUpsert, String parentTableName, String pkName, Short keySeq, boolean isSalted) throws SQLException {
        colUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
        colUpsert.setString(2, schemaName);
        colUpsert.setString(3, tableName);
        colUpsert.setString(4, column.getName().getString());
        colUpsert.setString(5, column.getFamilyName() == null ? null : column.getFamilyName().getString());
        colUpsert.setInt(6, column.getDataType().getSqlType());
        colUpsert.setInt(7, column.isNullable() ? 1 : 0);
        if (column.getMaxLength() == null) {
            colUpsert.setNull(8, 4);
        } else {
            colUpsert.setInt(8, column.getMaxLength());
        }
        if (column.getScale() == null) {
            colUpsert.setNull(9, 4);
        } else {
            colUpsert.setInt(9, column.getScale());
        }
        colUpsert.setInt(10, column.getPosition() + (isSalted ? 0 : 1));
        colUpsert.setInt(11, column.getSortOrder().getSystemValue());
        colUpsert.setString(12, parentTableName);
        if (column.getArraySize() == null) {
            colUpsert.setNull(13, 4);
        } else {
            colUpsert.setInt(13, column.getArraySize());
        }
        colUpsert.setBytes(14, column.getViewConstant());
        colUpsert.setBoolean(15, column.isViewReferenced());
        colUpsert.setString(16, pkName);
        if (keySeq == null) {
            colUpsert.setNull(17, 5);
        } else {
            colUpsert.setShort(17, keySeq);
        }
        if (column.getExpressionStr() == null) {
            colUpsert.setNull(18, 12);
        } else {
            colUpsert.setString(18, column.getExpressionStr());
        }
        if (colUpsert.getParameterMetaData().getParameterCount() > 18) {
            if (column.getColumnQualifierBytes() == null) {
                colUpsert.setNull(19, -3);
            } else {
                colUpsert.setBytes(19, column.getColumnQualifierBytes());
            }
        }
        if (colUpsert.getParameterMetaData().getParameterCount() > 19) {
            colUpsert.setBoolean(20, column.isRowTimestamp());
        }
        colUpsert.execute();
    }

    private void addFunctionArgMutation(String functionName, PFunction.FunctionArgument arg, PreparedStatement argUpsert, int position) throws SQLException {
        argUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
        argUpsert.setString(2, functionName);
        argUpsert.setString(3, arg.getArgumentType());
        byte[] bytes = Bytes.toBytes((short)((short)position));
        argUpsert.setBytes(4, bytes);
        argUpsert.setBoolean(5, arg.isArrayType());
        argUpsert.setBoolean(6, arg.isConstant());
        argUpsert.setString(7, arg.getDefaultValue() == null ? null : arg.getDefaultValue().toString());
        argUpsert.setString(8, arg.getMinValue() == null ? null : arg.getMinValue().toString());
        argUpsert.setString(9, arg.getMaxValue() == null ? null : arg.getMaxValue().toString());
        argUpsert.execute();
    }

    private PColumn newColumn(int position, ColumnDef def, PrimaryKeyConstraint pkConstraint, String defaultColumnFamily, boolean addingToPK, byte[] columnQualifierBytes) throws SQLException {
        try {
            Pair<ColumnName, SortOrder> pkSortOrder;
            ColumnName columnDefName = def.getColumnDefName();
            SortOrder sortOrder = def.getSortOrder();
            boolean isPK = def.isPK();
            boolean isRowTimestamp = def.isRowTimestamp();
            if (pkConstraint != null && (pkSortOrder = pkConstraint.getColumnWithSortOrder(columnDefName)) != null) {
                isPK = true;
                sortOrder = (SortOrder)((Object)pkSortOrder.getSecond());
                isRowTimestamp = pkConstraint.isColumnRowTimestamp(columnDefName);
            }
            String columnName = columnDefName.getColumnName();
            if (isPK && sortOrder == SortOrder.DESC && def.getDataType() == PVarbinary.INSTANCE) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.DESC_VARBINARY_NOT_SUPPORTED).setColumnName(columnName).build().buildException();
            }
            PName familyName = null;
            if (def.isPK() && !pkConstraint.getColumnNames().isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_ALREADY_EXISTS).setColumnName(columnName).build().buildException();
            }
            boolean isNull = def.isNull();
            if (def.getColumnDefName().getFamilyName() != null) {
                String family = def.getColumnDefName().getFamilyName();
                if (isPK) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_WITH_FAMILY_NAME).setColumnName(columnName).setFamilyName(family).build().buildException();
                }
                if (!def.isNull()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.KEY_VALUE_NOT_NULL).setColumnName(columnName).setFamilyName(family).build().buildException();
                }
                familyName = PNameFactory.newName(family);
            } else if (!isPK) {
                familyName = PNameFactory.newName(defaultColumnFamily == null ? "0" : defaultColumnFamily);
            }
            if (isPK && !addingToPK && pkConstraint.getColumnNames().size() <= 1) {
                if (def.isNull() && def.isNullSet()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_PK_MAY_NOT_BE_NULL).setColumnName(columnName).build().buildException();
                }
                isNull = false;
            }
            PColumnImpl column = new PColumnImpl(PNameFactory.newName(columnName), familyName, def.getDataType(), def.getMaxLength(), def.getScale(), isNull, position, sortOrder, def.getArraySize(), null, false, def.getExpression(), isRowTimestamp, false, columnQualifierBytes);
            return column;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
    }

    public MutationState createTable(CreateTableStatement statement, byte[][] splits, PTable parent, String viewStatement, PTable.ViewType viewType, byte[][] viewColumnConstants, BitSet isViewColumnReferenced) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result;
        TableName tableName = statement.getTableName();
        HashMap tableProps = Maps.newHashMapWithExpectedSize((int)statement.getProps().size());
        HashMap commonFamilyProps = Maps.newHashMapWithExpectedSize((int)(statement.getProps().size() + 1));
        this.populatePropertyMaps(statement.getProps(), tableProps, commonFamilyProps);
        boolean isAppendOnlySchema = false;
        long updateCacheFrequency = this.connection.getQueryServices().getProps().getLong("phoenix.default.update.cache.frequency", 0L);
        if (parent == null) {
            Long updateCacheFrequencyProp;
            Boolean appendOnlySchemaProp = (Boolean)TableProperty.APPEND_ONLY_SCHEMA.getValue(tableProps);
            if (appendOnlySchemaProp != null) {
                isAppendOnlySchema = appendOnlySchemaProp;
            }
            if ((updateCacheFrequencyProp = (Long)TableProperty.UPDATE_CACHE_FREQUENCY.getValue(tableProps)) != null) {
                updateCacheFrequency = updateCacheFrequencyProp;
            }
        } else {
            isAppendOnlySchema = parent.isAppendOnlySchema();
            updateCacheFrequency = parent.getUpdateCacheFrequency();
        }
        if (isAppendOnlySchema && updateCacheFrequency == 0L) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.UPDATE_CACHE_FREQUENCY_INVALID).setSchemaName(tableName.getSchemaName()).setTableName(tableName.getTableName()).build().buildException();
        }
        Boolean immutableProp = (Boolean)TableProperty.IMMUTABLE_ROWS.getValue(tableProps);
        if (statement.immutableRows() != null && immutableProp != null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.IMMUTABLE_TABLE_PROPERTY_INVALID).setSchemaName(tableName.getSchemaName()).setTableName(tableName.getTableName()).build().buildException();
        }
        PTable table = null;
        if (isAppendOnlySchema && (result = this.updateCache(tableName.getSchemaName(), tableName.getTableName())).getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
            table = result.getTable();
            if (!statement.ifNotExists()) {
                throw new NewerTableAlreadyExistsException(tableName.getSchemaName(), tableName.getTableName(), table);
            }
            List<ColumnDef> columnDefs = statement.getColumnDefs();
            PrimaryKeyConstraint pkConstraint = statement.getPrimaryKeyConstraint();
            for (ColumnDef columnDef : columnDefs) {
                if (!pkConstraint.contains(columnDef.getColumnDefName())) continue;
                columnDef.setIsPK(true);
            }
            return this.addColumn(table, columnDefs, statement.getProps(), statement.ifNotExists(), true, NamedTableNode.create(statement.getTableName()), statement.getTableType());
        }
        table = this.createTableInternal(statement, splits, parent, viewStatement, viewType, viewColumnConstants, isViewColumnReferenced, false, null, null, tableProps, commonFamilyProps);
        if (table == null || table.getType() == PTableType.VIEW) {
            return new MutationState(0L, 0L, this.connection);
        }
        PostDDLCompiler compiler = new PostDDLCompiler(this.connection);
        Long scn = this.connection.getSCN();
        long ts = scn == null ? table.getTimeStamp() : scn.longValue();
        TableRef tableRef = new TableRef(null, table, ts, false);
        byte[] emptyCF = SchemaUtil.getEmptyColumnFamily(table);
        MutationPlan plan = compiler.compile(Collections.singletonList(tableRef), emptyCF, null, null, ts);
        return this.connection.getQueryServices().updateData(plan);
    }

    private void populatePropertyMaps(ListMultimap<String, Pair<String, Object>> props, Map<String, Object> tableProps, Map<String, Object> commonFamilyProps) {
        HColumnDescriptor defaultDescriptor = new HColumnDescriptor(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
        if (!props.isEmpty()) {
            List propsList = props.get((Object)"");
            for (Pair prop : propsList) {
                if (defaultDescriptor.getValue((String)prop.getFirst()) == null) {
                    tableProps.put((String)prop.getFirst(), prop.getSecond());
                    continue;
                }
                commonFamilyProps.put((String)prop.getFirst(), prop.getSecond());
            }
        }
    }

    public MutationState updateStatistics(UpdateStatisticsStatement updateStatisticsStmt) throws SQLException {
        this.connection.rollback();
        ColumnResolver resolver = FromCompiler.getResolver(updateStatisticsStmt, this.connection);
        PTable table = resolver.getTables().get(0).getTable();
        long rowCount = 0L;
        if (updateStatisticsStmt.updateColumns()) {
            rowCount += this.updateStatisticsInternal(table.getPhysicalName(), table, updateStatisticsStmt.getProps());
        }
        if (updateStatisticsStmt.updateIndex()) {
            for (PTable index : table.getIndexes()) {
                rowCount += this.updateStatisticsInternal(index.getPhysicalName(), index, updateStatisticsStmt.getProps());
            }
            if (table.getType() != PTableType.VIEW) {
                List<byte[]> localCFs;
                PName physicalName;
                if (table.isMultiTenant() || MetaDataUtil.hasViewIndexTable(this.connection, table.getPhysicalName())) {
                    physicalName = PNameFactory.newName(MetaDataUtil.getViewIndexPhysicalName(table.getPhysicalName().getBytes()));
                    DelegateTable indexLogicalTable = new DelegateTable(table){

                        @Override
                        public PName getPhysicalName() {
                            return physicalName;
                        }
                    };
                    rowCount += this.updateStatisticsInternal(physicalName, indexLogicalTable, updateStatisticsStmt.getProps());
                }
                if (!(localCFs = MetaDataUtil.getLocalIndexColumnFamilies(this.connection, (physicalName = table.getPhysicalName()).getBytes())).isEmpty()) {
                    rowCount += this.updateStatisticsInternal(physicalName, table, updateStatisticsStmt.getProps(), localCFs);
                }
            }
        }
        final long count = rowCount;
        return new MutationState(1L, 1000L, this.connection){

            @Override
            public long getUpdateCount() {
                return count;
            }
        };
    }

    private long updateStatisticsInternal(PName physicalName, PTable logicalTable, Map<String, Object> statsProps) throws SQLException {
        return this.updateStatisticsInternal(physicalName, logicalTable, statsProps, null);
    }

    private long updateStatisticsInternal(PName physicalName, PTable logicalTable, Map<String, Object> statsProps, List<byte[]> cfs) throws SQLException {
        ReadOnlyProps props = this.connection.getQueryServices().getProps();
        long msMinBetweenUpdates = props.getLong("phoenix.stats.minUpdateFrequency", props.getLong("phoenix.stats.updateFrequency", 900000L) / 2L);
        byte[] tenantIdBytes = ByteUtil.EMPTY_BYTE_ARRAY;
        Long scn = this.connection.getSCN();
        long clientTimeStamp = this.connection.getSCN() == null ? Long.MAX_VALUE : scn;
        String query = "SELECT CURRENT_DATE(),LAST_STATS_UPDATE_TIME FROM " + PhoenixDatabaseMetaData.SYSTEM_STATS_NAME + " WHERE " + "PHYSICAL_NAME" + "='" + physicalName.getString() + "' AND " + "COLUMN_FAMILY" + " IS NULL AND " + "LAST_STATS_UPDATE_TIME" + " IS NOT NULL";
        ResultSet rs = this.connection.createStatement().executeQuery(query);
        long msSinceLastUpdate = Long.MAX_VALUE;
        if (rs.next()) {
            msSinceLastUpdate = rs.getLong(1) - rs.getLong(2);
        }
        long rowCount = 0L;
        if (msSinceLastUpdate >= msMinBetweenUpdates) {
            PostDDLCompiler compiler = new PostDDLCompiler(this.connection);
            DelegateTable nonTxnLogicalTable = new DelegateTable(logicalTable){

                @Override
                public boolean isTransactional() {
                    return false;
                }
            };
            TableRef tableRef = new TableRef(null, nonTxnLogicalTable, clientTimeStamp, false);
            MutationPlan plan = compiler.compile(Collections.singletonList(tableRef), null, cfs, null, clientTimeStamp);
            Scan scan = plan.getContext().getScan();
            scan.setCacheBlocks(false);
            scan.setAttribute("_ANALYZETABLE", PDataType.TRUE_BYTES);
            boolean runUpdateStatsAsync = props.getBoolean("phoenix.update.stats.command.async", true);
            scan.setAttribute("_RunUpdateStatsAsync", runUpdateStatsAsync ? PDataType.TRUE_BYTES : PDataType.FALSE_BYTES);
            if (statsProps != null) {
                Object gp_per_region;
                Object gp_width = statsProps.get("phoenix.stats.guidepost.width");
                if (gp_width != null) {
                    scan.setAttribute("_GUIDEPOST_WIDTH_BYTES", PLong.INSTANCE.toBytes(gp_width));
                }
                if ((gp_per_region = statsProps.get("phoenix.stats.guidepost.per.region")) != null) {
                    scan.setAttribute("_GUIDEPOST_PER_REGION", PInteger.INSTANCE.toBytes(gp_per_region));
                }
            }
            MutationState mutationState = plan.execute();
            rowCount = mutationState.getUpdateCount();
        }
        if (cfs == null) {
            List<PColumnFamily> families = logicalTable.getColumnFamilies();
            if (families.isEmpty()) {
                this.connection.getQueryServices().invalidateStats(new GuidePostsKey(physicalName.getBytes(), SchemaUtil.getEmptyColumnFamily(logicalTable)));
            } else {
                for (PColumnFamily family : families) {
                    this.connection.getQueryServices().invalidateStats(new GuidePostsKey(physicalName.getBytes(), family.getName().getBytes()));
                }
            }
        } else {
            for (byte[] cf : cfs) {
                this.connection.getQueryServices().invalidateStats(new GuidePostsKey(physicalName.getBytes(), cf));
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState buildIndexAtTimeStamp(PTable index, NamedTableNode dataTableNode) throws SQLException {
        block13: {
            Properties props = new Properties(this.connection.getClientInfo());
            props.setProperty("BuildIndexAt", Long.toString(this.connection.getSCN() + 1L));
            PhoenixConnection conn = new PhoenixConnection(this.connection, this.connection.getQueryServices(), props);
            MetaDataClient newClientAtNextTimeStamp = new MetaDataClient(conn);
            conn.setAutoCommit(true);
            ColumnResolver resolver = FromCompiler.getResolver(dataTableNode, conn);
            TableRef tableRef = resolver.getTables().get(0);
            boolean success = false;
            SQLException sqlException = null;
            try {
                MutationState state2 = newClientAtNextTimeStamp.buildIndex(index, tableRef);
                success = true;
                MutationState mutationState = state2;
                return mutationState;
            }
            catch (SQLException e) {
                sqlException = e;
                return sqlException;
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    if (sqlException == null) {
                        if (success) {
                            sqlException = e;
                        }
                    }
                    sqlException.setNextException(e);
                }
                if (sqlException == null) break block13;
                throw sqlException;
            }
        }
        throw new IllegalStateException();
    }

    private MutationPlan getMutationPlanForBuildingIndex(PTable index, TableRef dataTableRef) throws SQLException {
        MutationPlan mutationPlan;
        if (index.getIndexType() == PTable.IndexType.LOCAL) {
            PostLocalIndexDDLCompiler compiler = new PostLocalIndexDDLCompiler(this.connection, this.getFullTableName(dataTableRef));
            mutationPlan = compiler.compile(index);
        } else {
            PostIndexDDLCompiler compiler = new PostIndexDDLCompiler(this.connection, dataTableRef);
            mutationPlan = compiler.compile(index);
        }
        return mutationPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState buildIndex(PTable index, TableRef dataTableRef) throws SQLException {
        AlterIndexStatement indexStatement = null;
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            this.connection.setAutoCommit(true);
            MutationPlan mutationPlan = this.getMutationPlanForBuildingIndex(index, dataTableRef);
            Scan scan = mutationPlan.getContext().getScan();
            Long scn = this.connection.getSCN();
            try {
                if (ScanUtil.isDefaultTimeRange(scan.getTimeRange())) {
                    if (scn == null) {
                        scn = mutationPlan.getContext().getCurrentTime();
                    }
                    scan.setTimeRange(dataTableRef.getLowerBoundTimeStamp(), scn.longValue());
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            MutationState state2 = this.connection.getQueryServices().updateData(mutationPlan);
            long firstUpsertSelectTime = EnvironmentEdgeManager.currentTimeMillis() - startTime;
            long sleepTime = this.connection.getQueryServices().getProps().getLong("phoenix.index.population.wait.time", 5000L);
            if (!dataTableRef.getTable().isTransactional() && sleepTime > 0L) {
                long delta = sleepTime - firstUpsertSelectTime;
                if (delta > 0L) {
                    try {
                        Thread.sleep(delta);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                    }
                }
                long minTimestamp = index.getTimeStamp() - firstUpsertSelectTime;
                try {
                    mutationPlan.getContext().getScan().setTimeRange(minTimestamp, scn.longValue());
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                MutationState newMutationState = this.connection.getQueryServices().updateData(mutationPlan);
                state2.join(newMutationState);
            }
            indexStatement = FACTORY.alterIndex(FACTORY.namedTable(null, TableName.create(index.getSchemaName().getString(), index.getTableName().getString())), dataTableRef.getTable().getTableName().getString(), false, PIndexState.ACTIVE);
            this.alterIndex(indexStatement);
            MutationState mutationState = state2;
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private String getFullTableName(TableRef dataTableRef) {
        String schemaName = dataTableRef.getTable().getSchemaName().getString();
        String tableName = dataTableRef.getTable().getTableName().getString();
        String fullName = schemaName == null ? "\"" + tableName + "\"" : "\"" + schemaName + "\"" + "." + "\"" + tableName + "\"";
        return fullName;
    }

    public MutationState declareCursor(DeclareCursorStatement statement, QueryPlan queryPlan) throws SQLException {
        CursorUtil.declareCursor(statement, queryPlan);
        return new MutationState(0L, 0L, this.connection);
    }

    public MutationState open(OpenStatement statement) throws SQLException {
        CursorUtil.openCursor(statement, this.connection);
        return new MutationState(0L, 0L, this.connection);
    }

    public MutationState close(CloseStatement statement) throws SQLException {
        CursorUtil.closeCursor(statement);
        return new MutationState(0L, 0L, this.connection);
    }

    public MutationState createIndex(CreateIndexStatement statement, byte[][] splits) throws SQLException {
        IndexKeyConstraint ik = statement.getIndexConstraint();
        TableName indexTableName = statement.getIndexTableName();
        HashMap tableProps = Maps.newHashMapWithExpectedSize((int)statement.getProps().size());
        HashMap commonFamilyProps = Maps.newHashMapWithExpectedSize((int)(statement.getProps().size() + 1));
        this.populatePropertyMaps(statement.getProps(), tableProps, commonFamilyProps);
        List<Pair<ParseNode, SortOrder>> indexParseNodeAndSortOrderList = ik.getParseNodeAndSortOrderList();
        List<ColumnName> includedColumns = statement.getIncludeColumns();
        TableRef tableRef = null;
        PTable table = null;
        int numRetries = 0;
        boolean allocateIndexId = false;
        boolean isLocalIndex = statement.getIndexType() == PTable.IndexType.LOCAL;
        int hbaseVersion = this.connection.getQueryServices().getLowestClusterHBaseVersion();
        if (isLocalIndex && !this.connection.getQueryServices().supportsFeature(ConnectionQueryServices.Feature.LOCAL_INDEX)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_LOCAL_INDEXES).setTableName(indexTableName.getTableName()).build().buildException();
        }
        while (true) {
            try {
                PColumn col;
                LinkedHashSet unusedPkColumns;
                boolean isTenantConnection;
                ColumnResolver resolver = FromCompiler.getResolver(statement, this.connection, statement.getUdfParseNodes());
                tableRef = resolver.getTables().get(0);
                Date asyncCreatedDate = null;
                if (statement.isAsync()) {
                    asyncCreatedDate = new Date(tableRef.getTimeStamp());
                }
                PTable dataTable = tableRef.getTable();
                boolean bl = isTenantConnection = this.connection.getTenantId() != null;
                if (isTenantConnection && dataTable.getType() != PTableType.VIEW) {
                    throw new SQLFeatureNotSupportedException("An index may only be created for a VIEW through a tenant-specific connection");
                }
                if (!dataTable.isImmutableRows()) {
                    boolean tableWithRowTimestampCol;
                    if (hbaseVersion < PhoenixDatabaseMetaData.MUTABLE_SI_VERSION_THRESHOLD) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_MUTABLE_INDEXES).setTableName(indexTableName.getTableName()).build().buildException();
                    }
                    if (!this.connection.getQueryServices().hasIndexWALCodec() && !dataTable.isTransactional()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_MUTABLE_INDEX_CONFIG).setTableName(indexTableName.getTableName()).build().buildException();
                    }
                    boolean bl2 = tableWithRowTimestampCol = dataTable.getRowTimestampColPos() != -1;
                    if (tableWithRowTimestampCol) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_INDEX_ON_MUTABLE_TABLE_WITH_ROWTIMESTAMP).setTableName(indexTableName.getTableName()).build().buildException();
                    }
                }
                int posOffset = 0;
                List<PColumn> pkColumns = dataTable.getPKColumns();
                if (dataTable.getBucketNum() != null) {
                    unusedPkColumns = Sets.newLinkedHashSetWithExpectedSize((int)(pkColumns.size() - 1));
                    ++posOffset;
                } else {
                    unusedPkColumns = Sets.newLinkedHashSetWithExpectedSize((int)pkColumns.size());
                }
                for (int i = posOffset; i < pkColumns.size(); ++i) {
                    PColumn column = pkColumns.get(i);
                    unusedPkColumns.add(new RowKeyColumnExpression((PDatum)column, new RowKeyValueAccessor(pkColumns, i), "\"" + column.getName().getString() + "\""));
                }
                ArrayList allPkColumns = Lists.newArrayListWithExpectedSize((int)unusedPkColumns.size());
                ArrayList columnDefs = Lists.newArrayListWithExpectedSize((int)(includedColumns.size() + indexParseNodeAndSortOrderList.size()));
                if (isLocalIndex || dataTable.getType() == PTableType.VIEW && dataTable.getViewType() != PTable.ViewType.MAPPED) {
                    allocateIndexId = true;
                    PDataType dataType = MetaDataUtil.getViewIndexIdDataType();
                    ColumnName colName = ColumnName.caseSensitiveColumnName(MetaDataUtil.getViewIndexIdColumnName());
                    allPkColumns.add(new ColumnDefInPkConstraint(colName, SortOrder.getDefault(), false));
                    columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), false, null, null, false, SortOrder.getDefault(), null, false));
                }
                if (dataTable.isMultiTenant()) {
                    PColumn col2 = dataTable.getPKColumns().get(posOffset);
                    RowKeyColumnExpression columnExpression = new RowKeyColumnExpression((PDatum)col2, new RowKeyValueAccessor(pkColumns, posOffset), col2.getName().getString());
                    unusedPkColumns.remove(columnExpression);
                    PDataType dataType = IndexUtil.getIndexColumnDataType(col2);
                    ColumnName colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col2));
                    allPkColumns.add(new ColumnDefInPkConstraint(colName, col2.getSortOrder(), false));
                    columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), col2.isNullable(), col2.getMaxLength(), col2.getScale(), false, SortOrder.getDefault(), col2.getName().getString(), col2.isRowTimestamp()));
                }
                PhoenixStatement phoenixStatment = new PhoenixStatement(this.connection);
                StatementContext context = new StatementContext(phoenixStatment, resolver);
                IndexExpressionCompiler expressionIndexCompiler = new IndexExpressionCompiler(context);
                HashSet indexedColumnNames = Sets.newHashSetWithExpectedSize((int)indexParseNodeAndSortOrderList.size());
                for (Pair<ParseNode, SortOrder> pair : indexParseNodeAndSortOrderList) {
                    ParseNode parseNode = (ParseNode)pair.getFirst();
                    parseNode = StatementNormalizer.normalize(parseNode, resolver);
                    expressionIndexCompiler.reset();
                    Expression expression = parseNode.accept(expressionIndexCompiler);
                    if (expressionIndexCompiler.isAggregate()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.AGGREGATE_EXPRESSION_NOT_ALLOWED_IN_INDEX).build().buildException();
                    }
                    if (expression.getDeterminism() != Determinism.ALWAYS) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.NON_DETERMINISTIC_EXPRESSION_NOT_ALLOWED_IN_INDEX).build().buildException();
                    }
                    if (expression.isStateless()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.STATELESS_EXPRESSION_NOT_ALLOWED_IN_INDEX).build().buildException();
                    }
                    unusedPkColumns.remove(expression);
                    StringBuilder buf = new StringBuilder();
                    parseNode.toSQL(resolver, buf);
                    String expressionStr = StringUtil.escapeBackslash(buf.toString());
                    ColumnName colName = null;
                    ColumnRef colRef = expressionIndexCompiler.getColumnRef();
                    boolean isRowTimestamp = false;
                    if (colRef != null) {
                        PColumn column = colRef.getColumn();
                        String columnFamilyName = column.getFamilyName() != null ? column.getFamilyName().getString() : null;
                        colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(columnFamilyName, column.getName().getString()));
                        isRowTimestamp = column.isRowTimestamp();
                        if (colRef.getColumn().getExpressionStr() != null) {
                            expressionStr = colRef.getColumn().getExpressionStr();
                        }
                    } else {
                        String name = expressionStr.replaceAll("\"", "'");
                        colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(null, name));
                    }
                    indexedColumnNames.add(colName);
                    PDataType dataType = IndexUtil.getIndexColumnDataType(expression.isNullable(), expression.getDataType());
                    allPkColumns.add(new ColumnDefInPkConstraint(colName, (SortOrder)((Object)pair.getSecond()), isRowTimestamp));
                    columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), expression.isNullable(), expression.getMaxLength(), expression.getScale(), false, (SortOrder)((Object)pair.getSecond()), expressionStr, isRowTimestamp));
                }
                if (!unusedPkColumns.isEmpty()) {
                    for (RowKeyColumnExpression colExpression : unusedPkColumns) {
                        col = dataTable.getPKColumns().get(colExpression.getPosition());
                        if (col.getViewConstant() != null) continue;
                        ColumnName colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col));
                        allPkColumns.add(new ColumnDefInPkConstraint(colName, colExpression.getSortOrder(), col.isRowTimestamp()));
                        PDataType dataType = IndexUtil.getIndexColumnDataType(colExpression.isNullable(), colExpression.getDataType());
                        columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), colExpression.isNullable(), colExpression.getMaxLength(), colExpression.getScale(), false, colExpression.getSortOrder(), colExpression.toString(), col.isRowTimestamp()));
                    }
                }
                for (ColumnName colName : includedColumns) {
                    col = resolver.resolveColumn(null, colName.getFamilyName(), colName.getColumnName()).getColumn();
                    if (indexedColumnNames.contains(colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col)))) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_EXIST_IN_DEF).build().buildException();
                    }
                    if (SchemaUtil.isPKColumn(col) || col.getViewConstant() != null) continue;
                    colName = ColumnName.caseSensitiveColumnName(isLocalIndex ? IndexUtil.getLocalIndexColumnFamily(col.getFamilyName().getString()) : col.getFamilyName().getString(), IndexUtil.getIndexColumnName(col));
                    columnDefs.add(FACTORY.columnDef(colName, col.getDataType().getSqlTypeName(), col.isNullable(), col.getMaxLength(), col.getScale(), false, col.getSortOrder(), col.getExpressionStr(), col.isRowTimestamp()));
                }
                if (dataTable.getDefaultFamilyName() != null && dataTable.getType() != PTableType.VIEW && !allocateIndexId) {
                    statement.getProps().put((Object)"", (Object)new Pair((Object)"DEFAULT_COLUMN_FAMILY", (Object)dataTable.getDefaultFamilyName().getString()));
                }
                PrimaryKeyConstraint pk = FACTORY.primaryKey(null, allPkColumns);
                tableProps.put("DATA_TABLE_NAME", dataTable.getName().getString());
                CreateTableStatement tableStatement = FACTORY.createTable(indexTableName, statement.getProps(), columnDefs, pk, statement.getSplitNodes(), PTableType.INDEX, statement.ifNotExists(), null, null, statement.getBindCount(), null);
                table = this.createTableInternal(tableStatement, splits, dataTable, null, null, null, null, allocateIndexId, statement.getIndexType(), asyncCreatedDate, tableProps, commonFamilyProps);
            }
            catch (ConcurrentTableMutationException e) {
                if (numRetries < 5) {
                    ++numRetries;
                    continue;
                }
                throw e;
            }
            break;
        }
        if (table == null) {
            return new MutationState(0L, 0L, this.connection);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Created index " + table.getName().getString() + " at " + table.getTimeStamp());
        }
        boolean asyncIndexBuildEnabled = this.connection.getQueryServices().getProps().getBoolean("phoenix.index.async.build.enabled", true);
        if (statement.isAsync() && asyncIndexBuildEnabled) {
            return new MutationState(0L, 0L, this.connection);
        }
        if (this.connection.getSCN() != null) {
            return this.buildIndexAtTimeStamp(table, statement.getTable());
        }
        return this.buildIndex(table, tableRef);
    }

    public MutationState dropSequence(DropSequenceStatement statement) throws SQLException {
        Long scn = this.connection.getSCN();
        long timestamp = scn == null ? Long.MAX_VALUE : scn;
        String schemaName = this.connection.getSchema() != null && statement.getSequenceName().getSchemaName() == null ? this.connection.getSchema() : statement.getSequenceName().getSchemaName();
        String sequenceName = statement.getSequenceName().getTableName();
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        try {
            this.connection.getQueryServices().dropSequence(tenantId, schemaName, sequenceName, timestamp);
        }
        catch (SequenceNotFoundException e) {
            if (statement.ifExists()) {
                return new MutationState(0L, 0L, this.connection);
            }
            throw e;
        }
        return new MutationState(1L, 1000L, this.connection);
    }

    public MutationState createSequence(CreateSequenceStatement statement, long startWith, long incrementBy, long cacheSize, long minValue, long maxValue) throws SQLException {
        Long scn = this.connection.getSCN();
        long timestamp = scn == null ? Long.MAX_VALUE : scn;
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        String schemaName = statement.getSequenceName().getSchemaName();
        if (SchemaUtil.isNamespaceMappingEnabled(null, this.connection.getQueryServices().getProps())) {
            if (schemaName == null || schemaName.equals("")) {
                schemaName = this.connection.getSchema();
            }
            if (schemaName != null) {
                FromCompiler.getResolverForSchema(schemaName, this.connection);
            }
        }
        return this.createSequence(tenantId, schemaName, statement.getSequenceName().getTableName(), statement.ifNotExists(), startWith, incrementBy, cacheSize, statement.getCycle(), minValue, maxValue, timestamp);
    }

    private MutationState createSequence(String tenantId, String schemaName, String sequenceName, boolean ifNotExists, long startWith, long incrementBy, long cacheSize, boolean cycle, long minValue, long maxValue, long timestamp) throws SQLException {
        try {
            this.connection.getQueryServices().createSequence(tenantId, schemaName, sequenceName, startWith, incrementBy, cacheSize, minValue, maxValue, cycle, timestamp);
        }
        catch (SequenceAlreadyExistsException e) {
            if (ifNotExists) {
                return new MutationState(0L, 0L, this.connection);
            }
            throw e;
        }
        return new MutationState(1L, 1000L, this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState createFunction(CreateFunctionStatement stmt) throws SQLException {
        boolean wasAutoCommit = this.connection.getAutoCommit();
        this.connection.rollback();
        try {
            PFunction function = new PFunction(stmt.getFunctionInfo(), stmt.isTemporary(), stmt.isReplace());
            this.connection.setAutoCommit(false);
            String tenantIdStr = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
            ArrayList functionData = Lists.newArrayListWithExpectedSize((int)(function.getFunctionArguments().size() + 1));
            List<PFunction.FunctionArgument> args = function.getFunctionArguments();
            try (PreparedStatement argUpsert = this.connection.prepareStatement(INSERT_FUNCTION_ARGUMENT);){
                for (int i = 0; i < args.size(); ++i) {
                    PFunction.FunctionArgument arg = args.get(i);
                    this.addFunctionArgMutation(function.getFunctionName(), arg, argUpsert, i);
                }
                functionData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
                this.connection.rollback();
            }
            var8_8 = null;
            try (PreparedStatement functionUpsert = this.connection.prepareStatement(CREATE_FUNCTION);){
                functionUpsert.setString(1, tenantIdStr);
                functionUpsert.setString(2, function.getFunctionName());
                functionUpsert.setInt(3, function.getFunctionArguments().size());
                functionUpsert.setString(4, function.getClassName());
                functionUpsert.setString(5, function.getJarPath());
                functionUpsert.setString(6, function.getReturnType());
                functionUpsert.execute();
                functionData.addAll((Collection)this.connection.getMutationState().toMutations(null).next().getSecond());
                this.connection.rollback();
            }
            catch (Throwable x2) {
                var8_8 = x2;
                throw x2;
            }
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().createFunction(functionData, function, stmt.isTemporary());
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            switch (code) {
                case FUNCTION_ALREADY_EXISTS: {
                    if (!function.isReplace()) {
                        throw new FunctionAlreadyExistsException(function.getFunctionName(), result.getFunctions().get(0));
                    }
                    this.connection.removeFunction(function.getTenantId(), function.getFunctionName(), result.getMutationTime());
                    this.addFunctionToCache(result);
                }
                case NEWER_FUNCTION_FOUND: {
                    throw new NewerFunctionAlreadyExistsException(function.getFunctionName(), result.getFunctions().get(0));
                }
            }
            ArrayList<PFunction> functions = new ArrayList<PFunction>(1);
            functions.add(function);
            result = new MetaDataProtocol.MetaDataMutationResult(code, result.getMutationTime(), functions, true);
            if (function.isReplace()) {
                this.connection.removeFunction(function.getTenantId(), function.getFunctionName(), result.getMutationTime());
            }
            this.addFunctionToCache(result);
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
        return new MutationState(1L, 1000L, this.connection);
    }

    private static ColumnDef findColumnDefOrNull(List<ColumnDef> colDefs, ColumnName colName) {
        for (ColumnDef colDef : colDefs) {
            if (!colDef.getColumnDefName().getColumnName().equals(colName.getColumnName())) continue;
            return colDef;
        }
        return null;
    }

    private static boolean checkAndValidateRowTimestampCol(ColumnDef colDef, PrimaryKeyConstraint pkConstraint, boolean rowTimeStampColAlreadyFound, PTableType tableType) throws SQLException {
        ColumnName columnDefName = colDef.getColumnDefName();
        if (tableType == PTableType.VIEW && (pkConstraint.getNumColumnsWithRowTimestamp() > 0 || colDef.isRowTimestamp())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_NOT_ALLOWED_ON_VIEW).setColumnName(columnDefName.getColumnName()).build().buildException();
        }
        if (tableType == PTableType.TABLE) {
            boolean isColumnDeclaredRowTimestamp;
            boolean bl = isColumnDeclaredRowTimestamp = colDef.isRowTimestamp() || pkConstraint.isColumnRowTimestamp(columnDefName);
            if (isColumnDeclaredRowTimestamp) {
                boolean isColumnPartOfPk;
                boolean bl2 = isColumnPartOfPk = colDef.isPK() || pkConstraint.contains(columnDefName);
                if (isColumnDeclaredRowTimestamp && !isColumnPartOfPk) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_PK_COL_ONLY).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                PDataType dataType = colDef.getDataType();
                if (isColumnDeclaredRowTimestamp && dataType != PLong.INSTANCE && dataType != PUnsignedLong.INSTANCE && !dataType.isCoercibleTo(PTimestamp.INSTANCE)) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_COL_INVALID_TYPE).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                if (rowTimeStampColAlreadyFound && isColumnDeclaredRowTimestamp) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_ONE_PK_COL_ONLY).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTable createTableInternal(CreateTableStatement statement, byte[][] splits, PTable parent, String viewStatement, PTable.ViewType viewType, final byte[][] viewColumnConstants, final BitSet isViewColumnReferenced, boolean allocateIndexId, PTable.IndexType indexType, Date asyncCreatedDate, Map<String, Object> tableProps, Map<String, Object> commonFamilyProps) throws SQLException {
        PTableType tableType = statement.getTableType();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        this.connection.rollback();
        try {
            Object column;
            LinkedHashSet pkColumns;
            LinkedHashMap<PColumn, PColumn> columns;
            int autoPartitionColIndex;
            PDataType dataType;
            boolean sharedTable;
            Object ttl;
            boolean transactionsEnabled;
            Boolean transactionalProp;
            this.connection.setAutoCommit(false);
            ArrayList tableMetaData = Lists.newArrayListWithExpectedSize((int)(statement.getColumnDefs().size() + 3));
            TableName tableNameNode = statement.getTableName();
            String schemaName = this.connection.getSchema() != null && tableNameNode.getSchemaName() == null ? this.connection.getSchema() : tableNameNode.getSchemaName();
            String tableName = tableNameNode.getTableName();
            String parentTableName = null;
            PName tenantId = this.connection.getTenantId();
            String tenantIdStr = tenantId == null ? null : tenantId.getString();
            Long scn = this.connection.getSCN();
            long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
            boolean multiTenant = false;
            boolean storeNulls = false;
            boolean transactional = parent != null ? parent.isTransactional() : false;
            Integer saltBucketNum = null;
            String defaultFamilyName = null;
            boolean isImmutableRows = false;
            boolean isAppendOnlySchema = false;
            List<Object> physicalNames = Collections.emptyList();
            boolean addSaltColumn = false;
            boolean rowKeyOrderOptimizable = true;
            Long timestamp = null;
            boolean isNamespaceMapped = parent == null ? SchemaUtil.isNamespaceMappingEnabled(tableType, this.connection.getQueryServices().getProps()) : parent.isNamespaceMapped();
            boolean isLocalIndex = indexType == PTable.IndexType.LOCAL;
            PTable.QualifierEncodingScheme encodingScheme = PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
            PTable.ImmutableStorageScheme immutableStorageScheme = PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN;
            if (parent != null && tableType == PTableType.INDEX) {
                timestamp = TransactionUtil.getTableTimestamp(this.connection, transactional);
                storeNulls = parent.getStoreNulls();
                isImmutableRows = parent.isImmutableRows();
                isAppendOnlySchema = parent.isAppendOnlySchema();
                if (isLocalIndex || parent.getType() == PTableType.VIEW && parent.getViewType() != PTable.ViewType.MAPPED) {
                    PName physicalName = parent.getPhysicalName();
                    saltBucketNum = parent.getBucketNum();
                    addSaltColumn = saltBucketNum != null && !isLocalIndex;
                    String string = defaultFamilyName = parent.getDefaultFamilyName() == null ? null : parent.getDefaultFamilyName().getString();
                    if (isLocalIndex) {
                        defaultFamilyName = parent.getDefaultFamilyName() == null ? "L#0" : IndexUtil.getLocalIndexColumnFamily(parent.getDefaultFamilyName().getString());
                        saltBucketNum = null;
                        physicalNames = Collections.singletonList(PNameFactory.newName(physicalName.getBytes()));
                    } else {
                        defaultFamilyName = parent.getDefaultFamilyName() == null ? "0" : parent.getDefaultFamilyName().getString();
                        physicalNames = Collections.singletonList(PNameFactory.newName(MetaDataUtil.getViewIndexPhysicalName(physicalName.getBytes())));
                    }
                }
                multiTenant = parent.isMultiTenant();
                storeNulls = parent.getStoreNulls();
                parentTableName = parent.getTableName().getString();
                PreparedStatement incrementStatement = this.connection.prepareStatement(INCREMENT_SEQ_NUM);
                incrementStatement.setString(1, tenantIdStr);
                incrementStatement.setString(2, schemaName);
                incrementStatement.setString(3, parentTableName);
                incrementStatement.setLong(4, parent.getSequenceNumber());
                incrementStatement.execute();
                tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timestamp).next().getSecond());
                this.connection.rollback();
                PreparedStatement linkStatement = this.connection.prepareStatement(CREATE_LINK);
                linkStatement.setString(1, tenantIdStr);
                linkStatement.setString(2, schemaName);
                linkStatement.setString(3, parentTableName);
                linkStatement.setString(4, tableName);
                linkStatement.setByte(5, PTable.LinkType.INDEX_TABLE.getSerializedValue());
                linkStatement.setLong(6, parent.getSequenceNumber());
                linkStatement.setString(7, PTableType.INDEX.getSerializedValue());
                linkStatement.execute();
            }
            PrimaryKeyConstraint pkConstraint = statement.getPrimaryKeyConstraint();
            String pkName = null;
            List<Object> pkColumnsNames = Collections.emptyList();
            Iterator<Object> pkColumnsIterator = Collections.emptyIterator();
            if (pkConstraint != null) {
                pkColumnsNames = pkConstraint.getColumnNames();
                pkColumnsIterator = pkColumnsNames.iterator();
                pkName = pkConstraint.getName();
            }
            if (tableType != PTableType.INDEX && (tableType != PTableType.VIEW || viewType == PTable.ViewType.MAPPED)) {
                Boolean isImmutableRowsProp = statement.immutableRows() != null ? statement.immutableRows() : (Boolean)TableProperty.IMMUTABLE_ROWS.getValue(tableProps);
                isImmutableRows = isImmutableRowsProp == null ? this.connection.getQueryServices().getProps().getBoolean("phoenix.mutate.immutableRows", false) : isImmutableRowsProp.booleanValue();
            }
            if (tableType == PTableType.TABLE) {
                Boolean isAppendOnlySchemaProp = (Boolean)TableProperty.APPEND_ONLY_SCHEMA.getValue(tableProps);
                boolean bl = isAppendOnlySchema = isAppendOnlySchemaProp != null ? isAppendOnlySchemaProp : false;
            }
            if (tableType != PTableType.VIEW && !allocateIndexId) {
                saltBucketNum = (Integer)TableProperty.SALT_BUCKETS.getValue(tableProps);
                if (saltBucketNum != null && (saltBucketNum < 0 || saltBucketNum > SaltingUtil.MAX_BUCKET_NUM)) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_BUCKET_NUM).build().buildException();
                }
                if (saltBucketNum == null) {
                    if (parent != null) {
                        saltBucketNum = parent.getBucketNum();
                    }
                } else if (saltBucketNum == 0) {
                    saltBucketNum = null;
                }
                boolean bl = addSaltColumn = saltBucketNum != null;
            }
            if (tableType != PTableType.INDEX && (tableType != PTableType.VIEW || viewType == PTable.ViewType.MAPPED)) {
                Boolean multiTenantProp = (Boolean)tableProps.get("MULTI_TENANT");
                multiTenant = Boolean.TRUE.equals(multiTenantProp);
                defaultFamilyName = (String)TableProperty.DEFAULT_COLUMN_FAMILY.getValue(tableProps);
            }
            boolean disableWAL = false;
            Boolean disableWALProp = (Boolean)TableProperty.DISABLE_WAL.getValue(tableProps);
            if (disableWALProp != null) {
                disableWAL = disableWALProp;
            }
            long updateCacheFrequency = this.connection.getQueryServices().getProps().getLong("phoenix.default.update.cache.frequency", 0L);
            Long updateCacheFrequencyProp = (Long)TableProperty.UPDATE_CACHE_FREQUENCY.getValue(tableProps);
            if (updateCacheFrequencyProp != null) {
                updateCacheFrequency = updateCacheFrequencyProp;
            }
            String autoPartitionSeq = (String)TableProperty.AUTO_PARTITION_SEQ.getValue(tableProps);
            Long guidePostsWidth = (Long)TableProperty.GUIDE_POSTS_WIDTH.getValue(tableProps);
            Boolean storeNullsProp = (Boolean)TableProperty.STORE_NULLS.getValue(tableProps);
            if (storeNullsProp == null) {
                if (parent == null) {
                    storeNulls = this.connection.getQueryServices().getProps().getBoolean("phoenix.table.default.store.nulls", false);
                    tableProps.put("STORE_NULLS", storeNulls);
                }
            } else {
                storeNulls = storeNullsProp;
            }
            if ((transactionalProp = (Boolean)TableProperty.TRANSACTIONAL.getValue(tableProps)) != null && parent != null) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.ONLY_TABLE_MAY_BE_DECLARED_TRANSACTIONAL).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            if (parent == null) {
                transactional = transactionalProp == null ? this.connection.getQueryServices().getProps().getBoolean("phoenix.table.istransactional.default", false) : transactionalProp.booleanValue();
            }
            if (!(transactionsEnabled = this.connection.getQueryServices().getProps().getBoolean("phoenix.transactions.enabled", false)) && transactional) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_TXN_TABLE_IF_TXNS_DISABLED).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            if (pkConstraint.getNumColumnsWithRowTimestamp() > 0 && transactional) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_TXN_TABLE_WITH_ROW_TIMESTAMP).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            tableProps.put("TRANSACTIONAL", transactional);
            if (transactional && (ttl = commonFamilyProps.remove("TTL")) != null) {
                commonFamilyProps.put("dataset.table.ttl", ttl);
            }
            boolean useStatsForParallelization = true;
            Boolean useStatsForParallelizationProp = (Boolean)TableProperty.USE_STATS_FOR_PARALLELIZATION.getValue(tableProps);
            useStatsForParallelization = useStatsForParallelizationProp != null ? useStatsForParallelizationProp.booleanValue() : this.connection.getQueryServices().getProps().getBoolean("phoenix.use.stats.parallelization", true);
            boolean bl = sharedTable = statement.getTableType() == PTableType.VIEW || allocateIndexId;
            if (transactional) {
                Integer maxVersionsProp;
                if (Boolean.FALSE.equals(storeNullsProp)) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.STORE_NULLS_MUST_BE_TRUE_FOR_TRANSACTIONAL).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                storeNulls = true;
                tableProps.put("STORE_NULLS", Boolean.TRUE);
                if (!sharedTable && (maxVersionsProp = (Integer)commonFamilyProps.get("VERSIONS")) == null) {
                    HTableDescriptor desc;
                    if (parent != null && (desc = this.connection.getQueryServices().getTableDescriptor(parent.getPhysicalName().getBytes())) != null) {
                        maxVersionsProp = desc.getFamily(SchemaUtil.getEmptyColumnFamily(parent)).getMaxVersions();
                    }
                    if (maxVersionsProp == null) {
                        maxVersionsProp = this.connection.getQueryServices().getProps().getInt("phoenix.transactions.maxVersions", Integer.MAX_VALUE);
                    }
                    commonFamilyProps.put("VERSIONS", maxVersionsProp);
                }
            }
            Long l = timestamp = timestamp == null ? TransactionUtil.getTableTimestamp(this.connection, transactional) : timestamp;
            if (sharedTable) {
                if (tableProps.get("DEFAULT_COLUMN_FAMILY") != null) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.DEFAULT_COLUMN_FAMILY_ON_SHARED_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                if (SchemaUtil.hasHTableDescriptorProps(tableProps)) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
                }
            }
            List<ColumnDef> colDefs = statement.getColumnDefs();
            if (tenantId != null && !sharedTable) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_TENANT_SPECIFIC_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            if (autoPartitionSeq != null && !PLong.INSTANCE.isCastableTo(dataType = colDefs.get(autoPartitionColIndex = multiTenant ? 1 : 0).getDataType())) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.SEQUENCE_NOT_CASTABLE_TO_AUTO_PARTITION_ID_COLUMN).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            if (tableType == PTableType.VIEW) {
                physicalNames = Collections.singletonList(PNameFactory.newName(parent.getPhysicalName().getString()));
                if (viewType == PTable.ViewType.MAPPED) {
                    columns = Maps.newLinkedHashMap();
                    pkColumns = Sets.newLinkedHashSetWithExpectedSize((int)colDefs.size());
                } else {
                    rowKeyOrderOptimizable = parent.rowKeyOrderOptimizable();
                    if (rowKeyOrderOptimizable) {
                        UpgradeUtil.addRowKeyOrderOptimizableCell(tableMetaData, SchemaUtil.getTableKey(tenantIdStr, schemaName, tableName), clientTimeStamp);
                    }
                    multiTenant = parent.isMultiTenant();
                    saltBucketNum = parent.getBucketNum();
                    isAppendOnlySchema = parent.isAppendOnlySchema();
                    isImmutableRows = parent.isImmutableRows();
                    if (updateCacheFrequencyProp == null) {
                        updateCacheFrequency = parent.getUpdateCacheFrequency();
                    }
                    disableWAL = disableWALProp == null ? parent.isWALDisabled() : disableWALProp.booleanValue();
                    defaultFamilyName = parent.getDefaultFamilyName() == null ? null : parent.getDefaultFamilyName().getString();
                    List<PColumn> allColumns = parent.getColumns();
                    if (saltBucketNum != null) {
                        allColumns = allColumns.subList(1, allColumns.size());
                    }
                    columns = new LinkedHashMap<PColumn, PColumn>(allColumns.size() + colDefs.size());
                    for (PColumn pColumn : allColumns) {
                        columns.put(pColumn, pColumn);
                    }
                    pkColumns = Sets.newLinkedHashSet(parent.getPKColumns());
                    PreparedStatement linkStatement = this.connection.prepareStatement(CREATE_VIEW_LINK);
                    linkStatement.setString(1, tenantIdStr);
                    linkStatement.setString(2, schemaName);
                    linkStatement.setString(3, tableName);
                    linkStatement.setString(4, parent.getName().getString());
                    linkStatement.setByte(5, PTable.LinkType.PARENT_TABLE.getSerializedValue());
                    linkStatement.setString(6, parent.getTenantId() == null ? null : parent.getTenantId().getString());
                    linkStatement.execute();
                    linkStatement = this.connection.prepareStatement(CREATE_CHILD_LINK);
                    linkStatement.setString(1, parent.getTenantId() == null ? null : parent.getTenantId().getString());
                    linkStatement.setString(2, parent.getSchemaName() == null ? null : parent.getSchemaName().getString());
                    linkStatement.setString(3, parent.getTableName().getString());
                    linkStatement.setString(4, tenantIdStr);
                    linkStatement.setString(5, SchemaUtil.getTableName(schemaName, tableName));
                    linkStatement.setByte(6, PTable.LinkType.CHILD_TABLE.getSerializedValue());
                    linkStatement.execute();
                }
            } else {
                columns = new LinkedHashMap<PColumn, PColumn>(colDefs.size());
                pkColumns = Sets.newLinkedHashSetWithExpectedSize((int)(colDefs.size() + 1));
            }
            if (!(physicalNames.isEmpty() || viewType == PTable.ViewType.MAPPED && (((PName)physicalNames.get(0)).getString().equals(SchemaUtil.getTableName(schemaName, tableName)) || ((PName)physicalNames.get(0)).getString().equals(SchemaUtil.getPhysicalHBaseTableName(schemaName, tableName, isNamespaceMapped).getString())))) {
                PreparedStatement linkStatement = this.connection.prepareStatement(CREATE_LINK);
                for (PName pName : physicalNames) {
                    linkStatement.setString(1, tenantIdStr);
                    linkStatement.setString(2, schemaName);
                    linkStatement.setString(3, tableName);
                    linkStatement.setString(4, pName.getString());
                    linkStatement.setByte(5, PTable.LinkType.PHYSICAL_TABLE.getSerializedValue());
                    if (tableType == PTableType.VIEW) {
                        PTable physicalTable = this.connection.getTable(new PTableKey(null, pName.getString().replace(":", ".")));
                        linkStatement.setLong(6, physicalTable.getSequenceNumber());
                        linkStatement.setString(7, null);
                    } else {
                        linkStatement.setLong(6, parent.getSequenceNumber());
                        linkStatement.setString(7, PTableType.INDEX.getSerializedValue());
                    }
                    linkStatement.execute();
                }
                tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timestamp).next().getSecond());
                this.connection.rollback();
            }
            LinkedHashMap familyNames = Maps.newLinkedHashMap();
            boolean isPK = false;
            boolean bl2 = false;
            int positionOffset = columns.size();
            if (saltBucketNum != null) {
                ++positionOffset;
                if (addSaltColumn) {
                    pkColumns.add(SaltingUtil.SALTING_COLUMN);
                }
            }
            int pkPositionOffset = pkColumns.size();
            int position = positionOffset;
            PTable.EncodedCQCounter cqCounter = PTable.EncodedCQCounter.NULL_COUNTER;
            PTable viewPhysicalTable = null;
            if (tableType == PTableType.VIEW) {
                if (viewType != PTable.ViewType.MAPPED) {
                    viewPhysicalTable = PhoenixRuntime.getTable(this.connection, ((PName)physicalNames.get(0)).getString());
                    immutableStorageScheme = viewPhysicalTable.getImmutableStorageScheme();
                    encodingScheme = viewPhysicalTable.getEncodingScheme();
                    if (EncodedColumnsUtil.usesEncodedColumnNames(viewPhysicalTable)) {
                        cqCounter = viewPhysicalTable.getEncodedCQCounter();
                    }
                }
            } else if (!SchemaUtil.isSystemTable(Bytes.toBytes((String)SchemaUtil.getTableName(schemaName, tableName)))) {
                byte[] tableNameBytes = SchemaUtil.getTableNameAsBytes(schemaName, tableName);
                boolean tableExists = true;
                try {
                    HTableDescriptor tableDescriptor = this.connection.getQueryServices().getTableDescriptor(tableNameBytes);
                    if (tableDescriptor == null) {
                        tableExists = false;
                    }
                }
                catch (TableNotFoundException e) {
                    tableExists = false;
                }
                if (tableExists) {
                    encodingScheme = PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
                    immutableStorageScheme = PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN;
                } else if (parent != null) {
                    encodingScheme = parent.getEncodingScheme();
                    immutableStorageScheme = parent.getImmutableStorageScheme();
                } else {
                    Byte encodingSchemeSerializedByte = (Byte)TableProperty.COLUMN_ENCODED_BYTES.getValue(tableProps);
                    if (encodingSchemeSerializedByte == null) {
                        encodingSchemeSerializedByte = (byte)this.connection.getQueryServices().getProps().getInt("phoenix.default.column.encoded.bytes.attrib", QueryServicesOptions.DEFAULT_COLUMN_ENCODED_BYTES);
                    }
                    encodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue(encodingSchemeSerializedByte);
                    if (isImmutableRows) {
                        immutableStorageScheme = (PTable.ImmutableStorageScheme)TableProperty.IMMUTABLE_STORAGE_SCHEME.getValue(tableProps);
                        if (immutableStorageScheme == null) {
                            immutableStorageScheme = multiTenant ? PTable.ImmutableStorageScheme.valueOf(this.connection.getQueryServices().getProps().get("phoenix.default.multitenant.immutable.storage.scheme", QueryServicesOptions.DEFAULT_MULTITENANT_IMMUTABLE_STORAGE_SCHEME)) : PTable.ImmutableStorageScheme.valueOf(this.connection.getQueryServices().getProps().get("phoenix.default.immutable.storage.scheme", QueryServicesOptions.DEFAULT_IMMUTABLE_STORAGE_SCHEME));
                        }
                        if (immutableStorageScheme != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN && encodingScheme == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_IMMUTABLE_STORAGE_SCHEME_AND_COLUMN_QUALIFIER_BYTES).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                    }
                }
                cqCounter = encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? new PTable.EncodedCQCounter() : PTable.EncodedCQCounter.NULL_COUNTER;
            }
            HashMap<String, Integer> changedCqCounters = new HashMap<String, Integer>(colDefs.size());
            for (ColumnDef colDef : colDefs) {
                boolean bl3;
                bl3 = MetaDataClient.checkAndValidateRowTimestampCol(colDef, pkConstraint, bl3, tableType);
                if (colDef.isPK()) {
                    if (isPK) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_ALREADY_EXISTS).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                    }
                    isPK = true;
                } else if (Boolean.FALSE.equals(colDef.isNull()) && (isPK || pkConstraint != null && !pkConstraint.contains(colDef.getColumnDefName()))) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_NOT_NULL_CONSTRAINT).setSchemaName(schemaName).setTableName(tableName).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                }
                ColumnName columnDefName = colDef.getColumnDefName();
                String colDefFamily = columnDefName.getFamilyName();
                boolean isPkColumn = MetaDataClient.isPkColumn(pkConstraint, colDef, columnDefName);
                String cqCounterFamily = null;
                if (!isPkColumn) {
                    cqCounterFamily = immutableStorageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS && encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? (colDefFamily != null ? colDefFamily : (defaultFamilyName != null ? defaultFamilyName : "0")) : (defaultFamilyName != null ? defaultFamilyName : "0");
                }
                Integer n = isPkColumn ? null : cqCounter.getNextQualifier(cqCounterFamily);
                byte[] columnQualifierBytes = null;
                try {
                    columnQualifierBytes = EncodedColumnsUtil.getColumnQualifierBytes(columnDefName.getColumnName(), n, encodingScheme, isPkColumn);
                }
                catch (PTable.QualifierEncodingScheme.QualifierOutOfRangeException e) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.MAX_COLUMNS_EXCEEDED).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                column = this.newColumn(position++, colDef, pkConstraint, defaultFamilyName, false, columnQualifierBytes);
                if (cqCounter.increment(cqCounterFamily)) {
                    changedCqCounters.put(cqCounterFamily, cqCounter.getNextQualifier(cqCounterFamily));
                }
                if (SchemaUtil.isPKColumn((PColumn)column)) {
                    if (pkColumnsIterator.hasNext() && !column.getName().getString().equals(((ColumnName)((Pair)pkColumnsIterator.next()).getFirst()).getColumnName())) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_OUT_OF_ORDER).setSchemaName(schemaName).setTableName(tableName).setColumnName(column.getName().getString()).build().buildException();
                    }
                    if (tableType == PTableType.VIEW && viewType != PTable.ViewType.MAPPED) {
                        this.throwIfLastPKOfParentIsFixedLength(parent, schemaName, tableName, colDef);
                    }
                    if (!pkColumns.add(column)) {
                        throw new ColumnAlreadyExistsException(schemaName, tableName, column.getName().getString());
                    }
                }
                if (columns.put((PColumn)column, (PColumn)column) != null) {
                    throw new ColumnAlreadyExistsException(schemaName, tableName, column.getName().getString());
                }
                if ((colDef.getDataType() == PVarbinary.INSTANCE || colDef.getDataType().isArrayType()) && SchemaUtil.isPKColumn((PColumn)column) && pkColumnsIterator.hasNext()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.VARBINARY_IN_ROW_KEY).setSchemaName(schemaName).setTableName(tableName).setColumnName(column.getName().getString()).build().buildException();
                }
                if (column.getFamilyName() == null) continue;
                familyNames.put(IndexUtil.getActualColumnFamilyName(column.getFamilyName().getString()), column.getFamilyName());
            }
            if (!isPK && pkColumnsNames.isEmpty() && tableType != PTableType.VIEW && viewType != PTable.ViewType.MAPPED) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_MISSING).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            if (!pkColumnsNames.isEmpty() && pkColumnsNames.size() != pkColumns.size() - pkPositionOffset) {
                Iterator<Object> pkColumnNamesIterator = pkColumnsNames.iterator();
                while (pkColumnNamesIterator.hasNext()) {
                    ColumnName colName = (ColumnName)((Pair)pkColumnNamesIterator.next()).getFirst();
                    ColumnDef colDef = MetaDataClient.findColumnDefOrNull(colDefs, colName);
                    if (colDef == null) {
                        throw new ColumnNotFoundException(schemaName, tableName, null, colName.getColumnName());
                    }
                    if (colDef.getColumnDefName().getFamilyName() == null) continue;
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_WITH_FAMILY_NAME).setSchemaName(schemaName).setTableName(tableName).setColumnName(colDef.getColumnDefName().getColumnName()).setFamilyName(colDef.getColumnDefName().getFamilyName()).build().buildException();
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_PRIMARY_KEY_CONSTRAINT).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            ArrayList familyPropList = Lists.newArrayListWithExpectedSize((int)familyNames.size());
            if (!statement.getProps().isEmpty()) {
                for (Object familyName : statement.getProps().keySet()) {
                    if (((String)familyName).equals("")) continue;
                    if (familyNames.get(familyName) == null) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.PROPERTIES_FOR_FAMILY).setFamilyName((String)familyName).build().buildException();
                    }
                    if (statement.getTableType() != PTableType.VIEW) continue;
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
                }
            }
            MetaDataClient.throwIfInsufficientColumns(schemaName, tableName, pkColumns, saltBucketNum != null, multiTenant);
            for (Object familyName : familyNames.values()) {
                String fam = familyName.getString();
                List props = statement.getProps().get((Object)IndexUtil.getActualColumnFamilyName(fam));
                if (props.isEmpty()) {
                    familyPropList.add(new Pair((Object)familyName.getBytes(), commonFamilyProps));
                    continue;
                }
                HashMap combinedFamilyProps = Maps.newHashMapWithExpectedSize((int)(props.size() + commonFamilyProps.size()));
                combinedFamilyProps.putAll(commonFamilyProps);
                for (Pair prop : props) {
                    if (!familyName.equals("") && ((String)prop.getFirst()).equals("TTL")) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_TTL).build().buildException();
                    }
                    combinedFamilyProps.put(prop.getFirst(), prop.getSecond());
                }
                familyPropList.add(new Pair((Object)familyName.getBytes(), (Object)combinedFamilyProps));
            }
            if (familyNames.isEmpty()) {
                byte[] cf = defaultFamilyName == null ? (!isLocalIndex ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : QueryConstants.DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES) : Bytes.toBytes((String)defaultFamilyName);
                familyPropList.add(new Pair((Object)cf, commonFamilyProps));
            }
            if (SchemaUtil.isMetaTable(schemaName, tableName)) {
                PName newSchemaName = PNameFactory.newName(schemaName);
                PTableImpl table = PTableImpl.makePTable(tenantId, newSchemaName, PNameFactory.newName(tableName), tableType, null, 0L, 0L, PNameFactory.newName("pk"), null, columns.values(), null, null, Collections.emptyList(), isImmutableRows, Collections.emptyList(), defaultFamilyName == null ? null : PNameFactory.newName(defaultFamilyName), null, Boolean.TRUE.equals(disableWAL), false, false, null, null, indexType, true, false, 0L, 0L, isNamespaceMapped, autoPartitionSeq, isAppendOnlySchema, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, PTable.EncodedCQCounter.NULL_COUNTER, true);
                this.connection.addTable(table, 0L);
            }
            if (EncodedColumnsUtil.usesEncodedColumnNames(encodingScheme)) {
                String schemaNameToUse = tableType == PTableType.VIEW ? viewPhysicalTable.getSchemaName().getString() : schemaName;
                String tableNameToUse = tableType == PTableType.VIEW ? viewPhysicalTable.getTableName().getString() : tableName;
                boolean sharedIndex = tableType == PTableType.INDEX && (indexType == PTable.IndexType.LOCAL || parent.getType() == PTableType.VIEW);
                String tenantIdToUse = this.connection.getTenantId() != null && sharedIndex ? this.connection.getTenantId().getString() : null;
                for (Map.Entry entry : changedCqCounters.entrySet()) {
                    PreparedStatement linkStatement = this.connection.prepareStatement(UPDATE_ENCODED_COLUMN_COUNTER);
                    column = null;
                    try {
                        linkStatement.setString(1, tenantIdToUse);
                        linkStatement.setString(2, schemaNameToUse);
                        linkStatement.setString(3, tableNameToUse);
                        linkStatement.setString(4, (String)entry.getKey());
                        linkStatement.setInt(5, (Integer)entry.getValue());
                        linkStatement.execute();
                    }
                    catch (Throwable x2) {
                        column = x2;
                        throw x2;
                    }
                    finally {
                        if (linkStatement == null) continue;
                        if (column != null) {
                            try {
                                linkStatement.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)column).addSuppressed(x2);
                            }
                            continue;
                        }
                        linkStatement.close();
                    }
                }
                if (tableType == PTableType.VIEW && !changedCqCounters.isEmpty()) {
                    PreparedStatement incrementStatement = this.connection.prepareStatement(INCREMENT_SEQ_NUM);
                    incrementStatement.setString(1, null);
                    incrementStatement.setString(2, viewPhysicalTable.getSchemaName().getString());
                    incrementStatement.setString(3, viewPhysicalTable.getTableName().getString());
                    incrementStatement.setLong(4, viewPhysicalTable.getSequenceNumber() + 1L);
                    incrementStatement.execute();
                }
                if (this.connection.getMutationState().toMutations(timestamp).hasNext()) {
                    tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timestamp).next().getSecond());
                    this.connection.rollback();
                }
            }
            short nextKeySeq = 0;
            ArrayList columnMetadata = Lists.newArrayListWithExpectedSize((int)columns.size());
            try (PreparedStatement colUpsert = this.connection.prepareStatement(INSERT_COLUMN_CREATE_TABLE);){
                for (Map.Entry entry : columns.entrySet()) {
                    Short s;
                    PColumn column3 = (PColumn)entry.getValue();
                    final int columnPosition = column3.getPosition();
                    if (parent != null && parent.getAutoPartitionSeqName() != null && parent.getPKColumns().get(MetaDataUtil.getAutoPartitionColIndex(parent)).equals(column3)) {
                        column3 = new DelegateColumn(column3){

                            @Override
                            public byte[] getViewConstant() {
                                return QueryConstants.EMPTY_COLUMN_VALUE_BYTES;
                            }

                            @Override
                            public boolean isViewReferenced() {
                                return true;
                            }
                        };
                        entry.setValue((DelegateColumn)column3);
                    } else if (isViewColumnReferenced != null) {
                        if (viewColumnConstants != null && columnPosition < viewColumnConstants.length) {
                            column3 = new DelegateColumn(column3){

                                @Override
                                public byte[] getViewConstant() {
                                    return viewColumnConstants[columnPosition];
                                }

                                @Override
                                public boolean isViewReferenced() {
                                    return isViewColumnReferenced.get(columnPosition);
                                }
                            };
                            entry.setValue((DelegateColumn)column3);
                        } else {
                            column3 = new DelegateColumn(column3){

                                @Override
                                public boolean isViewReferenced() {
                                    return isViewColumnReferenced.get(columnPosition);
                                }
                            };
                            entry.setValue((DelegateColumn)column3);
                        }
                    }
                    if (SchemaUtil.isPKColumn(column3)) {
                        nextKeySeq = (short)(nextKeySeq + 1);
                        s = nextKeySeq;
                    } else {
                        s = null;
                    }
                    Short keySeq = s;
                    this.addColumnMutation(schemaName, tableName, column3, colUpsert, parentTableName, pkName, keySeq, saltBucketNum != null);
                    columnMetadata.addAll((Collection)this.connection.getMutationState().toMutations(timestamp).next().getSecond());
                    this.connection.rollback();
                }
            }
            Collections.reverse(columnMetadata);
            tableMetaData.addAll(columnMetadata);
            String dataTableName = parent == null || tableType == PTableType.VIEW ? null : parent.getTableName().getString();
            PIndexState indexState = parent == null || tableType == PTableType.VIEW ? null : PIndexState.BUILDING;
            PreparedStatement tableUpsert = this.connection.prepareStatement(CREATE_TABLE);
            tableUpsert.setString(1, tenantIdStr);
            tableUpsert.setString(2, schemaName);
            tableUpsert.setString(3, tableName);
            tableUpsert.setString(4, tableType.getSerializedValue());
            tableUpsert.setLong(5, 0L);
            tableUpsert.setInt(6, position);
            if (saltBucketNum != null) {
                tableUpsert.setInt(7, saltBucketNum);
            } else {
                tableUpsert.setNull(7, 4);
            }
            tableUpsert.setString(8, pkName);
            tableUpsert.setString(9, dataTableName);
            tableUpsert.setString(10, indexState == null ? null : indexState.getSerializedValue());
            tableUpsert.setBoolean(11, isImmutableRows);
            tableUpsert.setString(12, defaultFamilyName);
            if (parent != null && parent.getAutoPartitionSeqName() != null && viewStatement == null) {
                tableUpsert.setString(13, "x");
            } else {
                tableUpsert.setString(13, viewStatement);
            }
            tableUpsert.setBoolean(14, disableWAL);
            tableUpsert.setBoolean(15, multiTenant);
            if (viewType == null) {
                tableUpsert.setNull(16, -6);
            } else {
                tableUpsert.setByte(16, viewType.getSerializedValue());
            }
            if (indexType == null) {
                tableUpsert.setNull(17, -6);
            } else {
                tableUpsert.setByte(17, indexType.getSerializedValue());
            }
            tableUpsert.setBoolean(18, storeNulls);
            if (parent != null && tableType == PTableType.VIEW) {
                tableUpsert.setInt(19, parent.getColumns().size());
            } else {
                tableUpsert.setInt(19, -1);
            }
            tableUpsert.setBoolean(20, transactional);
            tableUpsert.setLong(21, updateCacheFrequency);
            tableUpsert.setBoolean(22, isNamespaceMapped);
            if (autoPartitionSeq == null) {
                tableUpsert.setNull(23, 12);
            } else {
                tableUpsert.setString(23, autoPartitionSeq);
            }
            tableUpsert.setBoolean(24, isAppendOnlySchema);
            if (guidePostsWidth == null) {
                tableUpsert.setNull(25, -5);
            } else {
                tableUpsert.setLong(25, guidePostsWidth);
            }
            tableUpsert.setByte(26, immutableStorageScheme.getSerializedMetadataValue());
            tableUpsert.setByte(27, encodingScheme.getSerializedMetadataValue());
            tableUpsert.setBoolean(28, useStatsForParallelization);
            tableUpsert.execute();
            if (asyncCreatedDate != null) {
                PreparedStatement preparedStatement = this.connection.prepareStatement(SET_ASYNC_CREATED_DATE);
                preparedStatement.setString(1, tenantIdStr);
                preparedStatement.setString(2, schemaName);
                preparedStatement.setString(3, tableName);
                preparedStatement.setDate(4, asyncCreatedDate);
                preparedStatement.execute();
            }
            tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timestamp).next().getSecond());
            this.connection.rollback();
            Collections.reverse(tableMetaData);
            if (indexType != PTable.IndexType.LOCAL) {
                splits = SchemaUtil.processSplits(splits, pkColumns, saltBucketNum, this.connection.getQueryServices().getProps().getBoolean("phoenix.query.force.rowkeyorder", false));
            }
            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = this.connection.getQueryServices().createTable(tableMetaData, viewType == PTable.ViewType.MAPPED || allocateIndexId ? ((PName)physicalNames.get(0)).getBytes() : null, tableType, tableProps, familyPropList, splits, isNamespaceMapped, allocateIndexId);
            MetaDataProtocol.MutationCode code = metaDataMutationResult.getMutationCode();
            switch (code) {
                case TABLE_ALREADY_EXISTS: {
                    if (metaDataMutationResult.getTable() != null) {
                        this.addTableToCache(metaDataMutationResult);
                    }
                    if (!statement.ifNotExists()) {
                        throw new TableAlreadyExistsException(schemaName, tableName, metaDataMutationResult.getTable());
                    }
                    PTable columnPosition = null;
                    return columnPosition;
                }
                case PARENT_TABLE_NOT_FOUND: {
                    throw new TableNotFoundException(schemaName, parent.getName().getString());
                }
                case NEWER_TABLE_FOUND: {
                    if (!statement.ifNotExists()) {
                        throw new NewerTableAlreadyExistsException(schemaName, tableName, metaDataMutationResult.getTable());
                    }
                }
                case UNALLOWED_TABLE_MUTATION: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                case CONCURRENT_TABLE_MUTATION: {
                    this.addTableToCache(metaDataMutationResult);
                    throw new ConcurrentTableMutationException(schemaName, tableName);
                }
                case AUTO_PARTITION_SEQUENCE_NOT_FOUND: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.AUTO_PARTITION_SEQUENCE_UNDEFINED).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                case CANNOT_COERCE_AUTO_PARTITION_ID: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_COERCE_AUTO_PARTITION_ID).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                case TOO_MANY_INDEXES: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.TOO_MANY_INDEXES).setSchemaName(SchemaUtil.getSchemaNameFromFullName(parent.getPhysicalName().getString())).setTableName(SchemaUtil.getTableNameFromFullName(parent.getPhysicalName().getString())).build().buildException();
                }
                case UNALLOWED_LOCAL_INDEXES: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNALLOWED_LOCAL_INDEXES).setTableName(tableName).build().buildException();
                }
            }
            if (parent != null && parent.getAutoPartitionSeqName() != null) {
                final PColumn autoPartitionCol = parent.getPKColumns().get(MetaDataUtil.getAutoPartitionColIndex(parent));
                final Long autoPartitionNum = metaDataMutationResult.getAutoPartitionNum();
                columns.put(autoPartitionCol, new DelegateColumn(autoPartitionCol){

                    @Override
                    public byte[] getViewConstant() {
                        PDataType dataType = autoPartitionCol.getDataType();
                        Object val = dataType.toObject(autoPartitionNum, (PDataType)PLong.INSTANCE);
                        byte[] bytes = new byte[dataType.getByteSize() + 1];
                        dataType.toBytes(val, bytes, 0);
                        return bytes;
                    }

                    @Override
                    public boolean isViewReferenced() {
                        return true;
                    }
                });
                String viewPartitionClause = QueryUtil.getViewPartitionClause(MetaDataUtil.getAutoPartitionColumnName(parent), autoPartitionNum);
                viewStatement = viewStatement != null ? viewStatement + " AND " + viewPartitionClause : QueryUtil.getViewStatement(parent.getSchemaName().getString(), parent.getTableName().getString(), viewPartitionClause);
            }
            PName newSchemaName = PNameFactory.newName(schemaName);
            PTable.EncodedCQCounter cqCounterToBe = tableType == PTableType.VIEW ? PTable.EncodedCQCounter.NULL_COUNTER : cqCounter;
            PTableImpl table = PTableImpl.makePTable(tenantId, newSchemaName, PNameFactory.newName(tableName), tableType, indexState, timestamp != null ? timestamp.longValue() : metaDataMutationResult.getMutationTime(), 0L, pkName == null ? null : PNameFactory.newName(pkName), saltBucketNum, columns.values(), parent == null ? null : parent.getSchemaName(), parent == null ? null : parent.getTableName(), Collections.emptyList(), isImmutableRows, physicalNames, defaultFamilyName == null ? null : PNameFactory.newName(defaultFamilyName), viewStatement, Boolean.TRUE.equals(disableWAL), multiTenant, storeNulls, viewType, metaDataMutationResult.getViewIndexId(), indexType, rowKeyOrderOptimizable, transactional, updateCacheFrequency, 0L, isNamespaceMapped, autoPartitionSeq, isAppendOnlySchema, immutableStorageScheme, encodingScheme, cqCounterToBe, useStatsForParallelization);
            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult2 = new MetaDataProtocol.MetaDataMutationResult(code, metaDataMutationResult.getMutationTime(), (PTable)table, true);
            this.addTableToCache(metaDataMutationResult2);
            PTableImpl pTableImpl = table;
            return pTableImpl;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private static boolean isPkColumn(PrimaryKeyConstraint pkConstraint, ColumnDef colDef, ColumnName columnDefName) {
        return colDef.isPK() || pkConstraint != null && pkConstraint.getColumnWithSortOrder(columnDefName) != null;
    }

    private static void throwIfInsufficientColumns(String schemaName, String tableName, Collection<PColumn> columns, boolean isSalted, boolean isMultiTenant) throws SQLException {
        PColumn tenantIdCol;
        if (!isMultiTenant) {
            return;
        }
        int nPKColumns = columns.size() - (isSalted ? 1 : 0);
        if (nPKColumns < 2) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INSUFFICIENT_MULTI_TENANT_COLUMNS).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
        Iterator<PColumn> iterator = columns.iterator();
        if (isSalted) {
            iterator.next();
        }
        if ((tenantIdCol = iterator.next()).isNullable()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INSUFFICIENT_MULTI_TENANT_COLUMNS).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
    }

    public MutationState dropTable(DropTableStatement statement) throws SQLException {
        String schemaName = this.connection.getSchema() != null && statement.getTableName().getSchemaName() == null ? this.connection.getSchema() : statement.getTableName().getSchemaName();
        String tableName = statement.getTableName().getTableName();
        return this.dropTable(schemaName, tableName, null, statement.getTableType(), statement.ifExists(), statement.cascade());
    }

    public MutationState dropFunction(DropFunctionStatement statement) throws SQLException {
        return this.dropFunction(statement.getFunctionName(), statement.ifExists());
    }

    public MutationState dropIndex(DropIndexStatement statement) throws SQLException {
        String schemaName = statement.getTableName().getSchemaName();
        String tableName = statement.getIndexName().getName();
        String parentTableName = statement.getTableName().getTableName();
        return this.dropTable(schemaName, tableName, parentTableName, PTableType.INDEX, statement.ifExists(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState dropFunction(String functionName, boolean ifExists) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            PName tenantId = this.connection.getTenantId();
            byte[] key = SchemaUtil.getFunctionKey(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes(), Bytes.toBytes((String)functionName));
            Long scn = this.connection.getSCN();
            long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
            try {
                PFunction function = this.connection.getMetaDataCache().getFunction(new PTableKey(tenantId, functionName));
                if (function.isTemporaryFunction()) {
                    this.connection.removeFunction(tenantId, functionName, clientTimeStamp);
                    MutationState mutationState = new MutationState(0L, 0L, this.connection);
                    return mutationState;
                }
            }
            catch (FunctionNotFoundException function) {
                // empty catch block
            }
            ArrayList functionMetaData = Lists.newArrayListWithExpectedSize((int)2);
            Delete functionDelete = new Delete(key, clientTimeStamp);
            functionMetaData.add(functionDelete);
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().dropFunction(functionMetaData, ifExists);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            switch (code) {
                case FUNCTION_NOT_FOUND: {
                    if (ifExists) break;
                    throw new FunctionNotFoundException(functionName);
                }
                default: {
                    this.connection.removeFunction(tenantId, functionName, result.getMutationTime());
                }
            }
            MutationState mutationState = new MutationState(0L, 0L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private MutationState dropTable(String schemaName, String tableName, String parentTableName, PTableType tableType, boolean ifExists, boolean cascade) throws SQLException {
        block32: {
            fullTableName = SchemaUtil.getTableName(schemaName, tableName);
            try {
                ptable = this.connection.getTable(new PTableKey(this.connection.getTenantId(), fullTableName));
                if (parentTableName != null && !parentTableName.equals(ptable.getParentTableName().getString())) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PARENT_TABLE_NOT_FOUND).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
            }
            catch (TableNotFoundException e) {
                if (ifExists) break block32;
                throw e;
            }
        }
        this.connection.rollback();
        wasAutoCommit = this.connection.getAutoCommit();
        try {
            tenantId = this.connection.getTenantId();
            tenantIdStr = tenantId == null ? null : tenantId.getString();
            key = SchemaUtil.getTableKey(tenantIdStr, schemaName, tableName);
            scn = this.connection.getSCN();
            clientTimeStamp = scn == null ? 0x7FFFFFFFFFFFFFFFL : scn;
            tableMetaData = Lists.newArrayListWithExpectedSize((int)2);
            tableDelete = new Delete(key, clientTimeStamp);
            tableMetaData.add(tableDelete);
            hasViewIndexTable = false;
            if (parentTableName != null) {
                linkKey = MetaDataUtil.getParentLinkKey(tenantIdStr, schemaName, parentTableName, tableName);
                linkDelete = new Delete(linkKey, clientTimeStamp);
                tableMetaData.add(linkDelete);
            }
            result = this.connection.getQueryServices().dropTable(tableMetaData, tableType, cascade);
            code = result.getMutationCode();
            table = result.getTable();
            switch (9.$SwitchMap$org$apache$phoenix$coprocessor$MetaDataProtocol$MutationCode[code.ordinal()]) {
                case 13: {
                    if (ifExists) break;
                    throw new TableNotFoundException(schemaName, tableName);
                }
                case 5: {
                    throw new NewerTableAlreadyExistsException(schemaName, tableName, result.getTable());
                }
                case 6: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                default: {
                    this.connection.removeTable(tenantId, SchemaUtil.getTableName(schemaName, tableName), parentTableName, result.getMutationTime());
                    if (table == null) break;
                    dropMetaData = false;
                    ts = scn == null ? result.getMutationTime() : scn.longValue();
                    tableRefs = Lists.newArrayListWithExpectedSize((int)(2 + table.getIndexes().size()));
                    this.connection.setAutoCommit(true);
                    if (tableType != PTableType.VIEW) ** GOTO lbl53
                    for (PTable index : table.getIndexes()) {
                        tableRefs.add(new TableRef(null, index, ts, false));
                    }
                    ** GOTO lbl93
lbl53:
                    // 1 sources

                    v0 = dropMetaData = result.getTable().getViewIndexId() == null && this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true) != false;
                    if (parentTableName == null) {
                        hasViewIndexTable = true;
                        MetaDataUtil.deleteViewIndexSequences(this.connection, table.getPhysicalName(), table.isNamespaceMapped());
                        viewIndexPhysicalName = MetaDataUtil.getViewIndexPhysicalName(table.getPhysicalName().getBytes());
                        if (!dropMetaData) {
                            try {
                                admin = this.connection.getQueryServices().getAdmin();
                                var27_29 = null;
                                try {
                                    hasViewIndexTable = admin.tableExists(viewIndexPhysicalName);
                                }
                                catch (Throwable var28_31) {
                                    var27_29 = var28_31;
                                    throw var28_31;
                                }
                                finally {
                                    if (admin != null) {
                                        if (var27_29 != null) {
                                            try {
                                                admin.close();
                                            }
                                            catch (Throwable x2) {
                                                var27_29.addSuppressed(x2);
                                            }
                                        } else {
                                            admin.close();
                                        }
                                    }
                                }
                            }
                            catch (IOException admin) {
                                // empty catch block
                            }
                        }
                    }
                    if (tableType == PTableType.TABLE && (table.isMultiTenant() || hasViewIndexTable) && hasViewIndexTable) {
                        viewIndexPhysicalName = MetaDataUtil.getViewIndexPhysicalName(table.getPhysicalName().getBytes());
                        viewIndexTable = new PTableImpl(null, SchemaUtil.getSchemaNameFromFullName(viewIndexPhysicalName), SchemaUtil.getTableNameFromFullName(viewIndexPhysicalName), ts, table.getColumnFamilies(), table.isNamespaceMapped(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.useStatsForParallelization());
                        tableRefs.add(new TableRef(null, viewIndexTable, ts, false));
                    }
                    tableRefs.add(new TableRef(null, table, ts, false));
                    for (PTable index : table.getIndexes()) {
                        tableRefs.add(new TableRef(null, index, ts, false));
                    }
                    this.deleteFromStatsTable(tableRefs, ts);
lbl93:
                    // 2 sources

                    if (dropMetaData) break;
                    plan = new PostDDLCompiler(this.connection).compile(tableRefs, null, null, Collections.emptyList(), ts);
                    var26_27 = this.connection.getQueryServices().updateData(plan);
                    return var26_27;
                }
            }
            var21_23 = new MutationState(0L, 0L, this.connection);
            return var21_23;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFromStatsTable(List<TableRef> tableRefs, long ts) throws SQLException {
        boolean isAutoCommit = this.connection.getAutoCommit();
        try {
            this.connection.setAutoCommit(true);
            StringBuilder buf = new StringBuilder("DELETE FROM SYSTEM.STATS WHERE PHYSICAL_NAME IN (");
            for (TableRef ref : tableRefs) {
                buf.append("'" + ref.getTable().getPhysicalName().getString() + "',");
            }
            buf.setCharAt(buf.length() - 1, ')');
            if (tableRefs.get(0).getTable().getIndexType() == PTable.IndexType.LOCAL) {
                buf.append(" AND COLUMN_FAMILY IN(");
                if (tableRefs.get(0).getTable().getColumnFamilies().isEmpty()) {
                    buf.append("'L#0',");
                } else {
                    for (PColumnFamily cf : tableRefs.get(0).getTable().getColumnFamilies()) {
                        buf.append("'" + cf.getName().getString() + "',");
                    }
                }
                buf.setCharAt(buf.length() - 1, ')');
            }
            this.connection.createStatement().execute(buf.toString());
        }
        finally {
            this.connection.setAutoCommit(isAutoCommit);
        }
    }

    private MetaDataProtocol.MutationCode processMutationResult(String schemaName, String tableName, MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        MetaDataProtocol.MutationCode mutationCode = result.getMutationCode();
        PName tenantId = this.connection.getTenantId();
        switch (mutationCode) {
            case TABLE_NOT_FOUND: {
                this.connection.removeTable(tenantId, SchemaUtil.getTableName(schemaName, tableName), null, Long.MAX_VALUE);
                throw new TableNotFoundException(schemaName, tableName);
            }
            case UNALLOWED_TABLE_MUTATION: {
                String columnName = null;
                String familyName = null;
                String msg = null;
                if (result.getColumnName() != null) {
                    familyName = result.getFamilyName() == null ? null : Bytes.toString((byte[])result.getFamilyName());
                    columnName = Bytes.toString((byte[])result.getColumnName());
                    msg = "Cannot add/drop column referenced by VIEW";
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_TABLE).setSchemaName(schemaName).setTableName(tableName).setFamilyName(familyName).setColumnName(columnName).setMessage(msg).build().buildException();
            }
            case NO_OP: 
            case COLUMN_ALREADY_EXISTS: 
            case COLUMN_NOT_FOUND: {
                break;
            }
            case CONCURRENT_TABLE_MUTATION: {
                this.addTableToCache(result);
                if (logger.isDebugEnabled()) {
                    logger.debug(LogUtil.addCustomAnnotations("CONCURRENT_TABLE_MUTATION for table " + SchemaUtil.getTableName(schemaName, tableName), this.connection));
                }
                throw new ConcurrentTableMutationException(schemaName, tableName);
            }
            case NEWER_TABLE_FOUND: {
                throw new NewerTableAlreadyExistsException(schemaName, tableName, result.getTable());
            }
            case NO_PK_COLUMNS: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_MISSING).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            case TABLE_ALREADY_EXISTS: {
                break;
            }
            default: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNEXPECTED_MUTATION_CODE).setSchemaName(schemaName).setTableName(tableName).setMessage("mutation code: " + (Object)((Object)mutationCode)).build().buildException();
            }
        }
        return mutationCode;
    }

    private long incrementTableSeqNum(PTable table, PTableType expectedType, int columnCountDelta, Boolean isTransactional, Long updateCacheFrequency) throws SQLException {
        return this.incrementTableSeqNum(table, expectedType, columnCountDelta, isTransactional, updateCacheFrequency, null, null, null, null, -1L, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrementTableSeqNum(PTable table, PTableType expectedType, int columnCountDelta, Boolean isTransactional, Long updateCacheFrequency, Boolean isImmutableRows, Boolean disableWAL, Boolean isMultiTenant, Boolean storeNulls, Long guidePostWidth, Boolean appendOnlySchema, PTable.ImmutableStorageScheme immutableStorageScheme, Boolean useStatsForParallelization) throws SQLException {
        String schemaName = table.getSchemaName().getString();
        String tableName = table.getTableName().getString();
        int totalColumnCount = table.getColumns().size() + (table.getBucketNum() == null ? 0 : -1);
        long seqNum = table.getSequenceNumber() + 1L;
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        try (PreparedStatement tableUpsert = this.connection.prepareStatement(MUTATE_TABLE);){
            tableUpsert.setString(1, tenantId);
            tableUpsert.setString(2, schemaName);
            tableUpsert.setString(3, tableName);
            tableUpsert.setString(4, expectedType.getSerializedValue());
            tableUpsert.setLong(5, seqNum);
            tableUpsert.setInt(6, totalColumnCount + columnCountDelta);
            tableUpsert.execute();
        }
        if (isImmutableRows != null) {
            this.mutateBooleanProperty(tenantId, schemaName, tableName, "IMMUTABLE_ROWS", isImmutableRows);
        }
        if (disableWAL != null) {
            this.mutateBooleanProperty(tenantId, schemaName, tableName, "DISABLE_WAL", disableWAL);
        }
        if (isMultiTenant != null) {
            this.mutateBooleanProperty(tenantId, schemaName, tableName, "MULTI_TENANT", isMultiTenant);
        }
        if (storeNulls != null) {
            this.mutateBooleanProperty(tenantId, schemaName, tableName, "STORE_NULLS", storeNulls);
        }
        if (isTransactional != null) {
            this.mutateBooleanProperty(tenantId, schemaName, tableName, "TRANSACTIONAL", isTransactional);
        }
        if (updateCacheFrequency != null) {
            this.mutateLongProperty(tenantId, schemaName, tableName, "UPDATE_CACHE_FREQUENCY", updateCacheFrequency);
        }
        if (guidePostWidth == null || guidePostWidth >= 0L) {
            this.mutateLongProperty(tenantId, schemaName, tableName, "GUIDE_POSTS_WIDTH", guidePostWidth);
        }
        if (appendOnlySchema != null) {
            this.mutateBooleanProperty(tenantId, schemaName, tableName, "APPEND_ONLY_SCHEMA", appendOnlySchema);
        }
        if (immutableStorageScheme != null) {
            this.mutateStringProperty(tenantId, schemaName, tableName, "IMMUTABLE_STORAGE_SCHEME", immutableStorageScheme.name());
        }
        if (useStatsForParallelization != null) {
            this.mutateBooleanProperty(tenantId, schemaName, tableName, "USE_STATS_FOR_PARALLELIZATION", useStatsForParallelization);
        }
        return seqNum;
    }

    private void mutateBooleanProperty(String tenantId, String schemaName, String tableName, String propertyName, boolean propertyValue) throws SQLException {
        String updatePropertySql = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME," + propertyName + ") VALUES (?, ?, ?, ?)";
        try (PreparedStatement tableBoolUpsert = this.connection.prepareStatement(updatePropertySql);){
            tableBoolUpsert.setString(1, tenantId);
            tableBoolUpsert.setString(2, schemaName);
            tableBoolUpsert.setString(3, tableName);
            tableBoolUpsert.setBoolean(4, propertyValue);
            tableBoolUpsert.execute();
        }
    }

    private void mutateLongProperty(String tenantId, String schemaName, String tableName, String propertyName, Long propertyValue) throws SQLException {
        String updatePropertySql = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME," + propertyName + ") VALUES (?, ?, ?, ?)";
        try (PreparedStatement tableBoolUpsert = this.connection.prepareStatement(updatePropertySql);){
            tableBoolUpsert.setString(1, tenantId);
            tableBoolUpsert.setString(2, schemaName);
            tableBoolUpsert.setString(3, tableName);
            if (propertyValue == null) {
                tableBoolUpsert.setNull(4, -5);
            } else {
                tableBoolUpsert.setLong(4, propertyValue);
            }
            tableBoolUpsert.execute();
        }
    }

    private void mutateStringProperty(String tenantId, String schemaName, String tableName, String propertyName, String propertyValue) throws SQLException {
        String updatePropertySql = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME," + propertyName + ") VALUES (?, ?, ?, ?)";
        try (PreparedStatement tableBoolUpsert = this.connection.prepareStatement(updatePropertySql);){
            tableBoolUpsert.setString(1, tenantId);
            tableBoolUpsert.setString(2, schemaName);
            tableBoolUpsert.setString(3, tableName);
            tableBoolUpsert.setString(4, propertyValue);
            tableBoolUpsert.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState modifyColumn(ModifyColumnStatement statement) throws SQLException {
        PTable table = FromCompiler.getResolver(statement, this.connection).getTables().get(0).getTable();
        ColumnDef columnDef = statement.getColumnDef();
        ColumnName columnName = columnDef.getColumnDefName();
        if (table.getType() != PTableType.TABLE && table.getType() != PTableType.VIEW) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.DISALLOW_MODIFY_TABLE_TYPE).build().buildException();
        }
        PColumn oldColumn = null;
        for (PColumn column : table.getColumns()) {
            if (column.getFamilyName() == null) {
                if (!column.getName().getString().equals(columnName.getColumnName())) continue;
                oldColumn = column;
                continue;
            }
            if (!column.getName().getString().equals(columnName.getColumnName()) || (columnName.getFamilyName() == null || !column.getFamilyName().getString().equals(columnName.getFamilyName())) && (columnName.getFamilyName() != null || !column.getFamilyName().getString().equals("0"))) continue;
            oldColumn = column;
            break;
        }
        if (oldColumn == null) {
            throw new ColumnNotFoundException(table.getSchemaName().getString(), table.getTableName().getString(), columnName.getFamilyName(), columnName.getColumnName());
        }
        if (oldColumn.isRowTimestamp() || SchemaUtil.isPKColumn(oldColumn)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.DISALLOW_MODIFY_TIMESTAMP_OR_PK_COLUMN).build().buildException();
        }
        if (oldColumn.getDataType().getSqlType() == columnDef.getDataType().getSqlType() && (oldColumn.getMaxLength() > 0 && oldColumn.getMaxLength() == columnDef.getMaxLength() || oldColumn.getScale() != null && oldColumn.getScale() == columnDef.getScale())) {
            logger.info("Column's properties will not be changed, because new properties are same with old properties! ");
            return new MutationState(0L, 0L, this.connection);
        }
        if (!oldColumn.getDataType().isCastableTo(columnDef.getDataType())) {
            throw new DataTypeCastException(columnDef.getDataType().getSqlTypeName(), oldColumn.getDataType().getSqlTypeName());
        }
        ArrayList tableMetaData = Lists.newArrayListWithExpectedSize((int)1);
        Long timestamp = TransactionUtil.getTableTimestamp(this.connection, table.isTransactional());
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            this.connection.setAutoCommit(false);
            String tenantIdStr = this.connection.getTenantId() == null ? (table.getTenantId() == null ? null : table.getTenantId().getString()) : this.connection.getTenantId().getString();
            try (PreparedStatement colUpsert = this.connection.prepareStatement(MODIFY_COLUMN_ALTER_TABLE);){
                colUpsert.setString(1, tenantIdStr);
                colUpsert.setString(2, table.getSchemaName().getString());
                colUpsert.setString(3, table.getTableName().getString());
                colUpsert.setString(4, columnName.getColumnName());
                if (!SchemaUtil.isPKColumn(oldColumn) && oldColumn.getFamilyName() != null) {
                    colUpsert.setString(5, oldColumn.getFamilyName().getString());
                } else {
                    colUpsert.setString(5, null);
                }
                colUpsert.setInt(6, columnDef.getDataType().getSqlType());
                if (columnDef.getMaxLength() == null) {
                    colUpsert.setNull(7, 4);
                } else {
                    colUpsert.setInt(7, columnDef.getMaxLength());
                }
                if (columnDef.getScale() == null) {
                    colUpsert.setNull(8, 4);
                } else {
                    colUpsert.setInt(8, columnDef.getScale());
                }
                colUpsert.execute();
            }
            tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(null).next().getSecond());
            this.connection.rollback();
            long seqNum = table.getSequenceNumber() + 1L;
            int totalColumnCount = table.getColumns().size() + (table.getBucketNum() == null ? 0 : -1);
            try (PreparedStatement tableUpsert = this.connection.prepareStatement(MUTATE_TABLE);){
                tableUpsert.setString(1, tenantIdStr);
                tableUpsert.setString(2, table.getSchemaName().getString());
                tableUpsert.setString(3, table.getTableName().getString());
                tableUpsert.setString(4, table.getType().getSerializedValue());
                tableUpsert.setLong(5, seqNum);
                tableUpsert.setInt(6, totalColumnCount);
                tableUpsert.execute();
            }
            tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timestamp).next().getSecond());
            this.connection.rollback();
            Collections.reverse(tableMetaData);
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().modifyColumn(tableMetaData, table);
            if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                logger.info(oldColumn.getName().getString() + " is modified successfully!");
                this.addTableToCache(result);
                if (result.getMutatedTableNames() != null) {
                    long resolvedTime = TransactionUtil.getResolvedTime(this.connection, result);
                    for (byte[] name : result.getMutatedTableNames()) {
                        String schema = SchemaUtil.getSchemaNameFromFullName(name);
                        String tableName = SchemaUtil.getTableNameFromFullName(name);
                        this.connection.removeTable(this.connection.getTenantId(), SchemaUtil.getTableName(schema, tableName), null, resolvedTime);
                    }
                }
            }
            MutationState mutationState = new MutationState(0L, 0L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    public MutationState addColumn(AddColumnStatement statement) throws SQLException {
        PTable table = FromCompiler.getResolver(statement, this.connection).getTables().get(0).getTable();
        return this.addColumn(table, statement.getColumnDefs(), statement.getProps(), statement.ifNotExists(), false, statement.getTable(), statement.getTableType());
    }

    /*
     * WARNING - void declaration
     */
    public MutationState addColumn(PTable table, List<ColumnDef> origColumnDefs, ListMultimap<String, Pair<String, Object>> stmtProperties, boolean ifNotExists, boolean removeTableProps, NamedTableNode namedTableNode, PTableType tableType) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            this.connection.setAutoCommit(false);
            PName tenantId = this.connection.getTenantId();
            String schemaName = table.getSchemaName().getString();
            String tableName = table.getTableName().getString();
            Boolean isImmutableRowsProp = null;
            Boolean multiTenantProp = null;
            Boolean disableWALProp = null;
            Boolean storeNullsProp = null;
            Boolean isTransactionalProp = null;
            Long updateCacheFrequencyProp = null;
            Boolean appendOnlySchemaProp = null;
            Long guidePostWidth = -1L;
            PTable.ImmutableStorageScheme immutableStorageSchemeProp = null;
            Boolean useStatsForParallelizationProp = null;
            HashMap<String, List<Pair<String, Object>>> properties = new HashMap<String, List<Pair<String, Object>>>(stmtProperties.size());
            List<Object> columnDefs = null;
            if (table.isAppendOnlySchema()) {
                columnDefs = Lists.newArrayList();
                for (ColumnDef columnDef : origColumnDefs) {
                    String familyName = columnDef.getColumnDefName().getFamilyName();
                    String columnName = columnDef.getColumnDefName().getColumnName();
                    if (familyName != null) {
                        try {
                            PColumnFamily columnFamily = table.getColumnFamily(familyName);
                            columnFamily.getPColumnForColumnName(columnName);
                            if (ifNotExists) continue;
                            throw new ColumnAlreadyExistsException(schemaName, tableName, columnName);
                        }
                        catch (ColumnFamilyNotFoundException | ColumnNotFoundException e) {
                            columnDefs.add(columnDef);
                            continue;
                        }
                    }
                    try {
                        table.getColumnForColumnName(columnName);
                        if (ifNotExists) continue;
                        throw new ColumnAlreadyExistsException(schemaName, tableName, columnName);
                    }
                    catch (ColumnNotFoundException e) {
                        columnDefs.add(columnDef);
                    }
                }
            } else {
                columnDefs = origColumnDefs == null ? Collections.emptyList() : origColumnDefs;
            }
            for (String family : stmtProperties.keySet()) {
                List origPropsList = stmtProperties.get((Object)family);
                ArrayList propsList = Lists.newArrayListWithExpectedSize((int)origPropsList.size());
                for (Pair prop : origPropsList) {
                    String propName = (String)prop.getFirst();
                    if (TableProperty.isPhoenixTableProperty(propName)) {
                        TableProperty tableProp = TableProperty.valueOf(propName);
                        tableProp.validate(true, !family.equals(""), table.getType());
                        Object value = tableProp.getValue(prop.getSecond());
                        if (propName.equals("IMMUTABLE_ROWS")) {
                            isImmutableRowsProp = (Boolean)value;
                        } else if (propName.equals("MULTI_TENANT")) {
                            multiTenantProp = (Boolean)value;
                        } else if (propName.equals("DISABLE_WAL")) {
                            disableWALProp = (Boolean)value;
                        } else if (propName.equals("STORE_NULLS")) {
                            storeNullsProp = (Boolean)value;
                        } else if (propName.equals("TRANSACTIONAL")) {
                            isTransactionalProp = (Boolean)value;
                        } else if (propName.equals("UPDATE_CACHE_FREQUENCY")) {
                            updateCacheFrequencyProp = (Long)value;
                        } else if (propName.equals("GUIDE_POSTS_WIDTH")) {
                            guidePostWidth = (Long)value;
                        } else if (propName.equals("APPEND_ONLY_SCHEMA")) {
                            appendOnlySchemaProp = (Boolean)value;
                        } else if (propName.equalsIgnoreCase("IMMUTABLE_STORAGE_SCHEME")) {
                            immutableStorageSchemeProp = (PTable.ImmutableStorageScheme)value;
                        } else if (propName.equalsIgnoreCase("USE_STATS_FOR_PARALLELIZATION")) {
                            useStatsForParallelizationProp = (Boolean)value;
                        }
                    }
                    if (removeTableProps && (TableProperty.isPhoenixTableProperty(propName) || MetaDataUtil.isHTableProperty(propName))) continue;
                    propsList.add(prop);
                }
                properties.put(family, propsList);
            }
            boolean retried = false;
            boolean changingPhoenixTableProperty = false;
            boolean nonTxToTx = false;
            while (true) {
                MetaDataProtocol.MetaDataMutationResult result;
                byte[] projectCF;
                byte[] emptyCF;
                int numPkColumnsAdded;
                Long updateCacheFrequency;
                Boolean multiTenant;
                block113: {
                    String tenantIdToUse;
                    int numCols;
                    ColumnResolver resolver = FromCompiler.getResolver(namedTableNode, this.connection);
                    table = resolver.getTables().get(0).getTable();
                    int nIndexes = table.getIndexes().size();
                    int nNewColumns = numCols = columnDefs.size();
                    ArrayList tableMetaData = Lists.newArrayListWithExpectedSize((int)((1 + nNewColumns) * (nIndexes + 1)));
                    ArrayList columnMetaData = Lists.newArrayListWithExpectedSize((int)(nNewColumns * (nIndexes + 1)));
                    if (logger.isDebugEnabled()) {
                        logger.debug(LogUtil.addCustomAnnotations("Resolved table to " + table.getName().getString() + " with seqNum " + table.getSequenceNumber() + " at timestamp " + table.getTimeStamp() + " with " + table.getColumns().size() + " columns: " + table.getColumns(), this.connection));
                    }
                    int position = table.getColumns().size();
                    List<PColumn> currentPKs = table.getPKColumns();
                    PColumn lastPK = currentPKs.get(currentPKs.size() - 1);
                    if (lastPK.getDataType() == PVarbinary.INSTANCE || lastPK.getDataType().isArrayType()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.VARBINARY_LAST_PK).setColumnName(lastPK.getName().getString()).build().buildException();
                    }
                    if (lastPK.isNullable() && lastPK.getDataType().isFixedWidth()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.NULLABLE_FIXED_WIDTH_LAST_PK).setColumnName(lastPK.getName().getString()).build().buildException();
                    }
                    Boolean isImmutableRows = null;
                    if (isImmutableRowsProp != null && isImmutableRowsProp.booleanValue() != table.isImmutableRows()) {
                        if (table.getImmutableStorageScheme() != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_IMMUTABLE_ROWS_PROPERTY).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                        isImmutableRows = isImmutableRowsProp;
                        changingPhoenixTableProperty = true;
                    }
                    multiTenant = null;
                    if (multiTenantProp != null && multiTenantProp.booleanValue() != table.isMultiTenant()) {
                        multiTenant = multiTenantProp;
                        changingPhoenixTableProperty = true;
                    }
                    Boolean disableWAL = null;
                    if (disableWALProp != null && disableWALProp.booleanValue() != table.isWALDisabled()) {
                        disableWAL = disableWALProp;
                        changingPhoenixTableProperty = true;
                    }
                    updateCacheFrequency = null;
                    if (updateCacheFrequencyProp != null && updateCacheFrequencyProp.longValue() != table.getUpdateCacheFrequency()) {
                        updateCacheFrequency = updateCacheFrequencyProp;
                        changingPhoenixTableProperty = true;
                    }
                    Boolean appendOnlySchema = null;
                    if (appendOnlySchemaProp != null && appendOnlySchemaProp.booleanValue() != table.isAppendOnlySchema()) {
                        appendOnlySchema = appendOnlySchemaProp;
                        changingPhoenixTableProperty = true;
                    }
                    PTable.ImmutableStorageScheme immutableStorageScheme = null;
                    if (immutableStorageSchemeProp != null) {
                        if (table.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN || immutableStorageSchemeProp == PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_IMMUTABLE_STORAGE_SCHEME_CHANGE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                        if (immutableStorageSchemeProp != table.getImmutableStorageScheme()) {
                            immutableStorageScheme = immutableStorageSchemeProp;
                            changingPhoenixTableProperty = true;
                        }
                    }
                    if (guidePostWidth == null || guidePostWidth >= 0L) {
                        changingPhoenixTableProperty = true;
                    }
                    Boolean storeNulls = null;
                    if (storeNullsProp != null && storeNullsProp.booleanValue() != table.getStoreNulls()) {
                        storeNulls = storeNullsProp;
                        changingPhoenixTableProperty = true;
                    }
                    Boolean useStatsForParallelization = null;
                    if (useStatsForParallelizationProp != null && useStatsForParallelizationProp.booleanValue() != table.useStatsForParallelization()) {
                        useStatsForParallelization = useStatsForParallelizationProp;
                        changingPhoenixTableProperty = true;
                    }
                    Boolean isTransactional = null;
                    if (isTransactionalProp != null && isTransactionalProp.booleanValue() != table.isTransactional()) {
                        isTransactional = isTransactionalProp;
                        if (!isTransactional.booleanValue()) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MAY_NOT_SWITCH_TO_NON_TX).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                        boolean transactionsEnabled = this.connection.getQueryServices().getProps().getBoolean("phoenix.transactions.enabled", false);
                        if (!transactionsEnabled) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_TO_BE_TXN_IF_TXNS_DISABLED).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                        if (SchemaUtil.hasRowTimestampColumn(table)) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_TO_BE_TXN_WITH_ROW_TIMESTAMP).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                        changingPhoenixTableProperty = true;
                        nonTxToTx = true;
                    }
                    Long timeStamp = TransactionUtil.getTableTimestamp(this.connection, table.isTransactional() || nonTxToTx);
                    numPkColumnsAdded = 0;
                    ArrayList columns = Lists.newArrayListWithExpectedSize((int)numCols);
                    LinkedHashSet<String> colFamiliesForPColumnsToBeAdded = new LinkedHashSet<String>();
                    LinkedHashSet<String> families = new LinkedHashSet<String>();
                    PTable tableForCQCounters = tableType == PTableType.VIEW ? PhoenixRuntime.getTable(this.connection, table.getPhysicalName().getString()) : table;
                    PTable.EncodedCQCounter cqCounterToUse = tableForCQCounters.getEncodedCQCounter();
                    HashMap<String, Integer> changedCqCounters = new HashMap<String, Integer>(numCols);
                    if (numCols > 0) {
                        StatementContext context = new StatementContext(new PhoenixStatement(this.connection), resolver);
                        String addColumnSqlToUse = this.connection.isRunningUpgrade() && tableName.equals("CATALOG") && schemaName.equals("SYSTEM") ? ALTER_SYSCATALOG_TABLE_UPGRADE : INSERT_COLUMN_ALTER_TABLE;
                        try (PreparedStatement colUpsert = this.connection.prepareStatement(addColumnSqlToUse);){
                            short nextKeySeq = SchemaUtil.getMaxKeySeq(table);
                            for (ColumnDef columnDef : columnDefs) {
                                void var59_80;
                                if (columnDef != null && !columnDef.isNull()) {
                                    if (columnDef.isPK()) {
                                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.NOT_NULLABLE_COLUMN_IN_ROW_KEY).setColumnName(columnDef.getColumnDefName().getColumnName()).build().buildException();
                                    }
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ADD_NOT_NULLABLE_COLUMN).setColumnName(columnDef.getColumnDefName().getColumnName()).build().buildException();
                                }
                                if (columnDef != null && columnDef.isPK() && table.getType() == PTableType.VIEW && table.getViewType() != PTable.ViewType.MAPPED) {
                                    this.throwIfLastPKOfParentIsFixedLength(this.getParentOfView(table), schemaName, tableName, columnDef);
                                }
                                if (columnDef != null && columnDef.isRowTimestamp()) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_CREATE_ONLY).setColumnName(columnDef.getColumnDefName().getColumnName()).build().buildException();
                                }
                                if (!columnDef.validateDefault(context, null)) {
                                    ColumnDef columnDef2 = new ColumnDef(columnDef, null);
                                }
                                Integer encodedCQ = null;
                                if (!var59_80.isPK()) {
                                    String defaultColumnFamily;
                                    String colDefFamily = var59_80.getColumnDefName().getFamilyName();
                                    String familyName = null;
                                    PTable.ImmutableStorageScheme storageScheme = table.getImmutableStorageScheme();
                                    String string = defaultColumnFamily = tableForCQCounters.getDefaultFamilyName() != null && !Strings.isNullOrEmpty((String)tableForCQCounters.getDefaultFamilyName().getString()) ? tableForCQCounters.getDefaultFamilyName().getString() : "0";
                                    if (table.getType() == PTableType.INDEX && table.getIndexType() == PTable.IndexType.LOCAL) {
                                        defaultColumnFamily = "L#" + defaultColumnFamily;
                                    }
                                    familyName = storageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS ? (colDefFamily != null ? colDefFamily : defaultColumnFamily) : defaultColumnFamily;
                                    encodedCQ = cqCounterToUse.getNextQualifier(familyName);
                                    if (cqCounterToUse.increment(familyName)) {
                                        changedCqCounters.put(familyName, cqCounterToUse.getNextQualifier(familyName));
                                    }
                                }
                                byte[] columnQualifierBytes = null;
                                try {
                                    columnQualifierBytes = EncodedColumnsUtil.getColumnQualifierBytes(var59_80.getColumnDefName().getColumnName(), encodedCQ, table, var59_80.isPK());
                                }
                                catch (PTable.QualifierEncodingScheme.QualifierOutOfRangeException e) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.MAX_COLUMNS_EXCEEDED).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                                }
                                PColumn column = this.newColumn(position++, (ColumnDef)var59_80, PrimaryKeyConstraint.EMPTY, table.getDefaultFamilyName() == null ? null : table.getDefaultFamilyName().getString(), true, columnQualifierBytes);
                                columns.add(column);
                                String pkName = null;
                                Short keySeq = null;
                                if (column.getFamilyName() == null) {
                                    ++numPkColumnsAdded;
                                    pkName = table.getPKName() == null ? null : table.getPKName().getString();
                                    nextKeySeq = (short)(nextKeySeq + 1);
                                    keySeq = nextKeySeq;
                                } else {
                                    families.add(column.getFamilyName().getString());
                                }
                                colFamiliesForPColumnsToBeAdded.add(column.getFamilyName() == null ? null : column.getFamilyName().getString());
                                this.addColumnMutation(schemaName, tableName, column, colUpsert, null, pkName, keySeq, table.getBucketNum() != null);
                            }
                            if (numPkColumnsAdded > 0) {
                                void var59_82;
                                ArrayList pkColumns = Lists.newArrayListWithExpectedSize((int)(table.getPKColumns().size() + numPkColumnsAdded));
                                pkColumns.addAll(table.getPKColumns());
                                boolean bl = false;
                                while (var59_82 < numCols) {
                                    if (((ColumnDef)columnDefs.get((int)var59_82)).isPK()) {
                                        pkColumns.add(columns.get((int)var59_82));
                                    }
                                    ++var59_82;
                                }
                                int n = table.getPKColumns().size() - 1;
                                for (PTable index : table.getIndexes()) {
                                    short nextIndexKeySeq = SchemaUtil.getMaxKeySeq(index);
                                    int indexPosition = index.getColumns().size();
                                    for (int i = 0; i < numCols; ++i) {
                                        void var59_84;
                                        ColumnDef colDef = (ColumnDef)columnDefs.get(i);
                                        if (!colDef.isPK()) continue;
                                        PDataType indexColDataType = IndexUtil.getIndexColumnDataType(colDef.isNull(), colDef.getDataType());
                                        ColumnName indexColName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(null, colDef.getColumnDefName().getColumnName()));
                                        RowKeyColumnExpression expression = new RowKeyColumnExpression((PDatum)columns.get(i), new RowKeyValueAccessor(pkColumns, (int)(++var59_84)));
                                        ColumnDef indexColDef = FACTORY.columnDef(indexColName, indexColDataType.getSqlTypeName(), colDef.isNull(), colDef.getMaxLength(), colDef.getScale(), true, colDef.getSortOrder(), ((Object)expression).toString(), colDef.isRowTimestamp());
                                        PColumn indexColumn = this.newColumn(indexPosition++, indexColDef, PrimaryKeyConstraint.EMPTY, null, true, null);
                                        nextIndexKeySeq = (short)(nextIndexKeySeq + 1);
                                        this.addColumnMutation(schemaName, index.getTableName().getString(), indexColumn, colUpsert, index.getParentTableName().getString(), index.getPKName() == null ? null : index.getPKName().getString(), nextIndexKeySeq, index.getBucketNum() != null);
                                    }
                                }
                            }
                            columnMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                            this.connection.rollback();
                        }
                    }
                    if (Boolean.FALSE.equals(isImmutableRows) && !table.getIndexes().isEmpty()) {
                        int hbaseVersion = this.connection.getQueryServices().getLowestClusterHBaseVersion();
                        if (hbaseVersion < PhoenixDatabaseMetaData.MUTABLE_SI_VERSION_THRESHOLD) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_MUTABLE_INDEXES).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                        if (!this.connection.getQueryServices().hasIndexWALCodec() && !table.isTransactional()) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_MUTABLE_INDEX_CONFIG).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                        }
                    }
                    if (Boolean.TRUE.equals(multiTenant)) {
                        MetaDataClient.throwIfInsufficientColumns(schemaName, tableName, table.getPKColumns(), table.getBucketNum() != null, multiTenant);
                    }
                    if (!table.getIndexes().isEmpty() && (numPkColumnsAdded > 0 || nonTxToTx)) {
                        for (PTable index : table.getIndexes()) {
                            this.incrementTableSeqNum(index, index.getType(), numPkColumnsAdded, nonTxToTx ? Boolean.TRUE : null, updateCacheFrequency);
                        }
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                        this.connection.rollback();
                    }
                    if (changingPhoenixTableProperty || columnDefs.size() > 0) {
                        this.incrementTableSeqNum(table, tableType, columnDefs.size(), isTransactional, updateCacheFrequency, isImmutableRows, disableWAL, multiTenant, storeNulls, guidePostWidth, appendOnlySchema, immutableStorageScheme, useStatsForParallelization);
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                        this.connection.rollback();
                    }
                    Collections.reverse(tableMetaData);
                    tableMetaData.addAll(columnMetaData);
                    boolean sharedIndex = tableType == PTableType.INDEX && (table.getIndexType() == PTable.IndexType.LOCAL || table.getViewIndexId() != null);
                    String string = tenantIdToUse = this.connection.getTenantId() != null && sharedIndex ? this.connection.getTenantId().getString() : null;
                    if (!changedCqCounters.isEmpty()) {
                        PreparedStatement linkStatement = this.connection.prepareStatement(UPDATE_ENCODED_COLUMN_COUNTER);
                        for (Map.Entry entry : changedCqCounters.entrySet()) {
                            linkStatement.setString(1, tenantIdToUse);
                            linkStatement.setString(2, tableForCQCounters.getSchemaName().getString());
                            linkStatement.setString(3, tableForCQCounters.getTableName().getString());
                            linkStatement.setString(4, (String)entry.getKey());
                            linkStatement.setInt(5, (Integer)entry.getValue());
                            linkStatement.execute();
                        }
                        if (tableType == PTableType.VIEW) {
                            PreparedStatement incrementStatement = this.connection.prepareStatement(INCREMENT_SEQ_NUM);
                            incrementStatement.setString(1, null);
                            incrementStatement.setString(2, tableForCQCounters.getSchemaName().getString());
                            incrementStatement.setString(3, tableForCQCounters.getTableName().getString());
                            incrementStatement.setLong(4, tableForCQCounters.getSequenceNumber() + 1L);
                            incrementStatement.execute();
                        }
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                        this.connection.rollback();
                    }
                    byte[] family = families.size() > 0 ? ((String)families.iterator().next()).getBytes() : null;
                    emptyCF = null;
                    projectCF = null;
                    if (table.getType() != PTableType.VIEW && family != null) {
                        if (table.getColumnFamilies().isEmpty()) {
                            emptyCF = family;
                        } else {
                            try {
                                table.getColumnFamily(family);
                            }
                            catch (ColumnFamilyNotFoundException e) {
                                projectCF = family;
                                emptyCF = SchemaUtil.getEmptyColumnFamily(table);
                            }
                        }
                    }
                    result = this.connection.getQueryServices().addColumn(tableMetaData, table, properties, colFamiliesForPColumnsToBeAdded, columns);
                    try {
                        MetaDataProtocol.MutationCode mutationCode = this.processMutationResult(schemaName, tableName, result);
                        if (mutationCode != MetaDataProtocol.MutationCode.COLUMN_ALREADY_EXISTS) break block113;
                        this.addTableToCache(result);
                        if (!ifNotExists) {
                            throw new ColumnAlreadyExistsException(schemaName, tableName, SchemaUtil.findExistingColumn(result.getTable(), columns));
                        }
                        MutationState i$ = new MutationState(0L, 0L, this.connection);
                        return i$;
                    }
                    catch (ConcurrentTableMutationException concurrentTableMutationException) {
                        if (retried) {
                            throw concurrentTableMutationException;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug(LogUtil.addCustomAnnotations("Caught ConcurrentTableMutationException for table " + SchemaUtil.getTableName(schemaName, tableName) + ". Will try again...", this.connection));
                        }
                        retried = true;
                        continue;
                    }
                }
                String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
                long resolvedTimeStamp = TransactionUtil.getResolvedTime(this.connection, result);
                if (table.getIndexes().isEmpty() || numPkColumnsAdded == 0 && !nonTxToTx) {
                    this.connection.addTable(result.getTable(), resolvedTimeStamp);
                    table = result.getTable();
                } else if (updateCacheFrequency != null) {
                    this.connection.removeTable(tenantId, fullTableName, null, resolvedTimeStamp);
                }
                if (table.getType() == PTableType.TABLE && Boolean.FALSE.equals(multiTenant) && MetaDataUtil.hasViewIndexTable(this.connection, table.getPhysicalName())) {
                    this.connection.setAutoCommit(true);
                    MetaDataUtil.deleteViewIndexSequences(this.connection, table.getPhysicalName(), table.isNamespaceMapped());
                    if (!this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true)) {
                        Long scn = this.connection.getSCN();
                        long ts = scn == null ? result.getMutationTime() : scn.longValue();
                        byte[] viewIndexPhysicalName = MetaDataUtil.getViewIndexPhysicalName(table.getPhysicalName().getBytes());
                        PTableImpl viewIndexTable = new PTableImpl(null, SchemaUtil.getSchemaNameFromFullName(viewIndexPhysicalName), SchemaUtil.getTableNameFromFullName(viewIndexPhysicalName), ts, table.getColumnFamilies(), table.isNamespaceMapped(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.useStatsForParallelization());
                        List<TableRef> tableRefs = Collections.singletonList(new TableRef(null, viewIndexTable, ts, false));
                        MutationPlan plan = new PostDDLCompiler(this.connection).compile(tableRefs, null, null, Collections.emptyList(), ts);
                        this.connection.getQueryServices().updateData(plan);
                    }
                }
                if (emptyCF != null) {
                    Long scn = this.connection.getSCN();
                    this.connection.setAutoCommit(true);
                    long ts = scn == null ? result.getMutationTime() : scn.longValue();
                    MutationPlan plan = new PostDDLCompiler(this.connection).compile(Collections.singletonList(new TableRef(null, table, ts, false)), emptyCF, projectCF == null ? null : Collections.singletonList(projectCF), null, ts);
                    MutationState mutationState = this.connection.getQueryServices().updateData(plan);
                    return mutationState;
                }
                MutationState mutationState = new MutationState(0L, 0L, this.connection);
                return mutationState;
            }
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private String dropColumnMutations(PTable table, List<PColumn> columnsToDrop) throws SQLException {
        String tenantId = this.connection.getTenantId() == null ? "" : this.connection.getTenantId().getString();
        String schemaName = table.getSchemaName().getString();
        String tableName = table.getTableName().getString();
        String familyName = null;
        StringBuilder buf = new StringBuilder("DELETE FROM SYSTEM.\"CATALOG\" WHERE ");
        buf.append("(TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME, COLUMN_FAMILY) IN (");
        for (PColumn columnToDrop : columnsToDrop) {
            buf.append("('" + tenantId + "'");
            buf.append(",'" + schemaName + "'");
            buf.append(",'" + tableName + "'");
            buf.append(",'" + columnToDrop.getName().getString() + "'");
            buf.append(",'" + (columnToDrop.getFamilyName() == null ? "" : columnToDrop.getFamilyName().getString()) + "'),");
        }
        buf.setCharAt(buf.length() - 1, ')');
        this.connection.createStatement().execute(buf.toString());
        Collections.sort(columnsToDrop, new Comparator<PColumn>(){

            @Override
            public int compare(PColumn left, PColumn right) {
                return Ints.compare((int)left.getPosition(), (int)right.getPosition());
            }
        });
        boolean isSalted = table.getBucketNum() != null;
        int columnsToDropIndex = 0;
        PreparedStatement colUpdate = this.connection.prepareStatement(UPDATE_COLUMN_POSITION);
        colUpdate.setString(1, tenantId);
        colUpdate.setString(2, schemaName);
        colUpdate.setString(3, tableName);
        for (int i = columnsToDrop.get(columnsToDropIndex).getPosition() + 1; i < table.getColumns().size(); ++i) {
            PColumn column = table.getColumns().get(i);
            if (columnsToDrop.contains(column)) {
                ++columnsToDropIndex;
                continue;
            }
            colUpdate.setString(4, column.getName().getString());
            colUpdate.setString(5, column.getFamilyName() == null ? null : column.getFamilyName().getString());
            colUpdate.setInt(6, column.getPosition() - columnsToDropIndex - (isSalted ? 1 : 0));
            colUpdate.execute();
        }
        return familyName;
    }

    private static byte[] getNewEmptyColumnFamilyOrNull(PTable table, PColumn columnToDrop) {
        if (table.getType() != PTableType.VIEW && !SchemaUtil.isPKColumn(columnToDrop) && table.getColumnFamilies().get(0).getName().equals(columnToDrop.getFamilyName()) && table.getColumnFamilies().get(0).getColumns().size() == 1) {
            return SchemaUtil.getEmptyColumnFamily(table.getDefaultFamilyName(), table.getColumnFamilies().subList(1, table.getColumnFamilies().size()));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MutationState dropColumn(DropColumnStatement statement) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            block51: {
                long l;
                MutationState state2;
                MetaDataProtocol.MetaDataMutationResult result;
                ArrayList indexesToDrop;
                ArrayList columnsToDrop;
                PTable table;
                this.connection.setAutoCommit(false);
                PName tenantId = this.connection.getTenantId();
                TableName tableNameNode = statement.getTable().getName();
                String schemaName = tableNameNode.getSchemaName();
                String tableName = tableNameNode.getTableName();
                String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
                boolean retried = false;
                while (true) {
                    Object tableContainingColumnToDrop;
                    ColumnResolver resolver = FromCompiler.getResolver(statement, this.connection);
                    TableRef tableRef = resolver.getTables().get(0);
                    table = tableRef.getTable();
                    ArrayList columnRefs = statement.getColumnRefs();
                    if (columnRefs == null) {
                        columnRefs = Lists.newArrayListWithCapacity((int)0);
                    }
                    columnsToDrop = Lists.newArrayListWithExpectedSize((int)(columnRefs.size() + table.getIndexes().size()));
                    indexesToDrop = Lists.newArrayListWithExpectedSize((int)table.getIndexes().size());
                    ArrayList tableMetaData = Lists.newArrayListWithExpectedSize((int)((table.getIndexes().size() + 1) * (1 + table.getColumns().size() - columnRefs.size())));
                    ArrayList tableColumnsToDrop = Lists.newArrayListWithExpectedSize((int)columnRefs.size());
                    for (ColumnName column : columnRefs) {
                        ColumnRef columnRef = null;
                        try {
                            columnRef = resolver.resolveColumn(null, column.getFamilyName(), column.getColumnName());
                        }
                        catch (ColumnNotFoundException e) {
                            if (!statement.ifExists()) throw e;
                            MutationState mutationState = new MutationState(0L, 0L, this.connection);
                            this.connection.setAutoCommit(wasAutoCommit);
                            return mutationState;
                        }
                        PColumn columnToDrop = columnRef.getColumn();
                        tableColumnsToDrop.add(columnToDrop);
                        if (SchemaUtil.isPKColumn(columnToDrop)) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_DROP_PK).setColumnName(columnToDrop.getName().getString()).build().buildException();
                        }
                        if (table.isAppendOnlySchema()) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_DROP_COL_APPEND_ONLY_SCHEMA).setColumnName(columnToDrop.getName().getString()).build().buildException();
                        }
                        columnsToDrop.add(new ColumnRef(columnRef.getTableRef(), columnToDrop.getPosition()));
                    }
                    this.dropColumnMutations(table, tableColumnsToDrop);
                    boolean removedIndexTableOrColumn = false;
                    Long timeStamp = table.isTransactional() ? Long.valueOf(tableRef.getTimeStamp()) : null;
                    for (PTable index : table.getIndexes()) {
                        IndexMaintainer indexMaintainer = index.getIndexMaintainer(table, this.connection);
                        ArrayList indexColumnsToDrop = Lists.newArrayListWithExpectedSize((int)columnRefs.size());
                        Set<Pair<String, String>> indexedColsInfo = indexMaintainer.getIndexedColumnInfo();
                        Set<ColumnReference> coveredCols = indexMaintainer.getCoveredColumns();
                        for (PColumn columnToDrop : tableColumnsToDrop) {
                            Pair columnToDropInfo = new Pair((Object)columnToDrop.getFamilyName().getString(), (Object)columnToDrop.getName().getString());
                            ColumnReference colDropRef = new ColumnReference(columnToDrop.getFamilyName() == null ? null : columnToDrop.getFamilyName().getBytes(), columnToDrop.getColumnQualifierBytes());
                            boolean isColumnIndexed = indexedColsInfo.contains(columnToDropInfo);
                            if (isColumnIndexed) {
                                if (index.getViewIndexId() == null) {
                                    indexesToDrop.add(new TableRef(index));
                                }
                                this.connection.removeTable(tenantId, SchemaUtil.getTableName(schemaName, index.getName().getString()), index.getParentName() == null ? null : index.getParentName().getString(), index.getTimeStamp());
                                removedIndexTableOrColumn = true;
                                continue;
                            }
                            if (!coveredCols.contains(colDropRef)) continue;
                            String indexColumnName = IndexUtil.getIndexColumnName(columnToDrop);
                            PColumn indexColumn = index.getColumnForColumnName(indexColumnName);
                            indexColumnsToDrop.add(indexColumn);
                            columnsToDrop.add(new ColumnRef(new TableRef(index), indexColumn.getPosition()));
                            removedIndexTableOrColumn = true;
                        }
                        if (indexColumnsToDrop.isEmpty()) continue;
                        long indexTableSeqNum = this.incrementTableSeqNum(index, index.getType(), -indexColumnsToDrop.size(), null, null);
                        this.dropColumnMutations(index, indexColumnsToDrop);
                        long clientTimestamp = MutationState.getTableTimestamp(timeStamp, this.connection.getSCN());
                        this.connection.removeColumn(tenantId, index.getName().getString(), indexColumnsToDrop, clientTimestamp, indexTableSeqNum, TransactionUtil.getResolvedTimestamp(this.connection, index.isTransactional(), clientTimestamp));
                    }
                    tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                    this.connection.rollback();
                    long seqNum = this.incrementTableSeqNum(table, statement.getTableType(), -tableColumnsToDrop.size(), null, null);
                    tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations(timeStamp).next().getSecond());
                    this.connection.rollback();
                    Collections.reverse(tableMetaData);
                    for (ColumnRef columnRefToDrop : columnsToDrop) {
                        tableContainingColumnToDrop = columnRefToDrop.getTable();
                        byte[] emptyCF = MetaDataClient.getNewEmptyColumnFamilyOrNull((PTable)tableContainingColumnToDrop, columnRefToDrop.getColumn());
                        if (emptyCF == null) continue;
                        try {
                            tableContainingColumnToDrop.getColumnFamily(emptyCF);
                        }
                        catch (ColumnFamilyNotFoundException e) {
                            byte[] tenantIdBytes;
                            HashMap<String, List<Pair<String, Object>>> family = new HashMap<String, List<Pair<String, Object>>>(1);
                            family.put(Bytes.toString((byte[])emptyCF), Collections.emptyList());
                            byte[] byArray = tenantIdBytes = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getBytes();
                            if (tenantIdBytes == null) {
                                tenantIdBytes = ByteUtil.EMPTY_BYTE_ARRAY;
                            }
                            this.connection.getQueryServices().addColumn(Collections.singletonList(new Put(SchemaUtil.getTableKey(tenantIdBytes, tableContainingColumnToDrop.getSchemaName().getBytes(), tableContainingColumnToDrop.getTableName().getBytes()))), (PTable)tableContainingColumnToDrop, family, Sets.newHashSet((Object[])new String[]{Bytes.toString((byte[])emptyCF)}), Collections.emptyList());
                        }
                    }
                    result = this.connection.getQueryServices().dropColumn(tableMetaData, statement.getTableType());
                    try {
                        MetaDataProtocol.MutationCode code = this.processMutationResult(schemaName, tableName, result);
                        if (code == MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND) {
                            this.addTableToCache(result);
                            if (!statement.ifExists()) {
                                throw new ColumnNotFoundException(schemaName, tableName, Bytes.toString((byte[])result.getFamilyName()), Bytes.toString((byte[])result.getColumnName()));
                            }
                            tableContainingColumnToDrop = new MutationState(0L, 0L, this.connection);
                            return tableContainingColumnToDrop;
                        }
                        if (tableColumnsToDrop.size() > 0) {
                            if (removedIndexTableOrColumn) {
                                this.connection.removeTable(tenantId, tableName, table.getParentName() == null ? null : table.getParentName().getString(), table.getTimeStamp());
                            } else {
                                this.connection.removeColumn(tenantId, SchemaUtil.getTableName(schemaName, tableName), tableColumnsToDrop, result.getMutationTime(), seqNum, TransactionUtil.getResolvedTime(this.connection, result));
                            }
                        }
                        if (table.getType() != PTableType.VIEW) {
                            state2 = null;
                            this.connection.setAutoCommit(true);
                            Long scn = this.connection.getSCN();
                            if (scn == null) {
                                l = result.getMutationTime();
                                break;
                            }
                            l = scn;
                            break;
                        }
                        break block51;
                    }
                    catch (ConcurrentTableMutationException e) {
                        if (retried) {
                            throw e;
                        }
                        table = this.connection.getTable(new PTableKey(tenantId, fullTableName));
                        retried = true;
                        continue;
                    }
                    break;
                }
                long ts = l;
                PostDDLCompiler compiler = new PostDDLCompiler(this.connection);
                boolean dropMetaData = this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true);
                ArrayList tableRefsToDrop = Lists.newArrayList();
                HashMap tenantIdTableRefMap = Maps.newHashMap();
                if (result.getSharedTablesToDelete() != null) {
                    for (MetaDataProtocol.SharedTableState sharedTableState : result.getSharedTablesToDelete()) {
                        PTableImpl viewIndexTable = new PTableImpl(sharedTableState.getTenantId(), sharedTableState.getSchemaName(), sharedTableState.getTableName(), ts, table.getColumnFamilies(), sharedTableState.getColumns(), sharedTableState.getPhysicalNames(), sharedTableState.getViewIndexId(), table.isMultiTenant(), table.isNamespaceMapped(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
                        TableRef indexTableRef = new TableRef(viewIndexTable);
                        PName indexTableTenantId = sharedTableState.getTenantId();
                        if (indexTableTenantId == null) {
                            tableRefsToDrop.add(indexTableRef);
                            continue;
                        }
                        if (!tenantIdTableRefMap.containsKey(indexTableTenantId)) {
                            tenantIdTableRefMap.put(indexTableTenantId.getString(), Lists.newArrayList());
                        }
                        ((List)tenantIdTableRefMap.get(indexTableTenantId.getString())).add(indexTableRef);
                    }
                }
                if (!dropMetaData) {
                    tableRefsToDrop.addAll(indexesToDrop);
                }
                state2 = this.connection.getQueryServices().updateData(compiler.compile(tableRefsToDrop, null, null, Collections.emptyList(), ts));
                if (!tenantIdTableRefMap.isEmpty()) {
                    for (Map.Entry entry : tenantIdTableRefMap.entrySet()) {
                        String indexTenantId = (String)entry.getKey();
                        Properties props = new Properties(this.connection.getClientInfo());
                        props.setProperty("TenantId", indexTenantId);
                        PhoenixConnection tenantConn = new PhoenixConnection(this.connection, this.connection.getQueryServices(), props);
                        Throwable throwable = null;
                        try {
                            PostDDLCompiler dropCompiler = new PostDDLCompiler(tenantConn);
                            state2 = tenantConn.getQueryServices().updateData(dropCompiler.compile((List)entry.getValue(), null, null, Collections.emptyList(), ts));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tenantConn == null) continue;
                            if (throwable != null) {
                                try {
                                    tenantConn.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            tenantConn.close();
                        }
                    }
                }
                if (!table.isImmutableRows() || table.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                    for (ColumnRef columnRef : columnsToDrop) {
                        ColumnRef columnRef2 = columnRef.cloneAtTimestamp(ts);
                        TableRef droppedColumnTableRef = columnRef2.getTableRef();
                        PColumn droppedColumn = columnRef2.getColumn();
                        MutationPlan plan = compiler.compile(Collections.singletonList(droppedColumnTableRef), MetaDataClient.getNewEmptyColumnFamilyOrNull(droppedColumnTableRef.getTable(), droppedColumn), null, Collections.singletonList(droppedColumn), ts);
                        state2 = this.connection.getQueryServices().updateData(plan);
                    }
                }
                MutationState mutationState = state2;
                return mutationState;
            }
            MutationState mutationState = new MutationState(0L, 0L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState alterIndex(AlterIndexStatement statement) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            String dataTableName = statement.getTableName();
            String schemaName = statement.getTable().getName().getSchemaName();
            String indexName = statement.getTable().getName().getTableName();
            boolean isAsync = statement.isAsync();
            PIndexState newIndexState = statement.getIndexState();
            if (isAsync && newIndexState != PIndexState.REBUILD) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.ASYNC_NOT_ALLOWED).setMessage(" ASYNC building of index is allowed only with REBUILD index state").setSchemaName(schemaName).setTableName(indexName).build().buildException();
            }
            if (newIndexState == PIndexState.REBUILD) {
                newIndexState = PIndexState.BUILDING;
            }
            this.connection.setAutoCommit(false);
            TableRef indexRef = FromCompiler.getResolver(statement, this.connection).getTables().get(0);
            try (Statement tableUpsert = null;){
                tableUpsert = newIndexState == PIndexState.ACTIVE ? this.connection.prepareStatement(UPDATE_INDEX_STATE_TO_ACTIVE) : this.connection.prepareStatement(UPDATE_INDEX_STATE);
                tableUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                tableUpsert.setString(2, schemaName);
                tableUpsert.setString(3, indexName);
                tableUpsert.setString(4, newIndexState.getSerializedValue());
                tableUpsert.setLong(5, 0L);
                if (newIndexState == PIndexState.ACTIVE) {
                    tableUpsert.setLong(6, 0L);
                }
                tableUpsert.execute();
            }
            Long timeStamp = indexRef.getTable().isTransactional() ? Long.valueOf(indexRef.getTimeStamp()) : null;
            List tableMetadata = (List)this.connection.getMutationState().toMutations(timeStamp).next().getSecond();
            this.connection.rollback();
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().updateIndexState(tableMetadata, dataTableName);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            if (code == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND) {
                throw new TableNotFoundException(schemaName, indexName);
            }
            if (code == MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_INDEX_STATE_TRANSITION).setMessage(" currentState=" + (Object)((Object)indexRef.getTable().getIndexState()) + ". requestedState=" + (Object)((Object)newIndexState)).setSchemaName(schemaName).setTableName(indexName).build().buildException();
            }
            if (code == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS && result.getTable() != null) {
                this.addTableToCache(result);
                indexRef.setTable(result.getTable());
                if (newIndexState == PIndexState.BUILDING && isAsync) {
                    try {
                        tableUpsert = this.connection.prepareStatement(UPDATE_INDEX_REBUILD_ASYNC_STATE);
                        tableUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                        tableUpsert.setString(2, schemaName);
                        tableUpsert.setString(3, indexName);
                        tableUpsert.setLong(4, result.getTable().getTimeStamp());
                        tableUpsert.execute();
                        this.connection.commit();
                    }
                    finally {
                        if (tableUpsert != null) {
                            tableUpsert.close();
                        }
                    }
                }
            }
            if (newIndexState == PIndexState.BUILDING && !isAsync) {
                PTable index = indexRef.getTable();
                Long scn = this.connection.getSCN();
                long ts = scn == null ? Long.MAX_VALUE : scn;
                MutationPlan plan = new PostDDLCompiler(this.connection).compile(Collections.singletonList(indexRef), null, null, Collections.emptyList(), ts);
                this.connection.getQueryServices().updateData(plan);
                NamedTableNode dataTableNode = NamedTableNode.create(null, TableName.create(schemaName, dataTableName), Collections.emptyList());
                this.connection.setAutoCommit(true);
                if (this.connection.getSCN() != null) {
                    MutationState mutationState = this.buildIndexAtTimeStamp(index, dataTableNode);
                    return mutationState;
                }
                TableRef dataTableRef = FromCompiler.getResolver(dataTableNode, this.connection).getTables().get(0);
                MutationState mutationState = this.buildIndex(index, dataTableRef);
                return mutationState;
            }
            MutationState mutationState = new MutationState(1L, 1000L, this.connection);
            return mutationState;
        }
        catch (TableNotFoundException e) {
            if (!statement.ifExists()) {
                throw e;
            }
            MutationState mutationState = new MutationState(0L, 0L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private PTable addTableToCache(MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        this.addIndexesFromParentTable(result, null);
        PTable table = result.getTable();
        this.connection.addTable(table, TransactionUtil.getResolvedTime(this.connection, result));
        return table;
    }

    private List<PFunction> addFunctionToCache(MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        for (PFunction function : result.getFunctions()) {
            this.connection.addFunction(function);
        }
        return result.getFunctions();
    }

    private void addSchemaToCache(MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        this.connection.addSchema(result.getSchema());
    }

    private void throwIfLastPKOfParentIsFixedLength(PTable parent, String viewSchemaName, String viewName, ColumnDef col) throws SQLException {
        if (this.isLastPKVariableLength(parent)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MODIFY_VIEW_PK).setSchemaName(viewSchemaName).setTableName(viewName).setColumnName(col.getColumnDefName().getColumnName()).build().buildException();
        }
    }

    private boolean isLastPKVariableLength(PTable table) {
        List<PColumn> pkColumns = table.getPKColumns();
        return !pkColumns.get(pkColumns.size() - 1).getDataType().isFixedWidth();
    }

    private PTable getParentOfView(PTable view) throws SQLException {
        SelectStatement select = new SQLParser(view.getViewStatement()).parseQuery();
        String parentName = SchemaUtil.normalizeFullTableName(select.getFrom().toString().trim());
        return this.connection.getTable(new PTableKey(view.getTenantId(), parentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState createSchema(CreateSchemaStatement create) throws SQLException {
        boolean wasAutoCommit = this.connection.getAutoCommit();
        this.connection.rollback();
        try {
            List schemaMutations;
            if (!SchemaUtil.isNamespaceMappingEnabled(null, this.connection.getQueryServices().getProps())) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CREATE_SCHEMA_NOT_ALLOWED).setSchemaName(create.getSchemaName()).build().buildException();
            }
            boolean isIfNotExists = create.isIfNotExists();
            this.validateSchema(create.getSchemaName());
            PSchema schema = new PSchema(create.getSchemaName());
            this.connection.setAutoCommit(false);
            try (PreparedStatement schemaUpsert = this.connection.prepareStatement(CREATE_SCHEMA);){
                schemaUpsert.setString(1, schema.getSchemaName());
                schemaUpsert.setString(2, EMPTY_TABLE);
                schemaUpsert.execute();
                schemaMutations = (List)this.connection.getMutationState().toMutations(null).next().getSecond();
                this.connection.rollback();
            }
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().createSchema(schemaMutations, schema.getSchemaName());
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            switch (code) {
                case SCHEMA_ALREADY_EXISTS: {
                    if (result.getSchema() != null) {
                        this.addSchemaToCache(result);
                    }
                    if (!isIfNotExists) {
                        throw new SchemaAlreadyExistsException(schema.getSchemaName());
                    }
                    break;
                }
                case NEWER_SCHEMA_FOUND: {
                    throw new NewerSchemaAlreadyExistsException(schema.getSchemaName());
                }
                default: {
                    result = new MetaDataProtocol.MetaDataMutationResult(code, schema, result.getMutationTime());
                    this.addSchemaToCache(result);
                    break;
                }
            }
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
        return new MutationState(0L, 0L, this.connection);
    }

    private void validateSchema(String schemaName) throws SQLException {
        if (SchemaUtil.NOT_ALLOWED_SCHEMA_LIST.contains(schemaName.toUpperCase())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.SCHEMA_NOT_ALLOWED).setSchemaName(schemaName).build().buildException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState dropSchema(DropSchemaStatement executableDropSchemaStatement) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            PSchema schema = new PSchema(executableDropSchemaStatement.getSchemaName());
            String schemaName = schema.getSchemaName();
            boolean ifExists = executableDropSchemaStatement.ifExists();
            byte[] key = SchemaUtil.getSchemaKey(schemaName);
            Long scn = this.connection.getSCN();
            long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
            ArrayList schemaMetaData = Lists.newArrayListWithExpectedSize((int)2);
            Delete schemaDelete = new Delete(key, clientTimeStamp);
            schemaMetaData.add(schemaDelete);
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().dropSchema(schemaMetaData, schemaName);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            schema = result.getSchema();
            switch (code) {
                case SCHEMA_NOT_FOUND: {
                    if (ifExists) break;
                    throw new SchemaNotFoundException(schemaName);
                }
                case NEWER_SCHEMA_FOUND: {
                    throw new NewerSchemaAlreadyExistsException(schemaName);
                }
                case TABLES_EXIST_ON_SCHEMA: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_SCHEMA).setSchemaName(schemaName).build().buildException();
                }
                default: {
                    this.connection.removeSchema(schema, result.getMutationTime());
                }
            }
            MutationState mutationState = new MutationState(0L, 0L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    public MutationState useSchema(UseSchemaStatement useSchemaStatement) throws SQLException {
        if (useSchemaStatement.getSchemaName().equals("")) {
            this.connection.setSchema(null);
        } else {
            FromCompiler.getResolverForSchema(useSchemaStatement, this.connection).resolveSchema(useSchemaStatement.getSchemaName());
            this.connection.setSchema(useSchemaStatement.getSchemaName());
        }
        return new MutationState(0L, 0L, this.connection);
    }
}

