/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsInfoBuilder;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;

public class StatisticsUtil {
    private static final Set<TableName> DISABLE_STATS = Sets.newHashSetWithExpectedSize((int)8);
    protected static final int NUM_KEY_PARTS = 3;

    private StatisticsUtil() {
    }

    public static byte[] getRowKey(byte[] table, ImmutableBytesWritable fam, byte[] guidePostStartKey) {
        return StatisticsUtil.getRowKey(table, fam, new ImmutableBytesWritable(guidePostStartKey, 0, guidePostStartKey.length));
    }

    public static byte[] getRowKey(byte[] table, ImmutableBytesWritable fam, ImmutableBytesWritable guidePostStartKey) {
        int guidePostLength = guidePostStartKey.getLength();
        boolean hasGuidePost = guidePostLength > 0;
        byte[] rowKey = new byte[table.length + fam.getLength() + guidePostLength + (hasGuidePost ? 2 : 1)];
        int offset = 0;
        System.arraycopy(table, 0, rowKey, offset, table.length);
        offset += table.length;
        rowKey[offset++] = 0;
        System.arraycopy(fam.get(), fam.getOffset(), rowKey, offset, fam.getLength());
        if (hasGuidePost) {
            offset += fam.getLength();
            rowKey[offset++] = 0;
            System.arraycopy(guidePostStartKey.get(), 0, rowKey, offset, guidePostLength);
        }
        return rowKey;
    }

    private static byte[] getStartKey(byte[] table, ImmutableBytesWritable fam) {
        return StatisticsUtil.getKey(table, fam, false);
    }

    private static byte[] getEndKey(byte[] table, ImmutableBytesWritable fam) {
        byte[] key = StatisticsUtil.getKey(table, fam, true);
        ByteUtil.nextKey(key, key.length);
        return key;
    }

    private static byte[] getKey(byte[] table, ImmutableBytesWritable fam, boolean terminateWithSeparator) {
        byte[] rowKey = new byte[table.length + fam.getLength() + 1 + (terminateWithSeparator ? 1 : 0)];
        int offset = 0;
        System.arraycopy(table, 0, rowKey, offset, table.length);
        offset += table.length;
        rowKey[offset++] = 0;
        System.arraycopy(fam.get(), fam.getOffset(), rowKey, offset, fam.getLength());
        offset += fam.getLength();
        if (terminateWithSeparator) {
            rowKey[offset] = 0;
        }
        return rowKey;
    }

    public static byte[] getAdjustedKey(byte[] key, byte[] tableNameBytes, ImmutableBytesWritable cf, boolean nextKey) {
        if (Bytes.compareTo((byte[])key, (byte[])ByteUtil.EMPTY_BYTE_ARRAY) != 0) {
            return StatisticsUtil.getRowKey(tableNameBytes, cf, key);
        }
        key = StatisticsUtil.getKey(tableNameBytes, cf, nextKey);
        if (nextKey) {
            ByteUtil.nextKey(key, key.length);
        }
        return key;
    }

    public static GuidePostsInfo readStatistics(HTableInterface statsHTable, GuidePostsKey key, long clientTimeStamp) throws IOException {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ptr.set(key.getColumnFamily());
        byte[] tableNameBytes = key.getPhysicalName();
        byte[] startKey = StatisticsUtil.getStartKey(tableNameBytes, ptr);
        byte[] endKey = StatisticsUtil.getEndKey(tableNameBytes, ptr);
        Scan s = MetaDataUtil.newTableRowsScan(startKey, endKey, 0L, clientTimeStamp);
        s.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_WIDTH_BYTES);
        s.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_ROW_COUNT_BYTES);
        s.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES);
        GuidePostsInfoBuilder guidePostsInfoBuilder = new GuidePostsInfoBuilder();
        Cell current = null;
        GuidePostsInfo emptyGuidePost = null;
        try (ResultScanner scanner = statsHTable.getScanner(s);){
            Result result = null;
            while ((result = scanner.next()) != null) {
                CellScanner cellScanner = result.cellScanner();
                long rowCount = 0L;
                long byteCount = 0L;
                while (cellScanner.advance()) {
                    current = cellScanner.current();
                    if (Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])PhoenixDatabaseMetaData.GUIDE_POSTS_ROW_COUNT_BYTES, (int)0, (int)PhoenixDatabaseMetaData.GUIDE_POSTS_ROW_COUNT_BYTES.length)) {
                        rowCount = PLong.INSTANCE.getCodec().decodeLong(current.getValueArray(), current.getValueOffset(), SortOrder.getDefault());
                        continue;
                    }
                    if (!Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])PhoenixDatabaseMetaData.GUIDE_POSTS_WIDTH_BYTES, (int)0, (int)PhoenixDatabaseMetaData.GUIDE_POSTS_WIDTH_BYTES.length)) continue;
                    byteCount = PLong.INSTANCE.getCodec().decodeLong(current.getValueArray(), current.getValueOffset(), SortOrder.getDefault());
                }
                if (current == null) continue;
                int tableNameLength = tableNameBytes.length + 1;
                int cfOffset = current.getRowOffset() + tableNameLength;
                int cfLength = SchemaUtil.getVarCharLength(current.getRowArray(), cfOffset, current.getRowLength() - tableNameLength);
                ptr.set(current.getRowArray(), cfOffset, cfLength);
                byte[] cfName = ByteUtil.copyKeyBytesIfNecessary(ptr);
                byte[] newGPStartKey = StatisticsUtil.getGuidePostsInfoFromRowKey(tableNameBytes, cfName, result.getRow());
                boolean isEmptyGuidePost = GuidePostsInfo.isEmptyGpsKey(newGPStartKey);
                long guidePostUpdateTime = current.getTimestamp();
                if (isEmptyGuidePost) {
                    emptyGuidePost = GuidePostsInfo.createEmptyGuidePost(byteCount, guidePostUpdateTime);
                    continue;
                }
                guidePostsInfoBuilder.trackGuidePost(new ImmutableBytesWritable(newGPStartKey), byteCount, rowCount, guidePostUpdateTime);
            }
        }
        return current == null ? GuidePostsInfo.NO_GUIDEPOST : (guidePostsInfoBuilder.isEmpty() ? emptyGuidePost : guidePostsInfoBuilder.build());
    }

    public static long getGuidePostDepth(int guidepostPerRegion, long guidepostWidth, HTableDescriptor tableDesc) {
        if (guidepostPerRegion > 0) {
            long tableMaxFileSize;
            long maxFileSize = 0x280000000L;
            if (tableDesc != null && (tableMaxFileSize = tableDesc.getMaxFileSize()) >= 0L) {
                maxFileSize = tableMaxFileSize;
            }
            return maxFileSize / (long)guidepostPerRegion;
        }
        return guidepostWidth;
    }

    public static byte[] getGuidePostsInfoFromRowKey(byte[] tableNameBytes, byte[] fam, byte[] row) {
        if (row.length > tableNameBytes.length + 1 + fam.length) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            int gpOffset = tableNameBytes.length + 1 + fam.length + 1;
            ptr.set(row, gpOffset, row.length - gpOffset);
            return ByteUtil.copyKeyBytesIfNecessary(ptr);
        }
        return ByteUtil.EMPTY_BYTE_ARRAY;
    }

    public static boolean isStatsEnabled(TableName tableName) {
        return !DISABLE_STATS.contains(tableName);
    }

    static {
        DISABLE_STATS.add(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME));
        DISABLE_STATS.add(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME));
        DISABLE_STATS.add(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME));
        DISABLE_STATS.add(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_STATS_NAME));
        DISABLE_STATS.add(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, true));
        DISABLE_STATS.add(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES, true));
        DISABLE_STATS.add(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, true));
        DISABLE_STATS.add(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES, true));
    }
}

