/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.SequenceValueExpression;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SequenceAllocation;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.tuple.DelegateTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.SequenceUtil;

public class SequenceManager {
    private final PhoenixStatement statement;
    private int[] sequencePosition;
    private List<SequenceAllocation> nextSequences;
    private List<SequenceKey> currentSequences;
    private final Map<SequenceKey, SequenceValueExpression> sequenceMap = Maps.newHashMap();
    private final BitSet isNextSequence = new BitSet();

    public SequenceManager(PhoenixStatement statement) {
        this.statement = statement;
    }

    public int getSequenceCount() {
        return this.sequenceMap == null ? 0 : this.sequenceMap.size();
    }

    private void setSequenceValues(long[] srcSequenceValues, long[] dstSequenceValues, SQLException[] sqlExceptions) throws SQLException {
        SQLException eTop = null;
        for (int i = 0; i < sqlExceptions.length; ++i) {
            SQLException e = sqlExceptions[i];
            if (e != null) {
                if (eTop == null) {
                    eTop = e;
                    continue;
                }
                e.setNextException(eTop.getNextException());
                eTop.setNextException(e);
                continue;
            }
            dstSequenceValues[this.sequencePosition[i]] = srcSequenceValues[i];
        }
        if (eTop != null) {
            throw eTop;
        }
    }

    public Tuple newSequenceTuple(Tuple tuple) throws SQLException {
        return new SequenceTuple(tuple);
    }

    public SequenceValueExpression newSequenceReference(SequenceValueParseNode node) throws SQLException {
        PName tenantName = this.statement.getConnection().getTenantId();
        String tenantId = tenantName == null ? null : tenantName.getString();
        TableName tableName = node.getTableName();
        if (tableName.getSchemaName() == null && this.statement.getConnection().getSchema() != null) {
            tableName = TableName.create(this.statement.getConnection().getSchema(), tableName.getTableName());
        }
        int nSaltBuckets = this.statement.getConnection().getQueryServices().getSequenceSaltBuckets();
        ParseNode numToAllocateNode = node.getNumToAllocateNode();
        long numToAllocate = this.determineNumToAllocate(tableName, numToAllocateNode);
        SequenceKey key = new SequenceKey(tenantId, tableName.getSchemaName(), tableName.getTableName(), nSaltBuckets);
        SequenceValueExpression expression = this.sequenceMap.get(key);
        if (expression == null) {
            int index = this.sequenceMap.size();
            expression = new SequenceValueExpression(key, node.getOp(), index, numToAllocate);
            this.sequenceMap.put(key, expression);
        } else if (expression.op != node.getOp() || expression.getNumToAllocate() < numToAllocate) {
            SequenceValueExpression oldExpression = expression;
            expression = new SequenceValueExpression(key, node.getOp(), expression.getIndex(), Math.max(expression.getNumToAllocate(), numToAllocate));
            if (oldExpression.getNumToAllocate() < numToAllocate) {
                this.sequenceMap.put(key, expression);
            }
        }
        if (node.getOp() == SequenceValueParseNode.Op.NEXT_VALUE) {
            this.isNextSequence.set(expression.getIndex());
        }
        return expression;
    }

    private long determineNumToAllocate(TableName sequenceName, ParseNode numToAllocateNode) throws SQLException {
        if (numToAllocateNode != null) {
            StatementContext context = new StatementContext(this.statement);
            ExpressionCompiler expressionCompiler = new ExpressionCompiler(context);
            Expression expression = numToAllocateNode.accept(expressionCompiler);
            ImmutableBytesWritable ptr = context.getTempPtr();
            expression.evaluate(null, ptr);
            if (ptr.getLength() == 0 || !expression.getDataType().isCoercibleTo(PLong.INSTANCE)) {
                throw SequenceUtil.getException(sequenceName.getSchemaName(), sequenceName.getTableName(), SQLExceptionCode.NUM_SEQ_TO_ALLOCATE_MUST_BE_CONSTANT);
            }
            long numToAllocate = (Long)PLong.INSTANCE.toObject(ptr, expression.getDataType());
            if (numToAllocate < 1L) {
                throw SequenceUtil.getException(sequenceName.getSchemaName(), sequenceName.getTableName(), SQLExceptionCode.NUM_SEQ_TO_ALLOCATE_MUST_BE_CONSTANT);
            }
            return numToAllocate;
        }
        return 1L;
    }

    public void validateSequences(Sequence.ValueOp action) throws SQLException {
        if (this.sequenceMap.isEmpty()) {
            return;
        }
        int maxSize = this.sequenceMap.size();
        long[] dstSequenceValues = new long[maxSize];
        this.sequencePosition = new int[maxSize];
        this.nextSequences = Lists.newArrayListWithExpectedSize((int)maxSize);
        this.currentSequences = Lists.newArrayListWithExpectedSize((int)maxSize);
        for (Map.Entry<SequenceKey, SequenceValueExpression> entry : this.sequenceMap.entrySet()) {
            if (this.isNextSequence.get(entry.getValue().getIndex())) {
                this.nextSequences.add(new SequenceAllocation(entry.getKey(), entry.getValue().getNumToAllocate()));
                continue;
            }
            this.currentSequences.add(entry.getKey());
        }
        long[] srcSequenceValues = new long[this.nextSequences.size()];
        SQLException[] sqlExceptions = new SQLException[this.nextSequences.size()];
        Collections.sort(this.nextSequences);
        for (int i = 0; i < this.nextSequences.size(); ++i) {
            this.sequencePosition[i] = this.sequenceMap.get(this.nextSequences.get(i)).getIndex();
        }
        int offset = this.nextSequences.size();
        for (int i = 0; i < this.currentSequences.size(); ++i) {
            this.sequencePosition[i + offset] = this.sequenceMap.get(this.currentSequences.get(i)).getIndex();
        }
        ConnectionQueryServices services = this.statement.getConnection().getQueryServices();
        Long scn = this.statement.getConnection().getSCN();
        long timestamp = scn == null ? Long.MAX_VALUE : scn;
        services.validateSequences(this.nextSequences, timestamp, srcSequenceValues, sqlExceptions, action);
        this.setSequenceValues(srcSequenceValues, dstSequenceValues, sqlExceptions);
    }

    private class SequenceTuple
    extends DelegateTuple {
        private final long[] srcSequenceValues;
        private final long[] dstSequenceValues;
        private final SQLException[] sqlExceptions;

        public SequenceTuple(Tuple delegate) throws SQLException {
            super(delegate);
            int maxSize = SequenceManager.this.sequenceMap.size();
            this.dstSequenceValues = new long[maxSize];
            this.srcSequenceValues = new long[SequenceManager.this.nextSequences.size()];
            this.sqlExceptions = new SQLException[SequenceManager.this.nextSequences.size()];
            this.incrementSequenceValues();
        }

        private void incrementSequenceValues() throws SQLException {
            if (SequenceManager.this.sequenceMap == null) {
                return;
            }
            Long scn = SequenceManager.this.statement.getConnection().getSCN();
            long timestamp = scn == null ? Long.MAX_VALUE : scn;
            ConnectionQueryServices services = SequenceManager.this.statement.getConnection().getQueryServices();
            services.incrementSequences(SequenceManager.this.nextSequences, timestamp, this.srcSequenceValues, this.sqlExceptions);
            SequenceManager.this.setSequenceValues(this.srcSequenceValues, this.dstSequenceValues, this.sqlExceptions);
            int offset = SequenceManager.this.nextSequences.size();
            for (int i = 0; i < SequenceManager.this.currentSequences.size(); ++i) {
                this.dstSequenceValues[((SequenceManager)SequenceManager.this).sequencePosition[offset + i]] = services.currentSequenceValue((SequenceKey)SequenceManager.this.currentSequences.get(i), timestamp);
            }
        }

        @Override
        public long getSequenceValue(int index) {
            return this.dstSequenceValues[index];
        }
    }
}

