/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.phoenix.execute.RuntimeContext;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;

public class RuntimeContextImpl
implements RuntimeContext {
    Map<String, VariableEntry> correlateVariables = Maps.newHashMap();

    @Override
    public void defineCorrelateVariable(String variableId, TableRef def) {
        this.correlateVariables.put(variableId, new VariableEntry(def));
    }

    @Override
    public TableRef getCorrelateVariableDef(String variableId) {
        VariableEntry entry = this.correlateVariables.get(variableId);
        if (entry == null) {
            throw new RuntimeException("Variable '" + variableId + "' undefined.");
        }
        return entry.getDef();
    }

    @Override
    public void setCorrelateVariableValue(String variableId, Tuple value) {
        VariableEntry entry = this.correlateVariables.get(variableId);
        if (entry == null) {
            throw new RuntimeException("Variable '" + variableId + "' undefined.");
        }
        entry.setValue(value);
    }

    @Override
    public Tuple getCorrelateVariableValue(String variableId) {
        VariableEntry entry = this.correlateVariables.get(variableId);
        if (entry == null) {
            throw new RuntimeException("Variable '" + variableId + "' undefined.");
        }
        return entry.getValue();
    }

    private static class VariableEntry {
        private final TableRef def;
        private Tuple value;

        VariableEntry(TableRef def) {
            this.def = def;
        }

        TableRef getDef() {
            return this.def;
        }

        Tuple getValue() {
            return this.value;
        }

        void setValue(Tuple value) {
            this.value = value;
        }
    }
}

