/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.iterate.DefaultParallelScanGrouper;
import org.apache.phoenix.iterate.GettingResultIterator;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.OffsetResultIterator;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.trace.TracingIterator;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.LogUtil;

public class SingleKeyQueryPlan
implements QueryPlan {
    private static final Log LOG = LogFactory.getLog(SingleKeyQueryPlan.class);
    private final StatementContext context;
    private final FilterableStatement statement;
    private final TableRef table;
    private final RowProjector projector;
    private final Integer limit;
    private final Integer offset;
    private final Expression where;
    private final OrderByCompiler.OrderBy orderBy;
    private final PhoenixConnection connection;

    public SingleKeyQueryPlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, Integer offset, Expression where, OrderByCompiler.OrderBy orderBy) {
        this.context = context;
        this.statement = statement;
        this.table = table;
        this.projector = projector;
        this.limit = limit;
        this.offset = offset;
        this.where = where;
        this.orderBy = orderBy;
        this.connection = context.getConnection();
    }

    @Override
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return this.context.getBindManager().getParameterMetaData();
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        ArrayList<String> steps = new ArrayList<String>();
        ResultIterator iterator = this.iterator();
        iterator.explain(steps);
        return new ExplainPlan(steps);
    }

    @Override
    public Set<TableRef> getSourceRefs() {
        return ImmutableSet.of((Object)this.table);
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return PhoenixStatement.Operation.QUERY;
    }

    @Override
    public Long getEstimatedRowsToScan() {
        return null;
    }

    @Override
    public Long getEstimatedBytesToScan() {
        return null;
    }

    @Override
    public Long getEstimateInfoTimestamp() {
        return null;
    }

    @Override
    public final ResultIterator iterator() throws SQLException {
        return this.iterator(DefaultParallelScanGrouper.getInstance());
    }

    @Override
    public final ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
        return this.iterator(scanGrouper, null);
    }

    @Override
    public final ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        TraceScope scope;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)LogUtil.addCustomAnnotations("Gets ready for iteration: " + scan, this.connection));
        }
        ResultIterator iterator = new GettingResultIterator(this.context, this.where);
        if (!this.orderBy.getOrderByExpressions().isEmpty()) {
            int thresholdBytes = this.context.getConnection().getQueryServices().getProps().getInt("phoenix.query.spoolThresholdBytes", 0x1400000);
            iterator = new OrderedResultIterator(iterator, this.orderBy.getOrderByExpressions(), thresholdBytes, this.limit, this.offset, this.projector.getEstimatedRowByteSize());
        } else {
            if (this.offset != null) {
                iterator = new OffsetResultIterator(iterator, this.offset);
            }
            if (this.limit != null) {
                iterator = new LimitingResultIterator(iterator, this.limit);
            }
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            iterator = new SequenceResultIterator(iterator, this.context.getSequenceManager());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)LogUtil.addCustomAnnotations("Iterator ready: " + iterator, this.connection));
        }
        return (scope = Tracing.startNewSpan(this.context.getConnection(), "Creating basic query for " + this.getPlanSteps(iterator))).getSpan() != null ? new TracingIterator(scope, iterator) : iterator;
    }

    private List<String> getPlanSteps(ResultIterator iterator) {
        ArrayList planSteps = Lists.newArrayListWithExpectedSize((int)5);
        iterator.explain(planSteps);
        return planSteps;
    }

    @Override
    public long getEstimatedSize() {
        return 0L;
    }

    @Override
    public TableRef getTableRef() {
        return this.table;
    }

    @Override
    public RowProjector getProjector() {
        return this.projector;
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public Integer getOffset() {
        return this.offset;
    }

    @Override
    public OrderByCompiler.OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return null;
    }

    @Override
    public List<KeyRange> getSplits() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<List<Scan>> getScans() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public FilterableStatement getStatement() {
        return this.statement;
    }

    @Override
    public boolean isDegenerate() {
        return false;
    }

    @Override
    public boolean isRowKeyOrdered() {
        return false;
    }

    @Override
    public boolean useRoundRobinIterator() throws SQLException {
        return false;
    }
}

