/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ProjectedColumn;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.SchemaUtil;

public class TupleProjector {
    private static final String SCAN_PROJECTOR = "scanProjector";
    private final KeyValueSchema schema;
    private final Expression[] expressions;
    private ValueBitSet valueSet;
    private final ImmutableBytesWritable ptr = new ImmutableBytesWritable();
    private static final byte[] OLD_VALUE_COLUMN_QUALIFIER = new byte[0];

    public TupleProjector(RowProjector rowProjector) {
        List<? extends ColumnProjector> columnProjectors = rowProjector.getColumnProjectors();
        int count = columnProjectors.size();
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
        this.expressions = new Expression[count];
        for (int i = 0; i < count; ++i) {
            Expression expression = columnProjectors.get(i).getExpression();
            builder.addField(expression);
            this.expressions[i] = expression;
        }
        this.schema = builder.build();
        this.valueSet = ValueBitSet.newInstance(this.schema);
    }

    public TupleProjector(Expression[] expressions) {
        this.expressions = expressions;
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
        for (int i = 0; i < expressions.length; ++i) {
            builder.addField(expressions[i]);
        }
        this.schema = builder.build();
        this.valueSet = ValueBitSet.newInstance(this.schema);
    }

    public TupleProjector(PTable projectedTable) throws SQLException {
        Preconditions.checkArgument((projectedTable.getType() == PTableType.PROJECTED ? 1 : 0) != 0);
        List<PColumn> columns = projectedTable.getColumns();
        this.expressions = new Expression[columns.size() - projectedTable.getPKColumns().size()];
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
        int i = 0;
        for (PColumn column : columns) {
            if (SchemaUtil.isPKColumn(column)) continue;
            builder.addField(column);
            this.expressions[i++] = ((ProjectedColumn)column).getSourceColumnRef().newColumnExpression();
        }
        this.schema = builder.build();
        this.valueSet = ValueBitSet.newInstance(this.schema);
    }

    public TupleProjector(KeyValueSchema schema, Expression[] expressions) {
        this.schema = schema;
        this.expressions = expressions;
        this.valueSet = ValueBitSet.newInstance(schema);
    }

    public void setValueBitSet(ValueBitSet bitSet) {
        this.valueSet = bitSet;
    }

    public static void copySerializeProjectorIntoGetFromScan(Scan scan, Get get) {
        get.setAttribute(SCAN_PROJECTOR, scan.getAttribute(SCAN_PROJECTOR));
    }

    public static void serializeProjectorIntoScan(Scan scan, TupleProjector projector) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            projector.schema.write(output);
            int count = projector.expressions.length;
            WritableUtils.writeVInt((DataOutput)output, (int)count);
            for (int i = 0; i < count; ++i) {
                WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(projector.expressions[i]).ordinal());
                projector.expressions[i].write(output);
            }
            scan.setAttribute(SCAN_PROJECTOR, stream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static TupleProjector deserializeProjectorFromBytes(byte[] bytes) {
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            KeyValueSchema schema = new KeyValueSchema();
            schema.readFields(input);
            int count = WritableUtils.readVInt((DataInput)input);
            Expression[] expressions = new Expression[count];
            for (int i = 0; i < count; ++i) {
                int ordinal = WritableUtils.readVInt((DataInput)input);
                expressions[i] = ExpressionType.values()[ordinal].newInstance();
                expressions[i].readFields(input);
            }
            TupleProjector tupleProjector = new TupleProjector(schema, expressions);
            return tupleProjector;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static TupleProjector deserializeProjectorFromGet(Get get) {
        byte[] proj = get.getAttribute(SCAN_PROJECTOR);
        if (proj == null) {
            return null;
        }
        return TupleProjector.deserializeProjectorFromBytes(proj);
    }

    public static TupleProjector deserializeProjectorFromScan(Scan scan) {
        byte[] proj = scan.getAttribute(SCAN_PROJECTOR);
        if (proj == null) {
            return null;
        }
        return TupleProjector.deserializeProjectorFromBytes(proj);
    }

    public ProjectedValueTuple projectResults(Tuple tuple) {
        byte[] bytesValue = this.schema.toBytes(tuple, this.getExpressions(), this.valueSet, this.ptr);
        Cell base = tuple.getValue(0);
        return new ProjectedValueTuple(base.getRowArray(), base.getRowOffset(), base.getRowLength(), base.getTimestamp(), bytesValue, 0, bytesValue.length, this.valueSet.getEstimatedLength());
    }

    public ProjectedValueTuple projectResults(Tuple tuple, boolean useNewValueQualifier) {
        long maxTS = tuple.getValue(0).getTimestamp();
        int nCells = tuple.size();
        for (int i = 1; i < nCells; ++i) {
            long ts = tuple.getValue(i).getTimestamp();
            if (ts <= maxTS) continue;
            maxTS = ts;
        }
        byte[] bytesValue = this.schema.toBytes(tuple, this.getExpressions(), this.valueSet, this.ptr);
        Cell base = tuple.getValue(0);
        if (useNewValueQualifier) {
            return new ProjectedValueTuple(base.getRowArray(), base.getRowOffset(), base.getRowLength(), maxTS, bytesValue, 0, bytesValue.length, this.valueSet.getEstimatedLength());
        }
        return new OldProjectedValueTuple(base.getRowArray(), base.getRowOffset(), base.getRowLength(), maxTS, bytesValue, 0, bytesValue.length, this.valueSet.getEstimatedLength());
    }

    public static void decodeProjectedValue(Tuple tuple, ImmutableBytesWritable ptr) throws IOException {
        boolean b = tuple.getValue(QueryConstants.VALUE_COLUMN_FAMILY, QueryConstants.VALUE_COLUMN_QUALIFIER, ptr);
        if (!b) {
            b = tuple.getValue(QueryConstants.VALUE_COLUMN_FAMILY, OLD_VALUE_COLUMN_QUALIFIER, ptr);
        }
        if (!b) {
            throw new IOException("Trying to decode a non-projected value.");
        }
    }

    public static ProjectedValueTuple mergeProjectedValue(ProjectedValueTuple dest, KeyValueSchema destSchema, ValueBitSet destBitSet, Tuple src, KeyValueSchema srcSchema, ValueBitSet srcBitSet, int offset, boolean useNewValueColumnQualifier) throws IOException {
        ImmutableBytesWritable destValue = dest.getProjectedValue();
        int origDestBitSetLen = dest.getBitSetLength();
        destBitSet.clear();
        destBitSet.or(destValue, origDestBitSetLen);
        ImmutableBytesWritable srcValue = null;
        int srcValueLen = 0;
        if (src != null) {
            srcValue = new ImmutableBytesWritable();
            TupleProjector.decodeProjectedValue(src, srcValue);
            srcBitSet.clear();
            srcBitSet.or(srcValue);
            int origSrcBitSetLen = srcBitSet.getEstimatedLength();
            for (int i = 0; i <= srcBitSet.getMaxSetBit(); ++i) {
                if (!srcBitSet.get(i)) continue;
                destBitSet.set(offset + i);
            }
            srcValueLen = srcValue.getLength() - origSrcBitSetLen;
        }
        int destBitSetLen = destBitSet.getEstimatedLength();
        byte[] merged = new byte[destValue.getLength() - origDestBitSetLen + srcValueLen + destBitSetLen];
        int o = Bytes.putBytes((byte[])merged, (int)0, (byte[])destValue.get(), (int)destValue.getOffset(), (int)(destValue.getLength() - origDestBitSetLen));
        if (src != null) {
            o = Bytes.putBytes((byte[])merged, (int)o, (byte[])srcValue.get(), (int)srcValue.getOffset(), (int)srcValueLen);
        }
        destBitSet.toBytes(merged, o);
        return useNewValueColumnQualifier ? new ProjectedValueTuple(dest, dest.getTimestamp(), merged, 0, merged.length, destBitSetLen) : new OldProjectedValueTuple(dest, dest.getTimestamp(), merged, 0, merged.length, destBitSetLen);
    }

    public KeyValueSchema getSchema() {
        return this.schema;
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }

    public ValueBitSet getValueBitSet() {
        return this.valueSet;
    }

    public String toString() {
        return "TUPLE-PROJECTOR {" + Arrays.toString(this.expressions) + " ==> " + this.schema.toString() + "}";
    }

    public static class OldProjectedValueTuple
    extends ProjectedValueTuple {
        public OldProjectedValueTuple(byte[] keyBuffer, int keyOffset, int keyLength, long timestamp, byte[] projectedValue, int valueOffset, int valueLength, int bitSetLen) {
            super(keyBuffer, keyOffset, keyLength, timestamp, projectedValue, valueOffset, valueLength, bitSetLen);
        }

        public OldProjectedValueTuple(Tuple keyBase, long timestamp, byte[] projectedValue, int valueOffset, int valueLength, int bitSetLen) {
            super(keyBase, timestamp, projectedValue, valueOffset, valueLength, bitSetLen);
        }

        @Override
        public KeyValue getValue(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            return this.getValue(QueryConstants.VALUE_COLUMN_FAMILY, OLD_VALUE_COLUMN_QUALIFIER);
        }

        @Override
        public KeyValue getValue(byte[] family, byte[] qualifier) {
            if (this.keyValue == null) {
                this.keyValue = KeyValueUtil.newKeyValue(this.keyPtr.get(), this.keyPtr.getOffset(), this.keyPtr.getLength(), QueryConstants.VALUE_COLUMN_FAMILY, OLD_VALUE_COLUMN_QUALIFIER, this.timestamp, this.projectedValue.get(), this.projectedValue.getOffset(), this.projectedValue.getLength());
            }
            return this.keyValue;
        }
    }

    public static class ProjectedValueTuple
    extends BaseTuple {
        ImmutableBytesWritable keyPtr = new ImmutableBytesWritable();
        long timestamp;
        ImmutableBytesWritable projectedValue = new ImmutableBytesWritable();
        int bitSetLen;
        KeyValue keyValue;

        public ProjectedValueTuple(Tuple keyBase, long timestamp, byte[] projectedValue, int valueOffset, int valueLength, int bitSetLen) {
            keyBase.getKey(this.keyPtr);
            this.timestamp = timestamp;
            this.projectedValue.set(projectedValue, valueOffset, valueLength);
            this.bitSetLen = bitSetLen;
        }

        public ProjectedValueTuple(byte[] keyBuffer, int keyOffset, int keyLength, long timestamp, byte[] projectedValue, int valueOffset, int valueLength, int bitSetLen) {
            this.keyPtr.set(keyBuffer, keyOffset, keyLength);
            this.timestamp = timestamp;
            this.projectedValue.set(projectedValue, valueOffset, valueLength);
            this.bitSetLen = bitSetLen;
        }

        public ImmutableBytesWritable getKeyPtr() {
            return this.keyPtr;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public ImmutableBytesWritable getProjectedValue() {
            return this.projectedValue;
        }

        public int getBitSetLength() {
            return this.bitSetLen;
        }

        @Override
        public void getKey(ImmutableBytesWritable ptr) {
            ptr.set(this.keyPtr.get(), this.keyPtr.getOffset(), this.keyPtr.getLength());
        }

        public KeyValue getValue(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            return this.getValue(QueryConstants.VALUE_COLUMN_FAMILY, QueryConstants.VALUE_COLUMN_QUALIFIER);
        }

        public KeyValue getValue(byte[] family, byte[] qualifier) {
            if (this.keyValue == null) {
                this.keyValue = KeyValueUtil.newKeyValue(this.keyPtr.get(), this.keyPtr.getOffset(), this.keyPtr.getLength(), QueryConstants.VALUE_COLUMN_FAMILY, QueryConstants.VALUE_COLUMN_QUALIFIER, this.timestamp, this.projectedValue.get(), this.projectedValue.getOffset(), this.projectedValue.getLength());
            }
            return this.keyValue;
        }

        @Override
        public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
            ptr.set(this.projectedValue.get(), this.projectedValue.getOffset(), this.projectedValue.getLength());
            return true;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public int size() {
            return 1;
        }
    }
}

