/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.parallel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Pair;

public class ThreadPoolBuilder {
    private static final Log LOG = LogFactory.getLog(ThreadPoolBuilder.class);
    private static final long DEFAULT_TIMEOUT = 60L;
    private static final int DEFAULT_MAX_THREADS = 1;
    private Pair<String, Long> timeout;
    private Pair<String, Integer> maxThreads;
    private String name;
    private Configuration conf;

    public ThreadPoolBuilder(String poolName, Configuration conf) {
        this.name = poolName;
        this.conf = conf;
    }

    public ThreadPoolBuilder setCoreTimeout(String confkey, long defaultTime) {
        if (defaultTime <= 0L) {
            defaultTime = 60L;
        }
        this.timeout = new Pair((Object)confkey, (Object)defaultTime);
        return this;
    }

    public ThreadPoolBuilder setCoreTimeout(String confKey) {
        return this.setCoreTimeout(confKey, 60L);
    }

    public ThreadPoolBuilder setMaxThread(String confkey, int defaultThreads) {
        if (defaultThreads <= 0) {
            defaultThreads = 1;
        }
        this.maxThreads = new Pair((Object)confkey, (Object)defaultThreads);
        return this;
    }

    String getName() {
        return this.name;
    }

    int getMaxThreads() {
        int maxThreads = 1;
        if (this.maxThreads != null) {
            String key = (String)this.maxThreads.getFirst();
            maxThreads = key == null ? ((Integer)this.maxThreads.getSecond()).intValue() : this.conf.getInt(key, ((Integer)this.maxThreads.getSecond()).intValue());
        }
        LOG.trace((Object)("Creating pool builder with max " + maxThreads + " threads "));
        return maxThreads;
    }

    long getKeepAliveTime() {
        long timeout = 60L;
        if (this.timeout != null) {
            String key = (String)this.timeout.getFirst();
            timeout = key == null ? ((Long)this.timeout.getSecond()).longValue() : this.conf.getLong(key, ((Long)this.timeout.getSecond()).longValue());
        }
        LOG.trace((Object)("Creating pool builder with core thread timeout of " + timeout + " seconds "));
        return timeout;
    }
}

