/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.IndexMetaDataCache;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ServerUtil;

public class PhoenixIndexMetaData
implements IndexMetaData {
    private final Map<String, byte[]> attributes;
    private final IndexMetaDataCache indexMetaDataCache;
    private final BaseScannerRegionObserver.ReplayWrite replayWrite;
    private final boolean isImmutable;

    private static IndexMetaDataCache getIndexMetaData(RegionCoprocessorEnvironment env, Map<String, byte[]> attributes) throws IOException {
        if (attributes == null) {
            return IndexMetaDataCache.EMPTY_INDEX_META_DATA_CACHE;
        }
        byte[] uuid = attributes.get("IdxUUID");
        if (uuid == null) {
            return IndexMetaDataCache.EMPTY_INDEX_META_DATA_CACHE;
        }
        boolean useProto = false;
        byte[] md = attributes.get("IdxProtoMD");
        boolean bl = useProto = md != null;
        if (md == null) {
            md = attributes.get("IdxMD");
        }
        byte[] txState = attributes.get("_TxState");
        if (md != null) {
            final List<IndexMaintainer> indexMaintainers = IndexMaintainer.deserialize(md, useProto);
            final PhoenixTransactionContext txnContext = TransactionFactory.getTransactionFactory().getTransactionContext(txState);
            return new IndexMetaDataCache(){

                @Override
                public void close() throws IOException {
                }

                @Override
                public List<IndexMaintainer> getIndexMaintainers() {
                    return indexMaintainers;
                }

                @Override
                public PhoenixTransactionContext getTransactionContext() {
                    return txnContext;
                }
            };
        }
        byte[] tenantIdBytes = attributes.get("TenantId");
        ImmutableBytesPtr tenantId = tenantIdBytes == null ? null : new ImmutableBytesPtr(tenantIdBytes);
        TenantCache cache = GlobalCache.getTenantCache(env, tenantId);
        IndexMetaDataCache indexCache = (IndexMetaDataCache)cache.getServerCache(new ImmutableBytesPtr(uuid));
        if (indexCache == null) {
            String msg = "key=" + ServerCacheClient.idToString(uuid) + " region=" + env.getRegion() + "host=" + env.getRegionServerServices().getServerName();
            SQLException e = new SQLExceptionInfo.Builder(SQLExceptionCode.INDEX_METADATA_NOT_FOUND).setMessage(msg).build().buildException();
            ServerUtil.throwIOException("Index update failed", e);
        }
        return indexCache;
    }

    public static boolean isIndexRebuild(Map<String, byte[]> attributes) {
        return attributes.get("_IGNORE_NEWER_MUTATIONS") != null;
    }

    public static BaseScannerRegionObserver.ReplayWrite getReplayWrite(Map<String, byte[]> attributes) {
        return BaseScannerRegionObserver.ReplayWrite.fromBytes(attributes.get("_IGNORE_NEWER_MUTATIONS"));
    }

    public PhoenixIndexMetaData(RegionCoprocessorEnvironment env, Map<String, byte[]> attributes) throws IOException {
        this.indexMetaDataCache = PhoenixIndexMetaData.getIndexMetaData(env, attributes);
        boolean isImmutable = true;
        for (IndexMaintainer maintainer : this.indexMetaDataCache.getIndexMaintainers()) {
            isImmutable &= maintainer.isImmutableRows();
        }
        this.isImmutable = isImmutable;
        this.attributes = attributes;
        this.replayWrite = PhoenixIndexMetaData.getReplayWrite(attributes);
    }

    public PhoenixTransactionContext getTransactionContext() {
        return this.indexMetaDataCache.getTransactionContext();
    }

    public List<IndexMaintainer> getIndexMaintainers() {
        return this.indexMetaDataCache.getIndexMaintainers();
    }

    public Map<String, byte[]> getAttributes() {
        return this.attributes;
    }

    @Override
    public BaseScannerRegionObserver.ReplayWrite getReplayWrite() {
        return this.replayWrite;
    }

    @Override
    public boolean isImmutableRows() {
        return this.isImmutable;
    }
}

