/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GettingResultIterator
implements ResultIterator {
    private static final Logger logger = LoggerFactory.getLogger(GettingResultIterator.class);
    private StatementContext context;
    private HTableInterface hTable = null;
    private List<Get> gets;
    private Iterator<Result> rsIterator = null;
    private final Expression where;

    public GettingResultIterator(StatementContext context, Expression where) {
        this.context = context;
        this.where = where;
        this.gets = Lists.newArrayListWithExpectedSize((int)context.getScanRanges().getPointLookupCount());
        Scan scan = context.getScan();
        List<List<KeyRange>> ranges = context.getScanRanges().getRanges();
        for (KeyRange range : ranges.get(0)) {
            Get get = new Get(range.getLowerRange());
            for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
                byte[] family = (byte[])entry.getKey();
                if (entry.getValue() != null) {
                    for (byte[] q : (NavigableSet)entry.getValue()) {
                        get.addColumn(family, q);
                    }
                    continue;
                }
                get.addFamily(family);
            }
            for (Map.Entry attr : scan.getAttributesMap().entrySet()) {
                get.setAttribute((String)attr.getKey(), (byte[])attr.getValue());
            }
            this.setGetAttribute(get);
            this.gets.add(get);
        }
    }

    private void setGetAttribute(Get get) {
        get.setAttribute("_UseNewValueColumnQualifier", Bytes.toBytes((boolean)true));
        TupleProjector.copySerializeProjectorIntoGetFromScan(this.context.getScan(), get);
        get.setAttribute("_QualifierEncodingScheme", new byte[]{this.context.getCurrentTable().getTable().getEncodingScheme().getSerializedMetadataValue()});
        if (this.where != null) {
            GettingResultIterator.serializeExpressionIntoGet(get, "_GetWhereExpression", this.where);
        }
    }

    private static void serializeExpressionIntoGet(Get get, String attrName, Expression expression) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(expression).ordinal());
            expression.write(output);
            get.setAttribute(attrName, stream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Tuple next() throws SQLException {
        try {
            if (this.hTable == null && this.rsIterator == null) {
                this.hTable = this.context.getConnection().getQueryServices().getTable(this.context.getCurrentTable().getTable().getPhysicalName().getBytes());
                this.rsIterator = Iterators.forArray((Object[])this.hTable.get(this.gets));
            }
            Result r = null;
            while (this.rsIterator.hasNext() && (r = this.rsIterator.next()).isEmpty()) {
            }
            if (r == null) {
                return null;
            }
            return new ResultTuple(r);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void explain(List<String> planSteps) {
        String step = "\n GETS " + this.gets.size() + " KEYS";
        planSteps.add(step);
    }

    @Override
    public void close() throws SQLException {
    }
}

