/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.iterate.DelegateResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;

public class SequenceResultIterator
extends DelegateResultIterator {
    private final SequenceManager sequenceManager;

    public SequenceResultIterator(ResultIterator delegate, SequenceManager sequenceManager) throws SQLException {
        super(delegate);
        this.sequenceManager = sequenceManager;
    }

    @Override
    public Tuple next() throws SQLException {
        Tuple next = super.next();
        if (next == null) {
            return null;
        }
        next = this.sequenceManager.newSequenceTuple(next);
        return next;
    }

    @Override
    public void explain(List<String> planSteps) {
        super.explain(planSteps);
        int nSequences = this.sequenceManager.getSequenceCount();
        planSteps.add("CLIENT RESERVE VALUES FROM " + nSequences + " SEQUENCE" + (nSequences == 1 ? "" : "S"));
    }

    public String toString() {
        return "SequenceResultIterator [sequenceManager=" + this.sequenceManager + "]";
    }
}

