/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.phoenix.mapreduce.ODPSInputSplit;
import org.apache.phoenix.mapreduce.ODPSRecordReader;
import org.apache.phoenix.mapreduce.util.PhoenixMapReduceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODPSInputFormat<T extends MapWritable>
extends InputFormat<NullWritable, T> {
    protected static final Logger LOG = LoggerFactory.getLogger(ODPSInputFormat.class);

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        int splitNumber = configuration.getInt("odps.table.split.number", 1);
        try {
            TableTunnel.DownloadSession downloadSession = PhoenixMapReduceUtil.getDownloadSession(configuration);
            long downloadCount = downloadSession.getRecordCount();
            List<Pair<Long, Long>> ranges = PhoenixMapReduceUtil.getRanges(downloadCount, splitNumber);
            LOG.info("Total " + downloadCount + " records in source table, split number is " + ranges.size());
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(ranges.size());
            int i = 0;
            for (Pair<Long, Long> range : ranges) {
                TunnelRecordReader reader = downloadSession.openRecordReader(((Long)range.getFirst()).longValue(), (Long)range.getSecond() - (Long)range.getFirst() + 1L);
                long totalSize = reader.getTotalBytes();
                splits.add(new ODPSInputSplit(i++, (Long)range.getFirst(), (Long)range.getSecond() - (Long)range.getFirst() + 1L, totalSize));
                reader.close();
            }
            return splits;
        }
        catch (TunnelException e) {
            throw new IOException(e.getCause());
        }
    }

    public RecordReader<NullWritable, T> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        Class inputClass = configuration.getClass("odps.input.class", NullWritable.class);
        return new ODPSRecordReader(inputClass, configuration);
    }
}

