/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.phoenix.mapreduce.ODPSInputSplit;
import org.apache.phoenix.mapreduce.util.PhoenixMapReduceUtil;
import org.apache.phoenix.util.ColumnInfo;

public class ODPSRecordReader<T extends MapWritable>
extends RecordReader<NullWritable, T> {
    private static final Log LOG = LogFactory.getLog(ODPSRecordReader.class);
    private final Configuration conf;
    private final Class<T> inputClass;
    private TunnelRecordReader reader;
    private NullWritable key = NullWritable.get();
    private T value = null;
    private Record record;
    private TableTunnel.DownloadSession downloadSession;
    private List<ColumnInfo> targetTableColumns;
    private List<String> sourceTableColumns;

    public ODPSRecordReader(Class<T> inputClass, Configuration conf) {
        this.conf = conf;
        this.inputClass = inputClass;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        ODPSInputSplit odpsSplit = (ODPSInputSplit)split;
        try {
            this.downloadSession = PhoenixMapReduceUtil.getDownloadSession(this.conf);
            this.reader = this.downloadSession.openRecordReader(odpsSplit.getStart(), odpsSplit.getCount());
            this.targetTableColumns = PhoenixMapReduceUtil.buildTargetTableColumns(this.conf);
            this.sourceTableColumns = Lists.newArrayList((Iterable)Splitter.on((String)"|").split((CharSequence)this.conf.get("odps.mapreduce.import.columninfos")));
            Preconditions.checkArgument((this.sourceTableColumns.size() == this.targetTableColumns.size() ? 1 : 0) != 0);
            LOG.info((Object)("Initialize " + (Object)((Object)odpsSplit)));
        }
        catch (TunnelException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.key == null) {
            this.key = NullWritable.get();
        }
        this.record = this.reader.read();
        if (this.record == null) {
            return false;
        }
        this.value = (MapWritable)ReflectionUtils.newInstance(this.inputClass, (Configuration)this.conf);
        for (int i = 0; i < this.sourceTableColumns.size(); ++i) {
            String col = this.sourceTableColumns.get(i);
            String v = this.record.get(col) == null ? "" : this.record.get(col).toString();
            this.value.put((Writable)new Text(this.targetTableColumns.get(i).getColumnName()), (Writable)new Text(v));
        }
        return true;
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

