/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.bulkload;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.mapreduce.bulkload.TargetTableRef;
import org.codehaus.jackson.map.ObjectMapper;

public class TargetTableRefFunctions {
    public static Function<TargetTableRef, String> TO_JSON = new Function<TargetTableRef, String>(){

        public String apply(TargetTableRef input) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                return mapper.writeValueAsString((Object)input);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static Function<String, TargetTableRef> FROM_JSON = new Function<String, TargetTableRef>(){

        public TargetTableRef apply(String json) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                return (TargetTableRef)mapper.readValue(json, TargetTableRef.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static Function<List<TargetTableRef>, String> NAMES_TO_JSON = new Function<List<TargetTableRef>, String>(){

        public String apply(List<TargetTableRef> input) {
            try {
                ArrayList tableNames = Lists.newArrayListWithCapacity((int)input.size());
                for (TargetTableRef table : input) {
                    tableNames.add(table.getPhysicalName());
                }
                ObjectMapper mapper = new ObjectMapper();
                return mapper.writeValueAsString((Object)tableNames);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static Function<List<TargetTableRef>, String> LOGICAL_NAMES_TO_JSON = new Function<List<TargetTableRef>, String>(){

        public String apply(List<TargetTableRef> input) {
            try {
                ArrayList tableNames = Lists.newArrayListWithCapacity((int)input.size());
                for (TargetTableRef table : input) {
                    tableNames.add(table.getLogicalName());
                }
                ObjectMapper mapper = new ObjectMapper();
                return mapper.writeValueAsString((Object)tableNames);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static Function<String, List<String>> NAMES_FROM_JSON = new Function<String, List<String>>(){

        public List<String> apply(String json) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                return (List)mapper.readValue(json, ArrayList.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
}

