/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.mapreduce.ImportPreUpsertKeyValueProcessor;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.PhoenixIndexDBWritable;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.PhoenixRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixIndexImportMapper
extends Mapper<NullWritable, PhoenixIndexDBWritable, ImmutableBytesWritable, KeyValue> {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixIndexImportMapper.class);
    private final PhoenixIndexDBWritable indxWritable = new PhoenixIndexDBWritable();
    private List<ColumnInfo> indxTblColumnMetadata;
    private Connection connection;
    private String indexTableName;
    private ImportPreUpsertKeyValueProcessor preUpdateProcessor;
    private PreparedStatement pStatement;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration configuration = context.getConfiguration();
        try {
            this.indxTblColumnMetadata = PhoenixConfigurationUtil.getUpsertColumnMetadataList(context.getConfiguration());
            this.indxWritable.setColumnMetadata(this.indxTblColumnMetadata);
            this.preUpdateProcessor = PhoenixConfigurationUtil.loadPreUpsertProcessor(configuration);
            this.indexTableName = PhoenixConfigurationUtil.getPhysicalTableName(configuration);
            Properties overrideProps = new Properties();
            String scn = configuration.get("phoenix.mr.currentscn.value");
            String txScnValue = configuration.get("phoenix.mr.txscn.value");
            if (txScnValue == null) {
                overrideProps.put("BuildIndexAt", scn);
            }
            this.connection = ConnectionUtil.getOutputConnection(configuration, overrideProps);
            this.connection.setAutoCommit(false);
            String upsertQuery = PhoenixConfigurationUtil.getUpsertStatement(configuration);
            this.pStatement = this.connection.prepareStatement(upsertQuery);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void map(NullWritable key, PhoenixIndexDBWritable record, Mapper.Context context) throws IOException, InterruptedException {
        context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).increment(1L);
        try {
            ImmutableBytesWritable outputKey = new ImmutableBytesWritable();
            List<Object> values = record.getValues();
            this.indxWritable.setValues(values);
            this.indxWritable.write(this.pStatement);
            this.pStatement.execute();
            Iterator<Pair<byte[], List<KeyValue>>> uncommittedDataIterator = PhoenixRuntime.getUncommittedDataIterator(this.connection, true);
            while (uncommittedDataIterator.hasNext()) {
                Pair<byte[], List<KeyValue>> kvPair = uncommittedDataIterator.next();
                if (Bytes.compareTo((byte[])Bytes.toBytes((String)this.indexTableName), (byte[])((byte[])kvPair.getFirst())) != 0) continue;
                List<KeyValue> keyValueList = (List<KeyValue>)kvPair.getSecond();
                keyValueList = this.preUpdateProcessor.preUpsert((byte[])kvPair.getFirst(), keyValueList);
                for (KeyValue kv : keyValueList) {
                    outputKey.set(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength());
                    context.write((Object)outputKey, (Object)kv);
                }
                context.getCounter((Enum)PhoenixJobCounters.OUTPUT_RECORDS).increment(1L);
            }
            this.connection.rollback();
        }
        catch (SQLException e) {
            LOG.error("Error {}  while read/write of a record ", (Object)e.getMessage());
            context.getCounter((Enum)PhoenixJobCounters.FAILED_RECORDS).increment(1L);
            throw new RuntimeException(e);
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOG.error("Error {} while closing connection in the PhoenixIndexMapper class ", (Object)e.getMessage());
            }
        }
    }
}

