/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.CombinableMetricImpl;
import org.apache.phoenix.monitoring.MetricType;

public class ReadMetricQueue {
    private static final int MAX_QUEUE_SIZE = 20000;
    private final ConcurrentMap<MetricKey, Queue<CombinableMetric>> metricsMap = new ConcurrentHashMap<MetricKey, Queue<CombinableMetric>>();
    private final boolean isRequestMetricsEnabled;

    public ReadMetricQueue(boolean isRequestMetricsEnabled) {
        this.isRequestMetricsEnabled = isRequestMetricsEnabled;
    }

    public CombinableMetric allotMetric(MetricType type, String tableName) {
        if (!this.isRequestMetricsEnabled) {
            return CombinableMetric.NoOpRequestMetric.INSTANCE;
        }
        MetricKey key = new MetricKey(type, tableName);
        Queue<CombinableMetric> q = this.getMetricQueue(key);
        CombinableMetric metric = this.getMetric(type);
        q.offer(metric);
        return metric;
    }

    @VisibleForTesting
    public CombinableMetric getMetric(MetricType type) {
        CombinableMetricImpl metric = new CombinableMetricImpl(type);
        return metric;
    }

    public Map<String, Map<MetricType, Long>> aggregate() {
        HashMap<String, Map<MetricType, Long>> publishedMetrics = new HashMap<String, Map<MetricType, Long>>();
        for (Map.Entry entry : this.metricsMap.entrySet()) {
            String tableNameToPublish = ((MetricKey)entry.getKey()).tableName;
            Collection metrics = (Collection)entry.getValue();
            if (metrics.size() <= 0) continue;
            CombinableMetric m = ReadMetricQueue.combine(metrics);
            HashMap<MetricType, Long> map = (HashMap<MetricType, Long>)publishedMetrics.get(tableNameToPublish);
            if (map == null) {
                map = new HashMap<MetricType, Long>();
                publishedMetrics.put(tableNameToPublish, map);
            }
            map.put(m.getMetricType(), m.getValue());
        }
        return publishedMetrics;
    }

    public void clearMetrics() {
        this.metricsMap.clear();
    }

    private static CombinableMetric combine(Collection<CombinableMetric> metrics) {
        int size = metrics.size();
        if (size == 0) {
            throw new IllegalArgumentException("Metrics collection needs to have at least one element");
        }
        Iterator<CombinableMetric> itr = metrics.iterator();
        CombinableMetric combinedMetric = itr.next();
        while (itr.hasNext()) {
            combinedMetric = combinedMetric.combine(itr.next());
        }
        return combinedMetric;
    }

    public ReadMetricQueue combineReadMetrics(ReadMetricQueue other) {
        ConcurrentMap<MetricKey, Queue<CombinableMetric>> otherMetricsMap = other.metricsMap;
        for (Map.Entry entry : otherMetricsMap.entrySet()) {
            MetricKey key = (MetricKey)entry.getKey();
            Queue otherQueue = (Queue)entry.getValue();
            CombinableMetric combinedMetric = null;
            for (CombinableMetric m : otherQueue) {
                if (combinedMetric == null) {
                    combinedMetric = m;
                    continue;
                }
                combinedMetric.combine(m);
            }
            if (combinedMetric == null) continue;
            Queue<CombinableMetric> thisQueue = this.getMetricQueue(key);
            thisQueue.offer(combinedMetric);
        }
        return this;
    }

    private Queue<CombinableMetric> getMetricQueue(MetricKey key) {
        Queue curQ;
        Queue q = (LinkedBlockingQueue)this.metricsMap.get(key);
        if (q == null && (curQ = (Queue)this.metricsMap.putIfAbsent(key, q = new LinkedBlockingQueue(20000))) != null) {
            q = curQ;
        }
        return q;
    }

    public boolean isRequestMetricsEnabled() {
        return this.isRequestMetricsEnabled;
    }

    private static class MetricKey {
        @Nonnull
        private final MetricType type;
        @Nonnull
        private final String tableName;

        MetricKey(MetricType type, String tableName) {
            Preconditions.checkNotNull((Object)((Object)type));
            Preconditions.checkNotNull((Object)tableName);
            this.type = type;
            this.tableName = tableName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.tableName.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MetricKey other = (MetricKey)obj;
            return this.tableName.equals(other.tableName) && this.type == other.type;
        }
    }
}

