/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.optimize;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexStatementRewriter;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.SubqueryRewriter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.ForceIndexException;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.BooleanParseNodeVisitor;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.IndexExpressionParseNodeRewriter;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.ParseNodeRewriter;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ReadOnlyProps;

public class QueryOptimizer {
    private static final ParseNodeFactory FACTORY = new ParseNodeFactory();
    public static final String PHOENIX_FORCE_INDEX = "phoenix.force.index";
    public static final boolean DEFAULT_PHOENIX_FORCE_INDEX = true;
    private final QueryServices services;
    private final boolean useIndexes;

    public QueryOptimizer(QueryServices services) {
        this.services = services;
        this.useIndexes = this.services.getProps().getBoolean("phoenix.query.useIndexes", true);
    }

    public QueryPlan optimize(PhoenixStatement statement, QueryPlan dataPlan) throws SQLException {
        if (dataPlan.getTableRef() == null) {
            return dataPlan;
        }
        return this.optimize(dataPlan, statement, Collections.emptyList(), null);
    }

    public QueryPlan optimize(PhoenixStatement statement, SelectStatement select) throws SQLException {
        return this.optimize(statement, select, FromCompiler.getResolverForQuery(select, statement.getConnection()), Collections.emptyList(), null);
    }

    public QueryPlan optimize(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        QueryCompiler compiler = new QueryCompiler(statement, select, resolver, targetColumns, parallelIteratorFactory, new SequenceManager(statement));
        QueryPlan dataPlan = compiler.compile();
        return this.optimize(dataPlan, statement, targetColumns, parallelIteratorFactory);
    }

    public QueryPlan optimize(QueryPlan dataPlan, PhoenixStatement statement, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        List<QueryPlan> plans = this.getApplicablePlans(dataPlan, statement, targetColumns, parallelIteratorFactory, true);
        QueryPlan bestCandidate = plans.get(0);
        QueryOptimizer.forceIndexCheck(bestCandidate);
        return bestCandidate;
    }

    public List<QueryPlan> getBestPlan(QueryPlan dataPlan, PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        return this.getApplicablePlans(dataPlan, statement, targetColumns, parallelIteratorFactory, true);
    }

    public List<QueryPlan> getApplicablePlans(QueryPlan dataPlan, PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        return this.getApplicablePlans(dataPlan, statement, targetColumns, parallelIteratorFactory, false);
    }

    private List<QueryPlan> getApplicablePlans(QueryPlan dataPlan, PhoenixStatement statement, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, boolean stopAtBestPlan) throws SQLException {
        SelectStatement select = (SelectStatement)dataPlan.getStatement();
        if (!this.useIndexes || dataPlan.getContext().getScanRanges().isPointLookup() && stopAtBestPlan) {
            return Collections.singletonList(dataPlan);
        }
        ArrayList indexes = Lists.newArrayList(dataPlan.getContext().getResolver().getTables().get(0).getTable().getIndexes());
        if (indexes.isEmpty() || dataPlan.isDegenerate() || dataPlan.getTableRef().hasDynamicCols() || select.getHint().hasHint(HintNode.Hint.NO_INDEX)) {
            return Collections.singletonList(dataPlan);
        }
        if (targetColumns.isEmpty()) {
            List<? extends ColumnProjector> projectors = dataPlan.getProjector().getColumnProjectors();
            ArrayList targetDatums = Lists.newArrayListWithExpectedSize((int)projectors.size());
            for (ColumnProjector columnProjector : projectors) {
                targetDatums.add(columnProjector.getExpression());
            }
            targetColumns = targetDatums;
        }
        SelectStatement translatedIndexSelect = IndexStatementRewriter.translate(select, FromCompiler.getResolver(dataPlan.getTableRef()));
        ArrayList plans = Lists.newArrayListWithExpectedSize((int)(1 + indexes.size()));
        plans.add(dataPlan);
        QueryPlan hintedPlan = QueryOptimizer.getHintedQueryPlan(statement, translatedIndexSelect, indexes, targetColumns, parallelIteratorFactory, plans);
        if (hintedPlan != null) {
            if (stopAtBestPlan) {
                return Collections.singletonList(hintedPlan);
            }
            plans.add(0, hintedPlan);
        }
        for (PTable index : indexes) {
            QueryPlan plan = QueryOptimizer.addPlan(statement, translatedIndexSelect, index, targetColumns, parallelIteratorFactory, dataPlan, false);
            if (plan == null) continue;
            if (plan.isDegenerate()) {
                return Collections.singletonList(plan);
            }
            plans.add(plan);
        }
        return hintedPlan == null ? this.orderPlansBestToWorst(select, plans, stopAtBestPlan) : plans;
    }

    private static QueryPlan getHintedQueryPlan(PhoenixStatement statement, SelectStatement select, List<PTable> indexes, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, List<QueryPlan> plans) throws SQLException {
        QueryPlan dataPlan = plans.get(0);
        String indexHint = select.getHint().getHint(HintNode.Hint.INDEX);
        if (indexHint == null) {
            return null;
        }
        int startIndex = 0;
        String alias = dataPlan.getTableRef().getTableAlias();
        String prefix = "(" + (alias == null ? dataPlan.getTableRef().getTable().getName().getString() : alias) + ' ';
        while (startIndex < indexHint.length()) {
            if ((startIndex = indexHint.indexOf(prefix, startIndex)) < 0) {
                return null;
            }
            startIndex += prefix.length();
            boolean done = false;
            while (startIndex < indexHint.length() && !done) {
                int endIndex;
                int endIndex1 = indexHint.indexOf(32, startIndex);
                int endIndex2 = indexHint.indexOf(")", startIndex);
                if (endIndex1 < 0 && endIndex2 < 0) {
                    endIndex = indexHint.length();
                } else if (endIndex1 < 0) {
                    done = true;
                    endIndex = endIndex2;
                } else if (endIndex2 < 0) {
                    endIndex = endIndex1;
                } else {
                    endIndex = Math.min(endIndex1, endIndex2);
                    done = endIndex2 == endIndex;
                }
                String indexName = indexHint.substring(startIndex, endIndex);
                int indexPos = QueryOptimizer.getIndexPosition(indexes, indexName);
                if (indexPos >= 0) {
                    PTable index = indexes.get(indexPos);
                    indexes.remove(indexPos);
                    QueryPlan plan = QueryOptimizer.addPlan(statement, select, index, targetColumns, parallelIteratorFactory, dataPlan, true);
                    if (plan != null) {
                        return plan;
                    }
                }
                startIndex = endIndex + 1;
            }
        }
        return null;
    }

    private static int getIndexPosition(List<PTable> indexes, String indexName) {
        for (int i = 0; i < indexes.size(); ++i) {
            if (!indexName.equals(indexes.get(i).getTableName().getString())) continue;
            return i;
        }
        return -1;
    }

    private static QueryPlan addPlan(PhoenixStatement statement, SelectStatement select, PTable index, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, QueryPlan dataPlan, boolean isHinted) throws SQLException {
        block15: {
            int nColumns = dataPlan.getProjector().getColumnCount();
            String tableAlias = dataPlan.getTableRef().getTableAlias();
            String alias = tableAlias == null ? null : '\"' + tableAlias + '\"';
            String schemaName = index.getParentSchemaName().getString();
            schemaName = schemaName.length() == 0 ? null : '\"' + schemaName + '\"';
            String tableName = '\"' + index.getTableName().getString() + '\"';
            NamedTableNode table = FACTORY.namedTable(alias, FACTORY.table(schemaName, tableName), select.getTableSamplingRate());
            SelectStatement indexSelect = FACTORY.select(select, table);
            ColumnResolver resolver = FromCompiler.getResolverForQuery(indexSelect, statement.getConnection());
            boolean isProjected = dataPlan.getContext().getResolver().getTables().get(0).getTable().getType() == PTableType.PROJECTED;
            PIndexState indexState = resolver.getTables().get(0).getTable().getIndexState();
            if (indexState == PIndexState.ACTIVE || indexState == PIndexState.PENDING_ACTIVE) {
                try {
                    indexSelect = ParseNodeRewriter.rewrite(indexSelect, (ParseNodeRewriter)new IndexExpressionParseNodeRewriter(index, null, statement.getConnection(), indexSelect.getUdfParseNodes()));
                    QueryCompiler compiler = new QueryCompiler(statement, indexSelect, resolver, targetColumns, parallelIteratorFactory, dataPlan.getContext().getSequenceManager(), isProjected);
                    QueryPlan plan = compiler.compile();
                    if (index.getIndexType() == PTable.IndexType.LOCAL && indexSelect.getWhere() == null && !plan.getContext().getDataColumns().isEmpty()) {
                        return null;
                    }
                    indexState = plan.getTableRef().getTable().getIndexState();
                    if (indexState == PIndexState.ACTIVE || indexState == PIndexState.PENDING_ACTIVE) {
                        if (plan.getProjector().getColumnCount() == nColumns) {
                            return plan;
                        }
                        if (index.getIndexType() == PTable.IndexType.GLOBAL) {
                            String schemaNameStr = index.getSchemaName() == null ? null : index.getSchemaName().getString();
                            String tableNameStr = index.getTableName() == null ? null : index.getTableName().getString();
                            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, "*");
                        }
                    }
                }
                catch (ColumnNotFoundException e) {
                    int posOffset;
                    if (index.getIndexType() == PTable.IndexType.LOCAL) {
                        return null;
                    }
                    ParseNode where = select.getWhere();
                    PTable dataTable = dataPlan.getTableRef().getTable();
                    ArrayList<ColumnRef> filterColumns = new ArrayList<ColumnRef>();
                    List<Pair<byte[], byte[]>> commonConditionColumns = dataPlan.getContext().getWhereConditionColumns();
                    IndexMaintainer maintainer = index.getIndexMaintainer(dataTable, statement.getConnection());
                    block4: for (Pair<byte[], byte[]> pair : commonConditionColumns) {
                        if (!maintainer.getIndexedColumns().contains(new ColumnReference((byte[])pair.getFirst(), (byte[])pair.getSecond()))) continue;
                        for (PColumn column : dataTable.getColumns()) {
                            boolean bl = column.getFamilyName() == null ? pair.getFirst() == null : Bytes.compareTo((byte[])column.getFamilyName().getBytes(), (byte[])((byte[])pair.getFirst())) == 0;
                            boolean sameCF = bl;
                            if (!sameCF || column.getFamilyName() == null || Bytes.compareTo((byte[])column.getColumnQualifierBytes(), (byte[])((byte[])pair.getSecond())) != 0) continue;
                            String indexName = IndexUtil.getIndexColumnName(column.getFamilyName().getString(), column.getName().getString());
                            try {
                                PColumn indexColumn = index.getColumnForColumnName(indexName);
                                filterColumns.add(new ColumnRef(new TableRef(index), indexColumn.getPosition()));
                            }
                            catch (ColumnNotFoundException indexColumn) {}
                            continue block4;
                        }
                    }
                    if ((filterColumns.isEmpty() || !QueryOptimizer.matchPrefixOfPk(index.getPKColumns(), filterColumns)) && (!isHinted || where == null)) break block15;
                    SelectStatement dataSelect = (SelectStatement)dataPlan.getStatement();
                    where = dataSelect.getWhere();
                    StatementContext context = new StatementContext(statement, resolver);
                    WhereConditionRewriter whereRewriter = new WhereConditionRewriter(FromCompiler.getResolver(dataPlan.getTableRef()), context);
                    if ((where = where.accept(whereRewriter)) == null) break block15;
                    List<PColumn> pkColumns = dataTable.getPKColumns();
                    ArrayList aliasedNodes = Lists.newArrayListWithExpectedSize((int)pkColumns.size());
                    ArrayList nodes = Lists.newArrayListWithExpectedSize((int)pkColumns.size());
                    boolean isSalted = dataTable.getBucketNum() != null;
                    boolean isTenantSpecific = dataTable.isMultiTenant() && statement.getConnection().getTenantId() != null;
                    for (int i = posOffset = (isSalted ? 1 : 0) + (isTenantSpecific ? 1 : 0); i < pkColumns.size(); ++i) {
                        PDataType dataColType;
                        PColumn column = pkColumns.get(i);
                        String indexColName = IndexUtil.getIndexColumnName(column);
                        ParseNode indexColNode = new ColumnParseNode(null, '\"' + indexColName + '\"', indexColName);
                        PDataType indexColType = IndexUtil.getIndexColumnDataType(column);
                        if (indexColType != (dataColType = column.getDataType())) {
                            indexColNode = FACTORY.cast(indexColNode, dataColType, null, null);
                        }
                        aliasedNodes.add(FACTORY.aliasedNode(null, indexColNode));
                        nodes.add(new ColumnParseNode(null, '\"' + column.getName().getString() + '\"'));
                    }
                    SelectStatement innerSelect = FACTORY.select(indexSelect.getFrom(), indexSelect.getHint(), false, aliasedNodes, where, null, null, null, null, null, indexSelect.getBindCount(), false, indexSelect.hasSequence(), Collections.emptyList(), indexSelect.getUdfParseNodes());
                    CompoundParseNode outerWhere = FACTORY.in(nodes.size() == 1 ? (ParseNode)nodes.get(0) : FACTORY.rowValueConstructor(nodes), FACTORY.subquery(innerSelect, false), false, true);
                    ParseNode extractedCondition = whereRewriter.getExtractedCondition();
                    if (extractedCondition != null) {
                        outerWhere = FACTORY.and(Lists.newArrayList((Object[])new ParseNode[]{outerWhere, extractedCondition}));
                    }
                    HintNode hint = HintNode.combine(HintNode.subtract(indexSelect.getHint(), new HintNode.Hint[]{HintNode.Hint.INDEX, HintNode.Hint.NO_CHILD_PARENT_JOIN_OPTIMIZATION}), FACTORY.hint("NO_INDEX"));
                    SelectStatement query = FACTORY.select(dataSelect, hint, (ParseNode)outerWhere);
                    ColumnResolver queryResolver = FromCompiler.getResolverForQuery(query, statement.getConnection());
                    query = SubqueryRewriter.transform(query, queryResolver, statement.getConnection());
                    queryResolver = FromCompiler.getResolverForQuery(query, statement.getConnection());
                    query = StatementNormalizer.normalize(query, queryResolver);
                    QueryPlan plan = new QueryCompiler(statement, query, queryResolver, targetColumns, parallelIteratorFactory, dataPlan.getContext().getSequenceManager(), isProjected).compile();
                    return plan;
                }
            }
        }
        return null;
    }

    private List<QueryPlan> orderPlansBestToWorst(SelectStatement select, List<QueryPlan> plans, boolean stopAtBestPlan) {
        QueryPlan dataPlan = plans.get(0);
        if (plans.size() == 1) {
            return plans;
        }
        ArrayList candidates = Lists.newArrayListWithExpectedSize((int)plans.size());
        if (stopAtBestPlan) {
            for (QueryPlan plan : plans) {
                if (!plan.getContext().getScanRanges().isPointLookup()) continue;
                candidates.add(plan);
            }
        } else {
            candidates.addAll(plans);
        }
        ArrayList stillCandidates = plans;
        ArrayList bestCandidates = candidates;
        if (!candidates.isEmpty()) {
            stillCandidates = candidates;
            bestCandidates = Lists.newArrayListWithExpectedSize((int)candidates.size());
        }
        for (QueryPlan plan : stillCandidates) {
            if (!plan.getOrderBy().getOrderByExpressions().isEmpty()) continue;
            bestCandidates.add(plan);
        }
        if (bestCandidates.isEmpty()) {
            bestCandidates.addAll(stillCandidates);
        }
        int nViewConstants = 0;
        PTable dataTable = dataPlan.getTableRef().getTable();
        if (dataTable.getType() == PTableType.VIEW) {
            for (PColumn column : dataTable.getColumns()) {
                if (column.getViewConstant() == null) continue;
                ++nViewConstants;
            }
        }
        final int boundRanges = nViewConstants;
        final int comparisonOfDataVersusIndexTable = select.getHint().hasHint(HintNode.Hint.USE_DATA_OVER_INDEX_TABLE) ? -1 : 1;
        Collections.sort(bestCandidates, new Comparator<QueryPlan>(){

            @Override
            public int compare(QueryPlan plan1, QueryPlan plan2) {
                PTable table1 = plan1.getTableRef().getTable();
                PTable table2 = plan2.getTableRef().getTable();
                StatementContext context1 = plan1.getContext();
                StatementContext context2 = plan2.getContext();
                int boundCount1 = context1.getScanRanges().getBoundPkColumnCount();
                int boundCount2 = context2.getScanRanges().getBoundPkColumnCount();
                int c = boundCount2 + (table2.getViewIndexId() == null ? 0 : boundRanges - 1) - (boundCount1 + (table1.getViewIndexId() == null ? 0 : boundRanges - 1));
                if (c != 0) {
                    return c;
                }
                if (table1.getType() != PTableType.VIEW && table2.getType() != PTableType.VIEW && context1.getWhereConditionColumns().isEmpty() && context2.getWhereConditionColumns().isEmpty() && !context1.getFilterConditionsPKColumns().isEmpty() && !context2.getFilterConditionsPKColumns().isEmpty() && (c = QueryOptimizer.this.getBetterCandidate(table1.getPKColumns(), context1.getFilterConditionsPKColumns(), table2.getPKColumns(), context2.getFilterConditionsPKColumns())) != 0) {
                    return c;
                }
                if (plan1.getGroupBy() != null && plan2.getGroupBy() != null && plan1.getGroupBy().isOrderPreserving() != plan2.getGroupBy().isOrderPreserving()) {
                    return plan1.getGroupBy().isOrderPreserving() ? -1 : 1;
                }
                c = table1.getColumns().size() - table1.getPKColumns().size() - (table2.getColumns().size() - table2.getPKColumns().size());
                if (c != 0) {
                    return c;
                }
                if (table1.getIndexType() == PTable.IndexType.LOCAL && table2.getIndexType() != PTable.IndexType.LOCAL) {
                    return plan1.getContext().getScanRanges().getRanges().isEmpty() ? -1 : 1;
                }
                if (table2.getIndexType() == PTable.IndexType.LOCAL && table1.getIndexType() != PTable.IndexType.LOCAL) {
                    return plan2.getContext().getScanRanges().getRanges().isEmpty() ? 1 : -1;
                }
                if (table1.getType() == PTableType.INDEX && table2.getType() != PTableType.INDEX) {
                    return comparisonOfDataVersusIndexTable;
                }
                if (table2.getType() == PTableType.INDEX && table1.getType() != PTableType.INDEX) {
                    return -comparisonOfDataVersusIndexTable;
                }
                c = QueryOptimizer.totalIndexTable(plan2) - QueryOptimizer.totalIndexTable(plan1);
                if (c != 0) {
                    return c;
                }
                return 0;
            }
        });
        return stopAtBestPlan ? bestCandidates.subList(0, 1) : bestCandidates;
    }

    private static int totalIndexTable(QueryPlan plan) {
        int counter = 0;
        for (TableRef tableRef : plan.getSourceRefs()) {
            counter += tableRef.getTable().getType() == PTableType.INDEX ? 1 : 0;
        }
        return counter;
    }

    private static void forceIndexCheck(QueryPlan plan) throws SQLException {
        PhoenixStatement statement = plan.getContext().getStatement();
        ReadOnlyProps props = statement.getConnection().getQueryServices().getProps();
        StatementContext context = plan.getContext();
        if (statement.isLastExplainQuery() || context.getWhereConditionColumns().isEmpty() || !props.getBoolean(PHOENIX_FORCE_INDEX, true)) {
            return;
        }
        SelectStatement select = (SelectStatement)plan.getStatement();
        if (!select.getHint().hasHint(HintNode.Hint.NO_INDEX) && !select.isJoin() && !select.isUnion() && context.getFilterConditionsPKColumns().isEmpty()) {
            PTable table = plan.getTableRef().getTable();
            String schema = table.getSchemaName() == null ? null : table.getSchemaName().getString();
            throw new ForceIndexException(schema, table.getTableName().toString(), "The filters must be contains one index column at least.");
        }
    }

    private static boolean matchPrefixOfPk(List<PColumn> allPKColumns, List<ColumnRef> filterPkColumns) {
        byte[] positions = QueryOptimizer.getPKFilledSlotPositionByFilters(allPKColumns, filterPkColumns);
        return positions[0] == 1;
    }

    private int getBetterCandidate(List<PColumn> pkColumns1, List<ColumnRef> filterPkColumns1, List<PColumn> pkColumns2, List<ColumnRef> filterPkColumns2) {
        byte[] positions1 = QueryOptimizer.getPKFilledSlotPositionByFilters(pkColumns1, filterPkColumns1);
        byte[] positions2 = QueryOptimizer.getPKFilledSlotPositionByFilters(pkColumns2, filterPkColumns2);
        return Bytes.compareTo((byte[])positions2, (byte[])positions1);
    }

    private static byte[] getPKFilledSlotPositionByFilters(List<PColumn> allPKColumns, List<ColumnRef> filterPkColumns) {
        ArrayList<PColumn> pkColumns = new ArrayList<PColumn>();
        int reservedCounter = 0;
        for (PColumn column : allPKColumns) {
            if (column.getName().getString().startsWith("_")) {
                ++reservedCounter;
                continue;
            }
            pkColumns.add(column);
        }
        byte[] positions = new byte[pkColumns.size()];
        Arrays.fill(positions, (byte)0);
        block1: for (int i = 0; i < pkColumns.size(); ++i) {
            PColumn pk = (PColumn)pkColumns.get(i);
            for (ColumnRef columnRef : filterPkColumns) {
                if (!pk.equals(columnRef.getColumn())) continue;
                positions[columnRef.getPKSlotPosition() - reservedCounter] = 1;
                continue block1;
            }
        }
        return positions;
    }

    private static class WhereConditionRewriter
    extends BooleanParseNodeVisitor<ParseNode> {
        private final ColumnResolver dataResolver;
        private final ExpressionCompiler expressionCompiler;
        private List<ParseNode> extractedConditions;

        public WhereConditionRewriter(ColumnResolver dataResolver, StatementContext context) throws SQLException {
            this.dataResolver = dataResolver;
            this.expressionCompiler = new ExpressionCompiler(context);
            this.extractedConditions = Lists.newArrayList();
        }

        public ParseNode getExtractedCondition() {
            if (this.extractedConditions.isEmpty()) {
                return null;
            }
            if (this.extractedConditions.size() == 1) {
                return this.extractedConditions.get(0);
            }
            return FACTORY.and(this.extractedConditions);
        }

        @Override
        public List<ParseNode> newElementList(int size) {
            return Lists.newArrayListWithExpectedSize((int)size);
        }

        @Override
        public void addElement(List<ParseNode> l, ParseNode element) {
            if (element != null) {
                l.add(element);
            }
        }

        @Override
        public boolean visitEnter(AndParseNode node) throws SQLException {
            return true;
        }

        @Override
        public ParseNode visitLeave(AndParseNode node, List<ParseNode> l) throws SQLException {
            if (l.equals(node.getChildren())) {
                return node;
            }
            if (l.isEmpty()) {
                return null;
            }
            if (l.size() == 1) {
                return l.get(0);
            }
            return FACTORY.and(l);
        }

        @Override
        protected boolean enterBooleanNode(ParseNode node) throws SQLException {
            return false;
        }

        @Override
        protected ParseNode leaveBooleanNode(ParseNode node, List<ParseNode> l) throws SQLException {
            ParseNode translatedNode = IndexStatementRewriter.translate(node, this.dataResolver);
            this.expressionCompiler.reset();
            try {
                translatedNode.accept(this.expressionCompiler);
            }
            catch (ColumnNotFoundException e) {
                this.extractedConditions.add(node);
                return null;
            }
            return translatedNode;
        }

        @Override
        protected boolean enterNonBooleanNode(ParseNode node) throws SQLException {
            return false;
        }

        @Override
        protected ParseNode leaveNonBooleanNode(ParseNode node, List<ParseNode> l) throws SQLException {
            return node;
        }
    }
}

